/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.Root;
import org.apache.lucene.util.CharsRef;

class CheckCompoundPattern {
    private final String endChars;
    private final String beginChars;
    private final String replacement;
    private final char[] endFlags;
    private final char[] beginFlags;
    private final Dictionary dictionary;

    CheckCompoundPattern(String unparsed, Dictionary.FlagParsingStrategy strategy, Dictionary dictionary) {
        this.dictionary = dictionary;
        String[] parts = unparsed.split("\\s+");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid pattern: " + unparsed);
        }
        int flagSep = parts[1].indexOf("/");
        this.endChars = flagSep < 0 ? parts[1] : parts[1].substring(0, flagSep);
        this.endFlags = flagSep < 0 ? new char[]{} : strategy.parseFlags(parts[1].substring(flagSep + 1));
        flagSep = parts[2].indexOf("/");
        this.beginChars = flagSep < 0 ? parts[2] : parts[2].substring(0, flagSep);
        this.beginFlags = flagSep < 0 ? new char[]{} : strategy.parseFlags(parts[2].substring(flagSep + 1));
        this.replacement = parts.length == 3 ? null : parts[3];
    }

    public String toString() {
        return this.endChars + " " + this.beginChars + (this.replacement == null ? "" : " -> " + this.replacement);
    }

    boolean prohibitsCompounding(CharsRef word, int breakPos, Root<?> rootBefore, Root<?> rootAfter) {
        if (CheckCompoundPattern.isNonAffixedPattern(this.endChars) ? !CheckCompoundPattern.charsMatch(word, breakPos - rootBefore.word.length(), rootBefore.word) : !CheckCompoundPattern.charsMatch(word, breakPos - this.endChars.length(), this.endChars)) {
            return false;
        }
        if (CheckCompoundPattern.isNonAffixedPattern(this.beginChars) ? !CheckCompoundPattern.charsMatch(word, breakPos, rootAfter.word) : !CheckCompoundPattern.charsMatch(word, breakPos, this.beginChars)) {
            return false;
        }
        if (this.endFlags.length > 0 && !this.hasAllFlags(rootBefore, this.endFlags)) {
            return false;
        }
        return this.beginFlags.length <= 0 || this.hasAllFlags(rootAfter, this.beginFlags);
    }

    private static boolean isNonAffixedPattern(String pattern) {
        return pattern.length() == 1 && pattern.charAt(0) == '0';
    }

    private boolean hasAllFlags(Root<?> root2, char[] flags) {
        for (char flag : flags) {
            if (this.dictionary.hasFlag(root2.entryId, flag)) continue;
            return false;
        }
        return true;
    }

    CharsRef expandReplacement(CharsRef word, int breakPos) {
        if (this.replacement != null && CheckCompoundPattern.charsMatch(word, breakPos, this.replacement)) {
            return new CharsRef(new String(word.chars, 0, word.offset + breakPos) + this.endChars + this.beginChars + word.subSequence(breakPos + this.replacement.length(), word.length));
        }
        return null;
    }

    int endLength() {
        return this.endChars.length();
    }

    private static boolean charsMatch(CharsRef word, int offset, CharSequence pattern) {
        int len = pattern.length();
        if (word.length - offset < len || offset < 0 || offset > word.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (word.chars[word.offset + offset + i] == pattern.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

