/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.jena.atlas.lib.BitsLong;

public class DecimalNode {
    BigDecimal decimal = null;
    static final int SCALE_LEN = 8;
    static final int VALUE_LEN = 48;
    static final int ENC_LEN = 56;
    static final long MAX_VALUE = 0x7FFFFFFFFFFFL;
    static final long MIN_VALUE = -140737488355328L;
    static final int MAX_SCALE = 127;
    static final int MIN_SCALE = -128;
    static final BigInteger MAX_I = BigInteger.valueOf(0x7FFFFFFFFFFFL);
    static final BigInteger MIN_I = BigInteger.valueOf(-140737488355328L);
    private static int SCALE_LO = 48;
    private static int SCALE_HI = 56;
    private static int VALUE_LO = 0;
    private static int VALUE_HI = VALUE_LO + 48;
    private int scale;
    private long value;

    public static DecimalNode valueOf(BigDecimal decimal) {
        int scale = decimal.scale();
        BigInteger bigInt = decimal.unscaledValue();
        if (bigInt.compareTo(MAX_I) > 0 || bigInt.compareTo(MIN_I) < 0) {
            return null;
        }
        return DecimalNode.valueOf(bigInt.longValue(), scale);
    }

    public static DecimalNode valueOf(long binValue, int scale) {
        if (scale < -128 || scale > 127) {
            return null;
        }
        if (binValue < -140737488355328L || binValue > 0x7FFFFFFFFFFFL) {
            return null;
        }
        return new DecimalNode(binValue, scale);
    }

    private DecimalNode(long value, int scale) {
        this.scale = scale;
        this.value = value;
    }

    public long pack() {
        return DecimalNode.pack(this.value, this.scale);
    }

    public static long pack(long value, int scale) {
        long v = BitsLong.pack(0L, 2L, 56, 64);
        v = BitsLong.pack(v, scale, SCALE_LO, SCALE_HI);
        v = BitsLong.pack(v, value, VALUE_LO, VALUE_HI);
        return v;
    }

    public static DecimalNode unpack(long v) {
        int scale = (int)BitsLong.unpack(v, SCALE_LO, SCALE_HI);
        long value = BitsLong.unpack(v, VALUE_LO, VALUE_HI);
        return new DecimalNode(value, scale);
    }

    public static BigDecimal unpackAsBigDecimal(long v) {
        int scale = (int)BitsLong.unpack(v, SCALE_LO, SCALE_HI);
        long value = BitsLong.unpack(v, VALUE_LO, VALUE_HI);
        if (BitsLong.isSet(value, VALUE_HI - 1)) {
            value |= -1L << VALUE_HI;
        }
        return BigDecimal.valueOf(value, scale);
    }

    public BigDecimal get() {
        if (this.decimal == null) {
            this.decimal = BigDecimal.valueOf(this.value, this.scale);
        }
        return this.decimal;
    }

    public String toString() {
        return this.get().toPlainString();
    }

    public int getScale() {
        return this.scale;
    }

    public long getValue() {
        return this.value;
    }
}

