/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.solver;

import java.util.function.Predicate;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.optimize.TransformFilterPlacement;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIterPeek;
import org.apache.jena.sparql.engine.main.OpExecutor;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.main.iterator.QueryIterGraph;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderProc;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.mgt.Explain;
import org.apache.jena.tdb.solver.PatternMatchTDB1;
import org.apache.jena.tdb.solver.QC2;
import org.apache.jena.tdb.solver.SolverLibTDB;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.GraphTDB;
import org.apache.jena.tdb.store.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpExecutorTDB1
extends OpExecutor {
    private static final Logger log = LoggerFactory.getLogger(OpExecutorTDB1.class);
    public static final OpExecutorFactory OpExecFactoryTDB = new OpExecutorFactory(){

        @Override
        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorTDB1(execCxt);
        }
    };
    private final boolean isForTDB;
    private static OpExecutorFactory plainFactory = new OpExecutorPlainFactoryTDB();

    public OpExecutorTDB1(ExecutionContext execCxt) {
        super(execCxt);
        this.isForTDB = execCxt.getActiveGraph() instanceof GraphTDB;
    }

    @Override
    protected QueryIterator exec(Op op, QueryIterator input) {
        if (this.level < 0) {
            Explain.explain("TDB1", op, this.execCxt.getContext());
        }
        return super.exec(op, input);
    }

    @Override
    protected QueryIterator execute(OpFilter opFilter, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opFilter, input);
        }
        if (OpBGP.isBGP(opFilter.getSubOp())) {
            GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
            OpBGP opBGP = (OpBGP)opFilter.getSubOp();
            return OpExecutorTDB1.executeBGP(graph, opBGP, input, opFilter.getExprs(), this.execCxt);
        }
        if (opFilter.getSubOp() instanceof OpQuadPattern) {
            OpQuadPattern quadPattern = (OpQuadPattern)opFilter.getSubOp();
            DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
            return OpExecutorTDB1.optimizeExecuteQuads(ds, input, quadPattern.getGraphNode(), quadPattern.getBasicPattern(), opFilter.getExprs(), this.execCxt);
        }
        return super.execute(opFilter, input);
    }

    @Override
    protected QueryIterator execute(OpBGP opBGP, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(opBGP, input);
        }
        GraphTDB graph = (GraphTDB)this.execCxt.getActiveGraph();
        return OpExecutorTDB1.executeBGP(graph, opBGP, input, null, this.execCxt);
    }

    @Override
    protected QueryIterator execute(OpQuadPattern quadPattern, QueryIterator input) {
        if (!this.isForTDB) {
            return super.execute(quadPattern, input);
        }
        DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
        BasicPattern bgp = quadPattern.getBasicPattern();
        Node gn = quadPattern.getGraphNode();
        return OpExecutorTDB1.optimizeExecuteQuads(ds, input, gn, bgp, null, this.execCxt);
    }

    @Override
    protected QueryIterator execute(OpGraph opGraph, QueryIterator input) {
        return new QueryIterGraph(input, opGraph, this.execCxt);
    }

    private static QueryIterator executeBGP(GraphTDB graph, OpBGP opBGP, QueryIterator input, ExprList exprs, ExecutionContext execCxt) {
        DatasetGraphTDB dsgtdb = graph.getDatasetGraphTDB();
        if (!OpExecutorTDB1.isDefaultGraphStorage(graph.getGraphName())) {
            return OpExecutorTDB1.optimizeExecuteQuads(dsgtdb, input, graph.getGraphName(), opBGP.getPattern(), exprs, execCxt);
        }
        return OpExecutorTDB1.optimizeExecuteTriples(dsgtdb, input, opBGP.getPattern(), exprs, execCxt);
    }

    private static QueryIterator optimizeExecuteTriples(DatasetGraphTDB dsgtdb, QueryIterator input, BasicPattern pattern, ExprList exprs, ExecutionContext execCxt) {
        ReorderTransformation transform;
        if (!input.hasNext()) {
            return input;
        }
        if (pattern.size() >= 2 && (transform = dsgtdb.getReorderTransform()) != null) {
            QueryIterPeek peek = QueryIterPeek.create(input, execCxt);
            input = peek;
            pattern = OpExecutorTDB1.reorder(pattern, peek, transform);
        }
        Op op = null;
        op = exprs != null ? TransformFilterPlacement.transform(exprs, pattern) : new OpBGP(pattern);
        return OpExecutorTDB1.plainExecute(op, input, execCxt);
    }

    private static QueryIterator optimizeExecuteQuads(DatasetGraphTDB ds, QueryIterator input, Node gn, BasicPattern bgp, ExprList exprs, ExecutionContext execCxt) {
        ReorderTransformation transform;
        if (!input.hasNext()) {
            return input;
        }
        if ((gn = OpExecutorTDB1.decideGraphNode(gn, execCxt)) == null) {
            return OpExecutorTDB1.optimizeExecuteTriples(ds, input, bgp, exprs, execCxt);
        }
        if (bgp.size() >= 2 && (transform = ds.getReorderTransform()) != null) {
            QueryIterPeek peek = QueryIterPeek.create(input, execCxt);
            input = peek;
            bgp = OpExecutorTDB1.reorder(bgp, peek, transform);
        }
        Op op = null;
        op = exprs != null ? TransformFilterPlacement.transform(exprs, gn, bgp) : new OpQuadPattern(gn, bgp);
        return OpExecutorTDB1.plainExecute(op, input, execCxt);
    }

    private static QueryIterator plainExecute(Op op, QueryIterator input, ExecutionContext execCxt) {
        ExecutionContext ec2 = new ExecutionContext(execCxt);
        ec2.setExecutor(plainFactory);
        return QC.execute(op, input, ec2);
    }

    private static BasicPattern reorder(BasicPattern pattern, QueryIterPeek peek, ReorderTransformation transform) {
        if (transform != null) {
            if (!peek.hasNext()) {
                throw new ARQInternalErrorException("Peek iterator is already empty");
            }
            BasicPattern pattern2 = Substitute.substitute(pattern, peek.peek());
            ReorderProc proc = transform.reorderIndexes(pattern2);
            pattern = proc.reorder(pattern);
        }
        return pattern;
    }

    public static Node decideGraphNode(Node gn, ExecutionContext execCxt) {
        if (OpExecutorTDB1.isDefaultGraphStorage(gn)) {
            return null;
        }
        if (Quad.isUnionGraph(gn)) {
            return Node.ANY;
        }
        return gn;
    }

    private static boolean isDefaultGraphStorage(Node gn) {
        if (gn == null) {
            return true;
        }
        return Quad.isDefaultGraph(gn);
    }

    @Override
    protected QueryIterator execute(OpDatasetNames dsNames, QueryIterator input) {
        DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
        Predicate<Tuple<NodeId>> filter = QC2.getFilter(this.execCxt.getContext());
        Node gn = dsNames.getGraphNode();
        if (Var.isVar(gn)) {
            return SolverLibTDB.graphNames(ds, dsNames.getGraphNode(), input, filter, this.execCxt);
        }
        return SolverLibTDB.testForGraphName(ds, dsNames.getGraphNode(), input, filter, this.execCxt);
    }

    private static class OpExecutorPlainTDB
    extends OpExecutor {
        Predicate<Tuple<NodeId>> filter = null;

        public OpExecutorPlainTDB(ExecutionContext execCxt) {
            super(execCxt);
            this.filter = QC2.getFilter(execCxt.getContext());
        }

        @Override
        public QueryIterator execute(OpBGP opBGP, QueryIterator input) {
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof GraphTDB) {
                BasicPattern bgp = opBGP.getPattern();
                Explain.explain("Execute", bgp, this.execCxt.getContext());
                GraphTDB gtdb = (GraphTDB)g;
                Node gn = OpExecutorTDB1.decideGraphNode(gtdb.getGraphName(), this.execCxt);
                return PatternMatchTDB1.execute(gtdb.getDatasetGraphTDB(), gn, bgp, input, this.filter, this.execCxt);
            }
            Log.warn(this, "Non-GraphTDB passed to OpExecutorPlainTDB");
            return super.execute(opBGP, input);
        }

        @Override
        public QueryIterator execute(OpQuadPattern opQuadPattern, QueryIterator input) {
            Node gn = opQuadPattern.getGraphNode();
            gn = OpExecutorTDB1.decideGraphNode(gn, this.execCxt);
            if (this.execCxt.getDataset() instanceof DatasetGraphTDB) {
                DatasetGraphTDB ds = (DatasetGraphTDB)this.execCxt.getDataset();
                Explain.explain("Execute", opQuadPattern.getPattern(), this.execCxt.getContext());
                BasicPattern bgp = opQuadPattern.getBasicPattern();
                return PatternMatchTDB1.execute(ds, gn, bgp, input, this.filter, this.execCxt);
            }
            Graph g = this.execCxt.getActiveGraph();
            if (g instanceof GraphTDB) {
                BasicPattern bgp = opQuadPattern.getBasicPattern();
                Explain.explain("Execute", bgp, this.execCxt.getContext());
                return PatternMatchTDB1.execute(((GraphTDB)g).getDatasetGraphTDB(), gn, bgp, input, this.filter, this.execCxt);
            }
            Log.warn(this, "Non-DatasetGraphTDB passed to OpExecutorPlainTDB");
            return super.execute(opQuadPattern, input);
        }
    }

    private static class OpExecutorPlainFactoryTDB
    implements OpExecutorFactory {
        private OpExecutorPlainFactoryTDB() {
        }

        @Override
        public OpExecutor create(ExecutionContext execCxt) {
            return new OpExecutorPlainTDB(execCxt);
        }
    }
}

