/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.base.file;

import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.tdb.base.file.ChannelManager;
import org.apache.jena.tdb.base.file.FileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBase
implements Sync,
Closeable {
    private static Logger log = LoggerFactory.getLogger(FileBase.class);
    public final String filename;
    private FileChannel channel;
    public static boolean DEBUG = false;
    private final boolean DebugThis;
    private static long counter = 0L;
    private final long id;

    static FileBase createUnmanged(String filename, FileChannel channel) {
        return new FileBase(filename, channel);
    }

    static FileBase create(String filename) {
        return new FileBase(filename);
    }

    static FileBase create(String filename, String mode) {
        return new FileBase(filename, mode);
    }

    private FileBase(String filename) {
        this(filename, "rw");
    }

    private FileBase(String filename, String mode) {
        this.DebugThis = false;
        this.id = counter++;
        if (this.DebugThis && log.isDebugEnabled()) {
            log.debug("open: [" + this.id + "]" + filename);
        }
        this.filename = filename;
        this.channel = ChannelManager.acquire(filename, mode);
    }

    private FileBase(String filename, FileChannel channel) {
        this.DebugThis = false;
        this.id = -1L;
        this.filename = filename;
        this.channel = channel;
    }

    public final FileChannel channel() {
        return this.channel;
    }

    public long size() {
        try {
            return this.channel.size();
        }
        catch (IOException ex) {
            IO.exception(ex);
            return -1L;
        }
    }

    public boolean isClosed() {
        return this.channel == null;
    }

    @Override
    public void close() {
        if (this.DebugThis) {
            log.debug("close: [" + this.id + "]: " + this.filename);
        }
        ChannelManager.release(this.channel);
        this.channel = null;
    }

    @Override
    public void sync() {
        if (this.DebugThis) {
            log.debug("sync: [" + this.id + "]: " + this.filename);
        }
        try {
            this.channel.force(false);
        }
        catch (IOException ex) {
            throw new FileException("FileBase.sync", ex);
        }
    }

    public String getFilename() {
        return this.filename;
    }
}

