/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.mgt;

import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.irix.IRIs;
import org.apache.jena.sparql.mgt.SystemInfoMBean;

public class SystemInfo
implements SystemInfoMBean {
    private final String name;
    private final Node iri;
    private final String jmxPath;
    private final String version;
    private final String buildDate;

    public SystemInfo(String name, String jmxPath, String version2, String buildDate) {
        this.name = name;
        this.iri = SystemInfo.createIRI(name);
        this.jmxPath = jmxPath;
        this.version = version2;
        this.buildDate = buildDate;
    }

    private static Node createIRI(String iriStr) {
        try {
            return NodeFactory.createURI(IRIs.resolve(iriStr));
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    @Override
    public String getBuildDate() {
        return this.buildDate;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getIRI() {
        return NodeFactory.createURI(this.name);
    }

    public String getJmxPath() {
        return this.jmxPath;
    }
}

