/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecDataset;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineRegistry;
import org.apache.jena.sparql.syntax.syntaxtransform.UpdateTransformOps;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateException;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecDatasetBuilder
implements UpdateExecBuilder {
    private DatasetGraph dataset = null;
    private Query query = null;
    private Context context = null;
    private Map<Var, Node> substitutionMap = null;
    private Binding initialBinding = null;
    private UpdateRequest update = null;
    private UpdateRequest updateRequest = new UpdateRequest();

    public static UpdateExecDatasetBuilder create() {
        return new UpdateExecDatasetBuilder();
    }

    private UpdateExecDatasetBuilder() {
    }

    @Override
    public UpdateExecDatasetBuilder update(UpdateRequest updateRequest) {
        Objects.requireNonNull(updateRequest);
        this.add(updateRequest);
        return this;
    }

    @Override
    public UpdateExecDatasetBuilder update(Update update2) {
        Objects.requireNonNull(update2);
        this.add(update2);
        return this;
    }

    @Override
    public UpdateExecDatasetBuilder update(String updateRequestString) {
        UpdateRequest more = UpdateFactory.create(updateRequestString);
        this.add(more);
        return this;
    }

    public UpdateExecDatasetBuilder dataset(DatasetGraph dsg) {
        this.dataset = dsg;
        return this;
    }

    @Override
    public UpdateExecDatasetBuilder context(Context context2) {
        if (context2 == null) {
            return this;
        }
        this.ensureContext();
        this.context.putAll(context2);
        return this;
    }

    @Override
    public UpdateExecDatasetBuilder set(Symbol symbol, Object value) {
        this.ensureContext();
        this.context.set(symbol, value);
        return this;
    }

    @Override
    public UpdateExecDatasetBuilder set(Symbol symbol, boolean value) {
        this.ensureContext();
        this.context.set(symbol, value);
        return this;
    }

    private void ensureContext() {
        if (this.context == null) {
            this.context = new Context();
        }
    }

    @Override
    public UpdateExecDatasetBuilder substitution(Binding binding) {
        this.ensureSubstitutionMap();
        binding.forEach(this.substitutionMap::put);
        return this;
    }

    @Override
    public UpdateExecDatasetBuilder substitution(Var var, Node value) {
        this.ensureSubstitutionMap();
        this.substitutionMap.put(var, value);
        return this;
    }

    private void ensureSubstitutionMap() {
        if (this.substitutionMap == null) {
            this.substitutionMap = new HashMap<Var, Node>();
        }
    }

    public UpdateExecDatasetBuilder initialBinding(Binding initialBinding) {
        this.initialBinding = initialBinding;
        return this;
    }

    @Override
    public UpdateExec build() {
        Objects.requireNonNull(this.dataset, "No dataset for update");
        Objects.requireNonNull(this.updateRequest, "No update request");
        UpdateRequest actualUpdate = this.updateRequest;
        if (this.substitutionMap != null && !this.substitutionMap.isEmpty()) {
            actualUpdate = UpdateTransformOps.transform(actualUpdate, this.substitutionMap);
        }
        Context cxt = Context.setupContextForDataset(this.context, this.dataset);
        UpdateEngineFactory f = UpdateEngineRegistry.get().find(this.dataset, cxt);
        if (f == null) {
            throw new UpdateException("Failed to find an UpdateEngine");
        }
        UpdateExecDataset uExec = new UpdateExecDataset(actualUpdate, this.dataset, this.initialBinding, cxt, f);
        return uExec;
    }

    @Override
    public void execute() {
        this.build().execute();
    }

    public void execute(DatasetGraph dsg) {
        this.dataset(dsg);
        this.execute();
    }

    private void add(UpdateRequest request) {
        request.getOperations().forEach(this::add);
    }

    private void add(Update update2) {
        this.updateRequest.add(update2);
    }
}

