/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Transactional;

public class TransactionalNotSupported
implements Transactional {
    public static Transactional create() {
        return new TransactionalNotSupported();
    }

    @Override
    public void begin() {
        throw new UnsupportedOperationException("Transactional.begin()");
    }

    @Override
    public void begin(TxnType txnType) {
        throw new UnsupportedOperationException("Transactional.begin(TxnType)");
    }

    @Override
    public void begin(ReadWrite readWrite) {
        throw new UnsupportedOperationException("Transactional.begin(ReadWrite)");
    }

    @Override
    public boolean promote(Transactional.Promote txnType) {
        throw new UnsupportedOperationException("Transactional.promote");
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException("Transactional.commit");
    }

    @Override
    public void abort() {
        throw new UnsupportedOperationException("Transactional.abort");
    }

    @Override
    public boolean isInTransaction() {
        return false;
    }

    @Override
    public ReadWrite transactionMode() {
        throw new UnsupportedOperationException("Transactional.transactionMode");
    }

    @Override
    public TxnType transactionType() {
        throw new UnsupportedOperationException("Transactional.transactionType");
    }

    @Override
    public void end() {
        throw new UnsupportedOperationException("Transactional.end");
    }

    public boolean supportsTransactions() {
        return false;
    }

    public boolean supportsTransactionAbort() {
        return false;
    }

    private static class Example
    implements Transactional {
        private final Transactional txn = new TransactionalNotSupported();

        private Example() {
        }

        @Override
        public void begin() {
            this.txn.begin();
        }

        @Override
        public void begin(TxnType txnType) {
            this.txn.begin(txnType);
        }

        @Override
        public void begin(ReadWrite mode) {
            this.txn.begin(mode);
        }

        @Override
        public void commit() {
            this.txn.commit();
        }

        @Override
        public void abort() {
            this.txn.abort();
        }

        @Override
        public boolean promote(Transactional.Promote mode) {
            return this.txn.promote(mode);
        }

        @Override
        public boolean isInTransaction() {
            return this.txn.isInTransaction();
        }

        @Override
        public void end() {
            this.txn.end();
        }

        @Override
        public ReadWrite transactionMode() {
            return this.txn.transactionMode();
        }

        @Override
        public TxnType transactionType() {
            return this.txn.transactionType();
        }
    }
}

