/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.sys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.shex.ShexMap;
import org.apache.jena.shex.ShexRecord;
import org.apache.jena.shex.ShexReport;
import org.apache.jena.shex.ShexSchema;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.ShexStatus;
import org.apache.jena.shex.ShexValidator;
import org.apache.jena.shex.sys.ReportItem;
import org.apache.jena.shex.sys.ShexLib;
import org.apache.jena.shex.sys.SysShex;
import org.apache.jena.shex.sys.ValidationContext;

class ShexValidatorImpl
implements ShexValidator {
    ShexValidatorImpl() {
    }

    public static ShexValidator get() {
        return SysShex.get();
    }

    @Override
    public ShexReport validate(Graph dataGraph, ShexSchema shapes, ShexMap shapeMap) {
        Objects.requireNonNull(dataGraph);
        Objects.requireNonNull(shapes);
        Objects.requireNonNull(shapeMap);
        shapes = shapes.importsClosure();
        ValidationContext vCxt = new ValidationContext(dataGraph, shapes);
        ArrayList reports = new ArrayList();
        shapeMap.entries().forEach(mapEntry -> {
            Collection<Node> focusNodes = ShexValidatorImpl.focusNodes(dataGraph, mapEntry);
            if (focusNodes == null) {
                throw new InternalErrorException("Shex shape mapping has no node and no pattern");
            }
            for (Node focus : focusNodes) {
                ShexValidatorImpl.validationStep(vCxt, mapEntry, mapEntry.shapeExprLabel, focus);
            }
        });
        ShexReport report = vCxt.generateReport();
        return report;
    }

    @Override
    public ShexReport validate(Graph dataGraph, ShexSchema shapes, Node shapeRef, Node focus) {
        Objects.requireNonNull(shapeRef);
        Objects.requireNonNull(focus);
        Objects.requireNonNull(shapes);
        Objects.requireNonNull(dataGraph);
        ShexRecord entry = new ShexRecord(focus, shapeRef);
        shapes = shapes.importsClosure();
        ValidationContext vCxt = new ValidationContext(dataGraph, shapes);
        boolean isValid = ShexValidatorImpl.validationStep(vCxt, entry, shapeRef, focus);
        return vCxt.generateReport();
    }

    @Override
    public ShexReport validate(Graph dataGraph, ShexSchema shapes, ShexShape shape, Node focus) {
        Objects.requireNonNull(shape);
        Objects.requireNonNull(shapes);
        Objects.requireNonNull(dataGraph);
        Objects.requireNonNull(focus);
        ShexRecord entry = new ShexRecord(focus, shape.getLabel());
        shapes = shapes.importsClosure();
        ValidationContext vCxt = new ValidationContext(dataGraph, shapes);
        boolean isValid = ShexValidatorImpl.validationStep(vCxt, entry, entry.shapeExprLabel, focus);
        return vCxt.generateReport();
    }

    @Override
    public ShexReport validate(Graph dataGraph, ShexSchema shapes, ShexMap shapeMap, Node focus) {
        Objects.requireNonNull(shapes);
        Objects.requireNonNull(dataGraph);
        Objects.requireNonNull(shapeMap);
        Objects.requireNonNull(focus);
        shapes = shapes.importsClosure();
        ValidationContext vCxt = new ValidationContext(dataGraph, shapes);
        ArrayList reports = new ArrayList();
        shapeMap.entries().forEach(mapEntry -> ShexValidatorImpl.validateOneShapeRecord(vCxt, mapEntry, focus));
        ShexReport report = vCxt.generateReport();
        return report;
    }

    private static boolean validateOneShapeRecord(ValidationContext vCxt, ShexRecord shapeRecord, Node focusNode) {
        Collection<Node> focusNodes = ShexValidatorImpl.focusNodes(vCxt.getData(), shapeRecord);
        if (focusNodes == null) {
            throw new InternalErrorException("Shex shape mapping has no node and no pattern");
        }
        if (!focusNodes.contains(focusNode)) {
            return true;
        }
        return ShexValidatorImpl.validationStep(vCxt, shapeRecord, shapeRecord.shapeExprLabel, focusNode);
    }

    private static Collection<Node> focusNodes(Graph graph, ShexRecord mapRecord) {
        if (mapRecord.node != null) {
            return List.of(mapRecord.node);
        }
        if (mapRecord.pattern != null) {
            Triple t = mapRecord.asMatcher();
            Set<Node> focusNodes = graph.find(t).mapWith(triple -> ShexValidatorImpl.focusFromRecord(mapRecord, triple)).toSet();
            return focusNodes;
        }
        return null;
    }

    private static Node focusFromRecord(ShexRecord mapRecord, Triple triple) {
        if (mapRecord.isSubjectFocus()) {
            return triple.getSubject();
        }
        if (mapRecord.isObjectFocus()) {
            return triple.getObject();
        }
        return null;
    }

    private static boolean validationStep(ValidationContext vCxt, ShexRecord mapEntry, Node shapeRef, Node focus) {
        ShexValidatorImpl.track(mapEntry.shapeExprLabel, focus);
        ShexShape shape = vCxt.getShape(shapeRef);
        if (shape == null) {
            vCxt.getShape(shapeRef);
            String msg = "No such shape: " + ShexLib.displayStr(shapeRef);
            ReportItem item = new ReportItem(msg, shapeRef);
            vCxt.reportEntry(item);
            ShexValidatorImpl.report(vCxt, mapEntry, shapeRef, ShexStatus.nonconformant, msg);
            return false;
        }
        return ShexValidatorImpl.validationStepWorker(vCxt, mapEntry, shape, shapeRef, focus);
    }

    private static boolean validationStepWorker(ValidationContext vCxt, ShexRecord mapEntry, ShexShape shape, Node shapeRef, Node focus) {
        ValidationContext vCxtInner = ValidationContext.create(vCxt);
        vCxtInner.startValidate(shape, focus);
        boolean isValid = shape.satisfies(vCxtInner, focus);
        vCxtInner.finishValidate(shape, focus);
        if (!isValid) {
            ShexValidatorImpl.atLeastOneReportItem(vCxtInner, focus);
            vCxtInner.copyInto(vCxt);
        }
        ShexValidatorImpl.createShexReportLine(vCxt, mapEntry, isValid, shapeRef, focus);
        return isValid;
    }

    private static void createShexReportLine(ValidationContext vCxt, ShexRecord mapEntry, boolean conforms, Node shapeRef, Node focus) {
        if (conforms) {
            ShexValidatorImpl.report(vCxt, mapEntry, focus, ShexStatus.conformant, null);
            return;
        }
        if (mapEntry == null) {
            return;
        }
        ReportItem item = ListUtils.last(vCxt.getReportItems());
        String reason = item != null ? item.getMessage() : null;
        ShexValidatorImpl.report(vCxt, mapEntry, focus, ShexStatus.nonconformant, reason);
    }

    private static void atLeastOneReportItem(ValidationContext vCxt, Node focus) {
        if (vCxt.getReportItems().isEmpty()) {
            ReportItem reportItem = new ReportItem("Failed", focus);
            vCxt.reportEntry(reportItem);
        }
    }

    private static void report(ValidationContext vCxt, ShexRecord entry, Node focusNode, ShexStatus result, String reason) {
        vCxt.shexReport(entry, focusNode, result, reason);
    }

    private static void track(Node shapeExprLabel, Node focus) {
    }
}

