/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.expressions.TripleExprVisitor;
import org.apache.jena.shex.expressions.TripleExpression;

public class TripleExprOneOf
extends TripleExpression {
    private List<TripleExpression> tripleExpressions;

    public static TripleExpression create(List<TripleExpression> acc) {
        if (acc.size() == 0) {
            throw new InternalErrorException("Empty list");
        }
        if (acc.size() == 1) {
            return acc.get(0);
        }
        return new TripleExprOneOf(acc);
    }

    private TripleExprOneOf(List<TripleExpression> expressions) {
        this.tripleExpressions = expressions;
    }

    public List<TripleExpression> expressions() {
        return this.tripleExpressions;
    }

    @Override
    public void visit(TripleExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(4, this.tripleExpressions);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TripleExprOneOf other = (TripleExprOneOf)obj;
        return Objects.equals(this.tripleExpressions, other.tripleExpressions);
    }

    @Override
    public void print(IndentedWriter iOut, NodeFormatter nFmt) {
        iOut.println("OneOf");
        iOut.incIndent();
        int idx = 0;
        for (TripleExpression tExpr : this.tripleExpressions) {
            iOut.printf("%d - ", ++idx);
            tExpr.print(iOut, nFmt);
        }
        iOut.decIndent();
        iOut.println("/OneOf");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.tripleExpressions + "]";
    }
}

