/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.parser.Constraint;
import org.apache.jena.shacl.parser.Shape;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.path.Path;

public abstract class ConstraintPairwise
implements Constraint {
    protected final Node value;
    private final Node constraintComponent;

    protected ConstraintPairwise(Node value, Node constraintComponent) {
        this.value = value;
        this.constraintComponent = constraintComponent;
    }

    public Node getValue() {
        return this.value;
    }

    @Override
    public final Node getComponent() {
        return this.constraintComponent;
    }

    @Override
    public void validateNodeShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode) {
        this.validatePropertyShape(vCxt, data, shape, focusNode, null, Collections.singleton(focusNode));
    }

    @Override
    public final void validatePropertyShape(ValidationContext vCxt, Graph data, Shape shape, Node focusNode, Path path, Set<Node> pathNodes) {
        Set<Node> compareNodes = G.allSP(data, focusNode, this.value);
        this.validate(vCxt, shape, focusNode, path, pathNodes, compareNodes);
    }

    public abstract void validate(ValidationContext var1, Shape var2, Node var3, Path var4, Set<Node> var5, Set<Node> var6);

    protected int compare(Node n1, Node n2) {
        NodeValue nv1 = NodeValue.makeNode(n1);
        NodeValue nv2 = NodeValue.makeNode(n2);
        try {
            return NodeValue.compare(nv1, nv2);
        }
        catch (ExprNotComparableException ex) {
            return -999;
        }
    }

    public int hashCode() {
        return Objects.hash(this.constraintComponent, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstraintPairwise other = (ConstraintPairwise)obj;
        return Objects.equals(this.constraintComponent, other.constraintComponent) && Objects.equals(this.value, other.value);
    }
}

