/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.other.G;
import org.apache.jena.shacl.engine.TargetOps;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.vocabulary.SHACL;

public class Targets {
    public Graph shapesGraph;
    public Set<Node> targetNodes;
    public Set<Node> targetClasses;
    public Set<Node> targetObjectsOf;
    public Set<Node> propertyTargetObjectsOf;
    public Set<Node> targetSubjectsOf;
    public Set<Node> propertyTargetSubjectsOf;
    public Set<Node> implicitClassTargets;
    public Set<Node> targetExtension;
    public Set<Node> allTargets;

    public static Targets create(Graph shapesGraph) {
        Targets targets = new Targets();
        targets.shapesGraph = shapesGraph;
        targets.targetNodes = TargetOps.shapesTargetNode(shapesGraph);
        targets.targetClasses = TargetOps.shapesTargetClass(shapesGraph);
        targets.targetObjectsOf = TargetOps.shapesTargetObjectsOf(shapesGraph);
        targets.targetSubjectsOf = TargetOps.shapesTargetSubjectsOf(shapesGraph);
        targets.implicitClassTargets = TargetOps.implicitClassTargets(shapesGraph);
        targets.targetExtension = TargetOps.shapesTargetExtension(shapesGraph);
        targets.propertyTargetObjectsOf = Targets.targetPredicatesOf(shapesGraph, SHACL.targetObjectsOf, targets.targetObjectsOf);
        targets.propertyTargetSubjectsOf = Targets.targetPredicatesOf(shapesGraph, SHACL.targetSubjectsOf, targets.targetSubjectsOf);
        HashSet<Node> allTargets = new HashSet<Node>();
        allTargets.addAll(targets.targetNodes);
        allTargets.addAll(targets.targetClasses);
        allTargets.addAll(targets.targetObjectsOf);
        allTargets.addAll(targets.targetSubjectsOf);
        allTargets.addAll(targets.implicitClassTargets);
        allTargets.addAll(targets.targetExtension);
        targets.allTargets = allTargets;
        return targets;
    }

    public Graph getShapesGraph() {
        return this.shapesGraph;
    }

    public Set<Node> getTargetNodes() {
        return this.targetNodes;
    }

    public Set<Node> getTargetClasses() {
        return this.targetClasses;
    }

    public Set<Node> getTargetObjectsOf() {
        return this.targetObjectsOf;
    }

    public Set<Node> getPropertyTargetObjectsOf() {
        return this.propertyTargetObjectsOf;
    }

    public Set<Node> getTargetSubjectsOf() {
        return this.targetSubjectsOf;
    }

    public Set<Node> getPropertyTargetSubjectsOf() {
        return this.propertyTargetSubjectsOf;
    }

    public Set<Node> getClassNodeShape() {
        return this.implicitClassTargets;
    }

    public Set<Node> getTargetExt() {
        return this.targetExtension;
    }

    private Targets() {
    }

    public Set<Node> targets() {
        return this.allTargets;
    }

    static Set<Node> targetPredicatesOf(Graph shapesGraph, Node predicate, Set<Node> targetsOf) {
        if (!predicate.equals(SHACL.targetObjectsOf) && !predicate.equals(SHACL.targetSubjectsOf)) {
            throw new IllegalArgumentException(ShLib.displayStr(predicate));
        }
        Set<Node> x = targetsOf.stream().flatMap(shape -> G.listSP(shapesGraph, shape, predicate).stream()).collect(Collectors.toSet());
        return x;
    }

    public void output(OutputStream out) {
        PrintStream pOut = new PrintStream(out);
        pOut.println("targetNode:       " + this.targetNodes);
        pOut.println("targetClass:      " + this.targetClasses);
        pOut.println("targetObjectsOf:  " + this.targetObjectsOf);
        pOut.println("targetSubjectsOf: " + this.targetSubjectsOf);
        pOut.println("sh:NodeShape:     " + this.implicitClassTargets);
        pOut.flush();
    }
}

