/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Node;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.NodeToLabelMap;

public class ResultSetWriterCSV
implements ResultSetWriter {
    public static ResultSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_CSV)) {
            throw new ResultSetException("ResultSetWriter for CSV asked for a " + lang);
        }
        return new ResultSetWriterCSV();
    };
    static final String NL = "\r\n";
    static final String headerBytes = "_askResult\r\n";
    static final String yesBytes = "true";
    static final String noBytes = "false";

    private ResultSetWriterCSV() {
    }

    @Override
    public void write(OutputStream out, ResultSet resultSet, Context context2) {
        ResultSetWriterCSV.output(IO.wrapUTF8(out), resultSet);
    }

    @Override
    public void write(Writer out, ResultSet resultSet, Context context2) {
        ResultSetWriterCSV.output(IO.wrap(out), resultSet);
    }

    @Override
    public void write(OutputStream out, boolean result, Context context2) {
        ResultSetWriterCSV.output(IO.wrapUTF8(out), result);
    }

    private static void output(AWriter out, boolean booleanResult) {
        out.write(headerBytes);
        if (booleanResult) {
            out.write(yesBytes);
        } else {
            out.write(noBytes);
        }
        out.write(NL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void output(AWriter out, ResultSet resultSet) {
        try {
            NodeToLabelMap bnodes = new NodeToLabelMap();
            String sep = null;
            List<String> varNames = resultSet.getResultVars();
            ArrayList<Var> vars = new ArrayList<Var>(varNames.size());
            for (String v : varNames) {
                if (sep != null) {
                    out.write(sep);
                } else {
                    sep = ",";
                }
                out.write(ResultSetWriterCSV.csvSafe(v));
                vars.add(Var.alloc(v));
            }
            out.write(NL);
            while (resultSet.hasNext()) {
                sep = null;
                Binding b = resultSet.nextBinding();
                for (Var v : vars) {
                    if (sep != null) {
                        out.write(sep);
                    }
                    sep = ",";
                    Node n = b.get(v);
                    if (n == null) continue;
                    ResultSetWriterCSV.output(out, n, bnodes);
                }
                out.write(NL);
            }
        }
        finally {
            out.flush();
        }
    }

    private static void output(AWriter w, Node n, NodeToLabelMap bnodes) {
        String str2 = "?";
        if (n.isLiteral()) {
            str2 = n.getLiteralLexicalForm();
        } else if (n.isURI()) {
            str2 = n.getURI();
        } else if (n.isBlank()) {
            str2 = bnodes.asString(n);
        }
        str2 = ResultSetWriterCSV.csvSafe(str2);
        w.write(str2);
        w.flush();
    }

    protected static String csvSafe(String str2) {
        if (((String)str2).contains("\"") || ((String)str2).contains(",") || ((String)str2).contains("\r") || ((String)str2).contains("\n")) {
            str2 = "\"" + ((String)str2).replaceAll("\"", "\"\"") + "\"";
        } else if (((String)str2).isEmpty()) {
            str2 = "\"\"";
        }
        return str2;
    }
}

