/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdf.model.RDFWriterI;
import org.apache.jena.rdf.model.impl.RDFDefaultErrorHandler;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFWriter;
import org.apache.jena.riot.RDFWriterBuilder;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class RDFWriterRIOT
implements RDFWriterI {
    private final String basename;
    private final String jenaName;
    private Context context = null;
    private Map<String, Object> properties = null;
    private RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();

    public RDFWriterRIOT(String jenaName) {
        this.basename = "org.apache.jena.riot.writer." + jenaName.toLowerCase(Locale.ROOT);
        this.jenaName = jenaName;
    }

    protected RDFWriterBuilder writer() {
        if (this.jenaName == null) {
            throw new IllegalArgumentException("Jena writer name is null");
        }
        RDFWriterBuilder builder = RDFWriter.create();
        Lang lang = RDFLanguages.nameToLang(this.jenaName);
        if (lang != null) {
            return builder.lang(lang);
        }
        throw new RiotException("No graph writer for '" + this.jenaName + "'");
    }

    @Override
    public void write(Model model, Writer out, String base) {
        if (base != null && base.equals("")) {
            base = null;
        }
        this.writer().source(model).context(this.context).base(base).build().output(out);
    }

    @Override
    public void write(Model model, OutputStream out, String base) {
        if (base != null && base.equals("")) {
            base = null;
        }
        this.writer().source(model).context(this.context).base(base).output(out);
    }

    @Override
    public Object setProperty(String propName, Object propValue) {
        if (this.context == null) {
            this.context = RIOT.getContext().copy();
            this.properties = new HashMap<String, Object>();
            this.context.put(SysRIOT.sysRdfWriterProperties, this.properties);
        }
        Symbol sym = Symbol.create(this.basename + "#" + propName);
        Object oldObj = this.properties.get(propName);
        this.properties.put(propName, propValue);
        return oldObj;
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        RDFErrorHandler old = this.errorHandler;
        this.errorHandler = errHandler;
        return old;
    }
}

