/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.TypedInputStream;
import org.apache.jena.graph.Graph;
import org.apache.jena.http.HttpLib;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIxResolver;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserBuilder;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.WebContent;
import org.apache.jena.riot.process.normalize.StreamCanonicalLangTag;
import org.apache.jena.riot.process.normalize.StreamCanonicalLiterals;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.ParserProfileStd;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.system.stream.StreamManager;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class RDFParser {
    private final String uri;
    private final Path path;
    private final String stringToParse;
    private final InputStream inputStream;
    private final Reader javaReader;
    private final StreamManager streamManager;
    private final String appAcceptHeader;
    private final Map<String, String> httpHeaders;
    private final HttpClient httpClient;
    private final Lang hintLang;
    private final Lang forceLang;
    private final String baseURI;
    private final boolean strict;
    private final boolean resolveURIs;
    private final IRIxResolver resolver;
    private final boolean canonicalLexicalValues;
    private final LangTagForm langTagForm;
    private final Optional<Boolean> checking;
    private final FactoryRDF factory;
    private final ErrorHandler errorHandler;
    private final Context context;
    private boolean canUseThisParser = true;

    public static RDFParserBuilder create() {
        return RDFParserBuilder.create();
    }

    public static RDFParserBuilder source(Path path) {
        return RDFParserBuilder.create().source(path);
    }

    public static RDFParserBuilder source(String uriOrFile) {
        return RDFParserBuilder.create().source(uriOrFile);
    }

    public static RDFParserBuilder fromString(String string) {
        return RDFParserBuilder.create().fromString(string);
    }

    public static RDFParserBuilder source(InputStream input) {
        return RDFParserBuilder.create().source(input);
    }

    RDFParser(String uri, Path path, String content, InputStream inputStream, Reader javaReader, StreamManager streamManager, String appAcceptHeader, Map<String, String> httpHeaders, HttpClient httpClient, Lang hintLang, Lang forceLang, String parserBaseURI, boolean strict, Optional<Boolean> checking, boolean canonicalLexicalValues, LangTagForm langTagForm, boolean resolveURIs, IRIxResolver resolver, FactoryRDF factory, ErrorHandler errorHandler, Context context2) {
        int x = this.countNonNull(uri, path, content, inputStream, javaReader);
        if (x >= 2) {
            throw new IllegalArgumentException("Only one source allowed: one of uri, path, content, inputStream and javaReader must be set");
        }
        if (x < 1) {
            throw new IllegalArgumentException("No source specified allowed: one of uri, path, content, inputStream and javaReader must be set");
        }
        Objects.requireNonNull(factory);
        Objects.requireNonNull(errorHandler);
        Objects.requireNonNull(checking);
        this.uri = uri;
        this.path = path;
        this.stringToParse = content;
        this.inputStream = inputStream;
        this.javaReader = javaReader;
        this.streamManager = streamManager;
        this.appAcceptHeader = appAcceptHeader;
        this.httpHeaders = httpHeaders;
        this.httpClient = httpClient;
        this.hintLang = hintLang;
        this.forceLang = forceLang;
        this.baseURI = parserBaseURI;
        this.strict = strict;
        this.resolveURIs = resolveURIs;
        this.resolver = resolver;
        this.canonicalLexicalValues = canonicalLexicalValues;
        this.langTagForm = langTagForm;
        this.checking = checking;
        this.factory = factory;
        this.errorHandler = errorHandler;
        this.context = context2;
    }

    private int countNonNull(Object ... objs) {
        int x = 0;
        for (Object obj : objs) {
            if (obj == null) continue;
            ++x;
        }
        return x;
    }

    private boolean isNonNull(Object ... objs) {
        boolean x = false;
        for (Object obj : objs) {
            if (obj == null) continue;
            return true;
        }
        return false;
    }

    private boolean allNull(Object ... objs) {
        boolean x = false;
        for (Object obj : objs) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    public void parse(Graph graph) {
        this.parse(StreamRDFLib.graph(graph));
    }

    public void parse(Model model) {
        this.parse(model.getGraph());
    }

    public void parse(DatasetGraph dataset) {
        this.parse(StreamRDFLib.dataset(dataset));
    }

    public void parse(Dataset dataset) {
        this.parse(dataset.asDatasetGraph());
    }

    public void parse(StreamRDF destination) {
        if (!this.canUseThisParser) {
            throw new RiotException("Parser has been used once and can not be used again");
        }
        this.canUseThisParser = this.inputStream == null && this.javaReader == null;
        this.factory.reset();
        if (this.canonicalLexicalValues) {
            destination = new StreamCanonicalLiterals(destination);
        }
        switch (this.langTagForm) {
            case NONE: {
                break;
            }
            case CANONICAL: {
                destination = StreamCanonicalLangTag.toCanonical(destination);
                break;
            }
            case LOWER_CASE: {
                destination = StreamCanonicalLangTag.toLC(destination);
                break;
            }
            default: {
                throw new InternalErrorException("langTagForm = " + this.langTagForm);
            }
        }
        if (this.isNonNull(this.stringToParse, this.inputStream, this.javaReader)) {
            this.parseNotUri(destination);
            return;
        }
        Objects.requireNonNull(this.baseURI);
        this.parseURI(destination);
    }

    private void parseURI(StreamRDF destination) {
        try (TypedInputStream input = this.openTypedInputStream(this.uri, this.path);){
            ReaderRIOT reader;
            ContentType ct;
            if (this.forceLang != null) {
                ReaderRIOTFactory r = RDFParserRegistry.getFactory(this.forceLang);
                if (r == null) {
                    throw new RiotException("No parser registered for language: " + this.forceLang);
                }
                ct = this.forceLang.getContentType();
                reader = this.createReader(r, this.forceLang);
            } else {
                ct = WebContent.determineCT(input.getContentType(), this.hintLang, this.baseURI);
                if (ct == null) {
                    throw new RiotException("Failed to determine the content type: (URI=" + this.baseURI + " : stream=" + input.getContentType() + ")");
                }
                reader = this.createReader(ct);
                if (reader == null) {
                    throw new RiotException("No parser registered for content type: " + ct.getContentTypeStr());
                }
            }
            RDFParser.read(reader, input, null, this.baseURI, this.context, ct, destination);
        }
    }

    private void parseNotUri(StreamRDF destination) {
        ContentType ct;
        Lang lang = this.hintLang;
        if (this.forceLang != null) {
            lang = this.forceLang;
        }
        if ((ct = WebContent.determineCT(null, lang, this.baseURI)) == null) {
            throw new RiotException("Failed to determine the RDF syntax (.lang or .base required)");
        }
        ReaderRIOT readerRiot = this.createReader(ct);
        if (readerRiot == null) {
            throw new RiotException("No parser registered for content type: " + ct.getContentTypeStr());
        }
        Reader jr = this.javaReader;
        if (this.stringToParse != null) {
            jr = new StringReader(this.stringToParse);
        }
        RDFParser.read(readerRiot, this.inputStream, jr, this.baseURI, this.context, ct, destination);
    }

    private static void read(ReaderRIOT readerRiot, InputStream inputStream, Reader javaReader, String baseUri, Context context2, ContentType ct, StreamRDF destination) {
        if (inputStream != null && javaReader != null) {
            throw new InternalErrorException("Both inputStream and javaReader are non-null");
        }
        if (inputStream != null) {
            readerRiot.read(inputStream, baseUri, ct, destination, context2);
            return;
        }
        if (javaReader != null) {
            readerRiot.read(javaReader, baseUri, ct, destination, context2);
            return;
        }
        throw new InternalErrorException("Both inputStream and javaReader are null");
    }

    private TypedInputStream openTypedInputStream(String urlStr, Path path) {
        TypedInputStream in;
        if (path != null) {
            try {
                InputStream in2 = Files.newInputStream(path, new OpenOption[0]);
                ContentType ct = RDFLanguages.guessContentType(urlStr);
                return new TypedInputStream(in2, ct);
            }
            catch (FileNotFoundException | NoSuchFileException ex) {
                throw new RiotNotFoundException();
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        }
        if ((urlStr = this.streamManager.mapURI(urlStr)).startsWith("http://") || urlStr.startsWith("https://")) {
            String acceptHeader = HttpLib.dft(this.appAcceptHeader, "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.7,application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.5");
            HttpRequest request = HttpLib.newGetRequest(urlStr, b -> {
                if (this.httpHeaders != null) {
                    this.httpHeaders.forEach(b::header);
                }
                b.setHeader("Accept", acceptHeader);
            });
            HttpResponse<InputStream> response = HttpLib.execute(this.httpClient, request);
            in = HttpLib.handleResponseTypedInputStream(response);
        } else {
            in = this.streamManager.openNoMapOrNull(urlStr);
        }
        if (in == null) {
            throw new RiotNotFoundException("Not found: " + urlStr);
        }
        return in;
    }

    private ReaderRIOT createReader(Lang lang) {
        ReaderRIOTFactory r = RDFParserRegistry.getFactory(lang);
        if (r == null) {
            return null;
        }
        ReaderRIOT reader = this.createReader(r, lang);
        return reader;
    }

    private ReaderRIOT createReader(ContentType ct) {
        Lang lang = RDFLanguages.contentTypeToLang(ct);
        if (lang == null) {
            return null;
        }
        ReaderRIOTFactory r = RDFParserRegistry.getFactory(lang);
        if (r == null) {
            return null;
        }
        ReaderRIOT reader = this.createReader(r, lang);
        return reader;
    }

    private ReaderRIOT createReader(ReaderRIOTFactory r, Lang lang) {
        ParserProfile profile = this.makeParserProfile(lang);
        ReaderRIOT reader = r.create(lang, profile);
        return reader;
    }

    private ParserProfile makeParserProfile(Lang lang) {
        boolean resolve = this.resolveURIs;
        boolean allowRelative = false;
        boolean checking$ = this.strict;
        String baseStr = this.baseURI;
        if (RDFLanguages.sameLang(RDFLanguages.NTRIPLES, lang) || RDFLanguages.sameLang(RDFLanguages.NQUADS, lang)) {
            baseStr = null;
            if (!this.strict) {
                allowRelative = true;
                checking$ = this.checking.orElseGet(() -> false);
            } else {
                resolve = false;
            }
        } else {
            if (!this.strict) {
                checking$ = this.checking.orElseGet(() -> true);
            }
            if (baseStr == null && resolve) {
                baseStr = IRIs.getBaseStr();
            }
        }
        if (RDFLanguages.sameLang(RDFLanguages.RDFJSON, lang)) {
            resolve = false;
        }
        IRIxResolver parserResolver = this.resolver != null ? this.resolver : IRIxResolver.create().base(baseStr).resolve(resolve).allowRelative(allowRelative).build();
        PrefixMap prefixMap = PrefixMapFactory.create();
        ParserProfileStd parserFactory = new ParserProfileStd(this.factory, this.errorHandler, parserResolver, prefixMap, this.context, checking$, this.strict);
        return parserFactory;
    }

    static enum LangTagForm {
        NONE,
        LOWER_CASE,
        CANONICAL;

    }
}

