/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import org.apache.commons.collections.Bag;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.SortedBag;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.bag.HashBag;
import org.apache.commons.collections.bag.PredicatedBag;
import org.apache.commons.collections.bag.PredicatedSortedBag;
import org.apache.commons.collections.bag.SynchronizedBag;
import org.apache.commons.collections.bag.SynchronizedSortedBag;
import org.apache.commons.collections.bag.TransformedBag;
import org.apache.commons.collections.bag.TransformedSortedBag;
import org.apache.commons.collections.bag.TreeBag;
import org.apache.commons.collections.bag.TypedBag;
import org.apache.commons.collections.bag.TypedSortedBag;
import org.apache.commons.collections.bag.UnmodifiableBag;
import org.apache.commons.collections.bag.UnmodifiableSortedBag;

public class BagUtils {
    public static final Bag EMPTY_BAG = UnmodifiableBag.decorate(new HashBag());
    public static final Bag EMPTY_SORTED_BAG = UnmodifiableSortedBag.decorate(new TreeBag());

    public static Bag synchronizedBag(Bag bag2) {
        return SynchronizedBag.decorate(bag2);
    }

    public static Bag unmodifiableBag(Bag bag2) {
        return UnmodifiableBag.decorate(bag2);
    }

    public static Bag predicatedBag(Bag bag2, Predicate predicate) {
        return PredicatedBag.decorate(bag2, predicate);
    }

    public static Bag typedBag(Bag bag2, Class type) {
        return TypedBag.decorate(bag2, type);
    }

    public static Bag transformedBag(Bag bag2, Transformer transformer) {
        return TransformedBag.decorate(bag2, transformer);
    }

    public static SortedBag synchronizedSortedBag(SortedBag bag2) {
        return SynchronizedSortedBag.decorate(bag2);
    }

    public static SortedBag unmodifiableSortedBag(SortedBag bag2) {
        return UnmodifiableSortedBag.decorate(bag2);
    }

    public static SortedBag predicatedSortedBag(SortedBag bag2, Predicate predicate) {
        return PredicatedSortedBag.decorate(bag2, predicate);
    }

    public static SortedBag typedSortedBag(SortedBag bag2, Class type) {
        return TypedSortedBag.decorate(bag2, type);
    }

    public static SortedBag transformedSortedBag(SortedBag bag2, Transformer transformer) {
        return TransformedSortedBag.decorate(bag2, transformer);
    }
}

