/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.jvm;

import com.sun.management.GarbageCollectionNotificationInfo;
import com.sun.management.GcInfo;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.JvmMemory;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import io.micrometer.core.util.internal.logging.InternalLogger;
import io.micrometer.core.util.internal.logging.InternalLoggerFactory;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ListenerNotFoundException;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;

@NonNullApi
@NonNullFields
public class JvmGcMetrics
implements MeterBinder,
AutoCloseable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(JvmGcMetrics.class);
    private final boolean managementExtensionsPresent = JvmGcMetrics.isManagementExtensionsPresent();
    final boolean isGenerationalGc = this.isGenerationalGcConfigured();
    private final Iterable<Tag> tags;
    @Nullable
    private String allocationPoolName;
    private final Set<String> longLivedPoolNames = new HashSet<String>();
    private final List<Runnable> notificationListenerCleanUpRunnables = new CopyOnWriteArrayList<Runnable>();

    public JvmGcMetrics() {
        this(Collections.emptyList());
    }

    public JvmGcMetrics(Iterable<Tag> tags) {
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            String name = mbean.getName();
            if (JvmMemory.isAllocationPool(name)) {
                this.allocationPoolName = name;
            }
            if (!JvmMemory.isLongLivedPool(name)) continue;
            this.longLivedPoolNames.add(name);
        }
        this.tags = tags;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (!this.managementExtensionsPresent) {
            return;
        }
        double maxLongLivedPoolBytes = JvmMemory.getLongLivedHeapPools().mapToDouble(mem -> JvmMemory.getUsageValue(mem, MemoryUsage::getMax)).sum();
        AtomicLong maxDataSize = new AtomicLong((long)maxLongLivedPoolBytes);
        Gauge.builder("jvm.gc.max.data.size", maxDataSize, AtomicLong::get).tags(this.tags).description("Max size of long-lived heap memory pool").baseUnit("bytes").register(registry);
        AtomicLong liveDataSize = new AtomicLong();
        Gauge.builder("jvm.gc.live.data.size", liveDataSize, AtomicLong::get).tags(this.tags).description("Size of long-lived heap memory pool after reclamation").baseUnit("bytes").register(registry);
        Counter allocatedBytes = Counter.builder("jvm.gc.memory.allocated").tags(this.tags).baseUnit("bytes").description("Incremented for an increase in the size of the (young) heap memory pool after one GC to before the next").register(registry);
        Counter promotedBytes = this.isGenerationalGc ? Counter.builder("jvm.gc.memory.promoted").tags(this.tags).baseUnit("bytes").description("Count of positive increases in the size of the old generation memory pool before GC to after GC").register(registry) : null;
        AtomicLong allocationPoolSizeAfter = new AtomicLong(0L);
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            if (!(mbean instanceof NotificationEmitter)) continue;
            NotificationListener notificationListener = (notification, ref) -> {
                long delta;
                CompositeData cd = (CompositeData)notification.getUserData();
                GarbageCollectionNotificationInfo notificationInfo = GarbageCollectionNotificationInfo.from(cd);
                String gcCause = notificationInfo.getGcCause();
                String gcAction = notificationInfo.getGcAction();
                GcInfo gcInfo = notificationInfo.getGcInfo();
                long duration = gcInfo.getDuration();
                if (JvmMemory.isConcurrentPhase(gcCause, notificationInfo.getGcName())) {
                    ((Timer.Builder)Timer.builder("jvm.gc.concurrent.phase.time").tags((Iterable)this.tags)).tags("action", gcAction, "cause", gcCause).description("Time spent in concurrent phase").register(registry).record(duration, TimeUnit.MILLISECONDS);
                } else {
                    ((Timer.Builder)Timer.builder("jvm.gc.pause").tags((Iterable)this.tags)).tags("action", gcAction, "cause", gcCause).description("Time spent in GC pause").register(registry).record(duration, TimeUnit.MILLISECONDS);
                }
                Map<String, MemoryUsage> before = gcInfo.getMemoryUsageBeforeGc();
                Map<String, MemoryUsage> after = gcInfo.getMemoryUsageAfterGc();
                this.countPoolSizeDelta(before, after, allocatedBytes, allocationPoolSizeAfter, this.allocationPoolName);
                long longLivedBefore = this.longLivedPoolNames.stream().mapToLong(pool -> ((MemoryUsage)before.get(pool)).getUsed()).sum();
                long longLivedAfter = this.longLivedPoolNames.stream().mapToLong(pool -> ((MemoryUsage)after.get(pool)).getUsed()).sum();
                if (this.isGenerationalGc && (delta = longLivedAfter - longLivedBefore) > 0L) {
                    promotedBytes.increment(delta);
                }
                if (longLivedAfter < longLivedBefore || this.isMajorGc(notificationInfo.getGcName())) {
                    liveDataSize.set(longLivedAfter);
                    maxDataSize.set(this.longLivedPoolNames.stream().mapToLong(pool -> ((MemoryUsage)after.get(pool)).getMax()).sum());
                }
            };
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)mbean);
            notificationEmitter.addNotificationListener(notificationListener, notification -> notification.getType().equals("com.sun.management.gc.notification"), null);
            this.notificationListenerCleanUpRunnables.add(() -> {
                try {
                    notificationEmitter.removeNotificationListener(notificationListener);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            });
        }
    }

    private boolean isGenerationalGcConfigured() {
        return ManagementFactory.getMemoryPoolMXBeans().stream().filter(JvmMemory::isHeap).map(MemoryPoolMXBean::getName).filter(name -> !name.contains("tenured")).count() > 1L;
    }

    private void countPoolSizeDelta(Map<String, MemoryUsage> before, Map<String, MemoryUsage> after, Counter counter, AtomicLong previousPoolSize, String poolName) {
        long beforeBytes = before.get(poolName).getUsed();
        long afterBytes = after.get(poolName).getUsed();
        long delta = beforeBytes - previousPoolSize.get();
        previousPoolSize.set(afterBytes);
        if (delta > 0L) {
            counter.increment(delta);
        }
    }

    private boolean isMajorGc(String gcName) {
        return !this.isGenerationalGc || GcGenerationAge.fromGcName(gcName) == GcGenerationAge.OLD;
    }

    private static boolean isManagementExtensionsPresent() {
        if (ManagementFactory.getMemoryPoolMXBeans().isEmpty()) {
            log.warn("GC notifications will not be available because MemoryPoolMXBeans are not provided by the JVM");
            return false;
        }
        try {
            Class.forName("com.sun.management.GarbageCollectionNotificationInfo", false, MemoryPoolMXBean.class.getClassLoader());
            return true;
        }
        catch (Throwable e2) {
            log.warn("GC notifications will not be available because com.sun.management.GarbageCollectionNotificationInfo is not present");
            return false;
        }
    }

    @Override
    public void close() {
        this.notificationListenerCleanUpRunnables.forEach(Runnable::run);
    }

    @NonNullApi
    static enum GcGenerationAge {
        OLD,
        YOUNG,
        UNKNOWN;

        private static final Map<String, GcGenerationAge> knownCollectors;

        static GcGenerationAge fromGcName(String gcName) {
            return knownCollectors.getOrDefault(gcName, UNKNOWN);
        }

        static {
            knownCollectors = new HashMap<String, GcGenerationAge>(){
                {
                    this.put("ConcurrentMarkSweep", OLD);
                    this.put("Copy", YOUNG);
                    this.put("G1 Old Generation", OLD);
                    this.put("G1 Young Generation", YOUNG);
                    this.put("MarkSweepCompact", OLD);
                    this.put("PS MarkSweep", OLD);
                    this.put("PS Scavenge", YOUNG);
                    this.put("ParNew", YOUNG);
                    this.put("global", OLD);
                    this.put("scavenge", YOUNG);
                    this.put("partial gc", YOUNG);
                    this.put("global garbage collect", OLD);
                    this.put("Epsilon", OLD);
                }
            };
        }
    }
}

