/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TypeParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeFactory _factory;

    public TypeParser(TypeFactory f) {
        this._factory = f;
    }

    public TypeParser withFactory(TypeFactory f) {
        return f == this._factory ? this : new TypeParser(f);
    }

    public JavaType parse(String canonical) throws IllegalArgumentException {
        MyTokenizer tokens2 = new MyTokenizer(canonical.trim());
        JavaType type = this.parseType(tokens2);
        if (tokens2.hasMoreTokens()) {
            throw this._problem(tokens2, "Unexpected tokens after complete type");
        }
        return type;
    }

    protected JavaType parseType(MyTokenizer tokens2) throws IllegalArgumentException {
        if (!tokens2.hasMoreTokens()) {
            throw this._problem(tokens2, "Unexpected end-of-string");
        }
        Class<?> base = this.findClass(tokens2.nextToken(), tokens2);
        if (tokens2.hasMoreTokens()) {
            String token = tokens2.nextToken();
            if ("<".equals(token)) {
                List<JavaType> parameterTypes = this.parseTypes(tokens2);
                TypeBindings b = TypeBindings.create(base, parameterTypes);
                return this._factory._fromClass(null, base, b);
            }
            tokens2.pushBack(token);
        }
        return this._factory._fromClass(null, base, TypeBindings.emptyBindings());
    }

    protected List<JavaType> parseTypes(MyTokenizer tokens2) throws IllegalArgumentException {
        ArrayList<JavaType> types = new ArrayList<JavaType>();
        while (tokens2.hasMoreTokens()) {
            types.add(this.parseType(tokens2));
            if (!tokens2.hasMoreTokens()) break;
            String token = tokens2.nextToken();
            if (">".equals(token)) {
                return types;
            }
            if (",".equals(token)) continue;
            throw this._problem(tokens2, "Unexpected token '" + token + "', expected ',' or '>')");
        }
        throw this._problem(tokens2, "Unexpected end-of-string");
    }

    protected Class<?> findClass(String className, MyTokenizer tokens2) {
        try {
            return this._factory.findClass(className);
        }
        catch (Exception e2) {
            ClassUtil.throwIfRTE(e2);
            throw this._problem(tokens2, "Cannot locate class '" + className + "', problem: " + e2.getMessage());
        }
    }

    protected IllegalArgumentException _problem(MyTokenizer tokens2, String msg) {
        return new IllegalArgumentException(String.format("Failed to parse type '%s' (remaining: '%s'): %s", tokens2.getAllInput(), tokens2.getRemainingInput(), msg));
    }

    static final class MyTokenizer
    extends StringTokenizer {
        protected final String _input;
        protected int _index;
        protected String _pushbackToken;

        public MyTokenizer(String str2) {
            super(str2, "<,>", true);
            this._input = str2;
        }

        @Override
        public boolean hasMoreTokens() {
            return this._pushbackToken != null || super.hasMoreTokens();
        }

        @Override
        public String nextToken() {
            String token;
            if (this._pushbackToken != null) {
                token = this._pushbackToken;
                this._pushbackToken = null;
            } else {
                token = super.nextToken();
                this._index += token.length();
                token = token.trim();
            }
            return token;
        }

        public void pushBack(String token) {
            this._pushbackToken = token;
        }

        public String getAllInput() {
            return this._input;
        }

        public String getRemainingInput() {
            return this._input.substring(this._index);
        }
    }
}

