# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError
from . import models


class SmartDiagnosticsApiConfiguration(Configuration):
    """Configuration for SmartDiagnosticsApi
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        if not base_url:
            base_url = 'https://sd.kcftech.com'

        super(SmartDiagnosticsApiConfiguration, self).__init__(base_url)

        self.add_user_agent('kcf_sd_sdk/{}'.format(VERSION))


class SmartDiagnosticsApi(SDKClient):
    """SmartDiagnostics REST API for internal users only

    :ivar config: Configuration for client.
    :vartype config: SmartDiagnosticsApiConfiguration

    :param str base_url: Service URL
    """

    def __init__(
            self, base_url=None):

        self.config = SmartDiagnosticsApiConfiguration(base_url)
        super(SmartDiagnosticsApi, self).__init__(None, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = 'v3'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)


    def get_analytics_model(
            self, model_id, custom_headers=None, raw=False, **operation_config):
        """Gets an Analytics Model.

        :param model_id:
        :type model_id: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_analytics_model.metadata['url']
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AnalyticsModelResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_analytics_model.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}'}

    def delete_analytics_model(
            self, model_id, custom_headers=None, raw=False, **operation_config):
        """Deletes an Analytics Model.

        :param model_id:
        :type model_id: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_analytics_model.metadata['url']
        path_format_arguments = {
            'modelId': self._serialize.url("model_id", model_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_analytics_model.metadata = {'url': '/api/v3.0/Analytics/Models/{modelId}'}

    def get_analytics_models(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Analytics Models.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `GroupType` | GroupTypeCodes? | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
         | `Version` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `GroupType` | GroupTypeCodes? |
         | `Name` | String |
         | `Version` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_analytics_models.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_analytics_models.metadata = {'url': '/api/v3.0/Analytics/Models'}

    def create_analytics_models(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates an Analytics Model.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.AnalyticsModelCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_analytics_models.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'AnalyticsModelCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AnalyticsModelResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_analytics_models.metadata = {'url': '/api/v3.0/Analytics/Models'}

    def get_asset(
            self, asset_id, include_analytics_models=False, custom_headers=None, raw=False, **operation_config):
        """Gets an Asset.

        :param asset_id:
        :type asset_id: str
        :param include_analytics_models: Determines whether to include the
         Analytics Model with the asset
        :type include_analytics_models: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_analytics_models is not None:
            query_parameters['includeAnalyticsModels'] = self._serialize.query("include_analytics_models", include_analytics_models, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}'}

    def update_asset(
            self, asset_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a asset.

        :param asset_id:
        :type asset_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.AssetUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_asset.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'AssetUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}'}

    def get_assets(
            self, include_analytics_models=False, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Assets.

        :param include_analytics_models: Determines whether to include the
         Analytics Model with the asset
        :type include_analytics_models: bool
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, in, like` |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `AnalyticsModelCount` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `AnalyticsModelId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `AnalyticsModelName` | String | `eq, neq, in, like` |
         | `CategoryCode` | String | `eq, neq, in, like` |
         | `CategoryId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `CategoryName` | String | `eq, neq, in, like` |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `CriticalityId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `CriticalityName` | String | `eq, neq, in, like` |
         | `IsOperatorView` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `IsPaused` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Manufacturer` | String | `eq, neq, in, like` |
         | `ModelName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
         | `NodeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `NodeSerialNumber` | String | `eq, neq, in, like` |
         | `SizeCode` | String | `eq, neq, in, like` |
         | `SizeId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `SizeName` | String | `eq, neq, in, like` |
         | `Supplier` | String | `eq, neq, in, like` |
         | `TagId` | Guid | `eq, neq, in` |
         | `TagName` | String | `eq, neq, in, like` |
         | `TypeCode` | String | `eq, neq, in, like` |
         | `TypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `TypeName` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CategoryCode` | String |
         | `CategoryName` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `CriticalityId` | Int32? |
         | `CriticalityName` | String |
         | `LocationName` | String |
         | `Name` | String |
         | `SizeCode` | String |
         | `SizeName` | String |
         | `TypeCode` | String |
         | `TypeName` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_assets.metadata['url']

        # Construct parameters
        query_parameters = {}
        if include_analytics_models is not None:
            query_parameters['includeAnalyticsModels'] = self._serialize.query("include_analytics_models", include_analytics_models, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAssetResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_assets.metadata = {'url': '/api/v3.0/Assets'}

    def create_asset(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a asset.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.AssetCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_asset.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'AssetCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_asset.metadata = {'url': '/api/v3.0/Assets'}

    def move_asset(
            self, asset_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Moves a asset.

        :param asset_id:
        :type asset_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.move_asset.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('AssetResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    move_asset.metadata = {'url': '/api/v3.0/Assets/{assetId}/Move'}

    def get_asset_types(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets Asset Types.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CategoryCode` | String | `eq, neq, in, like` |
         | `CategoryId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `CategoryName` | String | `eq, neq, in, like` |
         | `Code` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Code` | String |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_types.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelAssetTypeResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_types.metadata = {'url': '/api/v3.0/Assets/Types'}

    def get_asset_markers(
            self, asset_id, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets all markers on an asset.

        :param asset_id: Id of asset
        :type asset_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `MarkerType` | MarkerType | `eq, neq, in, lt, gt, leq, geq` |
         | `Name` | String | `eq, neq, in, like` |
         | `Value` | Double | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Name` | String |
         | `Order` | Int32 |
         | `Value` | Double |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_markers.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelMarkerResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_markers.metadata = {'url': '/api/v3.0/Assets/{assetId}/markers'}

    def replace_asset_markers(
            self, asset_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Replaces all the existing markers on the asset with new ones.

        :param asset_id: Id of the asset
        :type asset_id: str
        :param body: Request containing marker information
        :type body: list[~smartdiagnostics_sdk.models.MarkerUpdateRequest]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.replace_asset_markers.metadata['url']
        path_format_arguments = {
            'assetId': self._serialize.url("asset_id", asset_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, '[MarkerUpdateRequest]')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[MarkerResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    replace_asset_markers.metadata = {'url': '/api/v3.0/Assets/{assetId}/markers'}

    def get_base_station(
            self, base_station_id, include_state=False, custom_headers=None, raw=False, **operation_config):
        """Gets a Base Station by Id.

        :param base_station_id: Specifies the id of the Base Station to get
        :type base_station_id: long
        :param include_state: Determines whether to include the states for
         the LastDataUpdate, LastStatusUpdate, and IsOnline
        :type include_state: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_base_station.metadata['url']
        path_format_arguments = {
            'baseStationId': self._serialize.url("base_station_id", base_station_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('BaseStationResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_base_station.metadata = {'url': '/api/v3.0/BaseStations/{baseStationId}'}

    def edit_base_station(
            self, base_station_id, include_state=False, body=None, custom_headers=None, raw=False, **operation_config):
        """Edits a Base Station.

        :param base_station_id: The id of the Base Station to edit
        :type base_station_id: long
        :param include_state: Determines whether to include the states for
         the LastDataUpdate, LastStatusUpdate, and IsOnline
        :type include_state: bool
        :param body: Contains the properties to update
        :type body: ~smartdiagnostics_sdk.models.BaseStationUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.edit_base_station.metadata['url']
        path_format_arguments = {
            'baseStationId': self._serialize.url("base_station_id", base_station_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'BaseStationUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('BaseStationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    edit_base_station.metadata = {'url': '/api/v3.0/BaseStations/{baseStationId}'}

    def get_base_stations(
            self, include_state=False, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets a paged list of Base Stations.

        :param include_state: Determines whether to include the states for
         the LastDataUpdate, LastStatusUpdate, and IsOnline
        :type include_state: bool
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `CurrentSoftwareReleaseId` | Int32 | `eq, neq, in, lt, gt, leq, geq`
         |
         | `CurrentSoftwareReleaseName` | String | `eq, neq, in, like` |
         | `HardwareRevisionId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `HardwareRevisionName` | String | `eq, neq, in, like` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `ReceiverFirmwareVersion` | String | `eq, neq, in, like` |
         | `ReceiverId` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `ReceiverNetworkId` | String | `eq, neq, in, like` |
         | `ReceiverNickname` | String | `eq, neq, in, like` |
         | `ReceiverPendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq,
         geq` |
         | `ReceiverRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `ReceiverSerialNumber` | String | `eq, neq, in, like` |
         | `ReleaseRingId` | Guid | `eq, neq, in` |
         | `ReleaseRingName` | String | `eq, neq, in, like` |
         | `SerialNumber` | String | `eq, neq, in, like` |
         | `TargetedSoftwareReleaseId` | Int32 | `eq, neq, in, lt, gt, leq,
         geq` |
         | `TargetedSoftwareReleaseName` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationName` | String |
         | `CurrentSoftwareReleaseName` | String |
         | `HardwareRevisionId` | Int32 |
         | `HardwareRevisionName` | String |
         | `LocationName` | String |
         | `Nickname` | String |
         | `PushToStage` | Boolean |
         | `ReceiverFirmwareVersion` | String |
         | `ReceiverNetworkId` | String |
         | `ReceiverNickname` | String |
         | `ReceiverPendingRfChannel` | Int32? |
         | `ReceiverRfChannel` | Int32? |
         | `ReleaseRingId` | Guid |
         | `ReleaseRingName` | String |
         | `SerialNumber` | String |
         | `TargetedSoftwareReleaseName` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_base_stations.metadata['url']

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelBaseStationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_base_stations.metadata = {'url': '/api/v3.0/BaseStations'}

    def create_base_station(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new Base Station.

        :param body: Specifies the properties for the new Base Station
        :type body: ~smartdiagnostics_sdk.models.BaseStationCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_base_station.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'BaseStationCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('BaseStationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_base_station.metadata = {'url': '/api/v3.0/BaseStations'}

    def get_bearings(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets all bearings.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_bearings.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelBearingResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_bearings.metadata = {'url': '/api/v3.0/Bearings'}

    def get_bearing(
            self, bearing_id, custom_headers=None, raw=False, **operation_config):
        """Gets a bearing.

        :param bearing_id: Id of bearing to return
        :type bearing_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_bearing.metadata['url']
        path_format_arguments = {
            'bearingId': self._serialize.url("bearing_id", bearing_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('BearingResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_bearing.metadata = {'url': '/api/v3.0/Bearings/{bearingId}'}

    def create_corporation(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new corporation.

        :param body: A corporation create request
        :type body: ~smartdiagnostics_sdk.models.CorporationCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_corporation.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'CorporationCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_corporation.metadata = {'url': '/api/v3.0/Corporations'}

    def get_corporations(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Returns paginated list corporations.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_corporations.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelCorporationResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_corporations.metadata = {'url': '/api/v3.0/Corporations'}

    def get_corporation(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Returns a single corporation.

        :param id: Id of the corporation
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_corporation.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_corporation.metadata = {'url': '/api/v3.0/Corporations/{id}'}

    def update_corporation(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a Corporation.

        :param id: Id of the Corporation to be updated
        :type id: str
        :param body: Corporation Update Request
        :type body: ~smartdiagnostics_sdk.models.CorporationUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_corporation.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'CorporationUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_corporation.metadata = {'url': '/api/v3.0/Corporations/{id}'}

    def upload_corporation_icon(
            self, id, file=None, custom_headers=None, raw=False, **operation_config):
        """Updates a Corporations Icon.

        :param id: Id of the Corporation to be updated
        :type id: str
        :param file: The image file to upload
        :type file: Generator
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.upload_corporation_icon.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'file': file,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 422]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CorporationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 422:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    upload_corporation_icon.metadata = {'url': '/api/v3.0/Corporations/{id}/Icon'}

    def get_corporation_roi(
            self, corporation_id, start_date=None, end_date=None, custom_headers=None, raw=False, **operation_config):
        """Gets ROI information for a corporation.

        :param corporation_id:
        :type corporation_id: str
        :param start_date:
        :type start_date: datetime
        :param end_date:
        :type end_date: datetime
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_corporation_roi.metadata['url']
        path_format_arguments = {
            'corporationId': self._serialize.url("corporation_id", corporation_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if start_date is not None:
            query_parameters['StartDate'] = self._serialize.query("start_date", start_date, 'iso-8601')
        if end_date is not None:
            query_parameters['EndDate'] = self._serialize.query("end_date", end_date, 'iso-8601')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('RoiResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_corporation_roi.metadata = {'url': '/api/v3.0/Corporations/{corporationId}/roi'}

    def get_dashboard(
            self, id, custom_headers=None, raw=False, **operation_config):
        """

        :param id:
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_dashboard.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_dashboard.metadata = {'url': '/api/v3.0/Dashboards/{id}'}

    def update_dashboard(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a dashboard.

        :param id: Id of the dashboard
        :type id: str
        :param body: Updated dashboard details
        :type body: ~smartdiagnostics_sdk.models.DashboardUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_dashboard.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'DashboardUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_dashboard.metadata = {'url': '/api/v3.0/Dashboards/{id}'}

    def delete_dashboard(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Deletes a dashboard.

        :param id: Id of the dashboard
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_dashboard.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_dashboard.metadata = {'url': '/api/v3.0/Dashboards/{id}'}

    def get_dashboards(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets all dashboards available to the user.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `DashboardTypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `DashboardTypeName` | String | `eq, neq, in, like` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationName` | String |
         | `DashboardTypeName` | String |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_dashboards.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelDashboardResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_dashboards.metadata = {'url': '/api/v3.0/Dashboards'}

    def create_dashboard(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new dashboard.

        :param body: Contains dashboard details
        :type body: ~smartdiagnostics_sdk.models.DashboardCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_dashboard.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'DashboardCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_dashboard.metadata = {'url': '/api/v3.0/Dashboards'}

    def get_dashboard_templates(
            self, filter=None, page=None, page_limit=None, custom_headers=None, raw=False, **operation_config):
        """Gets dashboard templates.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `DashboardTypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_dashboard_templates.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelDashboardTemplateResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_dashboard_templates.metadata = {'url': '/api/v3.0/Dashboards/templates'}

    def update_dashboard_permissions(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates dashboard permissions.

        :param id: Id of the dashboard
        :type id: str
        :param body: Dashboard permission details
        :type body:
         ~smartdiagnostics_sdk.models.DashboardPermissionsUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_dashboard_permissions.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'DashboardPermissionsUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('DashboardResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_dashboard_permissions.metadata = {'url': '/api/v3.0/Dashboards/{id}/permissions'}

    def export_events(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Enqueues a report that contains all events for the params.

        :param group_id: Id of a group
        :type group_id: str
        :param body: Time Range
        :type body: ~smartdiagnostics_sdk.models.TimeRangeModelV3
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.export_events.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'TimeRangeModelV3')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 202, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    export_events.metadata = {'url': '/api/v3.0/Events/{groupId}/export'}

    def update_event(
            self, event_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates an Event.

        :param event_id:
        :type event_id: str
        :param body: New Event values
        :type body: ~smartdiagnostics_sdk.models.EventModelV3
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_event.metadata['url']
        path_format_arguments = {
            'eventId': self._serialize.url("event_id", event_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'EventModelV3')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('EventModelV3', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_event.metadata = {'url': '/api/v3.0/Events/{eventId}'}

    def create_event(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates an event.

        :param body: Model for the new event
        :type body: ~smartdiagnostics_sdk.models.EventModelV3
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_event.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'EventModelV3')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('EventModelV3', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_event.metadata = {'url': '/api/v3.0/Events'}

    def get_location_files(
            self, location_id, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets all files for a location.

        :param location_id:
        :type location_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `GroupIds` | IEnumerable<Guid> | `eq, neq, in, lt, gt, leq, geq` |
         | `IsRootFolder` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `ParentFolderId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `TagId` | Guid | `eq, neq, in` |
         | `TagName` | String | `eq, neq, in, like` |
         | `Type` | ContentType | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CreationDate` | DateTime |
         | `DisplayName` | String |
         | `FileName` | String |
         | `UpdateDate` | DateTime |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_location_files.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelFileResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_location_files.metadata = {'url': '/api/v3.0/Files/locations/{locationId}'}

    def get_corporation_files(
            self, corporation_id, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets all files for a corporation.

        :param corporation_id:
        :type corporation_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `GroupIds` | IEnumerable<Guid> | `eq, neq, in, lt, gt, leq, geq` |
         | `IsRootFolder` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `ParentFolderId` | Guid? | `eq, neq, in, lt, gt, leq, geq` |
         | `TagId` | Guid | `eq, neq, in` |
         | `TagName` | String | `eq, neq, in, like` |
         | `Type` | ContentType | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CreationDate` | DateTime |
         | `DisplayName` | String |
         | `FileName` | String |
         | `UpdateDate` | DateTime |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_corporation_files.metadata['url']
        path_format_arguments = {
            'corporationId': self._serialize.url("corporation_id", corporation_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelFileResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_corporation_files.metadata = {'url': '/api/v3.0/Files/corporations/{corporationId}'}

    def get_file(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Gets a file.

        :param id:
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_file.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_file.metadata = {'url': '/api/v3.0/Files/{id}'}

    def delete_file(
            self, file_id, custom_headers=None, raw=False, **operation_config):
        """Deletes a file.

        :param file_id: File id
        :type file_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_file.metadata['url']
        path_format_arguments = {
            'fileId': self._serialize.url("file_id", file_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_file.metadata = {'url': '/api/v3.0/Files/{fileId}'}

    def update_file(
            self, file_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Update a file.

        :param file_id:
        :type file_id: str
        :param body: File object to update
        :type body: ~smartdiagnostics_sdk.models.FilesUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_file.metadata['url']
        path_format_arguments = {
            'fileId': self._serialize.url("file_id", file_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'FilesUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_file.metadata = {'url': '/api/v3.0/Files/{fileId}'}

    def create_file(
            self, type, parent_folder_id, display_name=None, description=None, location_id=None, corporation_id=None, group_ids=None, files=None, custom_headers=None, raw=False, **operation_config):
        """Creates a file.

        :param type: Type of file. Possible values include: 'Invalid',
         'Picture', 'Folder'
        :type type: str
        :param parent_folder_id: The id of the folder that the file is inside
         of
        :type parent_folder_id: str
        :param display_name: Name of file
        :type display_name: str
        :param description: File Description
        :type description: str
        :param location_id: Location id of file
        :type location_id: str
        :param corporation_id: Corporation id of file
        :type corporation_id: str
        :param group_ids: Ids of groups the file belongs to
        :type group_ids: list[str]
        :param files: The file that will be associated with the file model
         object
        :type files: Generator
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_file.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'Type': type,
            'ParentFolderId': parent_folder_id,
            'DisplayName': display_name,
            'Description': description,
            'LocationId': location_id,
            'CorporationId': corporation_id,
            'GroupIds': group_ids,
            'files': files,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404, 422]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('FileResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 422:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_file.metadata = {'url': '/api/v3.0/Files'}

    def move_files(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Moves files to a folder.

        :param body: Move Request
        :type body: ~smartdiagnostics_sdk.models.MoveFilesRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.move_files.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'MoveFilesRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('MoveFilesResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    move_files.metadata = {'url': '/api/v3.0/Files/move'}

    def get_indicator_filter(
            self, indicator_filter_id, custom_headers=None, raw=False, **operation_config):
        """Gets a single indicator filter.

        :param indicator_filter_id: Id of indicator filter
        :type indicator_filter_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_filter.metadata['url']
        path_format_arguments = {
            'indicatorFilterId': self._serialize.url("indicator_filter_id", indicator_filter_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorFilterResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators/{indicatorFilterId}'}

    def update_indicator_filter(
            self, indicator_filter_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates an indicator filter.

        :param indicator_filter_id: The id of the indicator filter
        :type indicator_filter_id: str
        :param body: Indicator filter update request
        :type body: ~smartdiagnostics_sdk.models.IndicatorFilterUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_indicator_filter.metadata['url']
        path_format_arguments = {
            'indicatorFilterId': self._serialize.url("indicator_filter_id", indicator_filter_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorFilterUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorFilterResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators/{indicatorFilterId}'}

    def delete_indicator_filter(
            self, indicator_filter_id, custom_headers=None, raw=False, **operation_config):
        """Deletes an indicator filter.

        :param indicator_filter_id: The id of the indicator filter
        :type indicator_filter_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_indicator_filter.metadata['url']
        path_format_arguments = {
            'indicatorFilterId': self._serialize.url("indicator_filter_id", indicator_filter_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators/{indicatorFilterId}'}

    def get_indicator_filters(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets many indicator filters.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `IsGlobal` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
         | `SystemId` | Guid | `eq, neq, in` |
         | `SystemName` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `LocationName` | String |
         | `Name` | String |
         | `SortOrder` | Int32 |
         | `SystemName` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_filters.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorFilterResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_filters.metadata = {'url': '/api/v3.0/Filters/Indicators'}

    def create_indicator_filter(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates an indicator filter.

        :param body: Indicator filter create request
        :type body: ~smartdiagnostics_sdk.models.IndicatorFilterCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_indicator_filter.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorFilterCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 403, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorFilterResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 403:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_indicator_filter.metadata = {'url': '/api/v3.0/Filters/Indicators'}

    def get_group_alerts(
            self, group_id, filter_ids=None, sensor_role_type=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets the alerts for the given group.

        :param group_id: The group to get the alerts for
        :type group_id: str
        :param filter_ids:
        :type filter_ids: list[str]
        :param sensor_role_type: SensorRoleType is an additional filtering
         component for limiting to X or Y.
        :type sensor_role_type: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_group_alerts.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter_ids is not None:
            query_parameters['FilterIds'] = self._serialize.query("filter_ids", filter_ids, '[str]', div=',')
        if sensor_role_type is not None:
            query_parameters['SensorRoleType'] = self._serialize.query("sensor_role_type", sensor_role_type, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelGroupAlertsResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_group_alerts.metadata = {'url': '/api/v3.0/Groups/{groupId}/alerts'}

    def create_spectrum_chart_settings(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates the Spectrum Chart settings for a group.

        :param group_id:
        :type group_id: str
        :param body: Contains chart setting info for the Frequency and Time
         Domains
        :type body:
         ~smartdiagnostics_sdk.models.SpectrumChartSettingsCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_spectrum_chart_settings.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SpectrumChartSettingsCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SpectrumChartSettingsResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_spectrum_chart_settings.metadata = {'url': '/api/v3.0/Groups/{groupId}/spectrumChartSettings'}

    def get_spectrum_chart_settings(
            self, group_id, custom_headers=None, raw=False, **operation_config):
        """Gets the Spectrum Chart Settings for a given group.

        :param group_id: The group to retrieve the spectrum chart settings for
        :type group_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_spectrum_chart_settings.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SpectrumChartSettingsResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_spectrum_chart_settings.metadata = {'url': '/api/v3.0/Groups/{groupId}/spectrumChartSettings'}

    def get_bearings_for_group(
            self, group_id, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets all bearings for a group.

        :param group_id:
        :type group_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Manufacturer` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
         | `RollerCount` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Bpfi` | Double |
         | `Bpfo` | Double |
         | `Bsf` | Double |
         | `Ftf` | Double |
         | `Manufacturer` | String |
         | `Name` | String |
         | `RollerCount` | Int64 |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_bearings_for_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelBearingResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_bearings_for_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/bearings'}

    def update_bearings_for_group(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates bearings for a group.

        :param group_id:
        :type group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.UpdateBearingsForGroupRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_bearings_for_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'UpdateBearingsForGroupRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[BearingResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_bearings_for_group.metadata = {'url': '/api/v3.0/Groups/{groupId}/bearings'}

    def get_hardware_events_for_account(
            self, location_id, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets a listing of hardware event logs for a location.

        :param location_id:
        :type location_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `EventType` | String | `eq, neq, in, like` |
         | `HardwareType` | String | `eq, neq, in, like` |
         | `TimeAcked` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
         | `TimeEntered` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `TimeExited` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
         | `TimeNotified` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `EventType` | String |
         | `HardwareType` | String |
         | `TimeAcked` | DateTime? |
         | `TimeEntered` | DateTime |
         | `TimeExited` | DateTime? |
         | `TimeNotified` | DateTime |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_hardware_events_for_account.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelHardwareEventModelV3', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_hardware_events_for_account.metadata = {'url': '/api/v3.0/HardwareEvents/location/{locationId}'}

    def get_collectors_status(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Gets the online status for the desired base stations.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_collectors_status.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_collectors_status.metadata = {'url': '/api/v3.0/HardwareStatus/baseStations'}

    def get_repeaters_status(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Gets the online status for repeaters, grouped by location.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_repeaters_status.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_repeaters_status.metadata = {'url': '/api/v3.0/HardwareStatus/repeaters'}

    def get_nodes_status(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Gets all status for nodes.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_nodes_status.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_nodes_status.metadata = {'url': '/api/v3.0/HardwareStatus/nodes'}

    def get_hubs_status(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Gets all status for hubs.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_hubs_status.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HardwareStatusResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_hubs_status.metadata = {'url': '/api/v3.0/HardwareStatus/hubs'}

    def get_hubs(
            self, include_online_status=False, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets all hubs a user has access to.

        :param include_online_status:
        :type include_online_status: bool
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_hubs.metadata['url']

        # Construct parameters
        query_parameters = {}
        if include_online_status is not None:
            query_parameters['includeOnlineStatus'] = self._serialize.query("include_online_status", include_online_status, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelHubResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_hubs.metadata = {'url': '/api/v3.0/Hubs'}

    def get_hub(
            self, hub_id, include_online_status=False, custom_headers=None, raw=False, **operation_config):
        """Returns a single Hub with the supplied Id.

        :param hub_id: The Id of the Hub
        :type hub_id: long
        :param include_online_status:
        :type include_online_status: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_hub.metadata['url']
        path_format_arguments = {
            'hubId': self._serialize.url("hub_id", hub_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_online_status is not None:
            query_parameters['includeOnlineStatus'] = self._serialize.query("include_online_status", include_online_status, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('HubResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_hub.metadata = {'url': '/api/v3.0/Hubs/{hubId}'}

    def get_indicator_group(
            self, indicator_group_id, custom_headers=None, raw=False, **operation_config):
        """Gets a indicatorGroup.

        :param indicator_group_id:
        :type indicator_group_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_group.metadata['url']
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}'}

    def update_indicator_group(
            self, indicator_group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a indicatorGroup.

        :param indicator_group_id:
        :type indicator_group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.IndicatorGroupUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_indicator_group.metadata['url']
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorGroupUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}'}

    def get_indicator_groups(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets indicatorGroups.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, in, like` |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsPaused` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_groups.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorGroupResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_groups.metadata = {'url': '/api/v3.0/IndicatorGroups'}

    def create_indicator_group(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a indicatorGroup.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.IndicatorGroupCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_indicator_group.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'IndicatorGroupCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups'}

    def move_indicator_group(
            self, indicator_group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Moves a indicatorGroup.

        :param indicator_group_id:
        :type indicator_group_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.move_indicator_group.metadata['url']
        path_format_arguments = {
            'indicatorGroupId': self._serialize.url("indicator_group_id", indicator_group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorGroupResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    move_indicator_group.metadata = {'url': '/api/v3.0/IndicatorGroups/{indicatorGroupId}/Move'}

    def get_burst_data_audio(
            self, indicator_id, utc_timestamp, custom_headers=None, raw=False, **operation_config):
        """Generates audio from Indicator burst data.  Only vibration Indicators
        are supported.

        :param indicator_id: The indicator to generate audio for
        :type indicator_id: str
        :param utc_timestamp: The UTC timestamp used to locate the burst data
         used to generate the audio
        :type utc_timestamp: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_burst_data_audio.metadata['url']
        path_format_arguments = {
            'indicatorId': self._serialize.url("indicator_id", indicator_id, 'str'),
            'utcTimestamp': self._serialize.url("utc_timestamp", utc_timestamp, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('object', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_burst_data_audio.metadata = {'url': '/api/v3.0/Indicators/{indicatorId}/burstDataAudio/{utcTimestamp}'}

    def get_indicators(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets indicator responses.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `FilterId` | Guid | `eq, neq, in` |
         | `GroupId` | Guid | `eq, neq, in` |
         | `IndicatorType` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `SensorRoleType` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationId` | Guid |
         | `Id` | Guid |
         | `LocationId` | Guid |
         | `SensorRoleType` | String |
         | `SystemSortOrder` | Int32 |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicators.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicators.metadata = {'url': '/api/v3.0/Indicators'}

    def get_indicator_alarm_state(
            self, indicator_id, custom_headers=None, raw=False, **operation_config):
        """Get the alarm state for a specific indicator.

        :param indicator_id: Id of specific indicator
        :type indicator_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_alarm_state.metadata['url']
        path_format_arguments = {
            'indicatorId': self._serialize.url("indicator_id", indicator_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('IndicatorAlarmStateResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_alarm_state.metadata = {'url': '/api/v3.0/Indicators/{indicatorId}/alarmState'}

    def get_indicators_alarm_state(
            self, filter=None, custom_headers=None, raw=False, **operation_config):
        """Get the alarm state for a list of indicators.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Id` | Guid | `eq, neq, in` |
        :type filter: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicators_alarm_state.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[IndicatorAlarmStateResponse]', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicators_alarm_state.metadata = {'url': '/api/v3.0/Indicators/alarmState'}

    def get_indicator_types(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets indicator types.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Name` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Id` | Int32 |
         | `Name` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_indicator_types.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelIndicatorTypesResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_indicator_types.metadata = {'url': '/api/v3.0/Indicators/Types'}

    def get_installs(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets a list of installs for the current user.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
         | `UserEmail` | String | `eq, neq, in, like` |
         | `UserFirstName` | String | `eq, neq, in, like` |
         | `UserLastName` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Active` | Boolean |
         | `EndDate` | DateTime? |
         | `Name` | String |
         | `StartDate` | DateTime |
         | `UserEmail` | String |
         | `UserFirstName` | String |
         | `UserLastName` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_installs.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelInstallResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_installs.metadata = {'url': '/api/v3.0/Installs'}

    def get_install(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Gets a single Install.

        :param id: Id of install
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_install.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_install.metadata = {'url': '/api/v3.0/Installs/{id}'}

    def update_install(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates properties related to an install.

        :param id: the Guid for the install
        :type id: str
        :param body: the model containing the properties to update
        :type body: ~smartdiagnostics_sdk.models.InstallUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_install.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstallUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_install.metadata = {'url': '/api/v3.0/Installs/{id}'}

    def add_users_to_install(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Adds one or more users to an install.

        :param id: Id of an install
        :type id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.InstallModifyUsersRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.add_users_to_install.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstallModifyUsersRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallAddUserResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    add_users_to_install.metadata = {'url': '/api/v3.0/Installs/{id}/users'}

    def remove_users_from_install(
            self, id, body=None, custom_headers=None, raw=False, **operation_config):
        """Removes one or more users from an install.

        :param id: Id of an install
        :type id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.InstallModifyUsersRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.remove_users_from_install.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstallModifyUsersRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    remove_users_from_install.metadata = {'url': '/api/v3.0/Installs/{id}/users'}

    def get_node_install_status(
            self, install_id, page=None, page_limit=None, custom_headers=None, raw=False, **operation_config):
        """Gets a list of nodes per install.

        :param install_id: Id of an install
        :type install_id: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_node_install_status.metadata['url']
        path_format_arguments = {
            'installId': self._serialize.url("install_id", install_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelInstallNodeResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_node_install_status.metadata = {'url': '/api/v3.0/Installs/{installId}/nodes'}

    def update_node_install_status(
            self, install_id, node_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a node's status for the install.

        :param install_id: Id of install
        :type install_id: str
        :param node_id: Id of node
        :type node_id: long
        :param body: Status to change node to and accompanying note
        :type body: ~smartdiagnostics_sdk.models.InstallNodeUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_node_install_status.metadata['url']
        path_format_arguments = {
            'installId': self._serialize.url("install_id", install_id, 'str'),
            'nodeId': self._serialize.url("node_id", node_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'InstallNodeUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('InstallNodeResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_node_install_status.metadata = {'url': '/api/v3.0/Installs/{installId}/nodes/{nodeId}'}

    def export_install_report(
            self, install_id, custom_headers=None, raw=False, **operation_config):
        """Triggers a Hangfire job that will email an install's status report to
        the user.

        :param install_id:
        :type install_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.export_install_report.metadata['url']
        path_format_arguments = {
            'installId': self._serialize.url("install_id", install_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    export_install_report.metadata = {'url': '/api/v3.0/Installs/{installId}/exportReport'}

    def get_locations(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Returns a paged list of all locations that the user has access to.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, in, like` |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `Active` | Boolean |
         | `CorporationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_locations.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelLocationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_locations.metadata = {'url': '/api/v3.0/Locations'}

    def create_location(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a new location.

        :param body: Model for new location
        :type body: ~smartdiagnostics_sdk.models.LocationCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_location.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'LocationCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('LocationResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_location.metadata = {'url': '/api/v3.0/Locations'}

    def get_location(
            self, location_id, custom_headers=None, raw=False, **operation_config):
        """Gets a specific location.

        :param location_id: Id of location
        :type location_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_location.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('LocationResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_location.metadata = {'url': '/api/v3.0/Locations/{locationId}'}

    def get_location_roi(
            self, location_id, start_date=None, end_date=None, custom_headers=None, raw=False, **operation_config):
        """Gets ROI information for a location.

        :param location_id:
        :type location_id: str
        :param start_date:
        :type start_date: datetime
        :param end_date:
        :type end_date: datetime
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_location_roi.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if start_date is not None:
            query_parameters['StartDate'] = self._serialize.query("start_date", start_date, 'iso-8601')
        if end_date is not None:
            query_parameters['EndDate'] = self._serialize.query("end_date", end_date, 'iso-8601')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('RoiResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_location_roi.metadata = {'url': '/api/v3.0/Locations/{locationId}/roi'}

    def get_monitoring_point(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Gets a Monitoring Point.

        :param id:
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_point.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('MonitoringPointResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_point.metadata = {'url': '/api/v3.0/MonitoringPoints/{id}'}

    def get_monitoring_points(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Monitoring Points.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, in, like` |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `BearingId` | Guid | `eq, neq, in` |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsPaused` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `MonitoringPointType` | MonitoringPointTypeCodesForApi | `eq, neq,
         in, lt, gt, leq, geq` |
         | `Name` | String | `eq, neq, in, like` |
         | `NodeId` | Int64 | `eq, neq, in, lt, gt, leq, geq` |
         | `NodeSerialNumber` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_points.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelMonitoringPointResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_points.metadata = {'url': '/api/v3.0/MonitoringPoints'}

    def get_monitoring_point_type_codes(
            self, custom_headers=None, raw=False, **operation_config):
        """

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_monitoring_point_type_codes.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('[MonitoringPointTypeCodeModel]', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_monitoring_point_type_codes.metadata = {'url': '/api/v3.0/MonitoringPointTypeCodes'}

    def get_nodes(
            self, include_state=False, is_slim=False, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets a paginated list of the nodes to which a user has access.

        :param include_state:
        :type include_state: bool
        :param is_slim:
        :type is_slim: bool
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_nodes.metadata['url']

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')
        if is_slim is not None:
            query_parameters['isSlim'] = self._serialize.query("is_slim", is_slim, 'bool')
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelNodeResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_nodes.metadata = {'url': '/api/v3.0/Nodes'}

    def get_node(
            self, node_id, include_state=False, custom_headers=None, raw=False, **operation_config):
        """Gets the requested node.

        :param node_id: The ID of the node
        :type node_id: long
        :param include_state: Query parameter used to specify if the returned
         NodeResponse
         should include certain properties
        :type include_state: bool
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_node.metadata['url']
        path_format_arguments = {
            'nodeId': self._serialize.url("node_id", node_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if include_state is not None:
            query_parameters['includeState'] = self._serialize.query("include_state", include_state, 'bool')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('NodeResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_node.metadata = {'url': '/api/v3.0/Nodes/{nodeId}'}

    def export_long_burst(
            self, long_burst_id, node_id, custom_headers=None, raw=False, **operation_config):
        """

        :param long_burst_id:
        :type long_burst_id: long
        :param node_id:
        :type node_id: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.export_long_burst.metadata['url']
        path_format_arguments = {
            'longBurstId': self._serialize.url("long_burst_id", long_burst_id, 'long'),
            'nodeId': self._serialize.url("node_id", node_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('object', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    export_long_burst.metadata = {'url': '/api/v3.0/Nodes/{nodeId}/longBurst/{longBurstId}/export'}

    def get_picture(
            self, id, custom_headers=None, raw=False, **operation_config):
        """Returns a single picture.

        :param id: Picture Id
        :type id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_picture.metadata['url']
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PicturesModelV3', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_picture.metadata = {'url': '/api/v3.0/Pictures/{id}'}

    def get_pictures(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Returns a paged list of all pictures.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_pictures.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPicturesModelV3', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_pictures.metadata = {'url': '/api/v3.0/Pictures'}

    def get_pictures_for_group(
            self, group_id, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Get a paged list of pictures associated with a group.

        :param group_id: The GUID of the group
        :type group_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_pictures_for_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPicturesModelV3', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_pictures_for_group.metadata = {'url': '/api/v3.0/Pictures/group/{groupId}'}

    def assign_pictures_to_group(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Associate an ordered list of pictures to a group.

        :param group_id: The GUID of the group to assign pictures to
        :type group_id: str
        :param body: An ordered list of picture GUIDs to associate with the
         group.
        :type body: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.assign_pictures_to_group.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, '[str]')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    assign_pictures_to_group.metadata = {'url': '/api/v3.0/Pictures/group/{groupId}'}

    def get_pictures_for_location(
            self, location_id, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Returns a paged list of pictures associated with an account.

        :param location_id: The GUID of the account/location
        :type location_id: str
        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_pictures_for_location.metadata['url']
        path_format_arguments = {
            'locationId': self._serialize.url("location_id", location_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPicturesModelV3', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_pictures_for_location.metadata = {'url': '/api/v3.0/Pictures/location/{locationId}'}

    def get_property(
            self, property_id, custom_headers=None, raw=False, **operation_config):
        """Gets an Property.

        :param property_id:
        :type property_id: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_property.metadata['url']
        path_format_arguments = {
            'propertyId': self._serialize.url("property_id", property_id, 'int')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PropertyResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_property.metadata = {'url': '/api/v3.0/Properties/{propertyId}'}

    def get_properties(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets Properties.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Name` | String | `eq, neq, in, like` |
         | `ValueType` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Name` | String |
         | `ValueType` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_properties.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPropertyResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_properties.metadata = {'url': '/api/v3.0/Properties'}

    def get_receivers(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets receivers.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `FirmwareVersion` | String | `eq, neq, in, like` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `MacAddress` | String | `eq, neq, in, like` |
         | `NetworkId` | String | `eq, neq, in, like` |
         | `Nickname` | String | `eq, neq, in, like` |
         | `PendingRfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `RadioMacAddress` | String | `eq, neq, in, like` |
         | `ReceiverType` | ReceiverType | `eq, neq, in, lt, gt, leq, geq` |
         | `RfChannel` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `SerialNumber` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `CorporationName` | String |
         | `FirmwareVersion` | String |
         | `LocationName` | String |
         | `MacAddress` | String |
         | `NetworkId` | String |
         | `Nickname` | String |
         | `PendingRfChannel` | Int32? |
         | `RadioMacAddress` | String |
         | `ReceiverType` | ReceiverType |
         | `RfChannel` | Int32? |
         | `SerialNumber` | String |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_receivers.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelReceiverResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_receivers.metadata = {'url': '/api/v3.0/Receivers'}

    def get_receiver(
            self, receiver_id, custom_headers=None, raw=False, **operation_config):
        """Gets a receiver.

        :param receiver_id:
        :type receiver_id: long
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_receiver.metadata['url']
        path_format_arguments = {
            'receiverId': self._serialize.url("receiver_id", receiver_id, 'long')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('ReceiverResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_receiver.metadata = {'url': '/api/v3.0/Receivers/{receiverId}'}

    def get_repeater(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Get receivers subject to query options.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_repeater.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelRepeaterModelV3', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_repeater.metadata = {'url': '/api/v3.0/Repeaters'}

    def request_base_station_report(
            self, ids=None, file_name=None, custom_headers=None, raw=False, **operation_config):
        """This will download a base station and repeater hardware report for the
        locations provided in the details model.

        :param ids: A list of Locations Guids whose hardware should appear in
         the report
        :type ids: list[str]
        :param file_name: The Name of the File
        :type file_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.request_base_station_report.metadata['url']

        # Construct parameters
        query_parameters = {}
        if ids is not None:
            query_parameters['Ids'] = self._serialize.query("ids", ids, '[str]', div=',')
        if file_name is not None:
            query_parameters['FileName'] = self._serialize.query("file_name", file_name, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    request_base_station_report.metadata = {'url': '/api/v3.0/Reports/hardware/basestation'}

    def request_low_battery_report(
            self, location_id, custom_headers=None, raw=False, **operation_config):
        """This will download a low battery report for the location provided in
        the details model.

        :param location_id: Id of the location whose nodes will appear in the
         report
        :type location_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.request_low_battery_report.metadata['url']

        # Construct parameters
        query_parameters = {}
        query_parameters['LocationId'] = self._serialize.query("location_id", location_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    request_low_battery_report.metadata = {'url': '/api/v3.0/Reports/hardware/lowBattery'}

    def request_statistics_report(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Emails a statistics report for the group provided using the options
        provided.

        :param group_id: Id of the group to run the report on
        :type group_id: str
        :param body: Contains the options for the report
        :type body: ~smartdiagnostics_sdk.models.StatisticsReportRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.request_statistics_report.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'StatisticsReportRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    request_statistics_report.metadata = {'url': '/api/v3.0/Reports/statistics/group/{groupId}'}

    def request_heatmap_report(
            self, group_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Enqueues a job to run and later email a heatmap report for the group
        provided using the options provided.

        :param group_id: Id of the group to run the report on
        :type group_id: str
        :param body: Contains the options for the report
        :type body: ~smartdiagnostics_sdk.models.HeatmapReportRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.request_heatmap_report.metadata['url']
        path_format_arguments = {
            'groupId': self._serialize.url("group_id", group_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'HeatmapReportRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    request_heatmap_report.metadata = {'url': '/api/v3.0/Reports/heatmap/group/{groupId}'}

    def run_setup_tool_job(
            self, job_type, location_id=None, file=None, custom_headers=None, raw=False, **operation_config):
        """Enqueues a job of the given type to be run.

        :param job_type: The type of job to run
        :type job_type: str
        :param location_id: The location to run the job for
        :type location_id: str
        :param file: The file to be processed
        :type file: Generator
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.run_setup_tool_job.metadata['url']
        path_format_arguments = {
            'jobType': self._serialize.url("job_type", job_type, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'multipart/form-data'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct form data
        form_data_content = {
            'locationId': location_id,
            'file': file,
        }

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, form_content=form_data_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [202, 400, 401, 404, 415]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 202:
            deserialized = self._deserialize('JobModelV3', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 415:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    run_setup_tool_job.metadata = {'url': '/api/v3.0/SetupTools/{jobType}'}

    def get_spreadsheet(
            self, job_type, location_id=None, filter_id=None, custom_headers=None, raw=False, **operation_config):
        """Gets the template spreadsheet for the given job type.

        :param job_type: The job type to get the template for
        :type job_type: str
        :param location_id: The location to get the template for
        :type location_id: str
        :param filter_id:
        :type filter_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_spreadsheet.metadata['url']
        path_format_arguments = {
            'jobType': self._serialize.url("job_type", job_type, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if location_id is not None:
            query_parameters['locationId'] = self._serialize.query("location_id", location_id, 'str')
        if filter_id is not None:
            query_parameters['filterId'] = self._serialize.query("filter_id", filter_id, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('object', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_spreadsheet.metadata = {'url': '/api/v3.0/SetupTools/{jobType}'}

    def get_sub_system(
            self, sub_system_id, custom_headers=None, raw=False, **operation_config):
        """Gets a subSystem.

        :param sub_system_id:
        :type sub_system_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_sub_system.metadata['url']
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}'}

    def update_sub_system(
            self, sub_system_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a subSystem.

        :param sub_system_id:
        :type sub_system_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.SubSystemUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_sub_system.metadata['url']
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SubSystemUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}'}

    def get_sub_systems(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets subSystems.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, in, like` |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsPaused` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_sub_systems.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSubSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_sub_systems.metadata = {'url': '/api/v3.0/SubSystems'}

    def create_sub_system(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a subSystem.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.SubSystemCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_sub_system.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SubSystemCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_sub_system.metadata = {'url': '/api/v3.0/SubSystems'}

    def move_sub_system(
            self, sub_system_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Moves a subSystem.

        :param sub_system_id:
        :type sub_system_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.GroupMoveRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.move_sub_system.metadata['url']
        path_format_arguments = {
            'subSystemId': self._serialize.url("sub_system_id", sub_system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'GroupMoveRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SubSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    move_sub_system.metadata = {'url': '/api/v3.0/SubSystems/{subSystemId}/Move'}

    def create_system(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Creates a system.

        :param body:
        :type body: ~smartdiagnostics_sdk.models.SystemCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.create_system.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SystemCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    create_system.metadata = {'url': '/api/v3.0/Systems'}

    def get_systems(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets systems.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, in, like` |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsCollectorDependentSystem` | Boolean | `eq, neq, in, lt, gt, leq,
         geq` |
         | `IsPaused` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_systems.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_systems.metadata = {'url': '/api/v3.0/Systems'}

    def get_system(
            self, system_id, custom_headers=None, raw=False, **operation_config):
        """Gets a system.

        :param system_id:
        :type system_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_system.metadata['url']
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SystemResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_system.metadata = {'url': '/api/v3.0/Systems/{systemId}'}

    def update_system(
            self, system_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Updates a system.

        :param system_id:
        :type system_id: str
        :param body:
        :type body: ~smartdiagnostics_sdk.models.SystemUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_system.metadata['url']
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'SystemUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SystemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_system.metadata = {'url': '/api/v3.0/Systems/{systemId}'}

    def get_asset_status_summaries_for_system(
            self, system_id, custom_headers=None, raw=False, **operation_config):
        """Gets asset status summary for a system.

        :param system_id:
        :type system_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_status_summaries_for_system.metadata['url']
        path_format_arguments = {
            'systemId': self._serialize.url("system_id", system_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('SystemAssetsStatusSummaryResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_status_summaries_for_system.metadata = {'url': '/api/v3.0/Systems/{systemId}/Assets/Summary/Status'}

    def get_asset_status_summaries_for_systems(
            self, filter=None, page=None, page_limit=None, custom_headers=None, raw=False, **operation_config):
        """Gets asset status summary for systems.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `LocationId` | Guid | `eq, neq, in` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_asset_status_summaries_for_systems.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelSystemAssetsStatusSummaryResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_asset_status_summaries_for_systems.metadata = {'url': '/api/v3.0/Systems/Assets/Summary/Status'}

    def get_tags(
            self, filter=None, page=None, page_limit=None, order_by=None, custom_headers=None, raw=False, **operation_config):
        """Gets tags.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
         | `Type` | TagCategories | `eq, neq, in, lt, gt, leq, geq` |
         | `Updated` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
         | `Type` | TagCategories |
         | `Updated` | DateTime |
        :type order_by: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tags.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelTagResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tags.metadata = {'url': '/api/v3.0/Tags'}

    def exchange_token(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """

        :param body:
        :type body: ~smartdiagnostics_sdk.models.TokenExchangeRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: TokenExchangeResponse or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.TokenExchangeResponse or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.exchange_token.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'TokenExchangeRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TokenExchangeResponse', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    exchange_token.metadata = {'url': '/api/v3.0/Tokens/exchange'}

    def get_tree_item(
            self, tree_item_id, custom_headers=None, raw=False, **operation_config):
        """Gets a treeItem.

        :param tree_item_id:
        :type tree_item_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tree_item.metadata['url']
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('TreeItemResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tree_item.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}'}

    def get_tree_items(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Gets treeItems.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Abbreviation` | String | `eq, neq, in, like` |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `AssetClassCode` | String | `eq, neq, in, like` |
         | `CategoryCode` | String | `eq, neq, in, like` |
         | `CategoryId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `CategoryName` | String | `eq, neq, in, like` |
         | `CorporationAbbreviation` | String | `eq, neq, in, like` |
         | `CorporationId` | Guid | `eq, neq, in` |
         | `CorporationName` | String | `eq, neq, in, like` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `IsPaused` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `LocationAbbreviation` | String | `eq, neq, in, like` |
         | `LocationId` | Guid | `eq, neq, in` |
         | `LocationName` | String | `eq, neq, in, like` |
         | `Name` | String | `eq, neq, in, like` |
         | `SizeCode` | String | `eq, neq, in, like` |
         | `SizeId` | Int32? | `eq, neq, in, lt, gt, leq, geq` |
         | `SizeName` | String | `eq, neq, in, like` |
         | `TreeItemType` | GroupTypeCodes | `eq, neq, in, lt, gt, leq, geq` |
         | `TypeCode` | String | `eq, neq, in, like` |
         | `TypeId` | Int32 | `eq, neq, in, lt, gt, leq, geq` |
         | `TypeName` | String | `eq, neq, in, like` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Abbreviation` | String |
         | `CategoryCode` | String |
         | `CategoryName` | String |
         | `CorporationName` | String |
         | `Created` | DateTime |
         | `LocationName` | String |
         | `Name` | String |
         | `SizeCode` | String |
         | `SizeName` | String |
         | `TypeCode` | String |
         | `TypeName` | String |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tree_items.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 400, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelTreeItemResponse', response)
        if response.status_code == 400:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tree_items.metadata = {'url': '/api/v3.0/TreeItems'}

    def get_tree_item_available_asset_classes(
            self, tree_item_id, page=None, page_limit=None, custom_headers=None, raw=False, **operation_config):
        """Gets available asset classes in the subtree rooted at treeItemId.

        :param tree_item_id:
        :type tree_item_id: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_tree_item_available_asset_classes.metadata['url']
        path_format_arguments = {
            'treeItemId': self._serialize.url("tree_item_id", tree_item_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelTreeItemAvailableAssetClassResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_tree_item_available_asset_classes.metadata = {'url': '/api/v3.0/TreeItems/{treeItemId}/AvailableAssetClasses'}

    def get_current_user(
            self, custom_headers=None, raw=False, **operation_config):
        """Gets the Current user.

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_current_user.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('CurrentUserResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_current_user.metadata = {'url': '/api/v3.0/Users/currentUser'}

    def get_personal_access_tokens(
            self, filter=None, page=None, page_limit=None, order_by=None, name_search=None, custom_headers=None, raw=False, **operation_config):
        """Lists the current user's access tokens.

        :param filter: Filter statements to narrow results by properties.
         Filterable properties:
         | Field name | Type | Operators |
         | ---------- | ---- | --------- |
         | `Active` | Boolean | `eq, neq, in, lt, gt, leq, geq` |
         | `Created` | DateTime | `eq, neq, in, lt, gt, leq, geq` |
         | `Description` | String | `eq, neq, in, like` |
         | `LastUsed` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
         | `Updated` | DateTime? | `eq, neq, in, lt, gt, leq, geq` |
        :type filter: str
        :param page: Results page. 1-based (1 returns the first page, 0 is
         invalid).
        :type page: int
        :param page_limit: Number of items to return per page.
        :type page_limit: int
        :param order_by: Allows sorting response items by multiple fields.
         Sortable properties:
         | Field name | Type |
         | ---------- | ---- |
         | `Active` | Boolean |
         | `Created` | DateTime |
         | `Description` | String |
         | `LastUsed` | DateTime? |
         | `Updated` | DateTime? |
        :type order_by: str
        :param name_search: Search term to narrow results used by DataTable.js
        :type name_search: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_personal_access_tokens.metadata['url']

        # Construct parameters
        query_parameters = {}
        if filter is not None:
            query_parameters['Filter'] = self._serialize.query("filter", filter, 'str')
        if page is not None:
            query_parameters['Page'] = self._serialize.query("page", page, 'int', minimum=1)
        if page_limit is not None:
            query_parameters['PageLimit'] = self._serialize.query("page_limit", page_limit, 'int', maximum=2000, minimum=1)
        if order_by is not None:
            query_parameters['OrderBy'] = self._serialize.query("order_by", order_by, 'str')
        if name_search is not None:
            query_parameters['NameSearch'] = self._serialize.query("name_search", name_search, 'str')

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PagedResultsModelPersonalAccessTokenResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_personal_access_tokens.metadata = {'url': '/api/v3.0/Users/currentUser/tokens'}

    def generate_personal_access_tokens(
            self, body=None, custom_headers=None, raw=False, **operation_config):
        """Generate a new access token for the current user.

        :param body:
        :type body:
         ~smartdiagnostics_sdk.models.PersonalAccessTokenCreateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.generate_personal_access_tokens.metadata['url']

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'PersonalAccessTokenCreateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [201, 401]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 201:
            deserialized = self._deserialize('PersonalAccessTokenCreateResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    generate_personal_access_tokens.metadata = {'url': '/api/v3.0/Users/currentUser/tokens'}

    def get_personal_access_token(
            self, token_id, custom_headers=None, raw=False, **operation_config):
        """Get one of the current user's access tokens.

        :param token_id:
        :type token_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.get_personal_access_token.metadata['url']
        path_format_arguments = {
            'tokenId': self._serialize.url("token_id", token_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PersonalAccessTokenResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    get_personal_access_token.metadata = {'url': '/api/v3.0/Users/currentUser/tokens/{tokenId}'}

    def update_personal_access_token(
            self, token_id, body=None, custom_headers=None, raw=False, **operation_config):
        """Update one of the current user's access tokens.

        :param token_id:
        :type token_id: str
        :param body:
        :type body:
         ~smartdiagnostics_sdk.models.PersonalAccessTokenUpdateRequest
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: object or ClientRawResponse if raw=true
        :rtype: object or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.update_personal_access_token.metadata['url']
        path_format_arguments = {
            'tokenId': self._serialize.url("token_id", token_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        header_parameters['Content-Type'] = 'application/json-patch+json; charset=utf-8'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct body
        if body is not None:
            body_content = self._serialize.body(body, 'PersonalAccessTokenUpdateRequest')
        else:
            body_content = None

        # Construct and send request
        request = self._client.put(url, query_parameters, header_parameters, body_content)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 200:
            deserialized = self._deserialize('PersonalAccessTokenResponse', response)
        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    update_personal_access_token.metadata = {'url': '/api/v3.0/Users/currentUser/tokens/{tokenId}'}

    def delete_personal_access_token(
            self, token_id, custom_headers=None, raw=False, **operation_config):
        """Revokes one of the current user's access tokens.

        :param token_id:
        :type token_id: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: ProblemDetails or ClientRawResponse if raw=true
        :rtype: ~smartdiagnostics_sdk.models.ProblemDetails or
         ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.delete_personal_access_token.metadata['url']
        path_format_arguments = {
            'tokenId': self._serialize.url("token_id", token_id, 'str')
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}

        # Construct headers
        header_parameters = {}
        header_parameters['Accept'] = 'application/json'
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 401, 404]:
            raise HttpOperationError(self._deserialize, response)

        deserialized = None

        if response.status_code == 401:
            deserialized = self._deserialize('ProblemDetails', response)
        if response.status_code == 404:
            deserialized = self._deserialize('ProblemDetails', response)

        if raw:
            client_raw_response = ClientRawResponse(deserialized, response)
            return client_raw_response

        return deserialized
    delete_personal_access_token.metadata = {'url': '/api/v3.0/Users/currentUser/tokens/{tokenId}'}
