"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosRule = exports.RosDeliveryChannel = exports.RosCompliancePack = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosCompliancePackProps`
 *
 * @param properties - the TypeScript properties of a `RosCompliancePackProps`
 *
 * @returns the result of the validation.
 */
function RosCompliancePackPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('compliancePackName', ros.requiredValidator)(properties.compliancePackName));
    errors.collect(ros.propertyValidator('compliancePackName', ros.validateString)(properties.compliancePackName));
    errors.collect(ros.propertyValidator('description', ros.requiredValidator)(properties.description));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('configRules', ros.listValidator(RosCompliancePack_ConfigRulesPropertyValidator))(properties.configRules));
    errors.collect(ros.propertyValidator('compliancePackTemplateId', ros.validateString)(properties.compliancePackTemplateId));
    errors.collect(ros.propertyValidator('riskLevel', ros.requiredValidator)(properties.riskLevel));
    errors.collect(ros.propertyValidator('riskLevel', ros.validateNumber)(properties.riskLevel));
    return errors.wrap('supplied properties not correct for "RosCompliancePackProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack` resource
 *
 * @param properties - the TypeScript properties of a `RosCompliancePackProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack` resource.
 */
// @ts-ignore TS6133
function rosCompliancePackPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosCompliancePackPropsValidator(properties).assertSuccess();
    }
    return {
        CompliancePackName: ros.stringToRosTemplate(properties.compliancePackName),
        Description: ros.stringToRosTemplate(properties.description),
        RiskLevel: ros.numberToRosTemplate(properties.riskLevel),
        CompliancePackTemplateId: ros.stringToRosTemplate(properties.compliancePackTemplateId),
        ConfigRules: ros.listMapper(rosCompliancePackConfigRulesPropertyToRosTemplate)(properties.configRules),
    };
}
/**
 * A ROS template type:  `ALIYUN::Config::CompliancePack`
 */
class RosCompliancePack extends ros.RosResource {
    /**
     * Create a new `ALIYUN::Config::CompliancePack`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosCompliancePack.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrAccountId = this.getAtt('AccountId');
        this.attrCompliancePackId = this.getAtt('CompliancePackId');
        this.attrCompliancePackName = this.getAtt('CompliancePackName');
        this.attrCompliancePackTemplateId = this.getAtt('CompliancePackTemplateId');
        this.attrDescription = this.getAtt('Description');
        this.attrRiskLevel = this.getAtt('RiskLevel');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.compliancePackName = props.compliancePackName;
        this.description = props.description;
        this.riskLevel = props.riskLevel;
        this.compliancePackTemplateId = props.compliancePackTemplateId;
        this.configRules = props.configRules;
    }
    get rosProperties() {
        return {
            compliancePackName: this.compliancePackName,
            description: this.description,
            riskLevel: this.riskLevel,
            compliancePackTemplateId: this.compliancePackTemplateId,
            configRules: this.configRules,
        };
    }
    renderProperties(props) {
        return rosCompliancePackPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosCompliancePack = RosCompliancePack;
/**
 * The resource type name for this resource class.
 */
RosCompliancePack.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Config::CompliancePack";
/**
 * Determine whether the given properties match those of a `ConfigRuleParametersProperty`
 *
 * @param properties - the TypeScript properties of a `ConfigRuleParametersProperty`
 *
 * @returns the result of the validation.
 */
function RosCompliancePack_ConfigRuleParametersPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('parameterValue', ros.validateString)(properties.parameterValue));
    errors.collect(ros.propertyValidator('required', ros.validateBoolean)(properties.required));
    errors.collect(ros.propertyValidator('parameterName', ros.validateString)(properties.parameterName));
    return errors.wrap('supplied properties not correct for "ConfigRuleParametersProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack.ConfigRuleParameters` resource
 *
 * @param properties - the TypeScript properties of a `ConfigRuleParametersProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack.ConfigRuleParameters` resource.
 */
// @ts-ignore TS6133
function rosCompliancePackConfigRuleParametersPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCompliancePack_ConfigRuleParametersPropertyValidator(properties).assertSuccess();
    return {
        ParameterValue: ros.stringToRosTemplate(properties.parameterValue),
        Required: ros.booleanToRosTemplate(properties.required),
        ParameterName: ros.stringToRosTemplate(properties.parameterName),
    };
}
/**
 * Determine whether the given properties match those of a `ConfigRulesProperty`
 *
 * @param properties - the TypeScript properties of a `ConfigRulesProperty`
 *
 * @returns the result of the validation.
 */
function RosCompliancePack_ConfigRulesPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('configRuleId', ros.validateString)(properties.configRuleId));
    errors.collect(ros.propertyValidator('configRuleName', ros.validateString)(properties.configRuleName));
    errors.collect(ros.propertyValidator('managedRuleIdentifier', ros.validateString)(properties.managedRuleIdentifier));
    errors.collect(ros.propertyValidator('configRuleParameters', ros.listValidator(RosCompliancePack_ConfigRuleParametersPropertyValidator))(properties.configRuleParameters));
    return errors.wrap('supplied properties not correct for "ConfigRulesProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack.ConfigRules` resource
 *
 * @param properties - the TypeScript properties of a `ConfigRulesProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::CompliancePack.ConfigRules` resource.
 */
// @ts-ignore TS6133
function rosCompliancePackConfigRulesPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosCompliancePack_ConfigRulesPropertyValidator(properties).assertSuccess();
    return {
        ConfigRuleId: ros.stringToRosTemplate(properties.configRuleId),
        ConfigRuleName: ros.stringToRosTemplate(properties.configRuleName),
        ManagedRuleIdentifier: ros.stringToRosTemplate(properties.managedRuleIdentifier),
        ConfigRuleParameters: ros.listMapper(rosCompliancePackConfigRuleParametersPropertyToRosTemplate)(properties.configRuleParameters),
    };
}
/**
 * Determine whether the given properties match those of a `RosDeliveryChannelProps`
 *
 * @param properties - the TypeScript properties of a `RosDeliveryChannelProps`
 *
 * @returns the result of the validation.
 */
function RosDeliveryChannelPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('deliveryChannelName', ros.validateString)(properties.deliveryChannelName));
    errors.collect(ros.propertyValidator('deliveryChannelTargetArn', ros.requiredValidator)(properties.deliveryChannelTargetArn));
    errors.collect(ros.propertyValidator('deliveryChannelTargetArn', ros.validateString)(properties.deliveryChannelTargetArn));
    errors.collect(ros.propertyValidator('deliveryChannelAssumeRoleArn', ros.requiredValidator)(properties.deliveryChannelAssumeRoleArn));
    errors.collect(ros.propertyValidator('deliveryChannelAssumeRoleArn', ros.validateString)(properties.deliveryChannelAssumeRoleArn));
    errors.collect(ros.propertyValidator('deliveryChannelType', ros.requiredValidator)(properties.deliveryChannelType));
    if (properties.deliveryChannelType && (typeof properties.deliveryChannelType) !== 'object') {
        errors.collect(ros.propertyValidator('deliveryChannelType', ros.validateAllowedValues)({
            data: properties.deliveryChannelType,
            allowedValues: ["MNS", "OSS", "SLS"],
        }));
    }
    errors.collect(ros.propertyValidator('deliveryChannelType', ros.validateString)(properties.deliveryChannelType));
    errors.collect(ros.propertyValidator('deliveryChannelCondition', ros.validateString)(properties.deliveryChannelCondition));
    return errors.wrap('supplied properties not correct for "RosDeliveryChannelProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::DeliveryChannel` resource
 *
 * @param properties - the TypeScript properties of a `RosDeliveryChannelProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::DeliveryChannel` resource.
 */
// @ts-ignore TS6133
function rosDeliveryChannelPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosDeliveryChannelPropsValidator(properties).assertSuccess();
    }
    return {
        DeliveryChannelAssumeRoleArn: ros.stringToRosTemplate(properties.deliveryChannelAssumeRoleArn),
        DeliveryChannelTargetArn: ros.stringToRosTemplate(properties.deliveryChannelTargetArn),
        DeliveryChannelType: ros.stringToRosTemplate(properties.deliveryChannelType),
        DeliveryChannelCondition: ros.stringToRosTemplate(properties.deliveryChannelCondition),
        DeliveryChannelName: ros.stringToRosTemplate(properties.deliveryChannelName),
        Description: ros.stringToRosTemplate(properties.description),
    };
}
/**
 * A ROS template type:  `ALIYUN::Config::DeliveryChannel`
 */
class RosDeliveryChannel extends ros.RosResource {
    /**
     * Create a new `ALIYUN::Config::DeliveryChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosDeliveryChannel.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDeliveryChannelId = this.getAtt('DeliveryChannelId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.deliveryChannelAssumeRoleArn = props.deliveryChannelAssumeRoleArn;
        this.deliveryChannelTargetArn = props.deliveryChannelTargetArn;
        this.deliveryChannelType = props.deliveryChannelType;
        this.deliveryChannelCondition = props.deliveryChannelCondition;
        this.deliveryChannelName = props.deliveryChannelName;
        this.description = props.description;
    }
    get rosProperties() {
        return {
            deliveryChannelAssumeRoleArn: this.deliveryChannelAssumeRoleArn,
            deliveryChannelTargetArn: this.deliveryChannelTargetArn,
            deliveryChannelType: this.deliveryChannelType,
            deliveryChannelCondition: this.deliveryChannelCondition,
            deliveryChannelName: this.deliveryChannelName,
            description: this.description,
        };
    }
    renderProperties(props) {
        return rosDeliveryChannelPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosDeliveryChannel = RosDeliveryChannel;
/**
 * The resource type name for this resource class.
 */
RosDeliveryChannel.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Config::DeliveryChannel";
/**
 * Determine whether the given properties match those of a `RosRuleProps`
 *
 * @param properties - the TypeScript properties of a `RosRuleProps`
 *
 * @returns the result of the validation.
 */
function RosRulePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('tagKeyScope', ros.validateString)(properties.tagKeyScope));
    errors.collect(ros.propertyValidator('tagValueScope', ros.validateString)(properties.tagValueScope));
    errors.collect(ros.propertyValidator('description', ros.validateString)(properties.description));
    errors.collect(ros.propertyValidator('excludeResourceIdsScope', ros.validateString)(properties.excludeResourceIdsScope));
    errors.collect(ros.propertyValidator('sourceOwner', ros.requiredValidator)(properties.sourceOwner));
    errors.collect(ros.propertyValidator('sourceOwner', ros.validateString)(properties.sourceOwner));
    errors.collect(ros.propertyValidator('sourceIdentifier', ros.requiredValidator)(properties.sourceIdentifier));
    errors.collect(ros.propertyValidator('sourceIdentifier', ros.validateString)(properties.sourceIdentifier));
    errors.collect(ros.propertyValidator('maximumExecutionFrequency', ros.validateString)(properties.maximumExecutionFrequency));
    errors.collect(ros.propertyValidator('regionIdsScope', ros.validateString)(properties.regionIdsScope));
    errors.collect(ros.propertyValidator('configRuleTriggerTypes', ros.requiredValidator)(properties.configRuleTriggerTypes));
    errors.collect(ros.propertyValidator('configRuleTriggerTypes', ros.validateString)(properties.configRuleTriggerTypes));
    errors.collect(ros.propertyValidator('resourceGroupIdsScope', ros.validateString)(properties.resourceGroupIdsScope));
    errors.collect(ros.propertyValidator('riskLevel', ros.requiredValidator)(properties.riskLevel));
    errors.collect(ros.propertyValidator('riskLevel', ros.validateNumber)(properties.riskLevel));
    errors.collect(ros.propertyValidator('resourceTypesScope', ros.requiredValidator)(properties.resourceTypesScope));
    errors.collect(ros.propertyValidator('resourceTypesScope', ros.listValidator(ros.validateString))(properties.resourceTypesScope));
    errors.collect(ros.propertyValidator('ruleName', ros.requiredValidator)(properties.ruleName));
    errors.collect(ros.propertyValidator('ruleName', ros.validateString)(properties.ruleName));
    errors.collect(ros.propertyValidator('inputParameters', ros.hashValidator(ros.validateAny))(properties.inputParameters));
    return errors.wrap('supplied properties not correct for "RosRuleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::Config::Rule` resource
 *
 * @param properties - the TypeScript properties of a `RosRuleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::Config::Rule` resource.
 */
// @ts-ignore TS6133
function rosRulePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosRulePropsValidator(properties).assertSuccess();
    }
    return {
        ConfigRuleTriggerTypes: ros.stringToRosTemplate(properties.configRuleTriggerTypes),
        ResourceTypesScope: ros.listMapper(ros.stringToRosTemplate)(properties.resourceTypesScope),
        RiskLevel: ros.numberToRosTemplate(properties.riskLevel),
        RuleName: ros.stringToRosTemplate(properties.ruleName),
        SourceIdentifier: ros.stringToRosTemplate(properties.sourceIdentifier),
        SourceOwner: ros.stringToRosTemplate(properties.sourceOwner),
        Description: ros.stringToRosTemplate(properties.description),
        ExcludeResourceIdsScope: ros.stringToRosTemplate(properties.excludeResourceIdsScope),
        InputParameters: ros.hashMapper(ros.objectToRosTemplate)(properties.inputParameters),
        MaximumExecutionFrequency: ros.stringToRosTemplate(properties.maximumExecutionFrequency),
        RegionIdsScope: ros.stringToRosTemplate(properties.regionIdsScope),
        ResourceGroupIdsScope: ros.stringToRosTemplate(properties.resourceGroupIdsScope),
        TagKeyScope: ros.stringToRosTemplate(properties.tagKeyScope),
        TagValueScope: ros.stringToRosTemplate(properties.tagValueScope),
    };
}
/**
 * A ROS template type:  `ALIYUN::Config::Rule`
 */
class RosRule extends ros.RosResource {
    /**
     * Create a new `ALIYUN::Config::Rule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosRule.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrCompliancePackId = this.getAtt('CompliancePackId');
        this.attrConfigRuleArn = this.getAtt('ConfigRuleArn');
        this.attrConfigRuleId = this.getAtt('ConfigRuleId');
        this.attrConfigRuleTriggerTypes = this.getAtt('ConfigRuleTriggerTypes');
        this.attrDescription = this.getAtt('Description');
        this.attrEventSource = this.getAtt('EventSource');
        this.attrExcludeResourceIdsScope = this.getAtt('ExcludeResourceIdsScope');
        this.attrInputParameters = this.getAtt('InputParameters');
        this.attrMaximumExecutionFrequency = this.getAtt('MaximumExecutionFrequency');
        this.attrRegionIdsScope = this.getAtt('RegionIdsScope');
        this.attrResourceGroupIdsScope = this.getAtt('ResourceGroupIdsScope');
        this.attrResourceTypesScope = this.getAtt('ResourceTypesScope');
        this.attrRiskLevel = this.getAtt('RiskLevel');
        this.attrRuleName = this.getAtt('RuleName');
        this.attrSourceIdentifier = this.getAtt('SourceIdentifier');
        this.attrSourceOwner = this.getAtt('SourceOwner');
        this.attrTagKeyScope = this.getAtt('TagKeyScope');
        this.attrTagValueScope = this.getAtt('TagValueScope');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.configRuleTriggerTypes = props.configRuleTriggerTypes;
        this.resourceTypesScope = props.resourceTypesScope;
        this.riskLevel = props.riskLevel;
        this.ruleName = props.ruleName;
        this.sourceIdentifier = props.sourceIdentifier;
        this.sourceOwner = props.sourceOwner;
        this.description = props.description;
        this.excludeResourceIdsScope = props.excludeResourceIdsScope;
        this.inputParameters = props.inputParameters;
        this.maximumExecutionFrequency = props.maximumExecutionFrequency;
        this.regionIdsScope = props.regionIdsScope;
        this.resourceGroupIdsScope = props.resourceGroupIdsScope;
        this.tagKeyScope = props.tagKeyScope;
        this.tagValueScope = props.tagValueScope;
    }
    get rosProperties() {
        return {
            configRuleTriggerTypes: this.configRuleTriggerTypes,
            resourceTypesScope: this.resourceTypesScope,
            riskLevel: this.riskLevel,
            ruleName: this.ruleName,
            sourceIdentifier: this.sourceIdentifier,
            sourceOwner: this.sourceOwner,
            description: this.description,
            excludeResourceIdsScope: this.excludeResourceIdsScope,
            inputParameters: this.inputParameters,
            maximumExecutionFrequency: this.maximumExecutionFrequency,
            regionIdsScope: this.regionIdsScope,
            resourceGroupIdsScope: this.resourceGroupIdsScope,
            tagKeyScope: this.tagKeyScope,
            tagValueScope: this.tagValueScope,
        };
    }
    renderProperties(props) {
        return rosRulePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosRule = RosRule;
/**
 * The resource type name for this resource class.
 */
RosRule.ROS_RESOURCE_TYPE_NAME = "ALIYUN::Config::Rule";
//# sourceMappingURL=data:application/json;base64,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