"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CompliancePack = exports.CompliancePackProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const config_generated_1 = require("./config.generated");
Object.defineProperty(exports, "CompliancePackProperty", { enumerable: true, get: function () { return config_generated_1.RosCompliancePack; } });
/**
 * A ROS resource type:  `ALIYUN::Config::CompliancePack`
 */
class CompliancePack extends ros.Resource {
    /**
     * Create a new `ALIYUN::Config::CompliancePack`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCompliancePack = new config_generated_1.RosCompliancePack(this, id, {
            compliancePackName: props.compliancePackName,
            description: props.description,
            configRules: props.configRules,
            compliancePackTemplateId: props.compliancePackTemplateId,
            riskLevel: props.riskLevel,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCompliancePack;
        this.attrAccountId = rosCompliancePack.attrAccountId;
        this.attrCompliancePackId = rosCompliancePack.attrCompliancePackId;
        this.attrCompliancePackName = rosCompliancePack.attrCompliancePackName;
        this.attrCompliancePackTemplateId = rosCompliancePack.attrCompliancePackTemplateId;
        this.attrDescription = rosCompliancePack.attrDescription;
        this.attrRiskLevel = rosCompliancePack.attrRiskLevel;
    }
}
exports.CompliancePack = CompliancePack;
//# sourceMappingURL=data:application/json;base64,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