RSA = {
    "name": "South Africa",
    "topLevelDomain": [".za"],
    "alpha2Code": "ZA",
    "alpha3Code": "ZAF",
    "callingCodes": ["27"],
    "capital": "Pretoria",
    "altSpellings": ["ZA", "RSA", "Suid-Afrika", "Republic of South Africa"],
    "region": "Africa",
    "subregion": "Southern Africa",
    "population": 55653654,
    "latlng": [-29.0, 24.0],
    "demonym": "South African",
    "area": 1221037.0,
    "gini": 63.1,
    "timezones": ["UTC+02:00"],
    "borders": ["BWA", "LSO", "MOZ", "NAM", "SWZ", "ZWE"],
    "nativeName": "South Africa",
    "numericCode": "710",
    "currencies": [{"code": "ZAR", "name": "South African rand", "symbol": "R"}],
    "languages": [
        {
            "iso639_1": "af",
            "iso639_2": "afr",
            "name": "Afrikaans",
            "nativeName": "Afrikaans",
        },
        {
            "iso639_1": "en",
            "iso639_2": "eng",
            "name": "English",
            "nativeName": "English",
        },
        {
            "iso639_1": "nr",
            "iso639_2": "nbl",
            "name": "Southern Ndebele",
            "nativeName": "isiNdebele",
        },
        {
            "iso639_1": "st",
            "iso639_2": "sot",
            "name": "Southern Sotho",
            "nativeName": "Sesotho",
        },
        {"iso639_1": "ss", "iso639_2": "ssw", "name": "Swati", "nativeName": "SiSwati"},
        {
            "iso639_1": "tn",
            "iso639_2": "tsn",
            "name": "Tswana",
            "nativeName": "Setswana",
        },
        {
            "iso639_1": "ts",
            "iso639_2": "tso",
            "name": "Tsonga",
            "nativeName": "Xitsonga",
        },
        {
            "iso639_1": "ve",
            "iso639_2": "ven",
            "name": "Venda",
            "nativeName": "Tshivenḓa",
        },
        {
            "iso639_1": "xh",
            "iso639_2": "xho",
            "name": "Xhosa",
            "nativeName": "isiXhosa",
        },
        {"iso639_1": "zu", "iso639_2": "zul", "name": "Zulu", "nativeName": "isiZulu"},
    ],
    "translations": {
        "de": "Republik Südafrika",
        "es": "República de Sudáfrica",
        "fr": "Afrique du Sud",
        "ja": "南アフリカ",
        "it": "Sud Africa",
        "br": "República Sul-Africana",
        "pt": "República Sul-Africana",
        "nl": "Zuid-Afrika",
        "hr": "Južnoafrička Republika",
        "fa": "آفریقای جنوبی",
    },
    "flag": "https://restcountries.eu/data/zaf.svg",
    "regionalBlocs": [
        {
            "acronym": "AU",
            "name": "African Union",
            "otherAcronyms": [],
            "otherNames": [
                "الاتحاد الأفريقي",
                "Union africaine",
                "União Africana",
                "Unión Africana",
                "Umoja wa Afrika",
            ],
        }
    ],
    "cioc": "RSA",
}

NGR = {
    "name": "Nigeria",
    "topLevelDomain": [".ng"],
    "alpha2Code": "NG",
    "alpha3Code": "NGA",
    "callingCodes": ["234"],
    "capital": "Abuja",
    "altSpellings": ["NG", "Nijeriya", "Naíjíríà", "Federal Republic of Nigeria"],
    "region": "Africa",
    "subregion": "Western Africa",
    "population": 186988000,
    "latlng": [10.0, 8.0],
    "demonym": "Nigerian",
    "area": 923768.0,
    "gini": 48.8,
    "timezones": ["UTC+01:00"],
    "borders": ["BEN", "CMR", "TCD", "NER"],
    "nativeName": "Nigeria",
    "numericCode": "566",
    "currencies": [{"code": "NGN", "name": "Nigerian naira", "symbol": "₦"}],
    "languages": [
        {
            "iso639_1": "en",
            "iso639_2": "eng",
            "name": "English",
            "nativeName": "English",
        }
    ],
    "translations": {
        "de": "Nigeria",
        "es": "Nigeria",
        "fr": "Nigéria",
        "ja": "ナイジェリア",
        "it": "Nigeria",
        "br": "Nigéria",
        "pt": "Nigéria",
        "nl": "Nigeria",
        "hr": "Nigerija",
        "fa": "نیجریه",
    },
    "flag": "https://restcountries.eu/data/nga.svg",
    "regionalBlocs": [
        {
            "acronym": "AU",
            "name": "African Union",
            "otherAcronyms": [],
            "otherNames": [
                "الاتحاد الأفريقي",
                "Union africaine",
                "União Africana",
                "Unión Africana",
                "Umoja wa Afrika",
            ],
        }
    ],
    "cioc": "NGR",
}

EGY = {
    "name": "Egypt",
    "topLevelDomain": [".eg"],
    "alpha2Code": "EG",
    "alpha3Code": "EGY",
    "callingCodes": ["20"],
    "capital": "Cairo",
    "altSpellings": ["EG", "Arab Republic of Egypt"],
    "region": "Africa",
    "subregion": "Northern Africa",
    "population": 91290000,
    "latlng": [27.0, 30.0],
    "demonym": "Egyptian",
    "area": 1002450.0,
    "gini": 30.8,
    "timezones": ["UTC+02:00"],
    "borders": ["ISR", "LBY", "SDN"],
    "nativeName": "مصر‎",
    "numericCode": "818",
    "currencies": [{"code": "EGP", "name": "Egyptian pound", "symbol": "£"}],
    "languages": [
        {"iso639_1": "ar", "iso639_2": "ara", "name": "Arabic", "nativeName": "العربية"}
    ],
    "translations": {
        "de": "Ägypten",
        "es": "Egipto",
        "fr": "Égypte",
        "ja": "エジプト",
        "it": "Egitto",
        "br": "Egito",
        "pt": "Egipto",
        "nl": "Egypte",
        "hr": "Egipat",
        "fa": "مصر",
    },
    "flag": "https://restcountries.eu/data/egy.svg",
    "regionalBlocs": [
        {
            "acronym": "AU",
            "name": "African Union",
            "otherAcronyms": [],
            "otherNames": [
                "الاتحاد الأفريقي",
                "Union africaine",
                "União Africana",
                "Unión Africana",
                "Umoja wa Afrika",
            ],
        },
        {
            "acronym": "AL",
            "name": "Arab League",
            "otherAcronyms": [],
            "otherNames": [
                "جامعة الدول العربية",
                "Jāmiʻat ad-Duwal al-ʻArabīyah",
                "League of Arab States",
            ],
        },
    ],
    "cioc": "EGY",
}

KEN = {
    "name": "Kenya",
    "topLevelDomain": [".ke"],
    "alpha2Code": "KE",
    "alpha3Code": "KEN",
    "callingCodes": ["254"],
    "capital": "Nairobi",
    "altSpellings": ["KE", "Republic of Kenya", "Jamhuri ya Kenya"],
    "region": "Africa",
    "subregion": "Eastern Africa",
    "population": 47251000,
    "latlng": [1.0, 38.0],
    "demonym": "Kenyan",
    "area": 580367.0,
    "gini": 47.7,
    "timezones": ["UTC+03:00"],
    "borders": ["ETH", "SOM", "SSD", "TZA", "UGA"],
    "nativeName": "Kenya",
    "numericCode": "404",
    "currencies": [{"code": "KES", "name": "Kenyan shilling", "symbol": "Sh"}],
    "languages": [
        {
            "iso639_1": "en",
            "iso639_2": "eng",
            "name": "English",
            "nativeName": "English",
        },
        {
            "iso639_1": "sw",
            "iso639_2": "swa",
            "name": "Swahili",
            "nativeName": "Kiswahili",
        },
    ],
    "translations": {
        "de": "Kenia",
        "es": "Kenia",
        "fr": "Kenya",
        "ja": "ケニア",
        "it": "Kenya",
        "br": "Quênia",
        "pt": "Quénia",
        "nl": "Kenia",
        "hr": "Kenija",
        "fa": "کنیا",
    },
    "flag": "https://restcountries.eu/data/ken.svg",
    "regionalBlocs": [
        {
            "acronym": "AU",
            "name": "African Union",
            "otherAcronyms": [],
            "otherNames": [
                "الاتحاد الأفريقي",
                "Union africaine",
                "União Africana",
                "Unión Africana",
                "Umoja wa Afrika",
            ],
        }
    ],
    "cioc": "KEN",
}
