/**
 * The type of subnet group.
 *
 * Same as SubnetType in the @aws-cdk/aws-ec2 package,
 * but we can't use that because of cyclical dependencies.
 *
 * @stability stable
 */
export declare enum VpcSubnetGroupType {
    /**
     * Public subnet group type.
     *
     * @stability stable
     */
    PUBLIC = "Public",
    /**
     * Private subnet group type.
     *
     * @stability stable
     */
    PRIVATE = "Private",
    /**
     * Isolated subnet group type.
     *
     * @stability stable
     */
    ISOLATED = "Isolated"
}
/**
 * A subnet representation that the VPC provider uses.
 *
 * @stability stable
 */
export interface VpcSubnet {
    /**
     * The identifier of the subnet.
     *
     * @stability stable
     */
    readonly subnetId: string;
    /**
     * The code of the availability zone this subnet is in (for example, 'us-west-2a').
     *
     * @stability stable
     */
    readonly availabilityZone: string;
    /**
     * The identifier of the route table for this subnet.
     *
     * @stability stable
     */
    readonly routeTableId: string;
    /**
     * CIDR range of the subnet.
     *
     * @default - CIDR information not available
     * @stability stable
     */
    readonly cidr?: string;
}
/**
 * A group of subnets returned by the VPC provider.
 *
 * The included subnets do NOT have to be symmetric!
 *
 * @stability stable
 */
export interface VpcSubnetGroup {
    /**
     * The name of the subnet group, determined by looking at the tags of of the subnets that belong to it.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The type of the subnet group.
     *
     * @stability stable
     */
    readonly type: VpcSubnetGroupType;
    /**
     * The subnets that are part of this group.
     *
     * There is no condition that the subnets have to be symmetric
     * in the group.
     *
     * @stability stable
     */
    readonly subnets: VpcSubnet[];
}
/**
 * Properties of a discovered VPC.
 *
 * @stability stable
 */
export interface VpcContextResponse {
    /**
     * VPC id.
     *
     * @stability stable
     */
    readonly vpcId: string;
    /**
     * VPC cidr.
     *
     * @default - CIDR information not available
     * @stability stable
     */
    readonly vpcCidrBlock?: string;
    /**
     * AZs.
     *
     * @stability stable
     */
    readonly availabilityZones: string[];
    /**
     * IDs of all public subnets.
     *
     * Element count: #(availabilityZones) · #(publicGroups)
     *
     * @stability stable
     */
    readonly publicSubnetIds?: string[];
    /**
     * Name of public subnet groups.
     *
     * Element count: #(publicGroups)
     *
     * @stability stable
     */
    readonly publicSubnetNames?: string[];
    /**
     * Route Table IDs of public subnet groups.
     *
     * Element count: #(availabilityZones) · #(publicGroups)
     *
     * @stability stable
     */
    readonly publicSubnetRouteTableIds?: string[];
    /**
     * IDs of all private subnets.
     *
     * Element count: #(availabilityZones) · #(privateGroups)
     *
     * @stability stable
     */
    readonly privateSubnetIds?: string[];
    /**
     * Name of private subnet groups.
     *
     * Element count: #(privateGroups)
     *
     * @stability stable
     */
    readonly privateSubnetNames?: string[];
    /**
     * Route Table IDs of private subnet groups.
     *
     * Element count: #(availabilityZones) · #(privateGroups)
     *
     * @stability stable
     */
    readonly privateSubnetRouteTableIds?: string[];
    /**
     * IDs of all isolated subnets.
     *
     * Element count: #(availabilityZones) · #(isolatedGroups)
     *
     * @stability stable
     */
    readonly isolatedSubnetIds?: string[];
    /**
     * Name of isolated subnet groups.
     *
     * Element count: #(isolatedGroups)
     *
     * @stability stable
     */
    readonly isolatedSubnetNames?: string[];
    /**
     * Route Table IDs of isolated subnet groups.
     *
     * Element count: #(availabilityZones) · #(isolatedGroups)
     *
     * @stability stable
     */
    readonly isolatedSubnetRouteTableIds?: string[];
    /**
     * The VPN gateway ID.
     *
     * @stability stable
     */
    readonly vpnGatewayId?: string;
    /**
     * The subnet groups discovered for the given VPC.
     *
     * Unlike the above properties, this will include asymmetric subnets,
     * if the VPC has any.
     * This property will only be populated if {@link VpcContextQuery.returnAsymmetricSubnets}
     * is true.
     *
     * @default - no subnet groups will be returned unless {@link VpcContextQuery.returnAsymmetricSubnets} is true
     * @stability stable
     */
    readonly subnetGroups?: VpcSubnetGroup[];
}
