import { IResolvable, IResolveContext } from '../resolvable';
/**
 * Customization properties for an Intrinsic token.
 *
 * @stability stable
 */
export interface IntrinsicProps {
    /**
     * Capture the stack trace of where this token is created.
     *
     * @default true
     * @stability stable
     */
    readonly stackTrace?: boolean;
}
/**
 * Token subclass that represents values intrinsic to the target document language.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @stability stable
 */
export declare class Intrinsic implements IResolvable {
    /**
     * The captured stack trace which represents the location in which this token was created.
     *
     * @stability stable
     */
    readonly creationStack: string[];
    private readonly value;
    /**
     * @stability stable
     */
    constructor(value: any, options?: IntrinsicProps);
    /**
     * Produce the Token's value at resolution time.
     *
     * @stability stable
     */
    resolve(_context: IResolveContext): any;
    /**
     * Convert an instance of this Token to a string.
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     *
     * @stability stable
     */
    toString(): string;
    /**
     * Turn this Token into JSON.
     *
     * Called automatically when JSON.stringify() is called on a Token.
     *
     * @stability stable
     */
    toJSON(): any;
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     *
     * @param message Error message.
     * @stability stable
     */
    protected newError(message: string): any;
}
