# AUTOGENERATED! DO NOT EDIT! File to edit: 00_DataFrameLoader.ipynb (unless otherwise specified).

__all__ = ['DataFrameLoader']

# Cell
# hide
import pandas as pd
from sklearn.model_selection import train_test_split

# Cell

class DataFrameLoader:
    """
    Represent DataFrameLoader class

    Attributes:
    X_full: full dataframe load from raw input
    X_test_full: full test dataframe load from raw input
    X: features
    y: target
    """

    def __init__(self):
        self.X_full = None
        self.X_test_full = None
        self.X = None
        self.y = None
        self.X_train = None
        self.X_valid = None
        self.X_test = None
        self.y_train = None
        self.y_valid = None
        self.categorical_cols = None
        self.numerical_cols = None
        self.low_card_cat_cols = None
        self.high_card_cat_cols = None
        self.final_cols = None
        self.cv_cols = None
        self.X_cv = None
        self.X_test_cv = None

    def __str__(self):
        """Returns human readable string reprsentation"""
        return "DataFrameLoader object with attributes: X_full, X_test, X(features), y(target), X_train, X_valid, y_train and y_valid"

    def __repr__(self):
        return self.__str__()

#     def __lt__(self):
#         """returns: boolean"""
#         return True

    # load data from csv
    def read_csv(self,train_file_path:str,test_file_path:str, idx_col:str):
        # Read the csv files using pandas
        self.X_full = pd.read_csv(train_file_path, index_col=idx_col)
        self.X_test_full = pd.read_csv(test_file_path, index_col=idx_col)
        return self

    # prepare X and y
    def prepare_X_y(self,input_df:object, target:str):
        # Remove rows with missing target
        self.X = input_df.dropna(axis=0, subset=[target])
        # separate target from predictors
        self.y = self.X[target]
        # drop target
        self.X = input_df.drop([target], axis=1)
        return self

    # split X and y into X_train, y_train, X_valid & y_valid dataframes
    def prepare_train_valid(self,X:object,y:object, valid_size:float, random_state=42):
        self.X_train, self.X_valid, self.y_train, self.y_valid = train_test_split(
            self.X, self.y, train_size=(1-valid_size), test_size=valid_size,
            random_state=random_state)

    # select categorical columns
    def select_categorical_cols(self):
        # for low cardinality columns
        self.low_card_cat_cols = [cname for cname in self.X.columns if
                    self.X[cname].nunique() < 10 and
                    self.X[cname].dtype == "object"]
        # for high cardinality columns
        self.high_card_cat_cols = [cname for cname in self.X.columns if
                    self.X[cname].nunique() > 10 and
                    self.X[cname].dtype == "object"]

    # select numerical columns
    def select_numerical_cols(self):
        self.numerical_cols = [cname for cname in self.X.columns if
                self.X[cname].dtype in ['int64', 'float64']]

    # prepare final columns by data type
    def prepare_final_cols(self):
        self.select_categorical_cols()
        self.select_numerical_cols()
        self.categorical_cols = self.low_card_cat_cols + self.high_card_cat_cols
        self.final_cols = (self.low_card_cat_cols
                           + self.high_card_cat_cols
                           + self.numerical_cols)

        # prepare X_train, X_valid from selected columns
    def prepare_X_cv_X_test_cv(self):
        self.X_cv = self.X[self.cv_cols].copy()
        self.X_test_cv = self.X_test_full[self.cv_cols].copy()
        # ideally clean up all dataframes except these ones
        # del self.X, del self.X_test

    # prepare X_train, X_valid from selected columns
    def prepare_X_train_X_valid_X_test(self):
        self.X_train = self.X_train[self.final_cols].copy()
        self.X_valid = self.X_valid[self.final_cols].copy()
        self.X_test = self.X_test_full[self.final_cols].copy()
        # ideally clean up all dataframes except these ones
        # del self.X_train, del self.X_valid, del self.X_test_full

    # get train and valid dataframe
    def from_csv(self, train_file_path:str,test_file_path:str, idx_col:str, target:str,
                 random_state=42, valid_size:float=None, cv_cols_type:str=None):
        self.read_csv(train_file_path,test_file_path, idx_col)
        self.prepare_X_y(self.X_full, target)
        self.prepare_final_cols()
        if valid_size:
            self.prepare_train_valid(self.X,self.y, valid_size, random_state)
            self.prepare_X_train_X_valid_X_test()
        if cv_cols_type:
            if cv_cols_type == "all":
                # assign all final columns to dataframeloader cross_validations columns
                self.cv_cols = self.final_cols

            elif cv_cols_type == "num":
                # assign all numerical columns to cross_validations columns
                self.cv_cols = self.numerical_cols

            elif cv_cols_type == "cat":
                # assign all categorical columns to cross_validations columns
                self.cv_cols = (self.low_card_cat_cols +
                                self.high_card_cat_cols)
            else:
                raise ValueError("Bad cv_cols_type! Only 'num','cat','all' are allowed!")

            # now prepare X_cv, y_cv, X_test
            self.prepare_X_cv_X_test_cv()

        return self