# AUTOGENERATED! DO NOT EDIT! File to edit: 04_metric.ipynb (unless otherwise specified).

__all__ = ['min_max_norm', 'plot_metric', 'calm', 'engagement', 'engagement_1', 'concentration', 'fatigue', 'fatigue_1',
           'calc_band_metrics']

# Cell
from cognify import dataset, spectra
import mne
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

# Cell
def min_max_norm(x, window_length=None):
    return (x - x.min()) / (x.max() - x.min())

# Cell
def plot_metric(metric, title=None):
    ig, ax = plt.subplots(1, 1, figsize=(12, 4))
    plt.plot(metric, lw=1.5, color='k')
    plt.xlabel('Epochs')
    plt.title(title)

# Cell
def calm(alpha): return alpha

# Cell
def engagement(beta, alpha, theta): return beta/(alpha+theta)

# Cell
def engagement_1(theta, alpha): return theta/alpha

# Cell
def concentration(beta, theta): return beta/theta

# Cell
def fatigue(theta, alpha, beta): return (theta+alpha)/beta

# Cell
def fatigue_1(alpha, theta): return alpha/theta

# Cell
def calc_band_metrics(epochs, bands, norm=True, method='welch', window_sec=None):

    e_powers = spectra.calc_epoch_bands(epochs, bands, method=method, window_sec=window_sec)
    avg_powers = np.array([p.mean(axis=1) for p in e_powers.T])

    delta, theta, alpha, beta, gamma = avg_powers
    metrics = dict(
        calm=calm(alpha),
        engagement=engagement(beta, alpha, theta),
        concentration=concentration(beta, theta),
        fatigue=fatigue_1(alpha, theta))

    if norm:
        return {k:min_max_norm(m) for k,m in metrics.items()}
    else: return metrics