# AUTOGENERATED! DO NOT EDIT! File to edit: 09_heartrate.ipynb (unless otherwise specified).

__all__ = ['get_hr_timestamps', 'get_hr']

# Cell
import datetime as dt
import time
import matplotlib
import matplotlib.pyplot as plt
import pandas as pd
import numpy as np
import mne
import yasa
import heartpy as hp

from cognify import muse



# Cell
def get_hr_timestamps(start_time,segment_length,segment_overlap,periods):
    offset =  np.round_(segment_length/2,decimals=3)
    begin_timestamp = start_time + pd.Timedelta(str(offset)+"s")
    step = np.round_((1-segment_overlap)*segment_length,decimals=3)
    hr_timestamps = pd.date_range(start=begin_timestamp, periods=periods,freq=str(step)+'S')
    return hr_timestamps

# Cell
def get_hr(metricId, segment_width = 60, segment_overlap = 0.9,sample_rate=64):
    ppg = muse.get_ppg(metricId)
    df_ppg = muse.ppg_to_df(ppg)
    infrared = df_ppg.to_numpy()[:,1].astype(float)

    filtered = hp.filter_signal(infrared, [0.7, 3.5], sample_rate=sample_rate,
                            order=3, filtertype='bandpass')
    working_data, measures = hp.process_segmentwise(filtered, sample_rate=sample_rate, segment_width = segment_width, segment_overlap = segment_overlap)

    duration = df_ppg.index[-1]-df_ppg.index[0]
    periods = len(measures['bpm'])
    hr_timestamps = get_hr_timestamps(start_time=df_ppg.index[0],segment_length=segment_width,segment_overlap=segment_overlap,periods=periods)
    pd_hr = pd.DataFrame(data={'timestamps':hr_timestamps,'HR':measures['bpm']})
    pd_hr['timestamps'] = (pd_hr['timestamps'] - dt.datetime(1970,1,1)).dt.total_seconds()

    return pd_hr
