# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['cp2k_output_tools',
 'cp2k_output_tools.blocks',
 'cp2k_output_tools.scripts',
 'cp2k_output_tools.trajectories']

package_data = \
{'': ['*']}

install_requires = \
['click>=8.0.1,<9.0.0', 'numpy>=1.19,<2.0', 'regex>=2021.4,<2022.0']

extras_require = \
{':python_version >= "3.6" and python_version < "3.7"': ['dataclasses>=0.7,<1'],
 'yaml': ['ruamel.yaml>=0.16.5,<0.18.0']}

entry_points = \
{'console_scripts': ['cp2k_bs2csv = '
                     'cp2k_output_tools.scripts.bandstructure:cp2k_bs2csv',
                     'cp2k_pdos = cp2k_output_tools.scripts.pdos:cp2k_pdos',
                     'cp2kparse = cp2k_output_tools.cli:cp2kparse',
                     'xyz_restart_cleaner = '
                     'cp2k_output_tools.trajectories.xyz_cli:xyz_restart_cleaner']}

setup_kwargs = {
    'name': 'cp2k-output-tools',
    'version': '0.4.0',
    'description': 'Python tools to handle CP2K output files',
    'long_description': '# cp2k-output-tools\n\n[![Build Status](https://github.com/cp2k/cp2k-output-tools/actions/workflows/test.yml/badge.svg)](https://github.com/cp2k/cp2k-output-tools/actions) [![codecov](https://codecov.io/gh/cp2k/cp2k-output-tools/branch/develop/graph/badge.svg)](https://codecov.io/gh/cp2k/cp2k-output-tools) [![PyPI](https://img.shields.io/pypi/pyversions/cp2k-output-tools)](https://pypi.org/project/cp2k-output-tools/)\n\nModular CP2K output file parsers, mostly in the form of regular expressions plus other tools to mangle various CP2K output:\n\n  * `cp2kparse` ... parse CP2K output (for restart & input files look at the [cp2k-input-tools](https://github.com/cp2k/cp2k-input-tools) project) and allow easy selection of common values.\n  * `xyz_restart_parser` ... when restarts occur during an MD you may end up with duplicated frames in the trajectory, this tool filters them (and can easily handle huge files)\n  * `cp2k_bs2csv` ... convert a CP2K band structure file to multiple (one-per-set) CSV files for easier plotting. There is also an API available if you need to import bandstructure data into your application.\n  * `cp2k_pdos` ... apply a convolution with Gaussians on a regular grid on the CP2K PDOS output and generate a CSV file for further processing or plotting. The same grid is used for all input files with the min/max of the grid automatically determined, but no summation of the different projections is done.\n\n## Requirements\n\n* Python 3.6+\n* regex 2021+\n* click 8+\n* numpy 1.19+\n* optional: ruamel.yaml\n\nFor development: https://poetry.eustace.io/ https://pytest.org/\n\n\n## Usage: cp2kparse\n\nThere is a simple command-line interface `cp2kparse`:\n\n```console\n$ cp2kparse --help\nUsage: cp2kparse [OPTIONS] [FILE|-]\n\n  Parse the CP2K output FILE and return a structured output\n\nOptions:\n  -f, --format [json|yaml|highlight]\n                                  Output format (json or yaml are structure\n                                  formats, highlight shows which lines of the\n                                  output have been matched)\n  --color [auto|always]           When to colorize output\n  -s, --safe-keys                 generate \'safe\' key names (e.g. without\n                                  spaces, dashes, ..)\n  -S, --statistics                print some statistics to stderr\n  -k, --key <PATH>                Path, ex.: \'energies/total force_eval\'\n  --help                          Show this message and exit.\n\n$ cp2kparse calc.out\n{\n  "cp2k": {\n    "cp2kflags: libint fftw3 libxc xsmm spglib": " ",\n    "data directory path": "/data/tiziano/cp2k/data",\n    "input file name": "Si-supercell-001.inp",\n    "is freely available from": "https://www.cp2k.org/",\n    "program compiled at": "Mon Sep 16 14:42:43 CEST 2019",\n    "program compiled for": "local",\n    "program compiled on": "tcpc18",\n    "source code revision number": "git:43f50e2",\n    "version string": "CP2K version 7.0 (Development Version)"\n  },\n  "dbcsr": {\n    "cpu multiplication driver": "XSMM",\n    "maximum elements for images": "UNLIMITED",\n    "multiplication size stacks": 3,\n    "multiplication stack size": 1000,\n    "multiplicative factor virtual images": 1,\n    "multrec recursion limit": 512,\n    "use multiplication densification": true\n  },\n  "energies": {\n    "total force_eval": -251.6873903110507\n  },\n  "global": {\n    "all-to-all communication in single precision": false,\n    "basis set file name": "BASIS_MOLOPT",\n    "coordinate file name": "__STD_INPUT__",\n    "cpu model name": "Intel(R) Core(TM) i7-4790 CPU @ 3.60GHz",\n    "cpuid": 1002,\n    "ffts using library dependent lengths": false,\n    "force environment number": 1,\n    "global print level": "MEDIUM",\n    "method name": "CP2K",\n    "mm potential file name": "MM_POTENTIAL",\n    "mpi i/o enabled": true,\n    "number of threads for this process": 1,\n    "potential file name": "POTENTIAL",\n    "preferred diagonalization lib.": "SL",\n    "preferred fft library": "FFTW3",\n    "project name": "Si-supercell-001",\n    "run type": "ENERGY_FORCE",\n    "this output is from process": 0,\n    "total number of message passing processes": 1\n  },\n  "mulliken population analysis": {\n    "per atom": [\n      {\n        "charge": 7e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999993\n      },\n      {\n        "charge": 0.0,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.0\n      },\n      {\n        "charge": -0.0,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.0\n      },\n      {\n        "charge": -1e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000001\n      },\n      {\n        "charge": -0.0,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.0\n      },\n      {\n        "charge": -1e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000001\n      },\n      {\n        "charge": -1e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000001\n      },\n      {\n        "charge": -0.0,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.0\n      },\n      {\n        "charge": 0.000137,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999863\n      },\n      {\n        "charge": -2e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00002\n      },\n      {\n        "charge": -0.000133,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000133\n      },\n      {\n        "charge": 2.1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999979\n      },\n      {\n        "charge": -0.000133,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000133\n      },\n      {\n        "charge": 2.1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999979\n      },\n      {\n        "charge": 0.000137,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999863\n      },\n      {\n        "charge": -2e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00002\n      },\n      {\n        "charge": -3.9e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000039\n      },\n      {\n        "charge": 3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999964\n      },\n      {\n        "charge": -1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00001\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": -3.9e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000039\n      },\n      {\n        "charge": 3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999964\n      },\n      {\n        "charge": -1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00001\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": -3.9e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000039\n      },\n      {\n        "charge": 3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999964\n      },\n      {\n        "charge": -3.9e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000039\n      },\n      {\n        "charge": 3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999964\n      },\n      {\n        "charge": -1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00001\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": -1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.00001\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": 6e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999994\n      },\n      {\n        "charge": 3.5e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999965\n      },\n      {\n        "charge": 3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999967\n      },\n      {\n        "charge": 9e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999991\n      },\n      {\n        "charge": 3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999967\n      },\n      {\n        "charge": 9e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999991\n      },\n      {\n        "charge": 3e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999997\n      },\n      {\n        "charge": -0.000312,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000312\n      },\n      {\n        "charge": 3e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999997\n      },\n      {\n        "charge": -0.000311,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000311\n      },\n      {\n        "charge": 3.4e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999966\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": 3.4e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999966\n      },\n      {\n        "charge": 1e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.99999\n      },\n      {\n        "charge": 6e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999994\n      },\n      {\n        "charge": 3.5e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999965\n      },\n      {\n        "charge": -9e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000009\n      },\n      {\n        "charge": -3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000033\n      },\n      {\n        "charge": 0.000308,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999692\n      },\n      {\n        "charge": -4e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000004\n      },\n      {\n        "charge": -3.6e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000036\n      },\n      {\n        "charge": -7e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000007\n      },\n      {\n        "charge": -9e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000009\n      },\n      {\n        "charge": -3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000033\n      },\n      {\n        "charge": -8e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000008\n      },\n      {\n        "charge": -3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000033\n      },\n      {\n        "charge": -3.5e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000035\n      },\n      {\n        "charge": -6e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000006\n      },\n      {\n        "charge": 0.000308,\n        "element": "Si",\n        "kind": 1,\n        "population": 3.999692\n      },\n      {\n        "charge": -4e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000004\n      },\n      {\n        "charge": -8e-06,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000008\n      },\n      {\n        "charge": -3.3e-05,\n        "element": "Si",\n        "kind": 1,\n        "population": 4.000033\n      }\n    ],\n    "total": {\n      "charge": 0.0,\n      "population": 256.0\n    }\n  },\n  "program info": {\n    "ended at": "2019-09-17 17:02:35.738",\n    "process id": "23773",\n    "ran by": "tiziano",\n    "ran on": "tcpc18",\n    "started at": "2019-09-17 17:01:19.273",\n    "started by": "tiziano",\n    "started in": "/users/tiziano/work/phonopy/example/Si-CP2K",\n    "started on": "tcpc18",\n    "stopped in": "/users/tiziano/work/phonopy/example/Si-CP2K"\n  }\n}\n```\n\nand an API:\n\n```python\nfrom cp2k_output_tools import parse_iter\n\nwith open("calc.out", "r") as fhandle:\n    for match in parse_iter(fhandle.read()):\n        print(match.values)\n```\n\n## Usage: xyz_restart_cleaner\n\n```console\n$ xyz_restart_cleaner orig_trajectory.xyz new_trajectory.xyz\nfound restart point @1, dropping 1 frames, flushing 1\nflushing remaining 2 frames\n```\n\n## Usage: cp2k_bs2csv\n\nGiven a `.bs` file as written by CP2K the script will generate CSV files with the same name and suffixes `.set-X.csv` in the same directory as the source file:\n\n```console\n$ cp2k_bs2csv WO3.bs\nwriting point set WO3.bs.set-1.csv (total number of k-points: 11)\nwith the following special points:\n     GAMMA: 0.00000000 / 0.00000000 / 0.00000000\n         X: 0.00000000 / 0.50000000 / 0.00000000\nwriting point set WO3.bs.set-2.csv (total number of k-points: 11)\nwith the following special points:\n         X: 0.00000000 / 0.50000000 / 0.00000000\n         M: 0.50000000 / 0.50000000 / 0.00000000\nwriting point set WO3.bsset-3.csv (total number of k-points: 11)\nwith the following special points:\n         M: 0.50000000 / 0.50000000 / 0.00000000\n     GAMMA: 0.00000000 / 0.00000000 / 0.00000000\nwriting point set WO3.bs.set-4.csv (total number of k-points: 11)\nwith the following special points:\n     GAMMA: 0.00000000 / 0.00000000 / 0.00000000\n         R: 0.50000000 / 0.50000000 / 0.50000000\nwriting point set WO3.bs.set-5.csv (total number of k-points: 11)\nwith the following special points:\n         R: 0.50000000 / 0.50000000 / 0.50000000\n         X: 0.00000000 / 0.50000000 / 0.00000000\nwriting point set WO3.bs.set-6.csv (total number of k-points: 11)\nwith the following special points:\n         R: 0.50000000 / 0.50000000 / 0.50000000\n         M: 0.50000000 / 0.50000000 / 0.00000000\n$ ls\nWO3.cp2k-8.bs            WO3.cp2k-8.bs.set-2.csv  WO3.cp2k-8.bs.set-4.csv  WO3.cp2k-8.bs.set-6.csv\nWO3.cp2k-8.bs.set-1.csv  WO3.cp2k-8.bs.set-3.csv  WO3.cp2k-8.bs.set-5.csv\n```\n\n## Development\n\n```console\n$ poetry install\n$ poetry run pytest -v\n```\n',
    'author': 'Tiziano Müller',
    'author_email': 'tiziano.mueller@chem.uzh.ch',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/cp2k/cp2k-output-tools',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
