"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnJob = exports.SchedulePauseStatus = exports.toJson_TaskPythonWheelTask = exports.toJson_TaskPipelineTask = exports.toJson_TaskSparkSubmitTask = exports.toJson_TaskSparkPythonTask = exports.toJson_TaskSparkJarTask = exports.toJson_TaskNotebookTask = exports.toJson_AccessUser = exports.CfnJobPropsFormat = exports.toJson_Schedule = exports.toJson_EmailNotifications = exports.toJson_Task = exports.toJson_CfnJobProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnJobProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnJobProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Tags': obj.tags,
        'Tasks': obj.tasks?.map(y => toJson_Task(y)),
        'EmailNotifications': toJson_EmailNotifications(obj.emailNotifications),
        'TimeoutSeconds': obj.timeoutSeconds,
        'Schedule': toJson_Schedule(obj.schedule),
        'MaxConcurrentRuns': obj.maxConcurrentRuns,
        'Format': obj.format,
        'AccessControlList': obj.accessControlList?.map(y => toJson_AccessUser(y)),
        'ExistingClusterId': obj.existingClusterId,
        'RunAsOwner': obj.runAsOwner,
        'Settings': obj.settings,
        'RunAsUserName': obj.runAsUserName,
        'CreatorUserName': obj.creatorUserName,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnJobProps = toJson_CfnJobProps;
/**
 * Converts an object of type 'Task' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Task(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'TaskKey': obj.taskKey,
        'Description': obj.description,
        'DependsOn': obj.dependsOn?.map(y => y),
        'ExistingClusterId': obj.existingClusterId,
        'NotebookTask': toJson_TaskNotebookTask(obj.notebookTask),
        'SparkJarTask': toJson_TaskSparkJarTask(obj.sparkJarTask),
        'SparkPythonTask': toJson_TaskSparkPythonTask(obj.sparkPythonTask),
        'SparkSubmitTask': toJson_TaskSparkSubmitTask(obj.sparkSubmitTask),
        'PipelineTask': toJson_TaskPipelineTask(obj.pipelineTask),
        'PythonWheelTask': toJson_TaskPythonWheelTask(obj.pythonWheelTask),
        'Libraries': obj.libraries?.map(y => y),
        'EmailNotifications': toJson_EmailNotifications(obj.emailNotifications),
        'TimeoutSeconds': obj.timeoutSeconds,
        'MaxRetries': obj.maxRetries,
        'MinRetryIntervalMillies': obj.minRetryIntervalMillies,
        'RetryOnTimeout': obj.retryOnTimeout,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Task = toJson_Task;
/**
 * Converts an object of type 'EmailNotifications' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_EmailNotifications(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'OnStart': obj.onStart?.map(y => y),
        'OnSuccess': obj.onSuccess?.map(y => y),
        'OnFailure': obj.onFailure?.map(y => y),
        'NoAlertForSkippedRuns': obj.noAlertForSkippedRuns,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_EmailNotifications = toJson_EmailNotifications;
/**
 * Converts an object of type 'Schedule' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Schedule(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'QuartzCronExpression': obj.quartzCronExpression,
        'TimezoneId': obj.timezoneId,
        'PauseStatus': obj.pauseStatus,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Schedule = toJson_Schedule;
/* eslint-enable max-len, quote-props */
/**
 * Used to tell what is the format of the job. This field is ignored in Create/Update/Reset calls. When using the Jobs API 2.1 this value is always set to "MULTI_TASK".
 *
 * @schema CfnJobPropsFormat
 */
var CfnJobPropsFormat;
(function (CfnJobPropsFormat) {
    /** SINGLE_TASK */
    CfnJobPropsFormat["SINGLE_TASK"] = "SINGLE_TASK";
    /** MULTI_TASK */
    CfnJobPropsFormat["MULTI_TASK"] = "MULTI_TASK";
})(CfnJobPropsFormat = exports.CfnJobPropsFormat || (exports.CfnJobPropsFormat = {}));
/**
 * Converts an object of type 'AccessUser' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AccessUser(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'UserName': obj.userName,
        'PermissionLevel': obj.permissionLevel,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AccessUser = toJson_AccessUser;
/**
 * Converts an object of type 'TaskNotebookTask' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TaskNotebookTask(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'NotebookPath': obj.notebookPath,
        'BaseParameters': obj.baseParameters,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TaskNotebookTask = toJson_TaskNotebookTask;
/**
 * Converts an object of type 'TaskSparkJarTask' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TaskSparkJarTask(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'MainClassName': obj.mainClassName,
        'Parameters': obj.parameters,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TaskSparkJarTask = toJson_TaskSparkJarTask;
/**
 * Converts an object of type 'TaskSparkPythonTask' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TaskSparkPythonTask(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'PythonFile': obj.pythonFile,
        'Parameters': obj.parameters,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TaskSparkPythonTask = toJson_TaskSparkPythonTask;
/**
 * Converts an object of type 'TaskSparkSubmitTask' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TaskSparkSubmitTask(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Parameters': obj.parameters,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TaskSparkSubmitTask = toJson_TaskSparkSubmitTask;
/**
 * Converts an object of type 'TaskPipelineTask' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TaskPipelineTask(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'PipelineId': obj.pipelineId,
        'FullRefresh': obj.fullRefresh,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TaskPipelineTask = toJson_TaskPipelineTask;
/**
 * Converts an object of type 'TaskPythonWheelTask' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TaskPythonWheelTask(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'PackageName': obj.packageName,
        'EntryPoint': obj.entryPoint,
        'Parameters': obj.parameters?.map(y => y),
        'NamedParameters': obj.namedParameters,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TaskPythonWheelTask = toJson_TaskPythonWheelTask;
/* eslint-enable max-len, quote-props */
/**
 * Indicate whether this schedule is paused or not.
 *
 * @schema SchedulePauseStatus
 */
var SchedulePauseStatus;
(function (SchedulePauseStatus) {
    /** PAUSED */
    SchedulePauseStatus["PAUSED"] = "PAUSED";
    /** UNPAUSED */
    SchedulePauseStatus["UNPAUSED"] = "UNPAUSED";
})(SchedulePauseStatus = exports.SchedulePauseStatus || (exports.SchedulePauseStatus = {}));
/**
 * A CloudFormation `Databricks::Clusters::Job`
 *
 * @cloudformationResource Databricks::Clusters::Job
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
 */
class CfnJob extends cdk.CfnResource {
    /**
     * Create a new `Databricks::Clusters::Job`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnJob.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnJobProps(props) });
        this.props = props;
        this.attrJobId = cdk.Token.asNumber(this.getAtt('JobId'));
        this.attrCreatedTime = cdk.Token.asNumber(this.getAtt('CreatedTime'));
    }
}
exports.CfnJob = CfnJob;
_a = JSII_RTTI_SYMBOL_1;
CfnJob[_a] = { fqn: "@cdk-cloudformation/databricks-clusters-job.CfnJob", version: "1.0.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnJob.CFN_RESOURCE_TYPE_NAME = "Databricks::Clusters::Job";
//# sourceMappingURL=data:application/json;base64,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