import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage Jobs running on a cluster
 *
 * @schema CfnJobProps
 */
export interface CfnJobProps {
    /**
     * An optional name for the job.
     *
     * @schema CfnJobProps#Name
     */
    readonly name?: string;
    /**
     * A map of tags associated with the job. These are forwarded to the cluster as cluster tags for jobs clusters, and are subject to the same limitations as cluster tags. A maximum of 25 tags can be added to the job.
     *
     * @schema CfnJobProps#Tags
     */
    readonly tags?: any;
    /**
     * A list of task specifications to be executed by this job.
     *
     * @schema CfnJobProps#Tasks
     */
    readonly tasks?: Task[];
    /**
     * @schema CfnJobProps#EmailNotifications
     */
    readonly emailNotifications?: EmailNotifications;
    /**
     * An optional timeout applied to each run of this job. The default behavior is to have no timeout.
     *
     * @schema CfnJobProps#TimeoutSeconds
     */
    readonly timeoutSeconds?: number;
    /**
     * @schema CfnJobProps#Schedule
     */
    readonly schedule?: Schedule;
    /**
     * An optional maximum allowed number of concurrent runs of the job.
     *
     * Set this value if you want to be able to execute multiple runs of the same job concurrently. This is useful for example if you trigger your job on a frequent schedule and want to allow consecutive runs to overlap with each other, or if you want to trigger multiple runs which differ by their input parameters.
     *
     * This setting affects only new runs. For example, suppose the job's concurrency is 4 and there are 4 concurrent active runs. Then setting the concurrency to 3 won't kill any of the active runs. However, from then on, new runs are skipped unless there are fewer than 3 active runs.
     *
     * This value cannot exceed 1000. Setting this value to 0 causes all new runs to be skipped. The default behavior is to allow only 1 concurrent run.
     *
     * @schema CfnJobProps#MaxConcurrentRuns
     */
    readonly maxConcurrentRuns?: number;
    /**
     * Used to tell what is the format of the job. This field is ignored in Create/Update/Reset calls. When using the Jobs API 2.1 this value is always set to "MULTI_TASK".
     *
     * @schema CfnJobProps#Format
     */
    readonly format?: CfnJobPropsFormat;
    /**
     * List of permissions to set on the job.
     *
     * @schema CfnJobProps#AccessControlList
     */
    readonly accessControlList?: AccessUser[];
    /**
     * If existing_cluster_id, the ID of an existing cluster that is used for all runs of this task. When running tasks on an existing cluster, you may need to manually restart the cluster if it stops responding. We suggest running jobs on new clusters for greater reliability.
     *
     * @schema CfnJobProps#ExistingClusterId
     */
    readonly existingClusterId?: string;
    /**
     * @schema CfnJobProps#RunAsOwner
     */
    readonly runAsOwner?: boolean;
    /**
     * @schema CfnJobProps#Settings
     */
    readonly settings?: any;
    /**
     * @schema CfnJobProps#RunAsUserName
     */
    readonly runAsUserName?: string;
    /**
     * @schema CfnJobProps#CreatorUserName
     */
    readonly creatorUserName?: string;
}
/**
 * Converts an object of type 'CfnJobProps' to JSON representation.
 */
export declare function toJson_CfnJobProps(obj: CfnJobProps | undefined): Record<string, any> | undefined;
/**
 * @schema Task
 */
export interface Task {
    /**
     * A unique name for the task. This field is used to refer to this task from other tasks. This field is required and must be unique within its parent job. On Update or Reset, this field is used to reference the tasks to be updated or reset. The maximum length is 100 characters.
     *
     * @schema Task#TaskKey
     */
    readonly taskKey: string;
    /**
     * An optional description for this task. The maximum length is 4096 bytes.
     *
     * @schema Task#Description
     */
    readonly description?: string;
    /**
     * An optional array of objects specifying the dependency graph of the task. All tasks specified in this field must complete successfully before executing this task. The key is task_key, and the value is the name assigned to the dependent task. This field is required when a job consists of more than one task.
     *
     * @schema Task#DependsOn
     */
    readonly dependsOn?: string[];
    /**
     * If existing_cluster_id, the ID of an existing cluster that is used for all runs of this task. When running tasks on an existing cluster, you may need to manually restart the cluster if it stops responding. We suggest running jobs on new clusters for greater reliability.
     *
     * @schema Task#ExistingClusterId
     */
    readonly existingClusterId?: string;
    /**
     * @schema Task#NotebookTask
     */
    readonly notebookTask?: TaskNotebookTask;
    /**
     * @schema Task#SparkJarTask
     */
    readonly sparkJarTask?: TaskSparkJarTask;
    /**
     * @schema Task#SparkPythonTask
     */
    readonly sparkPythonTask?: TaskSparkPythonTask;
    /**
     * @schema Task#SparkSubmitTask
     */
    readonly sparkSubmitTask?: TaskSparkSubmitTask;
    /**
     * @schema Task#PipelineTask
     */
    readonly pipelineTask?: TaskPipelineTask;
    /**
     * @schema Task#PythonWheelTask
     */
    readonly pythonWheelTask?: TaskPythonWheelTask;
    /**
     * An optional list of libraries to be installed on the cluster that executes the task. The default value is an empty list.
     *
     * @schema Task#Libraries
     */
    readonly libraries?: any[];
    /**
     * @schema Task#EmailNotifications
     */
    readonly emailNotifications?: EmailNotifications;
    /**
     * An optional timeout applied to each run of this job task. The default behavior is to have no timeout.
     *
     * @schema Task#TimeoutSeconds
     */
    readonly timeoutSeconds?: number;
    /**
     * An optional maximum number of times to retry an unsuccessful run. A run is considered to be unsuccessful if it completes with the FAILED result_state or INTERNAL_ERROR life_cycle_state. The value -1 means to retry indefinitely and the value 0 means to never retry. The default behavior is to never retry.
     *
     * @schema Task#MaxRetries
     */
    readonly maxRetries?: number;
    /**
     * An optional minimal interval in milliseconds between the start of the failed run and the subsequent retry run. The default behavior is that unsuccessful runs are immediately retried.
     *
     * @schema Task#MinRetryIntervalMillies
     */
    readonly minRetryIntervalMillies?: number;
    /**
     * An optional policy to specify whether to retry a task when it times out. The default behavior is to not retry on timeout.
     *
     * @schema Task#RetryOnTimeout
     */
    readonly retryOnTimeout?: boolean;
}
/**
 * Converts an object of type 'Task' to JSON representation.
 */
export declare function toJson_Task(obj: Task | undefined): Record<string, any> | undefined;
/**
 * @schema EmailNotifications
 */
export interface EmailNotifications {
    /**
     * A list of email addresses to be notified when a run begins. If not specified on job creation, reset, or update, the list is empty, and notifications are not sent.
     *
     * @schema EmailNotifications#OnStart
     */
    readonly onStart?: string[];
    /**
     * A list of email addresses to be notified when a run successfully completes. A run is considered to have completed successfully if it ends with a TERMINATED life_cycle_state and a SUCCESSFUL result_state. If not specified on job creation, reset, or update, the list is empty, and notifications are not sent.
     *
     * @schema EmailNotifications#OnSuccess
     */
    readonly onSuccess?: string[];
    /**
     * A list of email addresses to be notified when a run unsuccessfully completes. A run is considered to have completed unsuccessfully if it ends with an INTERNAL_ERROR life_cycle_state or a SKIPPED, FAILED, or TIMED_OUT result_state. If this is not specified on job creation, reset, or update the list is empty, and notifications are not sent.
     *
     * @schema EmailNotifications#OnFailure
     */
    readonly onFailure?: string[];
    /**
     * If true, do not send email to recipients specified in on_failure if the run is skipped.
     *
     * @schema EmailNotifications#NoAlertForSkippedRuns
     */
    readonly noAlertForSkippedRuns?: boolean;
}
/**
 * Converts an object of type 'EmailNotifications' to JSON representation.
 */
export declare function toJson_EmailNotifications(obj: EmailNotifications | undefined): Record<string, any> | undefined;
/**
 * @schema Schedule
 */
export interface Schedule {
    /**
     * A Cron expression using Quartz syntax that describes the schedule for a job. See Cron Trigger for details. This field is required.
     *
     *
     *
     * @schema Schedule#QuartzCronExpression
     */
    readonly quartzCronExpression?: string;
    /**
     * A Java timezone ID. The schedule for a job is resolved with respect to this timezone. See Java TimeZone for details. This field is required.
     *
     *
     *
     * @schema Schedule#TimezoneId
     */
    readonly timezoneId?: string;
    /**
     * Indicate whether this schedule is paused or not.
     *
     * @schema Schedule#PauseStatus
     */
    readonly pauseStatus?: SchedulePauseStatus;
}
/**
 * Converts an object of type 'Schedule' to JSON representation.
 */
export declare function toJson_Schedule(obj: Schedule | undefined): Record<string, any> | undefined;
/**
 * Used to tell what is the format of the job. This field is ignored in Create/Update/Reset calls. When using the Jobs API 2.1 this value is always set to "MULTI_TASK".
 *
 * @schema CfnJobPropsFormat
 */
export declare enum CfnJobPropsFormat {
    /** SINGLE_TASK */
    SINGLE_TASK = "SINGLE_TASK",
    /** MULTI_TASK */
    MULTI_TASK = "MULTI_TASK"
}
/**
 * @schema AccessUser
 */
export interface AccessUser {
    /**
     * @schema AccessUser#UserName
     */
    readonly userName?: string;
    /**
     * @schema AccessUser#PermissionLevel
     */
    readonly permissionLevel?: string;
}
/**
 * Converts an object of type 'AccessUser' to JSON representation.
 */
export declare function toJson_AccessUser(obj: AccessUser | undefined): Record<string, any> | undefined;
/**
 * @schema TaskNotebookTask
 */
export interface TaskNotebookTask {
    /**
     * The path of the notebook to be run in the Databricks workspace or remote repository. For notebooks stored in the Databricks workspace, the path must be absolute and begin with a slash. For notebooks stored in a remote repository, the path must be relative. This field is required.
     *
     * @schema TaskNotebookTask#NotebookPath
     */
    readonly notebookPath: string;
    /**
     * Base parameters to be used for each run of this job. If the run is initiated by a call to run-now with parameters specified, the two parameters maps are merged. If the same key is specified in base_parameters and in run-now, the value from run-now is used.
     *
     * Use Task parameter variables to set parameters containing information about job runs.
     *
     * If the notebook takes a parameter that is not specified in the job's base_parameters or the run-now override parameters, the default value from the notebook is used
     *
     * @schema TaskNotebookTask#BaseParameters
     */
    readonly baseParameters?: any;
}
/**
 * Converts an object of type 'TaskNotebookTask' to JSON representation.
 */
export declare function toJson_TaskNotebookTask(obj: TaskNotebookTask | undefined): Record<string, any> | undefined;
/**
 * @schema TaskSparkJarTask
 */
export interface TaskSparkJarTask {
    /**
     * The full name of the class containing the main method to be executed. This class must be contained in a JAR provided as a library.
     *
     * @schema TaskSparkJarTask#MainClassName
     */
    readonly mainClassName: string;
    /**
     * Parameters passed to the main method.
     *
     * Use Task parameter variables to set parameters containing information about job runs.
     *
     * @schema TaskSparkJarTask#Parameters
     */
    readonly parameters?: any;
}
/**
 * Converts an object of type 'TaskSparkJarTask' to JSON representation.
 */
export declare function toJson_TaskSparkJarTask(obj: TaskSparkJarTask | undefined): Record<string, any> | undefined;
/**
 * @schema TaskSparkPythonTask
 */
export interface TaskSparkPythonTask {
    /**
     * The URI of the Python file to be executed. DBFS and S3 paths are supported. This field is required.
     *
     * @schema TaskSparkPythonTask#PythonFile
     */
    readonly pythonFile: string;
    /**
     * Command line parameters passed to the Python file.
     *
     * Use Task parameter variables to set parameters containing information about job runs.
     *
     * @schema TaskSparkPythonTask#Parameters
     */
    readonly parameters?: any;
}
/**
 * Converts an object of type 'TaskSparkPythonTask' to JSON representation.
 */
export declare function toJson_TaskSparkPythonTask(obj: TaskSparkPythonTask | undefined): Record<string, any> | undefined;
/**
 * @schema TaskSparkSubmitTask
 */
export interface TaskSparkSubmitTask {
    /**
     * Command-line parameters passed to spark submit.
     *
     * Use Task parameter variables to set parameters containing information about job runs.
     *
     * @schema TaskSparkSubmitTask#Parameters
     */
    readonly parameters?: any;
}
/**
 * Converts an object of type 'TaskSparkSubmitTask' to JSON representation.
 */
export declare function toJson_TaskSparkSubmitTask(obj: TaskSparkSubmitTask | undefined): Record<string, any> | undefined;
/**
 * @schema TaskPipelineTask
 */
export interface TaskPipelineTask {
    /**
     * The full name of the pipeline task to execute.
     *
     * @schema TaskPipelineTask#PipelineId
     */
    readonly pipelineId: string;
    /**
     * If true, a full refresh will be triggered on the delta live table.
     *
     * @schema TaskPipelineTask#FullRefresh
     */
    readonly fullRefresh?: boolean;
}
/**
 * Converts an object of type 'TaskPipelineTask' to JSON representation.
 */
export declare function toJson_TaskPipelineTask(obj: TaskPipelineTask | undefined): Record<string, any> | undefined;
/**
 * @schema TaskPythonWheelTask
 */
export interface TaskPythonWheelTask {
    /**
     * Name of the package to execute
     *
     * @schema TaskPythonWheelTask#PackageName
     */
    readonly packageName: string;
    /**
     * Named entry point to use, if it does not exist in the metadata of the package it executes the function from the package directly using $packageName.$entryPoint()
     *
     * @schema TaskPythonWheelTask#EntryPoint
     */
    readonly entryPoint?: string;
    /**
     * Command-line parameters passed to Python wheel task. Leave it empty if named_parameters is not null.
     *
     * @schema TaskPythonWheelTask#Parameters
     */
    readonly parameters?: string[];
    /**
     * Command-line parameters passed to Python wheel task in the form of ["--name=task", "--data=dbfs:/path/to/data.json"]. Leave it empty if parameters is not null
     *
     * @schema TaskPythonWheelTask#NamedParameters
     */
    readonly namedParameters?: any;
}
/**
 * Converts an object of type 'TaskPythonWheelTask' to JSON representation.
 */
export declare function toJson_TaskPythonWheelTask(obj: TaskPythonWheelTask | undefined): Record<string, any> | undefined;
/**
 * Indicate whether this schedule is paused or not.
 *
 * @schema SchedulePauseStatus
 */
export declare enum SchedulePauseStatus {
    /** PAUSED */
    PAUSED = "PAUSED",
    /** UNPAUSED */
    UNPAUSED = "UNPAUSED"
}
/**
 * A CloudFormation `Databricks::Clusters::Job`
 *
 * @cloudformationResource Databricks::Clusters::Job
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
 */
export declare class CfnJob extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Databricks::Clusters::Job";
    /**
     * Resource props.
     */
    readonly props: CfnJobProps;
    /**
     * Attribute `Databricks::Clusters::Job.JobId`
     * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
     */
    readonly attrJobId: number;
    /**
     * Attribute `Databricks::Clusters::Job.CreatedTime`
     * @link https://github.com/aws-ia/cloudformation-databricks-resource-providers.git
     */
    readonly attrCreatedTime: number;
    /**
     * Create a new `Databricks::Clusters::Job`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnJobProps);
}
