# Onestation 0.1.0
<p align="center">
   <img src="http://img.shields.io/static/v1?label=STATUS&message=EM%20DESENVOLVIMENTO&color=RED&style=for-the-badge" #vitrinedev/>
</p>
<p align="center">
    Pre-processing data from conventional weather stations
</p>
                             
<hr>

## Topics

- [Project description](#project-description)

- [Functionalities](#functionalities)

- [Application](#application)

- [Tools used](#tools-used)

- [Project access](#project-access)

- [Install and run the package](#install-and-run-the-package)

- [Developer](#developer)

## Project description
<p align="justify">
The project under development is a library/package in Python with the purpose of pre-processing conventional weather station data. One station is a Python package that has the main objective of helping developers or professionals who seek to treat and clean weather station data and apply it to a Machine Learning model aimed exclusively at precision irrigation.
<p align="justify">   
The package is available on [Pypisistema](https://pypi.org/project/onestation/) it will allow the daily, continuous and remote pre-processing of the collections carried out by conventional meteorological stations, allowing professionals and developers to apply them in their work in a fast and applied way.

## Application
 
![Onestation project description](https://user-images.githubusercontent.com/91737931/205759438-31590caa-2b14-4d01-9322-8964f96ea821.png)
</p>
<p align="justify">
Understand data pre-processing concepts and techniques used to transform raw data into an applicable format. Visit the link and learn more https://brain-mentors.com/concepts-of-data-pre-processing.
<p align="justify">
☑️Note: This work is being finalized and will facilitate the process of processing data from conventional meteorological stations and can also be applied or converted to automatic meteorological stations.

## Functionalities

:heavy_check_mark: `Functionalities 1:` Perform data cleaning.

:heavy_check_mark: `Functionalities 2:` Perform data transformation.

:heavy_check_mark: `Functionalities 3:` Apply data reduction.

###

## Tools used

<a href="https://www.python.org/" target="_blank"> <img src="https://user-images.githubusercontent.com/91737931/205761808-6584fc52-0494-41dd-ae16-8e303a314a6a.png" alt="Python" width="40" height="40"/> </a> 
<a href="https://www.jetbrains.com/pt-br/" target="_blank"> <img src="https://user-images.githubusercontent.com/91737931/205761156-27834c97-a75d-4c7a-89fe-7549f0fcc219.png" alt="Pycharm" width="40" height="40"/> </a> 
<a href="https://firebase.google.com/?hl=pt" target="_blank"> <img src="https://www.gstatic.com/mobilesdk/160503_mobilesdk/logo/2x/firebase_96dp.png" alt="firebase" width="40" height="40"/> </a>

###

## Project access

You may [access the project source code](https://github.com/rps-ifpr/station_data) or access the project on PyPi at the link https://pypi.org/project/onestation/  

## Install and run the package

To install the package you must use `Pycharm or Jupyter Notebook`. For this, you must have the latest version of Python installed on your machine:

### User installation
   
The easiest way to install `onestation` is with `pip`
   
`pip install onestation` 
   
#### If you are having difficulty installing the correct package versions, you can set up a virtual environment like this:
  
   1- pip install virtualenv
   
   2- virtualenv env
   
   3- source env/bin/activate
   
   4- curl https://bootstrap.pypa.io/get-pip.py | python3
   
   5- pip install onestation
   
   6- pip install ipykernel
   
   7- ipython kernel install --user --name=env
   
   8- jupyter notebook
   
   9- When finished, deactivate your virtualenv with deactivate 
   
### Use

For a complete tutorial on how the package is used in Jupyter notebooks, see our Jupyter notebook demo https://colab.research.google.com/github/IRkernel/IRkernel/blob/master/example-notebooks/Demo.ipynb
 
For more information about the database used in the tests and to be able to download the dataset, see the link: https://www.kaggle.com/datasets/rogerioifpr/brazil-weather-conventional-stations-19612019
   
### Help and Support
   
For help with using or installing the package, contact Rogerio Pereira do Santos <rogerio.dosantos@ifpr.edu.br>
   
## Developer
[<img src="https://user-images.githubusercontent.com/91737931/205754797-e4247c7e-ba75-43a4-bde0-94b13fb8392e.jpg" width=115><br><sub>Rogério Santos</sub>](https://github.com/rps-ifpr) 
