# Generated by Django 2.1.12 on 2020-01-21 12:27

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Collection',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('orig_filename', models.CharField(blank=True, max_length=255)),
                ('indexed', models.BooleanField(default=False)),
                ('pubinfo', models.CharField(blank=True, max_length=400)),
                ('author', models.CharField(blank=True, max_length=255)),
                ('orig_id', models.PositiveIntegerField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TempEntityClass',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, max_length=255)),
                ('review', models.BooleanField(default=False, help_text='Should be set to True, if the data record holds up quality standards.')),
                ('start_date', models.DateField(blank=True, null=True)),
                ('start_start_date', models.DateField(blank=True, null=True)),
                ('start_end_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('end_start_date', models.DateField(blank=True, null=True)),
                ('end_end_date', models.DateField(blank=True, null=True)),
                ('start_date_written', models.CharField(blank=True, max_length=255, null=True, verbose_name='Start')),
                ('end_date_written', models.CharField(blank=True, max_length=255, null=True, verbose_name='End')),
                ('status', models.CharField(max_length=100)),
                ('references', models.TextField(blank=True, null=True)),
                ('notes', models.TextField(blank=True, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Text',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='Uri',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uri', models.URLField(blank=True, max_length=255, null=True, unique=True)),
                ('domain', models.CharField(blank=True, max_length=255)),
                ('rdf_link', models.URLField(blank=True)),
                ('loaded', models.BooleanField(default=False)),
                ('loaded_time', models.DateTimeField(blank=True, null=True)),
                ('entity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='apis_metainfo.TempEntityClass')),
            ],
        ),
        migrations.CreateModel(
            name='UriCandidate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uri', models.URLField()),
                ('confidence', models.FloatField(blank=True, null=True)),
                ('responsible', models.CharField(max_length=255)),
                ('entity', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='apis_metainfo.TempEntityClass')),
            ],
        ),
    ]
