"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The action to invoke an AWS Lambda function, passing in an MQTT message.
 */
class LambdaFunctionAction {
    /**
     * @param func The lambda function to be invoked by this action
     */
    constructor(func) {
        this.func = func;
    }
    bind(topicRule) {
        this.func.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(topicRule.node)}:IotLambdaFunctionAction`, {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceAccount: topicRule.env.account,
            sourceArn: topicRule.topicRuleArn,
        });
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaFunctionAction = LambdaFunctionAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.LambdaFunctionAction", version: "2.18.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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