# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_ecs20140526 import models as ecs_20140526_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-hangzhou': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shanghai-finance-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shenzhen-finance-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-north-2-gov-1': 'ecs.aliyuncs.com',
            'ap-northeast-2-pop': 'ecs.aliyuncs.com',
            'cn-beijing-finance-pop': 'ecs.aliyuncs.com',
            'cn-beijing-gov-1': 'ecs.aliyuncs.com',
            'cn-beijing-nu16-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-edge-1': 'ecs.cn-qingdao-nebula.aliyuncs.com',
            'cn-fujian': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-haidian-cm12-c01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-bj-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-finance': 'ecs.aliyuncs.com',
            'cn-hangzhou-internal-prod-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-internal-test-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-internal-test-2': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-internal-test-3': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-test-306': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hongkong-finance-pop': 'ecs.aliyuncs.com',
            'cn-huhehaote-nebula-1': 'ecs.cn-qingdao-nebula.aliyuncs.com',
            'cn-shanghai-et15-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shanghai-et2-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shanghai-inner': 'ecs.aliyuncs.com',
            'cn-shanghai-internal-test-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shenzhen-inner': 'ecs.aliyuncs.com',
            'cn-shenzhen-st4-d01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shenzhen-su18-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-wuhan': 'ecs.aliyuncs.com',
            'cn-yushanfang': 'ecs.aliyuncs.com',
            'cn-zhangbei': 'ecs.aliyuncs.com',
            'cn-zhangbei-na61-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-zhangjiakou-na62-a01': 'ecs.cn-zhangjiakou.aliyuncs.com',
            'cn-zhengzhou-nebula-1': 'ecs.cn-qingdao-nebula.aliyuncs.com',
            'eu-west-1-oxs': 'ecs.cn-shenzhen-cloudstone.aliyuncs.com',
            'rus-west-1-pop': 'ecs.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('ecs', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def accept_inquired_system_event_with_options(
        self,
        request: ecs_20140526_models.AcceptInquiredSystemEventRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AcceptInquiredSystemEventResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.choice):
            query['Choice'] = request.choice
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AcceptInquiredSystemEvent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AcceptInquiredSystemEventResponse(),
            self.call_api(params, req, runtime)
        )

    async def accept_inquired_system_event_with_options_async(
        self,
        request: ecs_20140526_models.AcceptInquiredSystemEventRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AcceptInquiredSystemEventResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.choice):
            query['Choice'] = request.choice
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AcceptInquiredSystemEvent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AcceptInquiredSystemEventResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def accept_inquired_system_event(
        self,
        request: ecs_20140526_models.AcceptInquiredSystemEventRequest,
    ) -> ecs_20140526_models.AcceptInquiredSystemEventResponse:
        runtime = util_models.RuntimeOptions()
        return self.accept_inquired_system_event_with_options(request, runtime)

    async def accept_inquired_system_event_async(
        self,
        request: ecs_20140526_models.AcceptInquiredSystemEventRequest,
    ) -> ecs_20140526_models.AcceptInquiredSystemEventResponse:
        runtime = util_models.RuntimeOptions()
        return await self.accept_inquired_system_event_with_options_async(request, runtime)

    def activate_router_interface_with_options(
        self,
        request: ecs_20140526_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ActivateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: ActivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActivateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ActivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def activate_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ActivateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: ActivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActivateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ActivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def activate_router_interface(
        self,
        request: ecs_20140526_models.ActivateRouterInterfaceRequest,
    ) -> ecs_20140526_models.ActivateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: ActivateRouterInterfaceRequest
        @return: ActivateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.activate_router_interface_with_options(request, runtime)

    async def activate_router_interface_async(
        self,
        request: ecs_20140526_models.ActivateRouterInterfaceRequest,
    ) -> ecs_20140526_models.ActivateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: ActivateRouterInterfaceRequest
        @return: ActivateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.activate_router_interface_with_options_async(request, runtime)

    def add_bandwidth_package_ips_with_options(
        self,
        request: ecs_20140526_models.AddBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AddBandwidthPackageIpsResponse:
        """
        @deprecated
        
        @param request: AddBandwidthPackageIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBandwidthPackageIpsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_count):
            query['IpCount'] = request.ip_count
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBandwidthPackageIps',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AddBandwidthPackageIpsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_bandwidth_package_ips_with_options_async(
        self,
        request: ecs_20140526_models.AddBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AddBandwidthPackageIpsResponse:
        """
        @deprecated
        
        @param request: AddBandwidthPackageIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBandwidthPackageIpsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_count):
            query['IpCount'] = request.ip_count
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBandwidthPackageIps',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AddBandwidthPackageIpsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_bandwidth_package_ips(
        self,
        request: ecs_20140526_models.AddBandwidthPackageIpsRequest,
    ) -> ecs_20140526_models.AddBandwidthPackageIpsResponse:
        """
        @deprecated
        
        @param request: AddBandwidthPackageIpsRequest
        @return: AddBandwidthPackageIpsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.add_bandwidth_package_ips_with_options(request, runtime)

    async def add_bandwidth_package_ips_async(
        self,
        request: ecs_20140526_models.AddBandwidthPackageIpsRequest,
    ) -> ecs_20140526_models.AddBandwidthPackageIpsResponse:
        """
        @deprecated
        
        @param request: AddBandwidthPackageIpsRequest
        @return: AddBandwidthPackageIpsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_bandwidth_package_ips_with_options_async(request, runtime)

    def add_tags_with_options(
        self,
        request: ecs_20140526_models.AddTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AddTagsResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   Up to 20 tags can be bound to each ECS resource.
        *   The tag key (`Tag.N.Key`) must match the tag value (`Tag.N.Value`).
        *   If the tag key (`Tag.N.Key`) already exists on the specified resource, the new tag value (`Tag.N.Value`) automatically overwrites the original one.
        
        @param request: AddTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTags',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AddTagsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_tags_with_options_async(
        self,
        request: ecs_20140526_models.AddTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AddTagsResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   Up to 20 tags can be bound to each ECS resource.
        *   The tag key (`Tag.N.Key`) must match the tag value (`Tag.N.Value`).
        *   If the tag key (`Tag.N.Key`) already exists on the specified resource, the new tag value (`Tag.N.Value`) automatically overwrites the original one.
        
        @param request: AddTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTagsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTags',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AddTagsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_tags(
        self,
        request: ecs_20140526_models.AddTagsRequest,
    ) -> ecs_20140526_models.AddTagsResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   Up to 20 tags can be bound to each ECS resource.
        *   The tag key (`Tag.N.Key`) must match the tag value (`Tag.N.Value`).
        *   If the tag key (`Tag.N.Key`) already exists on the specified resource, the new tag value (`Tag.N.Value`) automatically overwrites the original one.
        
        @param request: AddTagsRequest
        @return: AddTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_tags_with_options(request, runtime)

    async def add_tags_async(
        self,
        request: ecs_20140526_models.AddTagsRequest,
    ) -> ecs_20140526_models.AddTagsResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   Up to 20 tags can be bound to each ECS resource.
        *   The tag key (`Tag.N.Key`) must match the tag value (`Tag.N.Value`).
        *   If the tag key (`Tag.N.Key`) already exists on the specified resource, the new tag value (`Tag.N.Value`) automatically overwrites the original one.
        
        @param request: AddTagsRequest
        @return: AddTagsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_tags_with_options_async(request, runtime)

    def allocate_dedicated_hosts_with_options(
        self,
        request: ecs_20140526_models.AllocateDedicatedHostsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocateDedicatedHostsResponse:
        """
        Before you create a dedicated host, you can call the [DescribeAvailableResource](~~66186~~) operation to query the available resources in a specific region or zone.
        We recommend that you understand the billing methods of resources before you create a dedicated host. You are charged for resources used by the created dedicated host. For more information, see [Billing overview](~~68978~~).
        * You can create up to 100 pay-as-you-go or subscription dedicated hosts at a time.
        * After a dedicated host is created, you can use its ID that is returned by the system as the value of a request parameter to call the [DescribeDedicatedHosts](~~134242~~) operation to query the state of the dedicated host.
        * After you submit a request to create a dedicated host, an error is returned if a specific parameter is invalid or the requested resources are insufficient. For more information about error reasons, see the "Error codes" section in this topic.
        * After a dedicated host is created, you can call the [ModifyInstanceDeployment](~~134248~~) operation to migrate ECS instances from a shared host to the dedicated host. You can also migrate ECS instances from another dedicated host to the created dedicated host.
        
        @param request: AllocateDedicatedHostsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateDedicatedHostsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.action_on_maintenance):
            query['ActionOnMaintenance'] = request.action_on_maintenance
        if not UtilClient.is_unset(request.auto_placement):
            query['AutoPlacement'] = request.auto_placement
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cpu_over_commit_ratio):
            query['CpuOverCommitRatio'] = request.cpu_over_commit_ratio
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.dedicated_host_name):
            query['DedicatedHostName'] = request.dedicated_host_name
        if not UtilClient.is_unset(request.dedicated_host_type):
            query['DedicatedHostType'] = request.dedicated_host_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.min_quantity):
            query['MinQuantity'] = request.min_quantity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.quantity):
            query['Quantity'] = request.quantity
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.network_attributes):
            query['NetworkAttributes'] = request.network_attributes
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateDedicatedHosts',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocateDedicatedHostsResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_dedicated_hosts_with_options_async(
        self,
        request: ecs_20140526_models.AllocateDedicatedHostsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocateDedicatedHostsResponse:
        """
        Before you create a dedicated host, you can call the [DescribeAvailableResource](~~66186~~) operation to query the available resources in a specific region or zone.
        We recommend that you understand the billing methods of resources before you create a dedicated host. You are charged for resources used by the created dedicated host. For more information, see [Billing overview](~~68978~~).
        * You can create up to 100 pay-as-you-go or subscription dedicated hosts at a time.
        * After a dedicated host is created, you can use its ID that is returned by the system as the value of a request parameter to call the [DescribeDedicatedHosts](~~134242~~) operation to query the state of the dedicated host.
        * After you submit a request to create a dedicated host, an error is returned if a specific parameter is invalid or the requested resources are insufficient. For more information about error reasons, see the "Error codes" section in this topic.
        * After a dedicated host is created, you can call the [ModifyInstanceDeployment](~~134248~~) operation to migrate ECS instances from a shared host to the dedicated host. You can also migrate ECS instances from another dedicated host to the created dedicated host.
        
        @param request: AllocateDedicatedHostsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateDedicatedHostsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.action_on_maintenance):
            query['ActionOnMaintenance'] = request.action_on_maintenance
        if not UtilClient.is_unset(request.auto_placement):
            query['AutoPlacement'] = request.auto_placement
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cpu_over_commit_ratio):
            query['CpuOverCommitRatio'] = request.cpu_over_commit_ratio
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.dedicated_host_name):
            query['DedicatedHostName'] = request.dedicated_host_name
        if not UtilClient.is_unset(request.dedicated_host_type):
            query['DedicatedHostType'] = request.dedicated_host_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.min_quantity):
            query['MinQuantity'] = request.min_quantity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.quantity):
            query['Quantity'] = request.quantity
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.network_attributes):
            query['NetworkAttributes'] = request.network_attributes
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateDedicatedHosts',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocateDedicatedHostsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_dedicated_hosts(
        self,
        request: ecs_20140526_models.AllocateDedicatedHostsRequest,
    ) -> ecs_20140526_models.AllocateDedicatedHostsResponse:
        """
        Before you create a dedicated host, you can call the [DescribeAvailableResource](~~66186~~) operation to query the available resources in a specific region or zone.
        We recommend that you understand the billing methods of resources before you create a dedicated host. You are charged for resources used by the created dedicated host. For more information, see [Billing overview](~~68978~~).
        * You can create up to 100 pay-as-you-go or subscription dedicated hosts at a time.
        * After a dedicated host is created, you can use its ID that is returned by the system as the value of a request parameter to call the [DescribeDedicatedHosts](~~134242~~) operation to query the state of the dedicated host.
        * After you submit a request to create a dedicated host, an error is returned if a specific parameter is invalid or the requested resources are insufficient. For more information about error reasons, see the "Error codes" section in this topic.
        * After a dedicated host is created, you can call the [ModifyInstanceDeployment](~~134248~~) operation to migrate ECS instances from a shared host to the dedicated host. You can also migrate ECS instances from another dedicated host to the created dedicated host.
        
        @param request: AllocateDedicatedHostsRequest
        @return: AllocateDedicatedHostsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_dedicated_hosts_with_options(request, runtime)

    async def allocate_dedicated_hosts_async(
        self,
        request: ecs_20140526_models.AllocateDedicatedHostsRequest,
    ) -> ecs_20140526_models.AllocateDedicatedHostsResponse:
        """
        Before you create a dedicated host, you can call the [DescribeAvailableResource](~~66186~~) operation to query the available resources in a specific region or zone.
        We recommend that you understand the billing methods of resources before you create a dedicated host. You are charged for resources used by the created dedicated host. For more information, see [Billing overview](~~68978~~).
        * You can create up to 100 pay-as-you-go or subscription dedicated hosts at a time.
        * After a dedicated host is created, you can use its ID that is returned by the system as the value of a request parameter to call the [DescribeDedicatedHosts](~~134242~~) operation to query the state of the dedicated host.
        * After you submit a request to create a dedicated host, an error is returned if a specific parameter is invalid or the requested resources are insufficient. For more information about error reasons, see the "Error codes" section in this topic.
        * After a dedicated host is created, you can call the [ModifyInstanceDeployment](~~134248~~) operation to migrate ECS instances from a shared host to the dedicated host. You can also migrate ECS instances from another dedicated host to the created dedicated host.
        
        @param request: AllocateDedicatedHostsRequest
        @return: AllocateDedicatedHostsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_dedicated_hosts_with_options_async(request, runtime)

    def allocate_eip_address_with_options(
        self,
        request: ecs_20140526_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocateEipAddressResponse:
        """
        @deprecated
        
        @param request: AllocateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateEipAddressResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activity_id):
            query['ActivityId'] = request.activity_id
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_address_with_options_async(
        self,
        request: ecs_20140526_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocateEipAddressResponse:
        """
        @deprecated
        
        @param request: AllocateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateEipAddressResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activity_id):
            query['ActivityId'] = request.activity_id
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_address(
        self,
        request: ecs_20140526_models.AllocateEipAddressRequest,
    ) -> ecs_20140526_models.AllocateEipAddressResponse:
        """
        @deprecated
        
        @param request: AllocateEipAddressRequest
        @return: AllocateEipAddressResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_address_with_options(request, runtime)

    async def allocate_eip_address_async(
        self,
        request: ecs_20140526_models.AllocateEipAddressRequest,
    ) -> ecs_20140526_models.AllocateEipAddressResponse:
        """
        @deprecated
        
        @param request: AllocateEipAddressRequest
        @return: AllocateEipAddressResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_address_with_options_async(request, runtime)

    def allocate_public_ip_address_with_options(
        self,
        request: ecs_20140526_models.AllocatePublicIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocatePublicIpAddressResponse:
        """
        When you call this operation, take note of the following items:
        *   The instance to which to assign a public IP address must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If `OperationLocks` in the DescribeInstances response contains `"LockReason" : "security"` for an instance, the instance is [locked for security reasons](~~25695~~) and cannot be assigned a public IP address.
        *   You can assign only a single public IP address to an instance. If the instance already has a public IP address, the `AllocatedAlready` error code is returned.
        *   After you assign a public IP address to an instance, you must restart the instance ([RebootInstance](~~25502~~)) or start the instance ([StartInstance](~~25500~~)) for the public IP address to take effect.
        If an instance is located in a virtual private cloud (VPC), you can assign a public IP address to the instance or associate an elastic IP address (EIP) with the instance. For more information, see [AssociateEipAddress](~~36017~~).
        > After an EIP is associated with an instance located in a VPC, no public IP addresses can be assigned to the instance.
        
        @param request: AllocatePublicIpAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocatePublicIpAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocatePublicIpAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocatePublicIpAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_public_ip_address_with_options_async(
        self,
        request: ecs_20140526_models.AllocatePublicIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocatePublicIpAddressResponse:
        """
        When you call this operation, take note of the following items:
        *   The instance to which to assign a public IP address must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If `OperationLocks` in the DescribeInstances response contains `"LockReason" : "security"` for an instance, the instance is [locked for security reasons](~~25695~~) and cannot be assigned a public IP address.
        *   You can assign only a single public IP address to an instance. If the instance already has a public IP address, the `AllocatedAlready` error code is returned.
        *   After you assign a public IP address to an instance, you must restart the instance ([RebootInstance](~~25502~~)) or start the instance ([StartInstance](~~25500~~)) for the public IP address to take effect.
        If an instance is located in a virtual private cloud (VPC), you can assign a public IP address to the instance or associate an elastic IP address (EIP) with the instance. For more information, see [AssociateEipAddress](~~36017~~).
        > After an EIP is associated with an instance located in a VPC, no public IP addresses can be assigned to the instance.
        
        @param request: AllocatePublicIpAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocatePublicIpAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocatePublicIpAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocatePublicIpAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_public_ip_address(
        self,
        request: ecs_20140526_models.AllocatePublicIpAddressRequest,
    ) -> ecs_20140526_models.AllocatePublicIpAddressResponse:
        """
        When you call this operation, take note of the following items:
        *   The instance to which to assign a public IP address must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If `OperationLocks` in the DescribeInstances response contains `"LockReason" : "security"` for an instance, the instance is [locked for security reasons](~~25695~~) and cannot be assigned a public IP address.
        *   You can assign only a single public IP address to an instance. If the instance already has a public IP address, the `AllocatedAlready` error code is returned.
        *   After you assign a public IP address to an instance, you must restart the instance ([RebootInstance](~~25502~~)) or start the instance ([StartInstance](~~25500~~)) for the public IP address to take effect.
        If an instance is located in a virtual private cloud (VPC), you can assign a public IP address to the instance or associate an elastic IP address (EIP) with the instance. For more information, see [AssociateEipAddress](~~36017~~).
        > After an EIP is associated with an instance located in a VPC, no public IP addresses can be assigned to the instance.
        
        @param request: AllocatePublicIpAddressRequest
        @return: AllocatePublicIpAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_public_ip_address_with_options(request, runtime)

    async def allocate_public_ip_address_async(
        self,
        request: ecs_20140526_models.AllocatePublicIpAddressRequest,
    ) -> ecs_20140526_models.AllocatePublicIpAddressResponse:
        """
        When you call this operation, take note of the following items:
        *   The instance to which to assign a public IP address must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If `OperationLocks` in the DescribeInstances response contains `"LockReason" : "security"` for an instance, the instance is [locked for security reasons](~~25695~~) and cannot be assigned a public IP address.
        *   You can assign only a single public IP address to an instance. If the instance already has a public IP address, the `AllocatedAlready` error code is returned.
        *   After you assign a public IP address to an instance, you must restart the instance ([RebootInstance](~~25502~~)) or start the instance ([StartInstance](~~25500~~)) for the public IP address to take effect.
        If an instance is located in a virtual private cloud (VPC), you can assign a public IP address to the instance or associate an elastic IP address (EIP) with the instance. For more information, see [AssociateEipAddress](~~36017~~).
        > After an EIP is associated with an instance located in a VPC, no public IP addresses can be assigned to the instance.
        
        @param request: AllocatePublicIpAddressRequest
        @return: AllocatePublicIpAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_public_ip_address_with_options_async(request, runtime)

    def apply_auto_snapshot_policy_with_options(
        self,
        request: ecs_20140526_models.ApplyAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ApplyAutoSnapshotPolicyResponse:
        """
        Each disk can have only one automatic snapshot policy applied.
        *   A single automatic snapshot policy can be applied to multiple disks.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.disk_ids):
            query['diskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ApplyAutoSnapshotPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def apply_auto_snapshot_policy_with_options_async(
        self,
        request: ecs_20140526_models.ApplyAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ApplyAutoSnapshotPolicyResponse:
        """
        Each disk can have only one automatic snapshot policy applied.
        *   A single automatic snapshot policy can be applied to multiple disks.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.disk_ids):
            query['diskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ApplyAutoSnapshotPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def apply_auto_snapshot_policy(
        self,
        request: ecs_20140526_models.ApplyAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.ApplyAutoSnapshotPolicyResponse:
        """
        Each disk can have only one automatic snapshot policy applied.
        *   A single automatic snapshot policy can be applied to multiple disks.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @return: ApplyAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.apply_auto_snapshot_policy_with_options(request, runtime)

    async def apply_auto_snapshot_policy_async(
        self,
        request: ecs_20140526_models.ApplyAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.ApplyAutoSnapshotPolicyResponse:
        """
        Each disk can have only one automatic snapshot policy applied.
        *   A single automatic snapshot policy can be applied to multiple disks.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @return: ApplyAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.apply_auto_snapshot_policy_with_options_async(request, runtime)

    def assign_ipv_6addresses_with_options(
        self,
        request: ecs_20140526_models.AssignIpv6AddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssignIpv6AddressesResponse:
        """
        You can specify IPv6 addresses that are in the CIDR block of the vSwitch with which the ENI is associated, or specify the number of IPv6 addresses to automatically generate for the ENI. When you call this operation, take note of the following items:
        *   IPv6 must be enabled for the vSwitch with which the ENI is associated. For more information, see [Enable IPv6 for a vSwitch](~~98923~~).
        *   The ENI must be in the Available (Available) or InUse (InUse) state.
        *   If you want to assign IPv6 addresses to a primary ENI, make sure that the instance to which the ENI is attached is in the Running (Running) or Stopped (Stopped) state.
        *   The maximum number of IPv6 addresses that can be assigned to an ENI varies per instance type.
        *   If the ENI is in the Available (Available) state, it can be assigned a maximum of 10 IPv6 addresses.
        *   If the ENI is already attached to an Elastic Compute Service (ECS) instance, the maximum number of IPv6 addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](~~25378~~).
        *   After the operation is called, you can obtain the IPv6 addresses that are assigned to the ENI from the response.
        
        @param request: AssignIpv6AddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignIpv6AddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.ipv_6prefix):
            query['Ipv6Prefix'] = request.ipv_6prefix
        if not UtilClient.is_unset(request.ipv_6prefix_count):
            query['Ipv6PrefixCount'] = request.ipv_6prefix_count
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignIpv6Addresses',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssignIpv6AddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def assign_ipv_6addresses_with_options_async(
        self,
        request: ecs_20140526_models.AssignIpv6AddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssignIpv6AddressesResponse:
        """
        You can specify IPv6 addresses that are in the CIDR block of the vSwitch with which the ENI is associated, or specify the number of IPv6 addresses to automatically generate for the ENI. When you call this operation, take note of the following items:
        *   IPv6 must be enabled for the vSwitch with which the ENI is associated. For more information, see [Enable IPv6 for a vSwitch](~~98923~~).
        *   The ENI must be in the Available (Available) or InUse (InUse) state.
        *   If you want to assign IPv6 addresses to a primary ENI, make sure that the instance to which the ENI is attached is in the Running (Running) or Stopped (Stopped) state.
        *   The maximum number of IPv6 addresses that can be assigned to an ENI varies per instance type.
        *   If the ENI is in the Available (Available) state, it can be assigned a maximum of 10 IPv6 addresses.
        *   If the ENI is already attached to an Elastic Compute Service (ECS) instance, the maximum number of IPv6 addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](~~25378~~).
        *   After the operation is called, you can obtain the IPv6 addresses that are assigned to the ENI from the response.
        
        @param request: AssignIpv6AddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignIpv6AddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.ipv_6prefix):
            query['Ipv6Prefix'] = request.ipv_6prefix
        if not UtilClient.is_unset(request.ipv_6prefix_count):
            query['Ipv6PrefixCount'] = request.ipv_6prefix_count
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignIpv6Addresses',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssignIpv6AddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def assign_ipv_6addresses(
        self,
        request: ecs_20140526_models.AssignIpv6AddressesRequest,
    ) -> ecs_20140526_models.AssignIpv6AddressesResponse:
        """
        You can specify IPv6 addresses that are in the CIDR block of the vSwitch with which the ENI is associated, or specify the number of IPv6 addresses to automatically generate for the ENI. When you call this operation, take note of the following items:
        *   IPv6 must be enabled for the vSwitch with which the ENI is associated. For more information, see [Enable IPv6 for a vSwitch](~~98923~~).
        *   The ENI must be in the Available (Available) or InUse (InUse) state.
        *   If you want to assign IPv6 addresses to a primary ENI, make sure that the instance to which the ENI is attached is in the Running (Running) or Stopped (Stopped) state.
        *   The maximum number of IPv6 addresses that can be assigned to an ENI varies per instance type.
        *   If the ENI is in the Available (Available) state, it can be assigned a maximum of 10 IPv6 addresses.
        *   If the ENI is already attached to an Elastic Compute Service (ECS) instance, the maximum number of IPv6 addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](~~25378~~).
        *   After the operation is called, you can obtain the IPv6 addresses that are assigned to the ENI from the response.
        
        @param request: AssignIpv6AddressesRequest
        @return: AssignIpv6AddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.assign_ipv_6addresses_with_options(request, runtime)

    async def assign_ipv_6addresses_async(
        self,
        request: ecs_20140526_models.AssignIpv6AddressesRequest,
    ) -> ecs_20140526_models.AssignIpv6AddressesResponse:
        """
        You can specify IPv6 addresses that are in the CIDR block of the vSwitch with which the ENI is associated, or specify the number of IPv6 addresses to automatically generate for the ENI. When you call this operation, take note of the following items:
        *   IPv6 must be enabled for the vSwitch with which the ENI is associated. For more information, see [Enable IPv6 for a vSwitch](~~98923~~).
        *   The ENI must be in the Available (Available) or InUse (InUse) state.
        *   If you want to assign IPv6 addresses to a primary ENI, make sure that the instance to which the ENI is attached is in the Running (Running) or Stopped (Stopped) state.
        *   The maximum number of IPv6 addresses that can be assigned to an ENI varies per instance type.
        *   If the ENI is in the Available (Available) state, it can be assigned a maximum of 10 IPv6 addresses.
        *   If the ENI is already attached to an Elastic Compute Service (ECS) instance, the maximum number of IPv6 addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](~~25378~~).
        *   After the operation is called, you can obtain the IPv6 addresses that are assigned to the ENI from the response.
        
        @param request: AssignIpv6AddressesRequest
        @return: AssignIpv6AddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.assign_ipv_6addresses_with_options_async(request, runtime)

    def assign_private_ip_addresses_with_options(
        self,
        request: ecs_20140526_models.AssignPrivateIpAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssignPrivateIpAddressesResponse:
        """
        ## Description
        *   The ENI to which you want to assign secondary private IP addresses must be in the Available (Available) or InUse (InUse) state.
        *   When you assign secondary private IP addresses to a primary ENI, the instance to which the ENI is attached must be in the Running (Running) or Stopped (Stopped) state.
        *   When an ENI is in the Available (Available) state, you can assign up to 50 secondary private IP addresses to it. When an ENI is attached to an instance, the number of secondary private IP addresses that can be assigned to the ENI is subject to the instance type. For more information, see [Instance families](~~25378~~).
        *   After you call this operation for an ENI, you can obtain the secondary private IP addresses that are assigned to the ENI from the response.
        
        @param request: AssignPrivateIpAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignPrivateIpAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_4prefix):
            query['Ipv4Prefix'] = request.ipv_4prefix
        if not UtilClient.is_unset(request.ipv_4prefix_count):
            query['Ipv4PrefixCount'] = request.ipv_4prefix_count
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_private_ip_address_count):
            query['SecondaryPrivateIpAddressCount'] = request.secondary_private_ip_address_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignPrivateIpAddresses',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssignPrivateIpAddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def assign_private_ip_addresses_with_options_async(
        self,
        request: ecs_20140526_models.AssignPrivateIpAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssignPrivateIpAddressesResponse:
        """
        ## Description
        *   The ENI to which you want to assign secondary private IP addresses must be in the Available (Available) or InUse (InUse) state.
        *   When you assign secondary private IP addresses to a primary ENI, the instance to which the ENI is attached must be in the Running (Running) or Stopped (Stopped) state.
        *   When an ENI is in the Available (Available) state, you can assign up to 50 secondary private IP addresses to it. When an ENI is attached to an instance, the number of secondary private IP addresses that can be assigned to the ENI is subject to the instance type. For more information, see [Instance families](~~25378~~).
        *   After you call this operation for an ENI, you can obtain the secondary private IP addresses that are assigned to the ENI from the response.
        
        @param request: AssignPrivateIpAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignPrivateIpAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_4prefix):
            query['Ipv4Prefix'] = request.ipv_4prefix
        if not UtilClient.is_unset(request.ipv_4prefix_count):
            query['Ipv4PrefixCount'] = request.ipv_4prefix_count
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_private_ip_address_count):
            query['SecondaryPrivateIpAddressCount'] = request.secondary_private_ip_address_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignPrivateIpAddresses',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssignPrivateIpAddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def assign_private_ip_addresses(
        self,
        request: ecs_20140526_models.AssignPrivateIpAddressesRequest,
    ) -> ecs_20140526_models.AssignPrivateIpAddressesResponse:
        """
        ## Description
        *   The ENI to which you want to assign secondary private IP addresses must be in the Available (Available) or InUse (InUse) state.
        *   When you assign secondary private IP addresses to a primary ENI, the instance to which the ENI is attached must be in the Running (Running) or Stopped (Stopped) state.
        *   When an ENI is in the Available (Available) state, you can assign up to 50 secondary private IP addresses to it. When an ENI is attached to an instance, the number of secondary private IP addresses that can be assigned to the ENI is subject to the instance type. For more information, see [Instance families](~~25378~~).
        *   After you call this operation for an ENI, you can obtain the secondary private IP addresses that are assigned to the ENI from the response.
        
        @param request: AssignPrivateIpAddressesRequest
        @return: AssignPrivateIpAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.assign_private_ip_addresses_with_options(request, runtime)

    async def assign_private_ip_addresses_async(
        self,
        request: ecs_20140526_models.AssignPrivateIpAddressesRequest,
    ) -> ecs_20140526_models.AssignPrivateIpAddressesResponse:
        """
        ## Description
        *   The ENI to which you want to assign secondary private IP addresses must be in the Available (Available) or InUse (InUse) state.
        *   When you assign secondary private IP addresses to a primary ENI, the instance to which the ENI is attached must be in the Running (Running) or Stopped (Stopped) state.
        *   When an ENI is in the Available (Available) state, you can assign up to 50 secondary private IP addresses to it. When an ENI is attached to an instance, the number of secondary private IP addresses that can be assigned to the ENI is subject to the instance type. For more information, see [Instance families](~~25378~~).
        *   After you call this operation for an ENI, you can obtain the secondary private IP addresses that are assigned to the ENI from the response.
        
        @param request: AssignPrivateIpAddressesRequest
        @return: AssignPrivateIpAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.assign_private_ip_addresses_with_options_async(request, runtime)

    def associate_eip_address_with_options(
        self,
        request: ecs_20140526_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssociateEipAddressResponse:
        """
        @deprecated
        
        @param request: AssociateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEipAddressResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssociateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_eip_address_with_options_async(
        self,
        request: ecs_20140526_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssociateEipAddressResponse:
        """
        @deprecated
        
        @param request: AssociateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEipAddressResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssociateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_eip_address(
        self,
        request: ecs_20140526_models.AssociateEipAddressRequest,
    ) -> ecs_20140526_models.AssociateEipAddressResponse:
        """
        @deprecated
        
        @param request: AssociateEipAddressRequest
        @return: AssociateEipAddressResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_eip_address_with_options(request, runtime)

    async def associate_eip_address_async(
        self,
        request: ecs_20140526_models.AssociateEipAddressRequest,
    ) -> ecs_20140526_models.AssociateEipAddressResponse:
        """
        @deprecated
        
        @param request: AssociateEipAddressRequest
        @return: AssociateEipAddressResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_eip_address_with_options_async(request, runtime)

    def associate_ha_vip_with_options(
        self,
        request: ecs_20140526_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssociateHaVipResponse:
        """
        @deprecated
        
        @param request: AssociateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssociateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_ha_vip_with_options_async(
        self,
        request: ecs_20140526_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssociateHaVipResponse:
        """
        @deprecated
        
        @param request: AssociateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssociateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_ha_vip(
        self,
        request: ecs_20140526_models.AssociateHaVipRequest,
    ) -> ecs_20140526_models.AssociateHaVipResponse:
        """
        @deprecated
        
        @param request: AssociateHaVipRequest
        @return: AssociateHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_ha_vip_with_options(request, runtime)

    async def associate_ha_vip_async(
        self,
        request: ecs_20140526_models.AssociateHaVipRequest,
    ) -> ecs_20140526_models.AssociateHaVipResponse:
        """
        @deprecated
        
        @param request: AssociateHaVipRequest
        @return: AssociateHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_ha_vip_with_options_async(request, runtime)

    def attach_classic_link_vpc_with_options(
        self,
        request: ecs_20140526_models.AttachClassicLinkVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachClassicLinkVpcResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   The instance to be connected must be in the **Running** state or **Stopped** state.
        *   The ClassicLink feature must be enabled for the target VPC. For more information, see [Enable ClassicLink](~~65413~~).
        *   The instance and the VPC must be in the same region.
        
        @param request: AttachClassicLinkVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachClassicLinkVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachClassicLinkVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachClassicLinkVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_classic_link_vpc_with_options_async(
        self,
        request: ecs_20140526_models.AttachClassicLinkVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachClassicLinkVpcResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   The instance to be connected must be in the **Running** state or **Stopped** state.
        *   The ClassicLink feature must be enabled for the target VPC. For more information, see [Enable ClassicLink](~~65413~~).
        *   The instance and the VPC must be in the same region.
        
        @param request: AttachClassicLinkVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachClassicLinkVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachClassicLinkVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachClassicLinkVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_classic_link_vpc(
        self,
        request: ecs_20140526_models.AttachClassicLinkVpcRequest,
    ) -> ecs_20140526_models.AttachClassicLinkVpcResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   The instance to be connected must be in the **Running** state or **Stopped** state.
        *   The ClassicLink feature must be enabled for the target VPC. For more information, see [Enable ClassicLink](~~65413~~).
        *   The instance and the VPC must be in the same region.
        
        @param request: AttachClassicLinkVpcRequest
        @return: AttachClassicLinkVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_classic_link_vpc_with_options(request, runtime)

    async def attach_classic_link_vpc_async(
        self,
        request: ecs_20140526_models.AttachClassicLinkVpcRequest,
    ) -> ecs_20140526_models.AttachClassicLinkVpcResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   The instance to be connected must be in the **Running** state or **Stopped** state.
        *   The ClassicLink feature must be enabled for the target VPC. For more information, see [Enable ClassicLink](~~65413~~).
        *   The instance and the VPC must be in the same region.
        
        @param request: AttachClassicLinkVpcRequest
        @return: AttachClassicLinkVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_classic_link_vpc_with_options_async(request, runtime)

    def attach_disk_with_options(
        self,
        request: ecs_20140526_models.AttachDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachDiskResponse:
        """
        When you call this operation, take note of the following points:
        *   The disk to be attached must be in the **Unattached** (`Available`) state.
        *   When the disk is attached as a data disk, take note of the following items:
        *   The instance must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If the disk was separately purchased, the billing method of the disk must be pay-as-you-go.
        *   If the disk is a system disk detached from an instance, no limits apply to the billing method of the disk.
        *   When the disk is attached as a system disk, take note of the following items:
        *   The instance must be the original instance from which the system disk was detached.
        *   The instance must be in the **Stopped** (`Stopped`) state.
        *   The logon credentials must be configured.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        *   Disks for which the multi-attach feature is enabled can be attached only to instances that support the NVMe protocol. For more information, see [NVMe protocol](~~256487~~) and [Use the multi-attach feature](~~262105~~).
        
        @param request: AttachDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bootable):
            query['Bootable'] = request.bootable
        if not UtilClient.is_unset(request.delete_with_instance):
            query['DeleteWithInstance'] = request.delete_with_instance
        if not UtilClient.is_unset(request.device):
            query['Device'] = request.device
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_disk_with_options_async(
        self,
        request: ecs_20140526_models.AttachDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachDiskResponse:
        """
        When you call this operation, take note of the following points:
        *   The disk to be attached must be in the **Unattached** (`Available`) state.
        *   When the disk is attached as a data disk, take note of the following items:
        *   The instance must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If the disk was separately purchased, the billing method of the disk must be pay-as-you-go.
        *   If the disk is a system disk detached from an instance, no limits apply to the billing method of the disk.
        *   When the disk is attached as a system disk, take note of the following items:
        *   The instance must be the original instance from which the system disk was detached.
        *   The instance must be in the **Stopped** (`Stopped`) state.
        *   The logon credentials must be configured.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        *   Disks for which the multi-attach feature is enabled can be attached only to instances that support the NVMe protocol. For more information, see [NVMe protocol](~~256487~~) and [Use the multi-attach feature](~~262105~~).
        
        @param request: AttachDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bootable):
            query['Bootable'] = request.bootable
        if not UtilClient.is_unset(request.delete_with_instance):
            query['DeleteWithInstance'] = request.delete_with_instance
        if not UtilClient.is_unset(request.device):
            query['Device'] = request.device
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_disk(
        self,
        request: ecs_20140526_models.AttachDiskRequest,
    ) -> ecs_20140526_models.AttachDiskResponse:
        """
        When you call this operation, take note of the following points:
        *   The disk to be attached must be in the **Unattached** (`Available`) state.
        *   When the disk is attached as a data disk, take note of the following items:
        *   The instance must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If the disk was separately purchased, the billing method of the disk must be pay-as-you-go.
        *   If the disk is a system disk detached from an instance, no limits apply to the billing method of the disk.
        *   When the disk is attached as a system disk, take note of the following items:
        *   The instance must be the original instance from which the system disk was detached.
        *   The instance must be in the **Stopped** (`Stopped`) state.
        *   The logon credentials must be configured.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        *   Disks for which the multi-attach feature is enabled can be attached only to instances that support the NVMe protocol. For more information, see [NVMe protocol](~~256487~~) and [Use the multi-attach feature](~~262105~~).
        
        @param request: AttachDiskRequest
        @return: AttachDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_disk_with_options(request, runtime)

    async def attach_disk_async(
        self,
        request: ecs_20140526_models.AttachDiskRequest,
    ) -> ecs_20140526_models.AttachDiskResponse:
        """
        When you call this operation, take note of the following points:
        *   The disk to be attached must be in the **Unattached** (`Available`) state.
        *   When the disk is attached as a data disk, take note of the following items:
        *   The instance must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If the disk was separately purchased, the billing method of the disk must be pay-as-you-go.
        *   If the disk is a system disk detached from an instance, no limits apply to the billing method of the disk.
        *   When the disk is attached as a system disk, take note of the following items:
        *   The instance must be the original instance from which the system disk was detached.
        *   The instance must be in the **Stopped** (`Stopped`) state.
        *   The logon credentials must be configured.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        *   Disks for which the multi-attach feature is enabled can be attached only to instances that support the NVMe protocol. For more information, see [NVMe protocol](~~256487~~) and [Use the multi-attach feature](~~262105~~).
        
        @param request: AttachDiskRequest
        @return: AttachDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_disk_with_options_async(request, runtime)

    def attach_instance_ram_role_with_options(
        self,
        request: ecs_20140526_models.AttachInstanceRamRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachInstanceRamRoleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachInstanceRamRole',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachInstanceRamRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_instance_ram_role_with_options_async(
        self,
        request: ecs_20140526_models.AttachInstanceRamRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachInstanceRamRoleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachInstanceRamRole',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachInstanceRamRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_instance_ram_role(
        self,
        request: ecs_20140526_models.AttachInstanceRamRoleRequest,
    ) -> ecs_20140526_models.AttachInstanceRamRoleResponse:
        runtime = util_models.RuntimeOptions()
        return self.attach_instance_ram_role_with_options(request, runtime)

    async def attach_instance_ram_role_async(
        self,
        request: ecs_20140526_models.AttachInstanceRamRoleRequest,
    ) -> ecs_20140526_models.AttachInstanceRamRoleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.attach_instance_ram_role_with_options_async(request, runtime)

    def attach_key_pair_with_options(
        self,
        request: ecs_20140526_models.AttachKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachKeyPairResponse:
        """
        When you call this operation, take note of the following items:
        *   SSH key pairs are not supported on Windows instances.
        *   If an SSH key pair is attached to an instance, the username and password authentication method is disabled for the instance.
        *   If you attach an SSH key pair to an instance in the **Running** state, you must call the [RebootInstance](~~25502~~) operation to restart the instance for the key pair to take effect.
        *   If you attach an SSH key pair to an instance in the **Stopped** state, you must call the [StartInstance](~~25500~~) operation to start the instance for the key pair to take effect.
        *   If an instance already has an SSH key pair attached, the new SSH key pair will replace the original one.
        
        @param request: AttachKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachKeyPair',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachKeyPairResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_key_pair_with_options_async(
        self,
        request: ecs_20140526_models.AttachKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachKeyPairResponse:
        """
        When you call this operation, take note of the following items:
        *   SSH key pairs are not supported on Windows instances.
        *   If an SSH key pair is attached to an instance, the username and password authentication method is disabled for the instance.
        *   If you attach an SSH key pair to an instance in the **Running** state, you must call the [RebootInstance](~~25502~~) operation to restart the instance for the key pair to take effect.
        *   If you attach an SSH key pair to an instance in the **Stopped** state, you must call the [StartInstance](~~25500~~) operation to start the instance for the key pair to take effect.
        *   If an instance already has an SSH key pair attached, the new SSH key pair will replace the original one.
        
        @param request: AttachKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachKeyPair',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachKeyPairResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_key_pair(
        self,
        request: ecs_20140526_models.AttachKeyPairRequest,
    ) -> ecs_20140526_models.AttachKeyPairResponse:
        """
        When you call this operation, take note of the following items:
        *   SSH key pairs are not supported on Windows instances.
        *   If an SSH key pair is attached to an instance, the username and password authentication method is disabled for the instance.
        *   If you attach an SSH key pair to an instance in the **Running** state, you must call the [RebootInstance](~~25502~~) operation to restart the instance for the key pair to take effect.
        *   If you attach an SSH key pair to an instance in the **Stopped** state, you must call the [StartInstance](~~25500~~) operation to start the instance for the key pair to take effect.
        *   If an instance already has an SSH key pair attached, the new SSH key pair will replace the original one.
        
        @param request: AttachKeyPairRequest
        @return: AttachKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_key_pair_with_options(request, runtime)

    async def attach_key_pair_async(
        self,
        request: ecs_20140526_models.AttachKeyPairRequest,
    ) -> ecs_20140526_models.AttachKeyPairResponse:
        """
        When you call this operation, take note of the following items:
        *   SSH key pairs are not supported on Windows instances.
        *   If an SSH key pair is attached to an instance, the username and password authentication method is disabled for the instance.
        *   If you attach an SSH key pair to an instance in the **Running** state, you must call the [RebootInstance](~~25502~~) operation to restart the instance for the key pair to take effect.
        *   If you attach an SSH key pair to an instance in the **Stopped** state, you must call the [StartInstance](~~25500~~) operation to start the instance for the key pair to take effect.
        *   If an instance already has an SSH key pair attached, the new SSH key pair will replace the original one.
        
        @param request: AttachKeyPairRequest
        @return: AttachKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_key_pair_with_options_async(request, runtime)

    def attach_network_interface_with_options(
        self,
        request: ecs_20140526_models.AttachNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachNetworkInterfaceResponse:
        """
        When you call this operation, take note of the following items:
        *   The ENI must be in the **Available** (`Available`) state. Each ENI can be attached to only a single instance that resides in the same zone and the same VPC as the ENI.
        *   The instance must be in the Running (Running) or Stopped (Stopped) state. When you attach ENIs to instances of some instance types, make sure that the instances are in the Stopped (Stopped) state. For more information, see the "Instance types of the ECS instances that must be in the Stopped (Stopped) state" section in [Bind an ENI](~~58503~~).
        > If the last start time of the instance (including the start time of the instance if it is newly purchased, the last restart time of the instance, and the last reactivation time of the instance) is before April 1, 2018 and the instance stays in the Running state, you must call the RebootInstance operation to restart the instance. If you do not call the RebootInstance operation to restart the instance, the ENI cannot be attached to the instance.
        *   You can attach multiple ENIs to a single instance. For more information, see [ENI overview](~~58496~~).
        *   The vSwitch to which the ENI is connected must be in the same zone and the same VPC as the vSwitch to which the instance is connected.
        *   This operation is an asynchronous operation. After this operation is called to attach an ENI, you can check the status or events of the ENI to determine whether the ENI is attached.
        - If the ENI is in the Attaching state, the ENI attachment request is sent and the ENI is being attached to the specified instance.
        - If the ENI is in the InUse state, the ENI is attached to the specified instance.
        - If the ENI is in the Available state, the ENI fails to be attached.
        **For information about examples on how to call this operation, see** [Attach an ENI](~~471550~~).
        
        @param request: AttachNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_card_index):
            query['NetworkCardIndex'] = request.network_card_index
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trunk_network_instance_id):
            query['TrunkNetworkInstanceId'] = request.trunk_network_instance_id
        if not UtilClient.is_unset(request.wait_for_network_configuration_ready):
            query['WaitForNetworkConfigurationReady'] = request.wait_for_network_configuration_ready
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachNetworkInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_network_interface_with_options_async(
        self,
        request: ecs_20140526_models.AttachNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachNetworkInterfaceResponse:
        """
        When you call this operation, take note of the following items:
        *   The ENI must be in the **Available** (`Available`) state. Each ENI can be attached to only a single instance that resides in the same zone and the same VPC as the ENI.
        *   The instance must be in the Running (Running) or Stopped (Stopped) state. When you attach ENIs to instances of some instance types, make sure that the instances are in the Stopped (Stopped) state. For more information, see the "Instance types of the ECS instances that must be in the Stopped (Stopped) state" section in [Bind an ENI](~~58503~~).
        > If the last start time of the instance (including the start time of the instance if it is newly purchased, the last restart time of the instance, and the last reactivation time of the instance) is before April 1, 2018 and the instance stays in the Running state, you must call the RebootInstance operation to restart the instance. If you do not call the RebootInstance operation to restart the instance, the ENI cannot be attached to the instance.
        *   You can attach multiple ENIs to a single instance. For more information, see [ENI overview](~~58496~~).
        *   The vSwitch to which the ENI is connected must be in the same zone and the same VPC as the vSwitch to which the instance is connected.
        *   This operation is an asynchronous operation. After this operation is called to attach an ENI, you can check the status or events of the ENI to determine whether the ENI is attached.
        - If the ENI is in the Attaching state, the ENI attachment request is sent and the ENI is being attached to the specified instance.
        - If the ENI is in the InUse state, the ENI is attached to the specified instance.
        - If the ENI is in the Available state, the ENI fails to be attached.
        **For information about examples on how to call this operation, see** [Attach an ENI](~~471550~~).
        
        @param request: AttachNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_card_index):
            query['NetworkCardIndex'] = request.network_card_index
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trunk_network_instance_id):
            query['TrunkNetworkInstanceId'] = request.trunk_network_instance_id
        if not UtilClient.is_unset(request.wait_for_network_configuration_ready):
            query['WaitForNetworkConfigurationReady'] = request.wait_for_network_configuration_ready
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachNetworkInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_network_interface(
        self,
        request: ecs_20140526_models.AttachNetworkInterfaceRequest,
    ) -> ecs_20140526_models.AttachNetworkInterfaceResponse:
        """
        When you call this operation, take note of the following items:
        *   The ENI must be in the **Available** (`Available`) state. Each ENI can be attached to only a single instance that resides in the same zone and the same VPC as the ENI.
        *   The instance must be in the Running (Running) or Stopped (Stopped) state. When you attach ENIs to instances of some instance types, make sure that the instances are in the Stopped (Stopped) state. For more information, see the "Instance types of the ECS instances that must be in the Stopped (Stopped) state" section in [Bind an ENI](~~58503~~).
        > If the last start time of the instance (including the start time of the instance if it is newly purchased, the last restart time of the instance, and the last reactivation time of the instance) is before April 1, 2018 and the instance stays in the Running state, you must call the RebootInstance operation to restart the instance. If you do not call the RebootInstance operation to restart the instance, the ENI cannot be attached to the instance.
        *   You can attach multiple ENIs to a single instance. For more information, see [ENI overview](~~58496~~).
        *   The vSwitch to which the ENI is connected must be in the same zone and the same VPC as the vSwitch to which the instance is connected.
        *   This operation is an asynchronous operation. After this operation is called to attach an ENI, you can check the status or events of the ENI to determine whether the ENI is attached.
        - If the ENI is in the Attaching state, the ENI attachment request is sent and the ENI is being attached to the specified instance.
        - If the ENI is in the InUse state, the ENI is attached to the specified instance.
        - If the ENI is in the Available state, the ENI fails to be attached.
        **For information about examples on how to call this operation, see** [Attach an ENI](~~471550~~).
        
        @param request: AttachNetworkInterfaceRequest
        @return: AttachNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_network_interface_with_options(request, runtime)

    async def attach_network_interface_async(
        self,
        request: ecs_20140526_models.AttachNetworkInterfaceRequest,
    ) -> ecs_20140526_models.AttachNetworkInterfaceResponse:
        """
        When you call this operation, take note of the following items:
        *   The ENI must be in the **Available** (`Available`) state. Each ENI can be attached to only a single instance that resides in the same zone and the same VPC as the ENI.
        *   The instance must be in the Running (Running) or Stopped (Stopped) state. When you attach ENIs to instances of some instance types, make sure that the instances are in the Stopped (Stopped) state. For more information, see the "Instance types of the ECS instances that must be in the Stopped (Stopped) state" section in [Bind an ENI](~~58503~~).
        > If the last start time of the instance (including the start time of the instance if it is newly purchased, the last restart time of the instance, and the last reactivation time of the instance) is before April 1, 2018 and the instance stays in the Running state, you must call the RebootInstance operation to restart the instance. If you do not call the RebootInstance operation to restart the instance, the ENI cannot be attached to the instance.
        *   You can attach multiple ENIs to a single instance. For more information, see [ENI overview](~~58496~~).
        *   The vSwitch to which the ENI is connected must be in the same zone and the same VPC as the vSwitch to which the instance is connected.
        *   This operation is an asynchronous operation. After this operation is called to attach an ENI, you can check the status or events of the ENI to determine whether the ENI is attached.
        - If the ENI is in the Attaching state, the ENI attachment request is sent and the ENI is being attached to the specified instance.
        - If the ENI is in the InUse state, the ENI is attached to the specified instance.
        - If the ENI is in the Available state, the ENI fails to be attached.
        **For information about examples on how to call this operation, see** [Attach an ENI](~~471550~~).
        
        @param request: AttachNetworkInterfaceRequest
        @return: AttachNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_network_interface_with_options_async(request, runtime)

    def authorize_security_group_with_options(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupResponse:
        """
        In the security group-related API documents, inbound traffic refers to the traffic sent by the source and received by the destination.
        When you call this operation, take note of the following items:
        - The total number of outbound and inbound rules in each security group cannot exceed 200. For more information, see the "Security group limits" section in [Limits](~~25412#SecurityGroupQuota1~~).
        - The valid value of Priority ranges from 1 to 100. A smaller value indicates a higher priority.
        - When multiple security group rules have the same priority, drop rules take precedence.
        - The source can be a CIDR block specified by SourceCidrIp, Ipv6SourceCidrIp, or SourcePrefixListId or can be Elastic Compute Service (ECS) instances in a security group specified by SourceGroupId.
        - For advanced security groups, security groups cannot be used as authorization objects.
        - For each basic security group, a maximum of 20 security groups can be used as authorization objects.
        - If the specified security group rule already exists, the call to AuthorizeSecurityGroup is successful but no security group rule is created.
        - The `Permissions.N` prefix is added to some parameters to generate new parameters. Original parameters and corresponding parameters prefixed with Permissions.N cannot be specified together. We recommend that you use parameters prefixed with `Permissions.N`.
        - You can determine a security group rule by specifying one of the following groups of parameters. You cannot determine a security group rule by specifying only one parameter.
        - Parameters used to specify an inbound security group rule that controls access from a specific CIDR block: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and SourceCidrIp. For a security group of the Virtual Private Cloud (VPC) type, you must set the NicType parameter to intranet. For a security group of the classic network type, you can set the NicType parameter to either internet or intranet. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourceCidrIp=10.0.0.0/8
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Accept
        &<Common request parameters>
        
        ```
        - Parameters used to specify an inbound security group rule that controls access from a security group: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, SourceGroupOwnerAccount, and SourceGroupId. In this case, you must set the NicType parameter to intranet. For mutual access between security groups in the classic network, you can allow or deny another security group within the same region access to your security group. The security group that is allowed access to your security group can belong to your own Alibaba Cloud account or another Alibaba Cloud account specified by the SourceGroupOwnerAccount parameter. For mutual access between security groups in VPCs, you can allow or deny another security group within the same VPC access to your security group. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourceGroupId=sg-1651FBB**\
        &Permissions.1.SourceGroupOwnerAccount=test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        - Parameters used to specify an inbound security group rule that controls access from a prefix list: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and SourcePrefixListId. In this case, prefix lists support only security groups in VPCs. NicType must be set to intranet. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourcePrefixListId=pl-x1j1k5ykzqlixdcy****\
        &Permissions.1.SourceGroupOwnerAccount=test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        - For information about examples on security group rule settings, see [Security groups for different use cases](~~25475~~) and [Security group quintuple rules](~~97439~~).
        
        @param request: AuthorizeSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ipv_6dest_cidr_ip):
            query['Ipv6DestCidrIp'] = request.ipv_6dest_cidr_ip
        if not UtilClient.is_unset(request.ipv_6source_cidr_ip):
            query['Ipv6SourceCidrIp'] = request.ipv_6source_cidr_ip
        if not UtilClient.is_unset(request.nic_type):
            query['NicType'] = request.nic_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permissions):
            query['Permissions'] = request.permissions
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_group_id):
            query['SourceGroupId'] = request.source_group_id
        if not UtilClient.is_unset(request.source_group_owner_account):
            query['SourceGroupOwnerAccount'] = request.source_group_owner_account
        if not UtilClient.is_unset(request.source_group_owner_id):
            query['SourceGroupOwnerId'] = request.source_group_owner_id
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        if not UtilClient.is_unset(request.source_prefix_list_id):
            query['SourcePrefixListId'] = request.source_prefix_list_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AuthorizeSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def authorize_security_group_with_options_async(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupResponse:
        """
        In the security group-related API documents, inbound traffic refers to the traffic sent by the source and received by the destination.
        When you call this operation, take note of the following items:
        - The total number of outbound and inbound rules in each security group cannot exceed 200. For more information, see the "Security group limits" section in [Limits](~~25412#SecurityGroupQuota1~~).
        - The valid value of Priority ranges from 1 to 100. A smaller value indicates a higher priority.
        - When multiple security group rules have the same priority, drop rules take precedence.
        - The source can be a CIDR block specified by SourceCidrIp, Ipv6SourceCidrIp, or SourcePrefixListId or can be Elastic Compute Service (ECS) instances in a security group specified by SourceGroupId.
        - For advanced security groups, security groups cannot be used as authorization objects.
        - For each basic security group, a maximum of 20 security groups can be used as authorization objects.
        - If the specified security group rule already exists, the call to AuthorizeSecurityGroup is successful but no security group rule is created.
        - The `Permissions.N` prefix is added to some parameters to generate new parameters. Original parameters and corresponding parameters prefixed with Permissions.N cannot be specified together. We recommend that you use parameters prefixed with `Permissions.N`.
        - You can determine a security group rule by specifying one of the following groups of parameters. You cannot determine a security group rule by specifying only one parameter.
        - Parameters used to specify an inbound security group rule that controls access from a specific CIDR block: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and SourceCidrIp. For a security group of the Virtual Private Cloud (VPC) type, you must set the NicType parameter to intranet. For a security group of the classic network type, you can set the NicType parameter to either internet or intranet. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourceCidrIp=10.0.0.0/8
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Accept
        &<Common request parameters>
        
        ```
        - Parameters used to specify an inbound security group rule that controls access from a security group: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, SourceGroupOwnerAccount, and SourceGroupId. In this case, you must set the NicType parameter to intranet. For mutual access between security groups in the classic network, you can allow or deny another security group within the same region access to your security group. The security group that is allowed access to your security group can belong to your own Alibaba Cloud account or another Alibaba Cloud account specified by the SourceGroupOwnerAccount parameter. For mutual access between security groups in VPCs, you can allow or deny another security group within the same VPC access to your security group. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourceGroupId=sg-1651FBB**\
        &Permissions.1.SourceGroupOwnerAccount=test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        - Parameters used to specify an inbound security group rule that controls access from a prefix list: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and SourcePrefixListId. In this case, prefix lists support only security groups in VPCs. NicType must be set to intranet. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourcePrefixListId=pl-x1j1k5ykzqlixdcy****\
        &Permissions.1.SourceGroupOwnerAccount=test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        - For information about examples on security group rule settings, see [Security groups for different use cases](~~25475~~) and [Security group quintuple rules](~~97439~~).
        
        @param request: AuthorizeSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ipv_6dest_cidr_ip):
            query['Ipv6DestCidrIp'] = request.ipv_6dest_cidr_ip
        if not UtilClient.is_unset(request.ipv_6source_cidr_ip):
            query['Ipv6SourceCidrIp'] = request.ipv_6source_cidr_ip
        if not UtilClient.is_unset(request.nic_type):
            query['NicType'] = request.nic_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permissions):
            query['Permissions'] = request.permissions
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_group_id):
            query['SourceGroupId'] = request.source_group_id
        if not UtilClient.is_unset(request.source_group_owner_account):
            query['SourceGroupOwnerAccount'] = request.source_group_owner_account
        if not UtilClient.is_unset(request.source_group_owner_id):
            query['SourceGroupOwnerId'] = request.source_group_owner_id
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        if not UtilClient.is_unset(request.source_prefix_list_id):
            query['SourcePrefixListId'] = request.source_prefix_list_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AuthorizeSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def authorize_security_group(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupRequest,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupResponse:
        """
        In the security group-related API documents, inbound traffic refers to the traffic sent by the source and received by the destination.
        When you call this operation, take note of the following items:
        - The total number of outbound and inbound rules in each security group cannot exceed 200. For more information, see the "Security group limits" section in [Limits](~~25412#SecurityGroupQuota1~~).
        - The valid value of Priority ranges from 1 to 100. A smaller value indicates a higher priority.
        - When multiple security group rules have the same priority, drop rules take precedence.
        - The source can be a CIDR block specified by SourceCidrIp, Ipv6SourceCidrIp, or SourcePrefixListId or can be Elastic Compute Service (ECS) instances in a security group specified by SourceGroupId.
        - For advanced security groups, security groups cannot be used as authorization objects.
        - For each basic security group, a maximum of 20 security groups can be used as authorization objects.
        - If the specified security group rule already exists, the call to AuthorizeSecurityGroup is successful but no security group rule is created.
        - The `Permissions.N` prefix is added to some parameters to generate new parameters. Original parameters and corresponding parameters prefixed with Permissions.N cannot be specified together. We recommend that you use parameters prefixed with `Permissions.N`.
        - You can determine a security group rule by specifying one of the following groups of parameters. You cannot determine a security group rule by specifying only one parameter.
        - Parameters used to specify an inbound security group rule that controls access from a specific CIDR block: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and SourceCidrIp. For a security group of the Virtual Private Cloud (VPC) type, you must set the NicType parameter to intranet. For a security group of the classic network type, you can set the NicType parameter to either internet or intranet. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourceCidrIp=10.0.0.0/8
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Accept
        &<Common request parameters>
        
        ```
        - Parameters used to specify an inbound security group rule that controls access from a security group: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, SourceGroupOwnerAccount, and SourceGroupId. In this case, you must set the NicType parameter to intranet. For mutual access between security groups in the classic network, you can allow or deny another security group within the same region access to your security group. The security group that is allowed access to your security group can belong to your own Alibaba Cloud account or another Alibaba Cloud account specified by the SourceGroupOwnerAccount parameter. For mutual access between security groups in VPCs, you can allow or deny another security group within the same VPC access to your security group. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourceGroupId=sg-1651FBB**\
        &Permissions.1.SourceGroupOwnerAccount=test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        - Parameters used to specify an inbound security group rule that controls access from a prefix list: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and SourcePrefixListId. In this case, prefix lists support only security groups in VPCs. NicType must be set to intranet. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourcePrefixListId=pl-x1j1k5ykzqlixdcy****\
        &Permissions.1.SourceGroupOwnerAccount=test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        - For information about examples on security group rule settings, see [Security groups for different use cases](~~25475~~) and [Security group quintuple rules](~~97439~~).
        
        @param request: AuthorizeSecurityGroupRequest
        @return: AuthorizeSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.authorize_security_group_with_options(request, runtime)

    async def authorize_security_group_async(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupRequest,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupResponse:
        """
        In the security group-related API documents, inbound traffic refers to the traffic sent by the source and received by the destination.
        When you call this operation, take note of the following items:
        - The total number of outbound and inbound rules in each security group cannot exceed 200. For more information, see the "Security group limits" section in [Limits](~~25412#SecurityGroupQuota1~~).
        - The valid value of Priority ranges from 1 to 100. A smaller value indicates a higher priority.
        - When multiple security group rules have the same priority, drop rules take precedence.
        - The source can be a CIDR block specified by SourceCidrIp, Ipv6SourceCidrIp, or SourcePrefixListId or can be Elastic Compute Service (ECS) instances in a security group specified by SourceGroupId.
        - For advanced security groups, security groups cannot be used as authorization objects.
        - For each basic security group, a maximum of 20 security groups can be used as authorization objects.
        - If the specified security group rule already exists, the call to AuthorizeSecurityGroup is successful but no security group rule is created.
        - The `Permissions.N` prefix is added to some parameters to generate new parameters. Original parameters and corresponding parameters prefixed with Permissions.N cannot be specified together. We recommend that you use parameters prefixed with `Permissions.N`.
        - You can determine a security group rule by specifying one of the following groups of parameters. You cannot determine a security group rule by specifying only one parameter.
        - Parameters used to specify an inbound security group rule that controls access from a specific CIDR block: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and SourceCidrIp. For a security group of the Virtual Private Cloud (VPC) type, you must set the NicType parameter to intranet. For a security group of the classic network type, you can set the NicType parameter to either internet or intranet. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourceCidrIp=10.0.0.0/8
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Accept
        &<Common request parameters>
        
        ```
        - Parameters used to specify an inbound security group rule that controls access from a security group: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, SourceGroupOwnerAccount, and SourceGroupId. In this case, you must set the NicType parameter to intranet. For mutual access between security groups in the classic network, you can allow or deny another security group within the same region access to your security group. The security group that is allowed access to your security group can belong to your own Alibaba Cloud account or another Alibaba Cloud account specified by the SourceGroupOwnerAccount parameter. For mutual access between security groups in VPCs, you can allow or deny another security group within the same VPC access to your security group. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourceGroupId=sg-1651FBB**\
        &Permissions.1.SourceGroupOwnerAccount=test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        - Parameters used to specify an inbound security group rule that controls access from a prefix list: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and SourcePrefixListId. In this case, prefix lists support only security groups in VPCs. NicType must be set to intranet. Sample request:
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroup
        &SecurityGroupId=sg-bp67acfmxazb4p****\
        &Permissions.1.SourcePrefixListId=pl-x1j1k5ykzqlixdcy****\
        &Permissions.1.SourceGroupOwnerAccount=test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        - For information about examples on security group rule settings, see [Security groups for different use cases](~~25475~~) and [Security group quintuple rules](~~97439~~).
        
        @param request: AuthorizeSecurityGroupRequest
        @return: AuthorizeSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.authorize_security_group_with_options_async(request, runtime)

    def authorize_security_group_egress_with_options(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupEgressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupEgressResponse:
        """
        In the security group-related API documents, outbound traffic refers to the traffic sent by the source and received by the destination.
        When you call this operation, take note of the following items:
        * The total number of outbound and inbound security group rules in each security group cannot exceed 200. For more information, see the "Security group limits" section in [~~25412#SecurityGroupQuota1~~](~~25412#SecurityGroupQuota1~~).
        * You can set Policy to accept or drop for each security group rule to allow or deny access.
        * The valid value of Priority ranges from 1 to 100. A smaller value indicates a higher priority.
        * When several security group rules have the same priority, drop rules take precedence.
        * The destination can be a CIDR block specified by DestCidrIp, Ipv6DestCidrIp, or DestPrefixListId or can be Elastic Compute Service (ECS) instances in a security group specified by DestGroupId.
        * For advanced security groups, security groups cannot be used as authorization objects.
        * For each basic security group, a maximum of 20 security groups can be used as authorization objects.
        * If the specified security group rule exists in the security group, the call to AuthorizeSecurityGroupEgress is successful but no security group rule is created.
        * The `Permissions.N` prefix is added to some parameters to generate new parameters. Original parameters and corresponding parameters prefixed with Permissions.N cannot be specified together. We recommend that you use parameters prefixed with `Permissions.N`.
        * You can determine a security group rule by specifying one of the following groups of parameters. You cannot determine a security group rule by specifying only one parameter.
        * Parameters used to specify an outbound security group rule that controls access to a specified CIDR block: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and DestCidrIp.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.IpProtocol=ICMP
        &Permissions.1.DestCidrIp=10.0.0.0/8
        &Permissions.1.PortRange=-1/-1
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Accept
        &<Common request parameters>
        
        ```
        * Parameters used to specify an outbound security group rule that controls access to a security group: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, DestGroupOwnerAccount, and DestGroupId.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.DestGroupId=sg-bp67acfmxazb4pi***\
        &Permissions.1.DestGroupOwnerAccount=Test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        * Parameters used to specify an outbound security group rule that controls access to a prefix list: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and DestPrefixListId. In this case, prefix lists support only security groups in virtual private clouds (VPCs). NicType must be set to intranet.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.DestPrefixListId=pl-x1j1k5ykzqlixdcy****\
        &Permissions.1.DestGroupOwnerAccount=Test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupEgressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.dest_group_id):
            query['DestGroupId'] = request.dest_group_id
        if not UtilClient.is_unset(request.dest_group_owner_account):
            query['DestGroupOwnerAccount'] = request.dest_group_owner_account
        if not UtilClient.is_unset(request.dest_group_owner_id):
            query['DestGroupOwnerId'] = request.dest_group_owner_id
        if not UtilClient.is_unset(request.dest_prefix_list_id):
            query['DestPrefixListId'] = request.dest_prefix_list_id
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ipv_6dest_cidr_ip):
            query['Ipv6DestCidrIp'] = request.ipv_6dest_cidr_ip
        if not UtilClient.is_unset(request.ipv_6source_cidr_ip):
            query['Ipv6SourceCidrIp'] = request.ipv_6source_cidr_ip
        if not UtilClient.is_unset(request.nic_type):
            query['NicType'] = request.nic_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permissions):
            query['Permissions'] = request.permissions
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroupEgress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AuthorizeSecurityGroupEgressResponse(),
            self.call_api(params, req, runtime)
        )

    async def authorize_security_group_egress_with_options_async(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupEgressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupEgressResponse:
        """
        In the security group-related API documents, outbound traffic refers to the traffic sent by the source and received by the destination.
        When you call this operation, take note of the following items:
        * The total number of outbound and inbound security group rules in each security group cannot exceed 200. For more information, see the "Security group limits" section in [~~25412#SecurityGroupQuota1~~](~~25412#SecurityGroupQuota1~~).
        * You can set Policy to accept or drop for each security group rule to allow or deny access.
        * The valid value of Priority ranges from 1 to 100. A smaller value indicates a higher priority.
        * When several security group rules have the same priority, drop rules take precedence.
        * The destination can be a CIDR block specified by DestCidrIp, Ipv6DestCidrIp, or DestPrefixListId or can be Elastic Compute Service (ECS) instances in a security group specified by DestGroupId.
        * For advanced security groups, security groups cannot be used as authorization objects.
        * For each basic security group, a maximum of 20 security groups can be used as authorization objects.
        * If the specified security group rule exists in the security group, the call to AuthorizeSecurityGroupEgress is successful but no security group rule is created.
        * The `Permissions.N` prefix is added to some parameters to generate new parameters. Original parameters and corresponding parameters prefixed with Permissions.N cannot be specified together. We recommend that you use parameters prefixed with `Permissions.N`.
        * You can determine a security group rule by specifying one of the following groups of parameters. You cannot determine a security group rule by specifying only one parameter.
        * Parameters used to specify an outbound security group rule that controls access to a specified CIDR block: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and DestCidrIp.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.IpProtocol=ICMP
        &Permissions.1.DestCidrIp=10.0.0.0/8
        &Permissions.1.PortRange=-1/-1
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Accept
        &<Common request parameters>
        
        ```
        * Parameters used to specify an outbound security group rule that controls access to a security group: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, DestGroupOwnerAccount, and DestGroupId.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.DestGroupId=sg-bp67acfmxazb4pi***\
        &Permissions.1.DestGroupOwnerAccount=Test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        * Parameters used to specify an outbound security group rule that controls access to a prefix list: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and DestPrefixListId. In this case, prefix lists support only security groups in virtual private clouds (VPCs). NicType must be set to intranet.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.DestPrefixListId=pl-x1j1k5ykzqlixdcy****\
        &Permissions.1.DestGroupOwnerAccount=Test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupEgressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.dest_group_id):
            query['DestGroupId'] = request.dest_group_id
        if not UtilClient.is_unset(request.dest_group_owner_account):
            query['DestGroupOwnerAccount'] = request.dest_group_owner_account
        if not UtilClient.is_unset(request.dest_group_owner_id):
            query['DestGroupOwnerId'] = request.dest_group_owner_id
        if not UtilClient.is_unset(request.dest_prefix_list_id):
            query['DestPrefixListId'] = request.dest_prefix_list_id
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ipv_6dest_cidr_ip):
            query['Ipv6DestCidrIp'] = request.ipv_6dest_cidr_ip
        if not UtilClient.is_unset(request.ipv_6source_cidr_ip):
            query['Ipv6SourceCidrIp'] = request.ipv_6source_cidr_ip
        if not UtilClient.is_unset(request.nic_type):
            query['NicType'] = request.nic_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permissions):
            query['Permissions'] = request.permissions
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroupEgress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AuthorizeSecurityGroupEgressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def authorize_security_group_egress(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupEgressRequest,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupEgressResponse:
        """
        In the security group-related API documents, outbound traffic refers to the traffic sent by the source and received by the destination.
        When you call this operation, take note of the following items:
        * The total number of outbound and inbound security group rules in each security group cannot exceed 200. For more information, see the "Security group limits" section in [~~25412#SecurityGroupQuota1~~](~~25412#SecurityGroupQuota1~~).
        * You can set Policy to accept or drop for each security group rule to allow or deny access.
        * The valid value of Priority ranges from 1 to 100. A smaller value indicates a higher priority.
        * When several security group rules have the same priority, drop rules take precedence.
        * The destination can be a CIDR block specified by DestCidrIp, Ipv6DestCidrIp, or DestPrefixListId or can be Elastic Compute Service (ECS) instances in a security group specified by DestGroupId.
        * For advanced security groups, security groups cannot be used as authorization objects.
        * For each basic security group, a maximum of 20 security groups can be used as authorization objects.
        * If the specified security group rule exists in the security group, the call to AuthorizeSecurityGroupEgress is successful but no security group rule is created.
        * The `Permissions.N` prefix is added to some parameters to generate new parameters. Original parameters and corresponding parameters prefixed with Permissions.N cannot be specified together. We recommend that you use parameters prefixed with `Permissions.N`.
        * You can determine a security group rule by specifying one of the following groups of parameters. You cannot determine a security group rule by specifying only one parameter.
        * Parameters used to specify an outbound security group rule that controls access to a specified CIDR block: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and DestCidrIp.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.IpProtocol=ICMP
        &Permissions.1.DestCidrIp=10.0.0.0/8
        &Permissions.1.PortRange=-1/-1
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Accept
        &<Common request parameters>
        
        ```
        * Parameters used to specify an outbound security group rule that controls access to a security group: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, DestGroupOwnerAccount, and DestGroupId.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.DestGroupId=sg-bp67acfmxazb4pi***\
        &Permissions.1.DestGroupOwnerAccount=Test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        * Parameters used to specify an outbound security group rule that controls access to a prefix list: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and DestPrefixListId. In this case, prefix lists support only security groups in virtual private clouds (VPCs). NicType must be set to intranet.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.DestPrefixListId=pl-x1j1k5ykzqlixdcy****\
        &Permissions.1.DestGroupOwnerAccount=Test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @return: AuthorizeSecurityGroupEgressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.authorize_security_group_egress_with_options(request, runtime)

    async def authorize_security_group_egress_async(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupEgressRequest,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupEgressResponse:
        """
        In the security group-related API documents, outbound traffic refers to the traffic sent by the source and received by the destination.
        When you call this operation, take note of the following items:
        * The total number of outbound and inbound security group rules in each security group cannot exceed 200. For more information, see the "Security group limits" section in [~~25412#SecurityGroupQuota1~~](~~25412#SecurityGroupQuota1~~).
        * You can set Policy to accept or drop for each security group rule to allow or deny access.
        * The valid value of Priority ranges from 1 to 100. A smaller value indicates a higher priority.
        * When several security group rules have the same priority, drop rules take precedence.
        * The destination can be a CIDR block specified by DestCidrIp, Ipv6DestCidrIp, or DestPrefixListId or can be Elastic Compute Service (ECS) instances in a security group specified by DestGroupId.
        * For advanced security groups, security groups cannot be used as authorization objects.
        * For each basic security group, a maximum of 20 security groups can be used as authorization objects.
        * If the specified security group rule exists in the security group, the call to AuthorizeSecurityGroupEgress is successful but no security group rule is created.
        * The `Permissions.N` prefix is added to some parameters to generate new parameters. Original parameters and corresponding parameters prefixed with Permissions.N cannot be specified together. We recommend that you use parameters prefixed with `Permissions.N`.
        * You can determine a security group rule by specifying one of the following groups of parameters. You cannot determine a security group rule by specifying only one parameter.
        * Parameters used to specify an outbound security group rule that controls access to a specified CIDR block: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and DestCidrIp.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.IpProtocol=ICMP
        &Permissions.1.DestCidrIp=10.0.0.0/8
        &Permissions.1.PortRange=-1/-1
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Accept
        &<Common request parameters>
        
        ```
        * Parameters used to specify an outbound security group rule that controls access to a security group: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, DestGroupOwnerAccount, and DestGroupId.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.DestGroupId=sg-bp67acfmxazb4pi***\
        &Permissions.1.DestGroupOwnerAccount=Test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        * Parameters used to specify an outbound security group rule that controls access to a prefix list: IpProtocol, PortRange, SourcePortRange (optional), NicType, Policy, and DestPrefixListId. In this case, prefix lists support only security groups in virtual private clouds (VPCs). NicType must be set to intranet.
        ```
        http(s)://ecs.aliyuncs.com/?Action=AuthorizeSecurityGroupEgress
        &SecurityGroupId=sg-bp67acfmxazb4ph***\
        &Permissions.1.DestPrefixListId=pl-x1j1k5ykzqlixdcy****\
        &Permissions.1.DestGroupOwnerAccount=Test@aliyun.com
        &Permissions.1.IpProtocol=TCP
        &Permissions.1.PortRange=22/22
        &Permissions.1.NicType=intranet
        &Permissions.1.Policy=Drop
        &<Common request parameters>
        
        ```
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @return: AuthorizeSecurityGroupEgressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.authorize_security_group_egress_with_options_async(request, runtime)

    def cancel_auto_snapshot_policy_with_options(
        self,
        request: ecs_20140526_models.CancelAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelAutoSnapshotPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.disk_ids):
            query['diskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelAutoSnapshotPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_auto_snapshot_policy_with_options_async(
        self,
        request: ecs_20140526_models.CancelAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelAutoSnapshotPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.disk_ids):
            query['diskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelAutoSnapshotPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_auto_snapshot_policy(
        self,
        request: ecs_20140526_models.CancelAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.CancelAutoSnapshotPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return self.cancel_auto_snapshot_policy_with_options(request, runtime)

    async def cancel_auto_snapshot_policy_async(
        self,
        request: ecs_20140526_models.CancelAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.CancelAutoSnapshotPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.cancel_auto_snapshot_policy_with_options_async(request, runtime)

    def cancel_copy_image_with_options(
        self,
        request: ecs_20140526_models.CancelCopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelCopyImageResponse:
        """
        When you call this operation, take note of the following items:
        *   After you cancel the image copy task, the image copy created in the destination region is deleted, and the source image remains unchanged.
        *   If the image copy task is complete, the CancelCopyImage operation fails and an error is returned.
        
        @param request: CancelCopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCopyImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelCopyImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_copy_image_with_options_async(
        self,
        request: ecs_20140526_models.CancelCopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelCopyImageResponse:
        """
        When you call this operation, take note of the following items:
        *   After you cancel the image copy task, the image copy created in the destination region is deleted, and the source image remains unchanged.
        *   If the image copy task is complete, the CancelCopyImage operation fails and an error is returned.
        
        @param request: CancelCopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCopyImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelCopyImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_copy_image(
        self,
        request: ecs_20140526_models.CancelCopyImageRequest,
    ) -> ecs_20140526_models.CancelCopyImageResponse:
        """
        When you call this operation, take note of the following items:
        *   After you cancel the image copy task, the image copy created in the destination region is deleted, and the source image remains unchanged.
        *   If the image copy task is complete, the CancelCopyImage operation fails and an error is returned.
        
        @param request: CancelCopyImageRequest
        @return: CancelCopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_copy_image_with_options(request, runtime)

    async def cancel_copy_image_async(
        self,
        request: ecs_20140526_models.CancelCopyImageRequest,
    ) -> ecs_20140526_models.CancelCopyImageResponse:
        """
        When you call this operation, take note of the following items:
        *   After you cancel the image copy task, the image copy created in the destination region is deleted, and the source image remains unchanged.
        *   If the image copy task is complete, the CancelCopyImage operation fails and an error is returned.
        
        @param request: CancelCopyImageRequest
        @return: CancelCopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_copy_image_with_options_async(request, runtime)

    def cancel_image_pipeline_execution_with_options(
        self,
        request: ecs_20140526_models.CancelImagePipelineExecutionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelImagePipelineExecutionResponse:
        """
        Before you call this operation, make sure that the image build task to be canceled is in the BUILDING, DISTRIBUTING, or RELEASING state.
        
        @param request: CancelImagePipelineExecutionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelImagePipelineExecutionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.execution_id):
            query['ExecutionId'] = request.execution_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.template_tag):
            query['TemplateTag'] = request.template_tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelImagePipelineExecution',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelImagePipelineExecutionResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_image_pipeline_execution_with_options_async(
        self,
        request: ecs_20140526_models.CancelImagePipelineExecutionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelImagePipelineExecutionResponse:
        """
        Before you call this operation, make sure that the image build task to be canceled is in the BUILDING, DISTRIBUTING, or RELEASING state.
        
        @param request: CancelImagePipelineExecutionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelImagePipelineExecutionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.execution_id):
            query['ExecutionId'] = request.execution_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.template_tag):
            query['TemplateTag'] = request.template_tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelImagePipelineExecution',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelImagePipelineExecutionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_image_pipeline_execution(
        self,
        request: ecs_20140526_models.CancelImagePipelineExecutionRequest,
    ) -> ecs_20140526_models.CancelImagePipelineExecutionResponse:
        """
        Before you call this operation, make sure that the image build task to be canceled is in the BUILDING, DISTRIBUTING, or RELEASING state.
        
        @param request: CancelImagePipelineExecutionRequest
        @return: CancelImagePipelineExecutionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_image_pipeline_execution_with_options(request, runtime)

    async def cancel_image_pipeline_execution_async(
        self,
        request: ecs_20140526_models.CancelImagePipelineExecutionRequest,
    ) -> ecs_20140526_models.CancelImagePipelineExecutionResponse:
        """
        Before you call this operation, make sure that the image build task to be canceled is in the BUILDING, DISTRIBUTING, or RELEASING state.
        
        @param request: CancelImagePipelineExecutionRequest
        @return: CancelImagePipelineExecutionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_image_pipeline_execution_with_options_async(request, runtime)

    def cancel_physical_connection_with_options(
        self,
        request: ecs_20140526_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelPhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: CancelPhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelPhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_physical_connection_with_options_async(
        self,
        request: ecs_20140526_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelPhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: CancelPhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelPhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_physical_connection(
        self,
        request: ecs_20140526_models.CancelPhysicalConnectionRequest,
    ) -> ecs_20140526_models.CancelPhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: CancelPhysicalConnectionRequest
        @return: CancelPhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_physical_connection_with_options(request, runtime)

    async def cancel_physical_connection_async(
        self,
        request: ecs_20140526_models.CancelPhysicalConnectionRequest,
    ) -> ecs_20140526_models.CancelPhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: CancelPhysicalConnectionRequest
        @return: CancelPhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_physical_connection_with_options_async(request, runtime)

    def cancel_simulated_system_events_with_options(
        self,
        request: ecs_20140526_models.CancelSimulatedSystemEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelSimulatedSystemEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelSimulatedSystemEvents',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelSimulatedSystemEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_simulated_system_events_with_options_async(
        self,
        request: ecs_20140526_models.CancelSimulatedSystemEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelSimulatedSystemEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelSimulatedSystemEvents',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelSimulatedSystemEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_simulated_system_events(
        self,
        request: ecs_20140526_models.CancelSimulatedSystemEventsRequest,
    ) -> ecs_20140526_models.CancelSimulatedSystemEventsResponse:
        runtime = util_models.RuntimeOptions()
        return self.cancel_simulated_system_events_with_options(request, runtime)

    async def cancel_simulated_system_events_async(
        self,
        request: ecs_20140526_models.CancelSimulatedSystemEventsRequest,
    ) -> ecs_20140526_models.CancelSimulatedSystemEventsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.cancel_simulated_system_events_with_options_async(request, runtime)

    def cancel_task_with_options(
        self,
        request: ecs_20140526_models.CancelTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelTask',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_task_with_options_async(
        self,
        request: ecs_20140526_models.CancelTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelTask',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_task(
        self,
        request: ecs_20140526_models.CancelTaskRequest,
    ) -> ecs_20140526_models.CancelTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.cancel_task_with_options(request, runtime)

    async def cancel_task_async(
        self,
        request: ecs_20140526_models.CancelTaskRequest,
    ) -> ecs_20140526_models.CancelTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.cancel_task_with_options_async(request, runtime)

    def connect_router_interface_with_options(
        self,
        request: ecs_20140526_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ConnectRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: ConnectRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConnectRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ConnectRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def connect_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ConnectRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: ConnectRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConnectRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ConnectRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def connect_router_interface(
        self,
        request: ecs_20140526_models.ConnectRouterInterfaceRequest,
    ) -> ecs_20140526_models.ConnectRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: ConnectRouterInterfaceRequest
        @return: ConnectRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.connect_router_interface_with_options(request, runtime)

    async def connect_router_interface_async(
        self,
        request: ecs_20140526_models.ConnectRouterInterfaceRequest,
    ) -> ecs_20140526_models.ConnectRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: ConnectRouterInterfaceRequest
        @return: ConnectRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.connect_router_interface_with_options_async(request, runtime)

    def convert_nat_public_ip_to_eip_with_options(
        self,
        request: ecs_20140526_models.ConvertNatPublicIpToEipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ConvertNatPublicIpToEipResponse:
        """
        After a public IP address is converted into an EIP, the EIP is billed separately. Make sure that you understand the billing methods of EIPs. For more information, see [Billing overview](~~122035~~).
        Before you call this operation, make sure that the following requirements are met:
        *   The instance is in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        *   No EIPs are associated with the instance.
        *   The instance has no configuration change tasks that have not taken effect.
        *   The public bandwidth of the instance is not 0 Mbit/s.
        *   The instance uses the pay-by-traffic billing method for network usage.
        *   If the instance is a subscription instance that resides in a VPC, the instance does not expire within 24 hours.
        
        @param request: ConvertNatPublicIpToEipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConvertNatPublicIpToEipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConvertNatPublicIpToEip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ConvertNatPublicIpToEipResponse(),
            self.call_api(params, req, runtime)
        )

    async def convert_nat_public_ip_to_eip_with_options_async(
        self,
        request: ecs_20140526_models.ConvertNatPublicIpToEipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ConvertNatPublicIpToEipResponse:
        """
        After a public IP address is converted into an EIP, the EIP is billed separately. Make sure that you understand the billing methods of EIPs. For more information, see [Billing overview](~~122035~~).
        Before you call this operation, make sure that the following requirements are met:
        *   The instance is in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        *   No EIPs are associated with the instance.
        *   The instance has no configuration change tasks that have not taken effect.
        *   The public bandwidth of the instance is not 0 Mbit/s.
        *   The instance uses the pay-by-traffic billing method for network usage.
        *   If the instance is a subscription instance that resides in a VPC, the instance does not expire within 24 hours.
        
        @param request: ConvertNatPublicIpToEipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConvertNatPublicIpToEipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConvertNatPublicIpToEip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ConvertNatPublicIpToEipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def convert_nat_public_ip_to_eip(
        self,
        request: ecs_20140526_models.ConvertNatPublicIpToEipRequest,
    ) -> ecs_20140526_models.ConvertNatPublicIpToEipResponse:
        """
        After a public IP address is converted into an EIP, the EIP is billed separately. Make sure that you understand the billing methods of EIPs. For more information, see [Billing overview](~~122035~~).
        Before you call this operation, make sure that the following requirements are met:
        *   The instance is in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        *   No EIPs are associated with the instance.
        *   The instance has no configuration change tasks that have not taken effect.
        *   The public bandwidth of the instance is not 0 Mbit/s.
        *   The instance uses the pay-by-traffic billing method for network usage.
        *   If the instance is a subscription instance that resides in a VPC, the instance does not expire within 24 hours.
        
        @param request: ConvertNatPublicIpToEipRequest
        @return: ConvertNatPublicIpToEipResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.convert_nat_public_ip_to_eip_with_options(request, runtime)

    async def convert_nat_public_ip_to_eip_async(
        self,
        request: ecs_20140526_models.ConvertNatPublicIpToEipRequest,
    ) -> ecs_20140526_models.ConvertNatPublicIpToEipResponse:
        """
        After a public IP address is converted into an EIP, the EIP is billed separately. Make sure that you understand the billing methods of EIPs. For more information, see [Billing overview](~~122035~~).
        Before you call this operation, make sure that the following requirements are met:
        *   The instance is in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        *   No EIPs are associated with the instance.
        *   The instance has no configuration change tasks that have not taken effect.
        *   The public bandwidth of the instance is not 0 Mbit/s.
        *   The instance uses the pay-by-traffic billing method for network usage.
        *   If the instance is a subscription instance that resides in a VPC, the instance does not expire within 24 hours.
        
        @param request: ConvertNatPublicIpToEipRequest
        @return: ConvertNatPublicIpToEipResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.convert_nat_public_ip_to_eip_with_options_async(request, runtime)

    def copy_image_with_options(
        self,
        request: ecs_20140526_models.CopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CopyImageResponse:
        """
        After you copy a custom image to the destination region, you can use the image copy to create Elastic Compute Service (ECS) instances by calling the RunInstances operation or replace the system disks of instances by calling the ReplaceSystemDisk operation in the destination region.
        When you call this operation, take note of the following items:
        *   Only custom images that are in the `Available` state can be copied.
        *   You can only copy images within your own Alibaba Cloud account. Images cannot be copied from one account to another.
        *   When an image is being copied, you cannot delete the image copy by calling the [DeleteImage](~~25537~~) operation, but you can cancel the running copy task by calling the [CancelCopyImage](~~25539~~) operation.
        *   A single region can have only one image copy task running at a time. Other image copy tasks queue up for the current task to complete before they run in sequence.
        *   You can set the `ResourceGroupId` parameter to specify the resource group to which the image copy belongs. If you do not set the `ResourceGroupId` parameter, the image copy belongs to the default resource group.
        
        @param request: CopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_description):
            query['DestinationDescription'] = request.destination_description
        if not UtilClient.is_unset(request.destination_image_name):
            query['DestinationImageName'] = request.destination_image_name
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.encrypt_algorithm):
            query['EncryptAlgorithm'] = request.encrypt_algorithm
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CopyImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_image_with_options_async(
        self,
        request: ecs_20140526_models.CopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CopyImageResponse:
        """
        After you copy a custom image to the destination region, you can use the image copy to create Elastic Compute Service (ECS) instances by calling the RunInstances operation or replace the system disks of instances by calling the ReplaceSystemDisk operation in the destination region.
        When you call this operation, take note of the following items:
        *   Only custom images that are in the `Available` state can be copied.
        *   You can only copy images within your own Alibaba Cloud account. Images cannot be copied from one account to another.
        *   When an image is being copied, you cannot delete the image copy by calling the [DeleteImage](~~25537~~) operation, but you can cancel the running copy task by calling the [CancelCopyImage](~~25539~~) operation.
        *   A single region can have only one image copy task running at a time. Other image copy tasks queue up for the current task to complete before they run in sequence.
        *   You can set the `ResourceGroupId` parameter to specify the resource group to which the image copy belongs. If you do not set the `ResourceGroupId` parameter, the image copy belongs to the default resource group.
        
        @param request: CopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_description):
            query['DestinationDescription'] = request.destination_description
        if not UtilClient.is_unset(request.destination_image_name):
            query['DestinationImageName'] = request.destination_image_name
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.encrypt_algorithm):
            query['EncryptAlgorithm'] = request.encrypt_algorithm
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CopyImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_image(
        self,
        request: ecs_20140526_models.CopyImageRequest,
    ) -> ecs_20140526_models.CopyImageResponse:
        """
        After you copy a custom image to the destination region, you can use the image copy to create Elastic Compute Service (ECS) instances by calling the RunInstances operation or replace the system disks of instances by calling the ReplaceSystemDisk operation in the destination region.
        When you call this operation, take note of the following items:
        *   Only custom images that are in the `Available` state can be copied.
        *   You can only copy images within your own Alibaba Cloud account. Images cannot be copied from one account to another.
        *   When an image is being copied, you cannot delete the image copy by calling the [DeleteImage](~~25537~~) operation, but you can cancel the running copy task by calling the [CancelCopyImage](~~25539~~) operation.
        *   A single region can have only one image copy task running at a time. Other image copy tasks queue up for the current task to complete before they run in sequence.
        *   You can set the `ResourceGroupId` parameter to specify the resource group to which the image copy belongs. If you do not set the `ResourceGroupId` parameter, the image copy belongs to the default resource group.
        
        @param request: CopyImageRequest
        @return: CopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_image_with_options(request, runtime)

    async def copy_image_async(
        self,
        request: ecs_20140526_models.CopyImageRequest,
    ) -> ecs_20140526_models.CopyImageResponse:
        """
        After you copy a custom image to the destination region, you can use the image copy to create Elastic Compute Service (ECS) instances by calling the RunInstances operation or replace the system disks of instances by calling the ReplaceSystemDisk operation in the destination region.
        When you call this operation, take note of the following items:
        *   Only custom images that are in the `Available` state can be copied.
        *   You can only copy images within your own Alibaba Cloud account. Images cannot be copied from one account to another.
        *   When an image is being copied, you cannot delete the image copy by calling the [DeleteImage](~~25537~~) operation, but you can cancel the running copy task by calling the [CancelCopyImage](~~25539~~) operation.
        *   A single region can have only one image copy task running at a time. Other image copy tasks queue up for the current task to complete before they run in sequence.
        *   You can set the `ResourceGroupId` parameter to specify the resource group to which the image copy belongs. If you do not set the `ResourceGroupId` parameter, the image copy belongs to the default resource group.
        
        @param request: CopyImageRequest
        @return: CopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_image_with_options_async(request, runtime)

    def copy_snapshot_with_options(
        self,
        request: ecs_20140526_models.CopySnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CopySnapshotResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   New snapshots, which are the copies of source snapshots, cannot be used to roll back the disks for which the source snapshots were created.
        *   Encrypted snapshots cannot be copied.
        *   Local snapshots cannot be copied.
        
        @param request: CopySnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopySnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.destination_snapshot_description):
            query['DestinationSnapshotDescription'] = request.destination_snapshot_description
        if not UtilClient.is_unset(request.destination_snapshot_name):
            query['DestinationSnapshotName'] = request.destination_snapshot_name
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopySnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CopySnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_snapshot_with_options_async(
        self,
        request: ecs_20140526_models.CopySnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CopySnapshotResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   New snapshots, which are the copies of source snapshots, cannot be used to roll back the disks for which the source snapshots were created.
        *   Encrypted snapshots cannot be copied.
        *   Local snapshots cannot be copied.
        
        @param request: CopySnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopySnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.destination_snapshot_description):
            query['DestinationSnapshotDescription'] = request.destination_snapshot_description
        if not UtilClient.is_unset(request.destination_snapshot_name):
            query['DestinationSnapshotName'] = request.destination_snapshot_name
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopySnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CopySnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_snapshot(
        self,
        request: ecs_20140526_models.CopySnapshotRequest,
    ) -> ecs_20140526_models.CopySnapshotResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   New snapshots, which are the copies of source snapshots, cannot be used to roll back the disks for which the source snapshots were created.
        *   Encrypted snapshots cannot be copied.
        *   Local snapshots cannot be copied.
        
        @param request: CopySnapshotRequest
        @return: CopySnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_snapshot_with_options(request, runtime)

    async def copy_snapshot_async(
        self,
        request: ecs_20140526_models.CopySnapshotRequest,
    ) -> ecs_20140526_models.CopySnapshotResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   New snapshots, which are the copies of source snapshots, cannot be used to roll back the disks for which the source snapshots were created.
        *   Encrypted snapshots cannot be copied.
        *   Local snapshots cannot be copied.
        
        @param request: CopySnapshotRequest
        @return: CopySnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_snapshot_with_options_async(request, runtime)

    def create_activation_with_options(
        self,
        request: ecs_20140526_models.CreateActivationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateActivationResponse:
        """
        After you use an activation code to register a server that is not provided by Alibaba Cloud as an Alibaba Cloud managed instance, you can use a variety of online services provided by Alibaba Cloud, such as Cloud Assistant, Operation Orchestration Service (OOS), and Apsara Devops, in the managed instance.
        A server that is not provided by Alibaba Cloud can be registered as an Alibaba Cloud managed instance only when the server can access the Internet and runs an operating system of one of the following versions:
        *   Alibaba Cloud Linux 2, Alibaba Cloud Linux 3, and later
        *   CentOS 6, CentOS 7, CentOS 8, and later
        *   Debian 8, Debian 9, Debian 10, and later
        *   Ubuntu 12, Ubuntu 14, Ubuntu 16, Ubuntu 18, and later
        *   CoreOS
        *   openSUSE
        *   Red Hat 5, Red Hat 6, Red Hat 7, and later
        *   SUSE Linux Enterprise Server (SLES) 11, SLES 12, SLES 15, and later
        *   Windows Server 2012, Windows Server 2016, Windows Server 2019, and later
        You can create up to 5,000 activation codes within a single Alibaba Cloud region. When the number of activation codes exceeds 1,000, the usage of activation codes must be greater than 50% before you can proceed to create more activation codes.
        > You can go to the **Cloud Assistant** page of the Elastic Compute Service (ECS) console and click **View Activation Codes** on the **Managed Instances** tab to query the usage data about activation codes.
        
        @param request: CreateActivationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateActivationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_count):
            query['InstanceCount'] = request.instance_count
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.ip_address_range):
            query['IpAddressRange'] = request.ip_address_range
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.time_to_live_in_hours):
            query['TimeToLiveInHours'] = request.time_to_live_in_hours
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateActivation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateActivationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_activation_with_options_async(
        self,
        request: ecs_20140526_models.CreateActivationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateActivationResponse:
        """
        After you use an activation code to register a server that is not provided by Alibaba Cloud as an Alibaba Cloud managed instance, you can use a variety of online services provided by Alibaba Cloud, such as Cloud Assistant, Operation Orchestration Service (OOS), and Apsara Devops, in the managed instance.
        A server that is not provided by Alibaba Cloud can be registered as an Alibaba Cloud managed instance only when the server can access the Internet and runs an operating system of one of the following versions:
        *   Alibaba Cloud Linux 2, Alibaba Cloud Linux 3, and later
        *   CentOS 6, CentOS 7, CentOS 8, and later
        *   Debian 8, Debian 9, Debian 10, and later
        *   Ubuntu 12, Ubuntu 14, Ubuntu 16, Ubuntu 18, and later
        *   CoreOS
        *   openSUSE
        *   Red Hat 5, Red Hat 6, Red Hat 7, and later
        *   SUSE Linux Enterprise Server (SLES) 11, SLES 12, SLES 15, and later
        *   Windows Server 2012, Windows Server 2016, Windows Server 2019, and later
        You can create up to 5,000 activation codes within a single Alibaba Cloud region. When the number of activation codes exceeds 1,000, the usage of activation codes must be greater than 50% before you can proceed to create more activation codes.
        > You can go to the **Cloud Assistant** page of the Elastic Compute Service (ECS) console and click **View Activation Codes** on the **Managed Instances** tab to query the usage data about activation codes.
        
        @param request: CreateActivationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateActivationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_count):
            query['InstanceCount'] = request.instance_count
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.ip_address_range):
            query['IpAddressRange'] = request.ip_address_range
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.time_to_live_in_hours):
            query['TimeToLiveInHours'] = request.time_to_live_in_hours
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateActivation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateActivationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_activation(
        self,
        request: ecs_20140526_models.CreateActivationRequest,
    ) -> ecs_20140526_models.CreateActivationResponse:
        """
        After you use an activation code to register a server that is not provided by Alibaba Cloud as an Alibaba Cloud managed instance, you can use a variety of online services provided by Alibaba Cloud, such as Cloud Assistant, Operation Orchestration Service (OOS), and Apsara Devops, in the managed instance.
        A server that is not provided by Alibaba Cloud can be registered as an Alibaba Cloud managed instance only when the server can access the Internet and runs an operating system of one of the following versions:
        *   Alibaba Cloud Linux 2, Alibaba Cloud Linux 3, and later
        *   CentOS 6, CentOS 7, CentOS 8, and later
        *   Debian 8, Debian 9, Debian 10, and later
        *   Ubuntu 12, Ubuntu 14, Ubuntu 16, Ubuntu 18, and later
        *   CoreOS
        *   openSUSE
        *   Red Hat 5, Red Hat 6, Red Hat 7, and later
        *   SUSE Linux Enterprise Server (SLES) 11, SLES 12, SLES 15, and later
        *   Windows Server 2012, Windows Server 2016, Windows Server 2019, and later
        You can create up to 5,000 activation codes within a single Alibaba Cloud region. When the number of activation codes exceeds 1,000, the usage of activation codes must be greater than 50% before you can proceed to create more activation codes.
        > You can go to the **Cloud Assistant** page of the Elastic Compute Service (ECS) console and click **View Activation Codes** on the **Managed Instances** tab to query the usage data about activation codes.
        
        @param request: CreateActivationRequest
        @return: CreateActivationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_activation_with_options(request, runtime)

    async def create_activation_async(
        self,
        request: ecs_20140526_models.CreateActivationRequest,
    ) -> ecs_20140526_models.CreateActivationResponse:
        """
        After you use an activation code to register a server that is not provided by Alibaba Cloud as an Alibaba Cloud managed instance, you can use a variety of online services provided by Alibaba Cloud, such as Cloud Assistant, Operation Orchestration Service (OOS), and Apsara Devops, in the managed instance.
        A server that is not provided by Alibaba Cloud can be registered as an Alibaba Cloud managed instance only when the server can access the Internet and runs an operating system of one of the following versions:
        *   Alibaba Cloud Linux 2, Alibaba Cloud Linux 3, and later
        *   CentOS 6, CentOS 7, CentOS 8, and later
        *   Debian 8, Debian 9, Debian 10, and later
        *   Ubuntu 12, Ubuntu 14, Ubuntu 16, Ubuntu 18, and later
        *   CoreOS
        *   openSUSE
        *   Red Hat 5, Red Hat 6, Red Hat 7, and later
        *   SUSE Linux Enterprise Server (SLES) 11, SLES 12, SLES 15, and later
        *   Windows Server 2012, Windows Server 2016, Windows Server 2019, and later
        You can create up to 5,000 activation codes within a single Alibaba Cloud region. When the number of activation codes exceeds 1,000, the usage of activation codes must be greater than 50% before you can proceed to create more activation codes.
        > You can go to the **Cloud Assistant** page of the Elastic Compute Service (ECS) console and click **View Activation Codes** on the **Managed Instances** tab to query the usage data about activation codes.
        
        @param request: CreateActivationRequest
        @return: CreateActivationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_activation_with_options_async(request, runtime)

    def create_auto_provisioning_group_with_options(
        self,
        request: ecs_20140526_models.CreateAutoProvisioningGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateAutoProvisioningGroupResponse:
        """
        Auto Provisioning is a service that allows quick deployment of an instance cluster that consists of preemptible and pay-as-you-go instances. Auto Provisioning supports one-click deployment of instance clusters across different billing methods, instance families, and zones. For more information, see [Use auto provisioning group-related API operations to create multiple ECS instances at the same time](~~200772~~).
        * Auto Provisioning uses auto provisioning groups to schedule and maintain computing resources. You can use auto provisioning groups to obtain a steady supply of computing resources. This helps reduce the impact on computing capacity when preemptible instances are reclaimed.
        * Auto Provisioning is provided free-of-charge. However, you are charged for instance resources that are created in auto provisioning groups. For more information about the billing, see [Overview](~~52088~~) and [Pay-as-you-go](~~40653~~).
        * When you specify both the `LaunchTemplateId` and `LaunchConfiguration.*` parameters, the LaunchTemplateId parameter takes precedence.
        
        @param request: CreateAutoProvisioningGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoProvisioningGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_name):
            query['AutoProvisioningGroupName'] = request.auto_provisioning_group_name
        if not UtilClient.is_unset(request.auto_provisioning_group_type):
            query['AutoProvisioningGroupType'] = request.auto_provisioning_group_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.data_disk_config):
            query['DataDiskConfig'] = request.data_disk_config
        if not UtilClient.is_unset(request.default_target_capacity_type):
            query['DefaultTargetCapacityType'] = request.default_target_capacity_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.excess_capacity_termination_policy):
            query['ExcessCapacityTerminationPolicy'] = request.excess_capacity_termination_policy
        if not UtilClient.is_unset(request.hibernation_options_configured):
            query['HibernationOptionsConfigured'] = request.hibernation_options_configured
        if not UtilClient.is_unset(request.launch_template_config):
            query['LaunchTemplateConfig'] = request.launch_template_config
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_version):
            query['LaunchTemplateVersion'] = request.launch_template_version
        if not UtilClient.is_unset(request.max_spot_price):
            query['MaxSpotPrice'] = request.max_spot_price
        if not UtilClient.is_unset(request.min_target_capacity):
            query['MinTargetCapacity'] = request.min_target_capacity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_as_you_go_allocation_strategy):
            query['PayAsYouGoAllocationStrategy'] = request.pay_as_you_go_allocation_strategy
        if not UtilClient.is_unset(request.pay_as_you_go_target_capacity):
            query['PayAsYouGoTargetCapacity'] = request.pay_as_you_go_target_capacity
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spot_allocation_strategy):
            query['SpotAllocationStrategy'] = request.spot_allocation_strategy
        if not UtilClient.is_unset(request.spot_instance_interruption_behavior):
            query['SpotInstanceInterruptionBehavior'] = request.spot_instance_interruption_behavior
        if not UtilClient.is_unset(request.spot_instance_pools_to_use_count):
            query['SpotInstancePoolsToUseCount'] = request.spot_instance_pools_to_use_count
        if not UtilClient.is_unset(request.spot_target_capacity):
            query['SpotTargetCapacity'] = request.spot_target_capacity
        if not UtilClient.is_unset(request.system_disk_config):
            query['SystemDiskConfig'] = request.system_disk_config
        if not UtilClient.is_unset(request.terminate_instances):
            query['TerminateInstances'] = request.terminate_instances
        if not UtilClient.is_unset(request.terminate_instances_with_expiration):
            query['TerminateInstancesWithExpiration'] = request.terminate_instances_with_expiration
        if not UtilClient.is_unset(request.total_target_capacity):
            query['TotalTargetCapacity'] = request.total_target_capacity
        if not UtilClient.is_unset(request.valid_from):
            query['ValidFrom'] = request.valid_from
        if not UtilClient.is_unset(request.valid_until):
            query['ValidUntil'] = request.valid_until
        if not UtilClient.is_unset(request.launch_configuration):
            query['LaunchConfiguration'] = request.launch_configuration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoProvisioningGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateAutoProvisioningGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_auto_provisioning_group_with_options_async(
        self,
        request: ecs_20140526_models.CreateAutoProvisioningGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateAutoProvisioningGroupResponse:
        """
        Auto Provisioning is a service that allows quick deployment of an instance cluster that consists of preemptible and pay-as-you-go instances. Auto Provisioning supports one-click deployment of instance clusters across different billing methods, instance families, and zones. For more information, see [Use auto provisioning group-related API operations to create multiple ECS instances at the same time](~~200772~~).
        * Auto Provisioning uses auto provisioning groups to schedule and maintain computing resources. You can use auto provisioning groups to obtain a steady supply of computing resources. This helps reduce the impact on computing capacity when preemptible instances are reclaimed.
        * Auto Provisioning is provided free-of-charge. However, you are charged for instance resources that are created in auto provisioning groups. For more information about the billing, see [Overview](~~52088~~) and [Pay-as-you-go](~~40653~~).
        * When you specify both the `LaunchTemplateId` and `LaunchConfiguration.*` parameters, the LaunchTemplateId parameter takes precedence.
        
        @param request: CreateAutoProvisioningGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoProvisioningGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_name):
            query['AutoProvisioningGroupName'] = request.auto_provisioning_group_name
        if not UtilClient.is_unset(request.auto_provisioning_group_type):
            query['AutoProvisioningGroupType'] = request.auto_provisioning_group_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.data_disk_config):
            query['DataDiskConfig'] = request.data_disk_config
        if not UtilClient.is_unset(request.default_target_capacity_type):
            query['DefaultTargetCapacityType'] = request.default_target_capacity_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.excess_capacity_termination_policy):
            query['ExcessCapacityTerminationPolicy'] = request.excess_capacity_termination_policy
        if not UtilClient.is_unset(request.hibernation_options_configured):
            query['HibernationOptionsConfigured'] = request.hibernation_options_configured
        if not UtilClient.is_unset(request.launch_template_config):
            query['LaunchTemplateConfig'] = request.launch_template_config
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_version):
            query['LaunchTemplateVersion'] = request.launch_template_version
        if not UtilClient.is_unset(request.max_spot_price):
            query['MaxSpotPrice'] = request.max_spot_price
        if not UtilClient.is_unset(request.min_target_capacity):
            query['MinTargetCapacity'] = request.min_target_capacity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_as_you_go_allocation_strategy):
            query['PayAsYouGoAllocationStrategy'] = request.pay_as_you_go_allocation_strategy
        if not UtilClient.is_unset(request.pay_as_you_go_target_capacity):
            query['PayAsYouGoTargetCapacity'] = request.pay_as_you_go_target_capacity
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spot_allocation_strategy):
            query['SpotAllocationStrategy'] = request.spot_allocation_strategy
        if not UtilClient.is_unset(request.spot_instance_interruption_behavior):
            query['SpotInstanceInterruptionBehavior'] = request.spot_instance_interruption_behavior
        if not UtilClient.is_unset(request.spot_instance_pools_to_use_count):
            query['SpotInstancePoolsToUseCount'] = request.spot_instance_pools_to_use_count
        if not UtilClient.is_unset(request.spot_target_capacity):
            query['SpotTargetCapacity'] = request.spot_target_capacity
        if not UtilClient.is_unset(request.system_disk_config):
            query['SystemDiskConfig'] = request.system_disk_config
        if not UtilClient.is_unset(request.terminate_instances):
            query['TerminateInstances'] = request.terminate_instances
        if not UtilClient.is_unset(request.terminate_instances_with_expiration):
            query['TerminateInstancesWithExpiration'] = request.terminate_instances_with_expiration
        if not UtilClient.is_unset(request.total_target_capacity):
            query['TotalTargetCapacity'] = request.total_target_capacity
        if not UtilClient.is_unset(request.valid_from):
            query['ValidFrom'] = request.valid_from
        if not UtilClient.is_unset(request.valid_until):
            query['ValidUntil'] = request.valid_until
        if not UtilClient.is_unset(request.launch_configuration):
            query['LaunchConfiguration'] = request.launch_configuration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoProvisioningGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateAutoProvisioningGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_auto_provisioning_group(
        self,
        request: ecs_20140526_models.CreateAutoProvisioningGroupRequest,
    ) -> ecs_20140526_models.CreateAutoProvisioningGroupResponse:
        """
        Auto Provisioning is a service that allows quick deployment of an instance cluster that consists of preemptible and pay-as-you-go instances. Auto Provisioning supports one-click deployment of instance clusters across different billing methods, instance families, and zones. For more information, see [Use auto provisioning group-related API operations to create multiple ECS instances at the same time](~~200772~~).
        * Auto Provisioning uses auto provisioning groups to schedule and maintain computing resources. You can use auto provisioning groups to obtain a steady supply of computing resources. This helps reduce the impact on computing capacity when preemptible instances are reclaimed.
        * Auto Provisioning is provided free-of-charge. However, you are charged for instance resources that are created in auto provisioning groups. For more information about the billing, see [Overview](~~52088~~) and [Pay-as-you-go](~~40653~~).
        * When you specify both the `LaunchTemplateId` and `LaunchConfiguration.*` parameters, the LaunchTemplateId parameter takes precedence.
        
        @param request: CreateAutoProvisioningGroupRequest
        @return: CreateAutoProvisioningGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_auto_provisioning_group_with_options(request, runtime)

    async def create_auto_provisioning_group_async(
        self,
        request: ecs_20140526_models.CreateAutoProvisioningGroupRequest,
    ) -> ecs_20140526_models.CreateAutoProvisioningGroupResponse:
        """
        Auto Provisioning is a service that allows quick deployment of an instance cluster that consists of preemptible and pay-as-you-go instances. Auto Provisioning supports one-click deployment of instance clusters across different billing methods, instance families, and zones. For more information, see [Use auto provisioning group-related API operations to create multiple ECS instances at the same time](~~200772~~).
        * Auto Provisioning uses auto provisioning groups to schedule and maintain computing resources. You can use auto provisioning groups to obtain a steady supply of computing resources. This helps reduce the impact on computing capacity when preemptible instances are reclaimed.
        * Auto Provisioning is provided free-of-charge. However, you are charged for instance resources that are created in auto provisioning groups. For more information about the billing, see [Overview](~~52088~~) and [Pay-as-you-go](~~40653~~).
        * When you specify both the `LaunchTemplateId` and `LaunchConfiguration.*` parameters, the LaunchTemplateId parameter takes precedence.
        
        @param request: CreateAutoProvisioningGroupRequest
        @return: CreateAutoProvisioningGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_auto_provisioning_group_with_options_async(request, runtime)

    def create_auto_snapshot_policy_with_options(
        self,
        request: ecs_20140526_models.CreateAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateAutoSnapshotPolicyResponse:
        """
        When you call this operation to create an automatic snapshot policy, you can specify the days of the week on which to create automatic snapshots, the retention period of the automatic snapshots, and cross-region replication for snapshots in the policy to meet your diverse data backup requirements. After you create an automatic snapshot policy, you must call the [ApplyAutoSnapshotPolicy](~~25531~~) operation to apply it to disks. If you want to modify the automatic snapshot policy, you must call the [ModifyAutoSnapshotPolicyEx](~~25529~~) operation.
        When you call this operation, take note of the following items:
        *   You can create a maximum of 100 automatic snapshot policies within each region for a single Alibaba Cloud account.
        *   If an automatic snapshot is being created when the time scheduled for creating another automatic snapshot is due, the new snapshot task is skipped. This may occur when a disk contains a large volume of data. For example, you have scheduled snapshots to be created at 09:00:00, 10:00:00, 11:00:00, and 12:00:00 for a disk. The system starts to create a snapshot for the disk at 09:00:00. The process takes 80 minutes because the disk contains a large volume of data and ends at 10:20:00. The system skips the automatic snapshot task scheduled for 10:00:00 and creates the next automatic snapshot for the disk at 11:00:00.
        *   For information about how to copy a snapshot from one region to another, see the "Background information" section in [Copy a snapshot](~~159441~~).
        
        @param request: CreateAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.copied_snapshots_retention_days):
            query['CopiedSnapshotsRetentionDays'] = request.copied_snapshots_retention_days
        if not UtilClient.is_unset(request.enable_cross_region_copy):
            query['EnableCrossRegionCopy'] = request.enable_cross_region_copy
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.target_copy_regions):
            query['TargetCopyRegions'] = request.target_copy_regions
        if not UtilClient.is_unset(request.auto_snapshot_policy_name):
            query['autoSnapshotPolicyName'] = request.auto_snapshot_policy_name
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_weekdays):
            query['repeatWeekdays'] = request.repeat_weekdays
        if not UtilClient.is_unset(request.retention_days):
            query['retentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.time_points):
            query['timePoints'] = request.time_points
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateAutoSnapshotPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_auto_snapshot_policy_with_options_async(
        self,
        request: ecs_20140526_models.CreateAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateAutoSnapshotPolicyResponse:
        """
        When you call this operation to create an automatic snapshot policy, you can specify the days of the week on which to create automatic snapshots, the retention period of the automatic snapshots, and cross-region replication for snapshots in the policy to meet your diverse data backup requirements. After you create an automatic snapshot policy, you must call the [ApplyAutoSnapshotPolicy](~~25531~~) operation to apply it to disks. If you want to modify the automatic snapshot policy, you must call the [ModifyAutoSnapshotPolicyEx](~~25529~~) operation.
        When you call this operation, take note of the following items:
        *   You can create a maximum of 100 automatic snapshot policies within each region for a single Alibaba Cloud account.
        *   If an automatic snapshot is being created when the time scheduled for creating another automatic snapshot is due, the new snapshot task is skipped. This may occur when a disk contains a large volume of data. For example, you have scheduled snapshots to be created at 09:00:00, 10:00:00, 11:00:00, and 12:00:00 for a disk. The system starts to create a snapshot for the disk at 09:00:00. The process takes 80 minutes because the disk contains a large volume of data and ends at 10:20:00. The system skips the automatic snapshot task scheduled for 10:00:00 and creates the next automatic snapshot for the disk at 11:00:00.
        *   For information about how to copy a snapshot from one region to another, see the "Background information" section in [Copy a snapshot](~~159441~~).
        
        @param request: CreateAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.copied_snapshots_retention_days):
            query['CopiedSnapshotsRetentionDays'] = request.copied_snapshots_retention_days
        if not UtilClient.is_unset(request.enable_cross_region_copy):
            query['EnableCrossRegionCopy'] = request.enable_cross_region_copy
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.target_copy_regions):
            query['TargetCopyRegions'] = request.target_copy_regions
        if not UtilClient.is_unset(request.auto_snapshot_policy_name):
            query['autoSnapshotPolicyName'] = request.auto_snapshot_policy_name
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_weekdays):
            query['repeatWeekdays'] = request.repeat_weekdays
        if not UtilClient.is_unset(request.retention_days):
            query['retentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.time_points):
            query['timePoints'] = request.time_points
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateAutoSnapshotPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_auto_snapshot_policy(
        self,
        request: ecs_20140526_models.CreateAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.CreateAutoSnapshotPolicyResponse:
        """
        When you call this operation to create an automatic snapshot policy, you can specify the days of the week on which to create automatic snapshots, the retention period of the automatic snapshots, and cross-region replication for snapshots in the policy to meet your diverse data backup requirements. After you create an automatic snapshot policy, you must call the [ApplyAutoSnapshotPolicy](~~25531~~) operation to apply it to disks. If you want to modify the automatic snapshot policy, you must call the [ModifyAutoSnapshotPolicyEx](~~25529~~) operation.
        When you call this operation, take note of the following items:
        *   You can create a maximum of 100 automatic snapshot policies within each region for a single Alibaba Cloud account.
        *   If an automatic snapshot is being created when the time scheduled for creating another automatic snapshot is due, the new snapshot task is skipped. This may occur when a disk contains a large volume of data. For example, you have scheduled snapshots to be created at 09:00:00, 10:00:00, 11:00:00, and 12:00:00 for a disk. The system starts to create a snapshot for the disk at 09:00:00. The process takes 80 minutes because the disk contains a large volume of data and ends at 10:20:00. The system skips the automatic snapshot task scheduled for 10:00:00 and creates the next automatic snapshot for the disk at 11:00:00.
        *   For information about how to copy a snapshot from one region to another, see the "Background information" section in [Copy a snapshot](~~159441~~).
        
        @param request: CreateAutoSnapshotPolicyRequest
        @return: CreateAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_auto_snapshot_policy_with_options(request, runtime)

    async def create_auto_snapshot_policy_async(
        self,
        request: ecs_20140526_models.CreateAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.CreateAutoSnapshotPolicyResponse:
        """
        When you call this operation to create an automatic snapshot policy, you can specify the days of the week on which to create automatic snapshots, the retention period of the automatic snapshots, and cross-region replication for snapshots in the policy to meet your diverse data backup requirements. After you create an automatic snapshot policy, you must call the [ApplyAutoSnapshotPolicy](~~25531~~) operation to apply it to disks. If you want to modify the automatic snapshot policy, you must call the [ModifyAutoSnapshotPolicyEx](~~25529~~) operation.
        When you call this operation, take note of the following items:
        *   You can create a maximum of 100 automatic snapshot policies within each region for a single Alibaba Cloud account.
        *   If an automatic snapshot is being created when the time scheduled for creating another automatic snapshot is due, the new snapshot task is skipped. This may occur when a disk contains a large volume of data. For example, you have scheduled snapshots to be created at 09:00:00, 10:00:00, 11:00:00, and 12:00:00 for a disk. The system starts to create a snapshot for the disk at 09:00:00. The process takes 80 minutes because the disk contains a large volume of data and ends at 10:20:00. The system skips the automatic snapshot task scheduled for 10:00:00 and creates the next automatic snapshot for the disk at 11:00:00.
        *   For information about how to copy a snapshot from one region to another, see the "Background information" section in [Copy a snapshot](~~159441~~).
        
        @param request: CreateAutoSnapshotPolicyRequest
        @return: CreateAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_auto_snapshot_policy_with_options_async(request, runtime)

    def create_capacity_reservation_with_options(
        self,
        request: ecs_20140526_models.CreateCapacityReservationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateCapacityReservationResponse:
        """
        ## Description
        When you create a capacity reservation, you can specify attributes such as the zone and instance type. The system uses a private pool to reserve resources that match the specified attributes. For more information, see [Overview of Immediate Capacity Reservation](~~193633~~).
        *   Only immediate capacity reservations are supported. Immediate capacity reservations immediately take effect after they are purchased. After you purchase an immediate capacity reservation, the instance type is billed on a pay-as-you-go basis, regardless of whether you use the capacity reservation to create pay-as-you-go instances. Billing stops until you manually release the capacity reservation or until the capacity reservation is automatically released when it expires.
        *   You can call the [CreateInstance](~~25499~~) or [RunInstances](~~63440~~) operation to configure a private pool when you create instances. You can also call the [ModifyInstanceAttachmentAttributes](~~190006~~) operation to modify the attributes of a private pool. When an instance matches a private pool, you are charged based on the configurations of the instance such as the instance type, disks, and public bandwidth.
        *   If no pay-as-you-go instance is created, you are charged only for the instance type.
        *   Savings plans or regional reserved instances can be applied to offset the hourly bills of the unused capacity of immediate capacity reservations and the hourly bills of the instances that match immediate capacity reservations. Zonal reserved instances cannot be applied to offset these bills. We recommend that you purchase reserved instances or savings plans before you use immediate capacity reservations. This way, you can obtain assured resource reservations for free.
        
        @param request: CreateCapacityReservationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCapacityReservationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_time_type):
            query['EndTimeType'] = request.end_time_type
        if not UtilClient.is_unset(request.instance_amount):
            query['InstanceAmount'] = request.instance_amount
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCapacityReservation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateCapacityReservationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_capacity_reservation_with_options_async(
        self,
        request: ecs_20140526_models.CreateCapacityReservationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateCapacityReservationResponse:
        """
        ## Description
        When you create a capacity reservation, you can specify attributes such as the zone and instance type. The system uses a private pool to reserve resources that match the specified attributes. For more information, see [Overview of Immediate Capacity Reservation](~~193633~~).
        *   Only immediate capacity reservations are supported. Immediate capacity reservations immediately take effect after they are purchased. After you purchase an immediate capacity reservation, the instance type is billed on a pay-as-you-go basis, regardless of whether you use the capacity reservation to create pay-as-you-go instances. Billing stops until you manually release the capacity reservation or until the capacity reservation is automatically released when it expires.
        *   You can call the [CreateInstance](~~25499~~) or [RunInstances](~~63440~~) operation to configure a private pool when you create instances. You can also call the [ModifyInstanceAttachmentAttributes](~~190006~~) operation to modify the attributes of a private pool. When an instance matches a private pool, you are charged based on the configurations of the instance such as the instance type, disks, and public bandwidth.
        *   If no pay-as-you-go instance is created, you are charged only for the instance type.
        *   Savings plans or regional reserved instances can be applied to offset the hourly bills of the unused capacity of immediate capacity reservations and the hourly bills of the instances that match immediate capacity reservations. Zonal reserved instances cannot be applied to offset these bills. We recommend that you purchase reserved instances or savings plans before you use immediate capacity reservations. This way, you can obtain assured resource reservations for free.
        
        @param request: CreateCapacityReservationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCapacityReservationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_time_type):
            query['EndTimeType'] = request.end_time_type
        if not UtilClient.is_unset(request.instance_amount):
            query['InstanceAmount'] = request.instance_amount
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCapacityReservation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateCapacityReservationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_capacity_reservation(
        self,
        request: ecs_20140526_models.CreateCapacityReservationRequest,
    ) -> ecs_20140526_models.CreateCapacityReservationResponse:
        """
        ## Description
        When you create a capacity reservation, you can specify attributes such as the zone and instance type. The system uses a private pool to reserve resources that match the specified attributes. For more information, see [Overview of Immediate Capacity Reservation](~~193633~~).
        *   Only immediate capacity reservations are supported. Immediate capacity reservations immediately take effect after they are purchased. After you purchase an immediate capacity reservation, the instance type is billed on a pay-as-you-go basis, regardless of whether you use the capacity reservation to create pay-as-you-go instances. Billing stops until you manually release the capacity reservation or until the capacity reservation is automatically released when it expires.
        *   You can call the [CreateInstance](~~25499~~) or [RunInstances](~~63440~~) operation to configure a private pool when you create instances. You can also call the [ModifyInstanceAttachmentAttributes](~~190006~~) operation to modify the attributes of a private pool. When an instance matches a private pool, you are charged based on the configurations of the instance such as the instance type, disks, and public bandwidth.
        *   If no pay-as-you-go instance is created, you are charged only for the instance type.
        *   Savings plans or regional reserved instances can be applied to offset the hourly bills of the unused capacity of immediate capacity reservations and the hourly bills of the instances that match immediate capacity reservations. Zonal reserved instances cannot be applied to offset these bills. We recommend that you purchase reserved instances or savings plans before you use immediate capacity reservations. This way, you can obtain assured resource reservations for free.
        
        @param request: CreateCapacityReservationRequest
        @return: CreateCapacityReservationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_capacity_reservation_with_options(request, runtime)

    async def create_capacity_reservation_async(
        self,
        request: ecs_20140526_models.CreateCapacityReservationRequest,
    ) -> ecs_20140526_models.CreateCapacityReservationResponse:
        """
        ## Description
        When you create a capacity reservation, you can specify attributes such as the zone and instance type. The system uses a private pool to reserve resources that match the specified attributes. For more information, see [Overview of Immediate Capacity Reservation](~~193633~~).
        *   Only immediate capacity reservations are supported. Immediate capacity reservations immediately take effect after they are purchased. After you purchase an immediate capacity reservation, the instance type is billed on a pay-as-you-go basis, regardless of whether you use the capacity reservation to create pay-as-you-go instances. Billing stops until you manually release the capacity reservation or until the capacity reservation is automatically released when it expires.
        *   You can call the [CreateInstance](~~25499~~) or [RunInstances](~~63440~~) operation to configure a private pool when you create instances. You can also call the [ModifyInstanceAttachmentAttributes](~~190006~~) operation to modify the attributes of a private pool. When an instance matches a private pool, you are charged based on the configurations of the instance such as the instance type, disks, and public bandwidth.
        *   If no pay-as-you-go instance is created, you are charged only for the instance type.
        *   Savings plans or regional reserved instances can be applied to offset the hourly bills of the unused capacity of immediate capacity reservations and the hourly bills of the instances that match immediate capacity reservations. Zonal reserved instances cannot be applied to offset these bills. We recommend that you purchase reserved instances or savings plans before you use immediate capacity reservations. This way, you can obtain assured resource reservations for free.
        
        @param request: CreateCapacityReservationRequest
        @return: CreateCapacityReservationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_capacity_reservation_with_options_async(request, runtime)

    def create_command_with_options(
        self,
        request: ecs_20140526_models.CreateCommandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateCommandResponse:
        """
        You can create commands of the following types:
        *   RunBatScript: batch commands. These commands are applicable to Windows instances.
        *   RunPowerShellScript: PowerShell commands. These commands are applicable to Windows instances.
        *   RunShellScript: shell commands. These commands are applicable to Linux instances.
        *   You can specify the TimeOut parameter to set the maximum timeout period for executions of a command on Elastic Compute Service (ECS) instances. If an execution times out, the Cloud Assistant client forcefully terminates the command process by canceling the process ID (PID) of the command. For more information, see [Install the Cloud Assistant client](~~64921~~).
        *   When the one-time execution of a command times out, the execution state ([InvokeRecordStatus](~~64845~~)) of the command becomes Failed.
        *   For a scheduled task, take note of the following items:
        *   The timeout period takes effect on each execution of the command.
        *   When a scheduled execution of a command times out, the execution state ([InvokeRecordStatus](~~64845~~)) of the command becomes Failed.
        *   The timeout of one execution does not affect the subsequent executions of the command.
        *   You can retain up to 500 to 10,000 Cloud Assistant commands in each region.
        *   You can use the WorkingDir parameter to specify the working directory of a Cloud Assistant command. For Linux instances, the default working directory of a command is the home directory of the root user, which is `/root`. For Windows instances, the default working directory of a command is the directory where the Cloud Assistant client process resides, such as `C:\\Windows\\System32`.
        *   You can enable the custom parameter feature for a Cloud Assistant command by setting EnableParameter to true when you create the command. When you configure the CommandContent parameter, you can define custom parameters in the {{parameter}} format. Then, when the [InvokeCommand](~~64841~~) operation is called, the key-value pairs of custom parameters are passed in. For example, assume that the command content is `echo {{name}}`. You can use the Parameters parameter to pass in the `<name, Jack>` key-value pair when the InvokeCommand operation is called. The name key of the custom parameter is automatically replaced by the paired Jack value to generate a new command. Therefore, the `echo Jack` command is actually run.
        
        @param request: CreateCommandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_content):
            query['CommandContent'] = request.command_content
        if not UtilClient.is_unset(request.content_encoding):
            query['ContentEncoding'] = request.content_encoding
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_parameter):
            query['EnableParameter'] = request.enable_parameter
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.working_dir):
            query['WorkingDir'] = request.working_dir
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCommand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateCommandResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_command_with_options_async(
        self,
        request: ecs_20140526_models.CreateCommandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateCommandResponse:
        """
        You can create commands of the following types:
        *   RunBatScript: batch commands. These commands are applicable to Windows instances.
        *   RunPowerShellScript: PowerShell commands. These commands are applicable to Windows instances.
        *   RunShellScript: shell commands. These commands are applicable to Linux instances.
        *   You can specify the TimeOut parameter to set the maximum timeout period for executions of a command on Elastic Compute Service (ECS) instances. If an execution times out, the Cloud Assistant client forcefully terminates the command process by canceling the process ID (PID) of the command. For more information, see [Install the Cloud Assistant client](~~64921~~).
        *   When the one-time execution of a command times out, the execution state ([InvokeRecordStatus](~~64845~~)) of the command becomes Failed.
        *   For a scheduled task, take note of the following items:
        *   The timeout period takes effect on each execution of the command.
        *   When a scheduled execution of a command times out, the execution state ([InvokeRecordStatus](~~64845~~)) of the command becomes Failed.
        *   The timeout of one execution does not affect the subsequent executions of the command.
        *   You can retain up to 500 to 10,000 Cloud Assistant commands in each region.
        *   You can use the WorkingDir parameter to specify the working directory of a Cloud Assistant command. For Linux instances, the default working directory of a command is the home directory of the root user, which is `/root`. For Windows instances, the default working directory of a command is the directory where the Cloud Assistant client process resides, such as `C:\\Windows\\System32`.
        *   You can enable the custom parameter feature for a Cloud Assistant command by setting EnableParameter to true when you create the command. When you configure the CommandContent parameter, you can define custom parameters in the {{parameter}} format. Then, when the [InvokeCommand](~~64841~~) operation is called, the key-value pairs of custom parameters are passed in. For example, assume that the command content is `echo {{name}}`. You can use the Parameters parameter to pass in the `<name, Jack>` key-value pair when the InvokeCommand operation is called. The name key of the custom parameter is automatically replaced by the paired Jack value to generate a new command. Therefore, the `echo Jack` command is actually run.
        
        @param request: CreateCommandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_content):
            query['CommandContent'] = request.command_content
        if not UtilClient.is_unset(request.content_encoding):
            query['ContentEncoding'] = request.content_encoding
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_parameter):
            query['EnableParameter'] = request.enable_parameter
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.working_dir):
            query['WorkingDir'] = request.working_dir
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCommand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateCommandResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_command(
        self,
        request: ecs_20140526_models.CreateCommandRequest,
    ) -> ecs_20140526_models.CreateCommandResponse:
        """
        You can create commands of the following types:
        *   RunBatScript: batch commands. These commands are applicable to Windows instances.
        *   RunPowerShellScript: PowerShell commands. These commands are applicable to Windows instances.
        *   RunShellScript: shell commands. These commands are applicable to Linux instances.
        *   You can specify the TimeOut parameter to set the maximum timeout period for executions of a command on Elastic Compute Service (ECS) instances. If an execution times out, the Cloud Assistant client forcefully terminates the command process by canceling the process ID (PID) of the command. For more information, see [Install the Cloud Assistant client](~~64921~~).
        *   When the one-time execution of a command times out, the execution state ([InvokeRecordStatus](~~64845~~)) of the command becomes Failed.
        *   For a scheduled task, take note of the following items:
        *   The timeout period takes effect on each execution of the command.
        *   When a scheduled execution of a command times out, the execution state ([InvokeRecordStatus](~~64845~~)) of the command becomes Failed.
        *   The timeout of one execution does not affect the subsequent executions of the command.
        *   You can retain up to 500 to 10,000 Cloud Assistant commands in each region.
        *   You can use the WorkingDir parameter to specify the working directory of a Cloud Assistant command. For Linux instances, the default working directory of a command is the home directory of the root user, which is `/root`. For Windows instances, the default working directory of a command is the directory where the Cloud Assistant client process resides, such as `C:\\Windows\\System32`.
        *   You can enable the custom parameter feature for a Cloud Assistant command by setting EnableParameter to true when you create the command. When you configure the CommandContent parameter, you can define custom parameters in the {{parameter}} format. Then, when the [InvokeCommand](~~64841~~) operation is called, the key-value pairs of custom parameters are passed in. For example, assume that the command content is `echo {{name}}`. You can use the Parameters parameter to pass in the `<name, Jack>` key-value pair when the InvokeCommand operation is called. The name key of the custom parameter is automatically replaced by the paired Jack value to generate a new command. Therefore, the `echo Jack` command is actually run.
        
        @param request: CreateCommandRequest
        @return: CreateCommandResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_command_with_options(request, runtime)

    async def create_command_async(
        self,
        request: ecs_20140526_models.CreateCommandRequest,
    ) -> ecs_20140526_models.CreateCommandResponse:
        """
        You can create commands of the following types:
        *   RunBatScript: batch commands. These commands are applicable to Windows instances.
        *   RunPowerShellScript: PowerShell commands. These commands are applicable to Windows instances.
        *   RunShellScript: shell commands. These commands are applicable to Linux instances.
        *   You can specify the TimeOut parameter to set the maximum timeout period for executions of a command on Elastic Compute Service (ECS) instances. If an execution times out, the Cloud Assistant client forcefully terminates the command process by canceling the process ID (PID) of the command. For more information, see [Install the Cloud Assistant client](~~64921~~).
        *   When the one-time execution of a command times out, the execution state ([InvokeRecordStatus](~~64845~~)) of the command becomes Failed.
        *   For a scheduled task, take note of the following items:
        *   The timeout period takes effect on each execution of the command.
        *   When a scheduled execution of a command times out, the execution state ([InvokeRecordStatus](~~64845~~)) of the command becomes Failed.
        *   The timeout of one execution does not affect the subsequent executions of the command.
        *   You can retain up to 500 to 10,000 Cloud Assistant commands in each region.
        *   You can use the WorkingDir parameter to specify the working directory of a Cloud Assistant command. For Linux instances, the default working directory of a command is the home directory of the root user, which is `/root`. For Windows instances, the default working directory of a command is the directory where the Cloud Assistant client process resides, such as `C:\\Windows\\System32`.
        *   You can enable the custom parameter feature for a Cloud Assistant command by setting EnableParameter to true when you create the command. When you configure the CommandContent parameter, you can define custom parameters in the {{parameter}} format. Then, when the [InvokeCommand](~~64841~~) operation is called, the key-value pairs of custom parameters are passed in. For example, assume that the command content is `echo {{name}}`. You can use the Parameters parameter to pass in the `<name, Jack>` key-value pair when the InvokeCommand operation is called. The name key of the custom parameter is automatically replaced by the paired Jack value to generate a new command. Therefore, the `echo Jack` command is actually run.
        
        @param request: CreateCommandRequest
        @return: CreateCommandResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_command_with_options_async(request, runtime)

    def create_dedicated_host_cluster_with_options(
        self,
        request: ecs_20140526_models.CreateDedicatedHostClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDedicatedHostClusterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_name):
            query['DedicatedHostClusterName'] = request.dedicated_host_cluster_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDedicatedHostCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDedicatedHostClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dedicated_host_cluster_with_options_async(
        self,
        request: ecs_20140526_models.CreateDedicatedHostClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDedicatedHostClusterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_name):
            query['DedicatedHostClusterName'] = request.dedicated_host_cluster_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDedicatedHostCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDedicatedHostClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dedicated_host_cluster(
        self,
        request: ecs_20140526_models.CreateDedicatedHostClusterRequest,
    ) -> ecs_20140526_models.CreateDedicatedHostClusterResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_dedicated_host_cluster_with_options(request, runtime)

    async def create_dedicated_host_cluster_async(
        self,
        request: ecs_20140526_models.CreateDedicatedHostClusterRequest,
    ) -> ecs_20140526_models.CreateDedicatedHostClusterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_dedicated_host_cluster_with_options_async(request, runtime)

    def create_demand_with_options(
        self,
        request: ecs_20140526_models.CreateDemandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDemandResponse:
        """
        ## Description
        You can call this operation to submit the instance type requirement information. Alibaba Cloud will provide the required resources based on your requirement forms.
        Only I/O optimized instance types and VPC-type instances can be filed.
        >  This operation is in internal preview and has not been officially released. We recommend that you avoid using this operation.
        
        @param request: CreateDemandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDemandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.demand_description):
            query['DemandDescription'] = request.demand_description
        if not UtilClient.is_unset(request.demand_name):
            query['DemandName'] = request.demand_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDemand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDemandResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_demand_with_options_async(
        self,
        request: ecs_20140526_models.CreateDemandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDemandResponse:
        """
        ## Description
        You can call this operation to submit the instance type requirement information. Alibaba Cloud will provide the required resources based on your requirement forms.
        Only I/O optimized instance types and VPC-type instances can be filed.
        >  This operation is in internal preview and has not been officially released. We recommend that you avoid using this operation.
        
        @param request: CreateDemandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDemandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.amount):
            query['Amount'] = request.amount
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.demand_description):
            query['DemandDescription'] = request.demand_description
        if not UtilClient.is_unset(request.demand_name):
            query['DemandName'] = request.demand_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDemand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDemandResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_demand(
        self,
        request: ecs_20140526_models.CreateDemandRequest,
    ) -> ecs_20140526_models.CreateDemandResponse:
        """
        ## Description
        You can call this operation to submit the instance type requirement information. Alibaba Cloud will provide the required resources based on your requirement forms.
        Only I/O optimized instance types and VPC-type instances can be filed.
        >  This operation is in internal preview and has not been officially released. We recommend that you avoid using this operation.
        
        @param request: CreateDemandRequest
        @return: CreateDemandResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_demand_with_options(request, runtime)

    async def create_demand_async(
        self,
        request: ecs_20140526_models.CreateDemandRequest,
    ) -> ecs_20140526_models.CreateDemandResponse:
        """
        ## Description
        You can call this operation to submit the instance type requirement information. Alibaba Cloud will provide the required resources based on your requirement forms.
        Only I/O optimized instance types and VPC-type instances can be filed.
        >  This operation is in internal preview and has not been officially released. We recommend that you avoid using this operation.
        
        @param request: CreateDemandRequest
        @return: CreateDemandResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_demand_with_options_async(request, runtime)

    def create_deployment_set_with_options(
        self,
        request: ecs_20140526_models.CreateDeploymentSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDeploymentSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.deployment_set_name):
            query['DeploymentSetName'] = request.deployment_set_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.granularity):
            query['Granularity'] = request.granularity
        if not UtilClient.is_unset(request.group_count):
            query['GroupCount'] = request.group_count
        if not UtilClient.is_unset(request.on_unable_to_redeploy_failed_instance):
            query['OnUnableToRedeployFailedInstance'] = request.on_unable_to_redeploy_failed_instance
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDeploymentSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDeploymentSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_deployment_set_with_options_async(
        self,
        request: ecs_20140526_models.CreateDeploymentSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDeploymentSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.deployment_set_name):
            query['DeploymentSetName'] = request.deployment_set_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.granularity):
            query['Granularity'] = request.granularity
        if not UtilClient.is_unset(request.group_count):
            query['GroupCount'] = request.group_count
        if not UtilClient.is_unset(request.on_unable_to_redeploy_failed_instance):
            query['OnUnableToRedeployFailedInstance'] = request.on_unable_to_redeploy_failed_instance
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDeploymentSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDeploymentSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_deployment_set(
        self,
        request: ecs_20140526_models.CreateDeploymentSetRequest,
    ) -> ecs_20140526_models.CreateDeploymentSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_deployment_set_with_options(request, runtime)

    async def create_deployment_set_async(
        self,
        request: ecs_20140526_models.CreateDeploymentSetRequest,
    ) -> ecs_20140526_models.CreateDeploymentSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_deployment_set_with_options_async(request, runtime)

    def create_diagnostic_metric_set_with_options(
        self,
        request: ecs_20140526_models.CreateDiagnosticMetricSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiagnosticMetricSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.metric_ids):
            query['MetricIds'] = request.metric_ids
        if not UtilClient.is_unset(request.metric_set_name):
            query['MetricSetName'] = request.metric_set_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiagnosticMetricSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiagnosticMetricSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_diagnostic_metric_set_with_options_async(
        self,
        request: ecs_20140526_models.CreateDiagnosticMetricSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiagnosticMetricSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.metric_ids):
            query['MetricIds'] = request.metric_ids
        if not UtilClient.is_unset(request.metric_set_name):
            query['MetricSetName'] = request.metric_set_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiagnosticMetricSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiagnosticMetricSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_diagnostic_metric_set(
        self,
        request: ecs_20140526_models.CreateDiagnosticMetricSetRequest,
    ) -> ecs_20140526_models.CreateDiagnosticMetricSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_diagnostic_metric_set_with_options(request, runtime)

    async def create_diagnostic_metric_set_async(
        self,
        request: ecs_20140526_models.CreateDiagnosticMetricSetRequest,
    ) -> ecs_20140526_models.CreateDiagnosticMetricSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_diagnostic_metric_set_with_options_async(request, runtime)

    def create_diagnostic_report_with_options(
        self,
        request: ecs_20140526_models.CreateDiagnosticReportRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiagnosticReportResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.metric_set_id):
            query['MetricSetId'] = request.metric_set_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiagnosticReport',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiagnosticReportResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_diagnostic_report_with_options_async(
        self,
        request: ecs_20140526_models.CreateDiagnosticReportRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiagnosticReportResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.metric_set_id):
            query['MetricSetId'] = request.metric_set_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiagnosticReport',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiagnosticReportResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_diagnostic_report(
        self,
        request: ecs_20140526_models.CreateDiagnosticReportRequest,
    ) -> ecs_20140526_models.CreateDiagnosticReportResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_diagnostic_report_with_options(request, runtime)

    async def create_diagnostic_report_async(
        self,
        request: ecs_20140526_models.CreateDiagnosticReportRequest,
    ) -> ecs_20140526_models.CreateDiagnosticReportResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_diagnostic_report_with_options_async(request, runtime)

    def create_disk_with_options(
        self,
        request: ecs_20140526_models.CreateDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiskResponse:
        """
        ## Description
        *   You can enable the multi-attach feature when you create a disk. We recommend that you first understand this feature and its limits. For more information, see [NVMe protocol](~~256487~~) and [Use the multi-attach feature](~~262105~~).
        <!---->
        *   The disk can be a basic disk, an ultra disk, a standard SSD, or an enhanced SSD (ESSD).
        *   When you create disks, you may be charged for the resources used. We recommend that you understand the Elastic Compute Service (ECS) billing methods before you create a disk. For more information, see [Billing overview](~~25398~~).
        *   By default, the `DeleteAutoSnapshot` parameter is set to `true` when a disk is created. This indicates that when the disk is released, its automatic snapshots are also deleted. You can call the [ModifyDiskAttribute](~~25517~~) operation to modify the parameter.
        *   If you do not configure the performance level when you create an ESSD, the performance level for the ESSD is PL1 by default. You can call the [ModifyDiskSpec](~~123780~~) operation to modify the performance level of the ESSD.
        *   By default, for a disk that is created by calling the CreateDisk operation, the `Portable` attribute is set to `true` and the billing method is pay-as-you-go.
        
        @param request: CreateDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.advanced_features):
            query['AdvancedFeatures'] = request.advanced_features
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.bursting_enabled):
            query['BurstingEnabled'] = request.bursting_enabled
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_category):
            query['DiskCategory'] = request.disk_category
        if not UtilClient.is_unset(request.disk_name):
            query['DiskName'] = request.disk_name
        if not UtilClient.is_unset(request.encrypt_algorithm):
            query['EncryptAlgorithm'] = request.encrypt_algorithm
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.multi_attach):
            query['MultiAttach'] = request.multi_attach
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.performance_level):
            query['PerformanceLevel'] = request.performance_level
        if not UtilClient.is_unset(request.provisioned_iops):
            query['ProvisionedIops'] = request.provisioned_iops
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.size):
            query['Size'] = request.size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.storage_cluster_id):
            query['StorageClusterId'] = request.storage_cluster_id
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        if not UtilClient.is_unset(request.storage_set_partition_number):
            query['StorageSetPartitionNumber'] = request.storage_set_partition_number
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_disk_with_options_async(
        self,
        request: ecs_20140526_models.CreateDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiskResponse:
        """
        ## Description
        *   You can enable the multi-attach feature when you create a disk. We recommend that you first understand this feature and its limits. For more information, see [NVMe protocol](~~256487~~) and [Use the multi-attach feature](~~262105~~).
        <!---->
        *   The disk can be a basic disk, an ultra disk, a standard SSD, or an enhanced SSD (ESSD).
        *   When you create disks, you may be charged for the resources used. We recommend that you understand the Elastic Compute Service (ECS) billing methods before you create a disk. For more information, see [Billing overview](~~25398~~).
        *   By default, the `DeleteAutoSnapshot` parameter is set to `true` when a disk is created. This indicates that when the disk is released, its automatic snapshots are also deleted. You can call the [ModifyDiskAttribute](~~25517~~) operation to modify the parameter.
        *   If you do not configure the performance level when you create an ESSD, the performance level for the ESSD is PL1 by default. You can call the [ModifyDiskSpec](~~123780~~) operation to modify the performance level of the ESSD.
        *   By default, for a disk that is created by calling the CreateDisk operation, the `Portable` attribute is set to `true` and the billing method is pay-as-you-go.
        
        @param request: CreateDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.advanced_features):
            query['AdvancedFeatures'] = request.advanced_features
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.bursting_enabled):
            query['BurstingEnabled'] = request.bursting_enabled
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_category):
            query['DiskCategory'] = request.disk_category
        if not UtilClient.is_unset(request.disk_name):
            query['DiskName'] = request.disk_name
        if not UtilClient.is_unset(request.encrypt_algorithm):
            query['EncryptAlgorithm'] = request.encrypt_algorithm
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.multi_attach):
            query['MultiAttach'] = request.multi_attach
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.performance_level):
            query['PerformanceLevel'] = request.performance_level
        if not UtilClient.is_unset(request.provisioned_iops):
            query['ProvisionedIops'] = request.provisioned_iops
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.size):
            query['Size'] = request.size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.storage_cluster_id):
            query['StorageClusterId'] = request.storage_cluster_id
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        if not UtilClient.is_unset(request.storage_set_partition_number):
            query['StorageSetPartitionNumber'] = request.storage_set_partition_number
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_disk(
        self,
        request: ecs_20140526_models.CreateDiskRequest,
    ) -> ecs_20140526_models.CreateDiskResponse:
        """
        ## Description
        *   You can enable the multi-attach feature when you create a disk. We recommend that you first understand this feature and its limits. For more information, see [NVMe protocol](~~256487~~) and [Use the multi-attach feature](~~262105~~).
        <!---->
        *   The disk can be a basic disk, an ultra disk, a standard SSD, or an enhanced SSD (ESSD).
        *   When you create disks, you may be charged for the resources used. We recommend that you understand the Elastic Compute Service (ECS) billing methods before you create a disk. For more information, see [Billing overview](~~25398~~).
        *   By default, the `DeleteAutoSnapshot` parameter is set to `true` when a disk is created. This indicates that when the disk is released, its automatic snapshots are also deleted. You can call the [ModifyDiskAttribute](~~25517~~) operation to modify the parameter.
        *   If you do not configure the performance level when you create an ESSD, the performance level for the ESSD is PL1 by default. You can call the [ModifyDiskSpec](~~123780~~) operation to modify the performance level of the ESSD.
        *   By default, for a disk that is created by calling the CreateDisk operation, the `Portable` attribute is set to `true` and the billing method is pay-as-you-go.
        
        @param request: CreateDiskRequest
        @return: CreateDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_disk_with_options(request, runtime)

    async def create_disk_async(
        self,
        request: ecs_20140526_models.CreateDiskRequest,
    ) -> ecs_20140526_models.CreateDiskResponse:
        """
        ## Description
        *   You can enable the multi-attach feature when you create a disk. We recommend that you first understand this feature and its limits. For more information, see [NVMe protocol](~~256487~~) and [Use the multi-attach feature](~~262105~~).
        <!---->
        *   The disk can be a basic disk, an ultra disk, a standard SSD, or an enhanced SSD (ESSD).
        *   When you create disks, you may be charged for the resources used. We recommend that you understand the Elastic Compute Service (ECS) billing methods before you create a disk. For more information, see [Billing overview](~~25398~~).
        *   By default, the `DeleteAutoSnapshot` parameter is set to `true` when a disk is created. This indicates that when the disk is released, its automatic snapshots are also deleted. You can call the [ModifyDiskAttribute](~~25517~~) operation to modify the parameter.
        *   If you do not configure the performance level when you create an ESSD, the performance level for the ESSD is PL1 by default. You can call the [ModifyDiskSpec](~~123780~~) operation to modify the performance level of the ESSD.
        *   By default, for a disk that is created by calling the CreateDisk operation, the `Portable` attribute is set to `true` and the billing method is pay-as-you-go.
        
        @param request: CreateDiskRequest
        @return: CreateDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_disk_with_options_async(request, runtime)

    def create_elasticity_assurance_with_options(
        self,
        request: ecs_20140526_models.CreateElasticityAssuranceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateElasticityAssuranceResponse:
        """
        Elasticity Assurance provides a new method to purchase and use resources with flexibility and assurance. It offers assured resource reservations for pay-as-you-go Elastic Compute Service (ECS) instances. For more information, see [Overview of Elasticity Assurance](~~193630~~).
        * Elasticity assurances are not refundable after purchase.
        * Elasticity assurances are applicable only to pay-as-you-go ECS instances.
        * Elasticity assurances only support the unlimited mode. Therefore, you can set `AssuranceTimes` only to `Unlimited`. Elasticity assurances in unlimited mode take effect immediately after they are purchased and can be applied an unlimited number of times within their effective duration.
        
        @param request: CreateElasticityAssuranceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateElasticityAssuranceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assurance_times):
            query['AssuranceTimes'] = request.assurance_times
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_amount):
            query['InstanceAmount'] = request.instance_amount
        if not UtilClient.is_unset(request.instance_cpu_core_count):
            query['InstanceCpuCoreCount'] = request.instance_cpu_core_count
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateElasticityAssurance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateElasticityAssuranceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_elasticity_assurance_with_options_async(
        self,
        request: ecs_20140526_models.CreateElasticityAssuranceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateElasticityAssuranceResponse:
        """
        Elasticity Assurance provides a new method to purchase and use resources with flexibility and assurance. It offers assured resource reservations for pay-as-you-go Elastic Compute Service (ECS) instances. For more information, see [Overview of Elasticity Assurance](~~193630~~).
        * Elasticity assurances are not refundable after purchase.
        * Elasticity assurances are applicable only to pay-as-you-go ECS instances.
        * Elasticity assurances only support the unlimited mode. Therefore, you can set `AssuranceTimes` only to `Unlimited`. Elasticity assurances in unlimited mode take effect immediately after they are purchased and can be applied an unlimited number of times within their effective duration.
        
        @param request: CreateElasticityAssuranceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateElasticityAssuranceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assurance_times):
            query['AssuranceTimes'] = request.assurance_times
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_amount):
            query['InstanceAmount'] = request.instance_amount
        if not UtilClient.is_unset(request.instance_cpu_core_count):
            query['InstanceCpuCoreCount'] = request.instance_cpu_core_count
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateElasticityAssurance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateElasticityAssuranceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_elasticity_assurance(
        self,
        request: ecs_20140526_models.CreateElasticityAssuranceRequest,
    ) -> ecs_20140526_models.CreateElasticityAssuranceResponse:
        """
        Elasticity Assurance provides a new method to purchase and use resources with flexibility and assurance. It offers assured resource reservations for pay-as-you-go Elastic Compute Service (ECS) instances. For more information, see [Overview of Elasticity Assurance](~~193630~~).
        * Elasticity assurances are not refundable after purchase.
        * Elasticity assurances are applicable only to pay-as-you-go ECS instances.
        * Elasticity assurances only support the unlimited mode. Therefore, you can set `AssuranceTimes` only to `Unlimited`. Elasticity assurances in unlimited mode take effect immediately after they are purchased and can be applied an unlimited number of times within their effective duration.
        
        @param request: CreateElasticityAssuranceRequest
        @return: CreateElasticityAssuranceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_elasticity_assurance_with_options(request, runtime)

    async def create_elasticity_assurance_async(
        self,
        request: ecs_20140526_models.CreateElasticityAssuranceRequest,
    ) -> ecs_20140526_models.CreateElasticityAssuranceResponse:
        """
        Elasticity Assurance provides a new method to purchase and use resources with flexibility and assurance. It offers assured resource reservations for pay-as-you-go Elastic Compute Service (ECS) instances. For more information, see [Overview of Elasticity Assurance](~~193630~~).
        * Elasticity assurances are not refundable after purchase.
        * Elasticity assurances are applicable only to pay-as-you-go ECS instances.
        * Elasticity assurances only support the unlimited mode. Therefore, you can set `AssuranceTimes` only to `Unlimited`. Elasticity assurances in unlimited mode take effect immediately after they are purchased and can be applied an unlimited number of times within their effective duration.
        
        @param request: CreateElasticityAssuranceRequest
        @return: CreateElasticityAssuranceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_elasticity_assurance_with_options_async(request, runtime)

    def create_forward_entry_with_options(
        self,
        request: ecs_20140526_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateForwardEntryResponse:
        """
        @deprecated
        
        @param request: CreateForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateForwardEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_forward_entry_with_options_async(
        self,
        request: ecs_20140526_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateForwardEntryResponse:
        """
        @deprecated
        
        @param request: CreateForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateForwardEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_forward_entry(
        self,
        request: ecs_20140526_models.CreateForwardEntryRequest,
    ) -> ecs_20140526_models.CreateForwardEntryResponse:
        """
        @deprecated
        
        @param request: CreateForwardEntryRequest
        @return: CreateForwardEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_forward_entry_with_options(request, runtime)

    async def create_forward_entry_async(
        self,
        request: ecs_20140526_models.CreateForwardEntryRequest,
    ) -> ecs_20140526_models.CreateForwardEntryResponse:
        """
        @deprecated
        
        @param request: CreateForwardEntryRequest
        @return: CreateForwardEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_forward_entry_with_options_async(request, runtime)

    def create_ha_vip_with_options(
        self,
        request: ecs_20140526_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateHaVipResponse:
        """
        @deprecated
        
        @param request: CreateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ha_vip_with_options_async(
        self,
        request: ecs_20140526_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateHaVipResponse:
        """
        @deprecated
        
        @param request: CreateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ha_vip(
        self,
        request: ecs_20140526_models.CreateHaVipRequest,
    ) -> ecs_20140526_models.CreateHaVipResponse:
        """
        @deprecated
        
        @param request: CreateHaVipRequest
        @return: CreateHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ha_vip_with_options(request, runtime)

    async def create_ha_vip_async(
        self,
        request: ecs_20140526_models.CreateHaVipRequest,
    ) -> ecs_20140526_models.CreateHaVipResponse:
        """
        @deprecated
        
        @param request: CreateHaVipRequest
        @return: CreateHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ha_vip_with_options_async(request, runtime)

    def create_hpc_cluster_with_options(
        self,
        request: ecs_20140526_models.CreateHpcClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateHpcClusterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHpcCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateHpcClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_hpc_cluster_with_options_async(
        self,
        request: ecs_20140526_models.CreateHpcClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateHpcClusterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHpcCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateHpcClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_hpc_cluster(
        self,
        request: ecs_20140526_models.CreateHpcClusterRequest,
    ) -> ecs_20140526_models.CreateHpcClusterResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_hpc_cluster_with_options(request, runtime)

    async def create_hpc_cluster_async(
        self,
        request: ecs_20140526_models.CreateHpcClusterRequest,
    ) -> ecs_20140526_models.CreateHpcClusterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_hpc_cluster_with_options_async(request, runtime)

    def create_image_with_options(
        self,
        request: ecs_20140526_models.CreateImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImageResponse:
        """
        ## Description
        When you call this operation, take note of the following points:
        *   The created custom image can be used only when it is in the Available (Available) state.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        You can call the CreateImage operation to create a custom image by using one of the following methods. The following request parameters are sorted by priority: `InstanceId` > `DiskDeviceMapping` > `SnapshotId`. If your request contains two or more parameters, the custom image is created based on the parameter that has a higher priority by default.
        *   **Method 1**: Create a custom image from an instance. You need to only specify the instance ID (`InstanceId`). The instance must be in the Running (`Running`) or Stopped (`Stopped`) state. After the CreateImage operation is called, a snapshot is created for each disk of the instance. When you create a custom image from a running instance, some cache data may not be written to the disks. As a result, the data of the created custom image may be slightly inconsistent with that of the instance. We recommend that you create custom images from instances after you stop the instances ([StopInstances](~~155372~~)).
        *   **Method 2**: Create a custom image from the system disk snapshot of an instance. You need to only specify the ID of the system disk snapshot (`SnapshotId`). The specified snapshot cannot be created on or before July 15, 2013.
        *   **Method 3**: Create a custom image from multiple disk snapshots. You must specify the data mapping between the disks and the snapshots (`DiskDeviceMapping`).
        When you use Method 3 to create a custom image, take note of the following items:
        *   You can specify only one system disk snapshot. The device name of the system disk must be /dev/xvda.
        *   You can specify multiple data disk snapshots. The device names of the data disks are unique and in alphabetical order from /dev/xvdb to /dev/xvdz.
        *   `SnapshotId` may not be specified. In this case, an empty data disk with a specified size is created.
        *   The specified snapshot cannot be created on or before July 15, 2013.
        
        @param request: CreateImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.boot_mode):
            query['BootMode'] = request.boot_mode
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.detection_strategy):
            query['DetectionStrategy'] = request.detection_strategy
        if not UtilClient.is_unset(request.disk_device_mapping):
            query['DiskDeviceMapping'] = request.disk_device_mapping
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_version):
            query['ImageVersion'] = request.image_version
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_image_with_options_async(
        self,
        request: ecs_20140526_models.CreateImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImageResponse:
        """
        ## Description
        When you call this operation, take note of the following points:
        *   The created custom image can be used only when it is in the Available (Available) state.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        You can call the CreateImage operation to create a custom image by using one of the following methods. The following request parameters are sorted by priority: `InstanceId` > `DiskDeviceMapping` > `SnapshotId`. If your request contains two or more parameters, the custom image is created based on the parameter that has a higher priority by default.
        *   **Method 1**: Create a custom image from an instance. You need to only specify the instance ID (`InstanceId`). The instance must be in the Running (`Running`) or Stopped (`Stopped`) state. After the CreateImage operation is called, a snapshot is created for each disk of the instance. When you create a custom image from a running instance, some cache data may not be written to the disks. As a result, the data of the created custom image may be slightly inconsistent with that of the instance. We recommend that you create custom images from instances after you stop the instances ([StopInstances](~~155372~~)).
        *   **Method 2**: Create a custom image from the system disk snapshot of an instance. You need to only specify the ID of the system disk snapshot (`SnapshotId`). The specified snapshot cannot be created on or before July 15, 2013.
        *   **Method 3**: Create a custom image from multiple disk snapshots. You must specify the data mapping between the disks and the snapshots (`DiskDeviceMapping`).
        When you use Method 3 to create a custom image, take note of the following items:
        *   You can specify only one system disk snapshot. The device name of the system disk must be /dev/xvda.
        *   You can specify multiple data disk snapshots. The device names of the data disks are unique and in alphabetical order from /dev/xvdb to /dev/xvdz.
        *   `SnapshotId` may not be specified. In this case, an empty data disk with a specified size is created.
        *   The specified snapshot cannot be created on or before July 15, 2013.
        
        @param request: CreateImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.boot_mode):
            query['BootMode'] = request.boot_mode
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.detection_strategy):
            query['DetectionStrategy'] = request.detection_strategy
        if not UtilClient.is_unset(request.disk_device_mapping):
            query['DiskDeviceMapping'] = request.disk_device_mapping
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_version):
            query['ImageVersion'] = request.image_version
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_image(
        self,
        request: ecs_20140526_models.CreateImageRequest,
    ) -> ecs_20140526_models.CreateImageResponse:
        """
        ## Description
        When you call this operation, take note of the following points:
        *   The created custom image can be used only when it is in the Available (Available) state.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        You can call the CreateImage operation to create a custom image by using one of the following methods. The following request parameters are sorted by priority: `InstanceId` > `DiskDeviceMapping` > `SnapshotId`. If your request contains two or more parameters, the custom image is created based on the parameter that has a higher priority by default.
        *   **Method 1**: Create a custom image from an instance. You need to only specify the instance ID (`InstanceId`). The instance must be in the Running (`Running`) or Stopped (`Stopped`) state. After the CreateImage operation is called, a snapshot is created for each disk of the instance. When you create a custom image from a running instance, some cache data may not be written to the disks. As a result, the data of the created custom image may be slightly inconsistent with that of the instance. We recommend that you create custom images from instances after you stop the instances ([StopInstances](~~155372~~)).
        *   **Method 2**: Create a custom image from the system disk snapshot of an instance. You need to only specify the ID of the system disk snapshot (`SnapshotId`). The specified snapshot cannot be created on or before July 15, 2013.
        *   **Method 3**: Create a custom image from multiple disk snapshots. You must specify the data mapping between the disks and the snapshots (`DiskDeviceMapping`).
        When you use Method 3 to create a custom image, take note of the following items:
        *   You can specify only one system disk snapshot. The device name of the system disk must be /dev/xvda.
        *   You can specify multiple data disk snapshots. The device names of the data disks are unique and in alphabetical order from /dev/xvdb to /dev/xvdz.
        *   `SnapshotId` may not be specified. In this case, an empty data disk with a specified size is created.
        *   The specified snapshot cannot be created on or before July 15, 2013.
        
        @param request: CreateImageRequest
        @return: CreateImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_image_with_options(request, runtime)

    async def create_image_async(
        self,
        request: ecs_20140526_models.CreateImageRequest,
    ) -> ecs_20140526_models.CreateImageResponse:
        """
        ## Description
        When you call this operation, take note of the following points:
        *   The created custom image can be used only when it is in the Available (Available) state.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        You can call the CreateImage operation to create a custom image by using one of the following methods. The following request parameters are sorted by priority: `InstanceId` > `DiskDeviceMapping` > `SnapshotId`. If your request contains two or more parameters, the custom image is created based on the parameter that has a higher priority by default.
        *   **Method 1**: Create a custom image from an instance. You need to only specify the instance ID (`InstanceId`). The instance must be in the Running (`Running`) or Stopped (`Stopped`) state. After the CreateImage operation is called, a snapshot is created for each disk of the instance. When you create a custom image from a running instance, some cache data may not be written to the disks. As a result, the data of the created custom image may be slightly inconsistent with that of the instance. We recommend that you create custom images from instances after you stop the instances ([StopInstances](~~155372~~)).
        *   **Method 2**: Create a custom image from the system disk snapshot of an instance. You need to only specify the ID of the system disk snapshot (`SnapshotId`). The specified snapshot cannot be created on or before July 15, 2013.
        *   **Method 3**: Create a custom image from multiple disk snapshots. You must specify the data mapping between the disks and the snapshots (`DiskDeviceMapping`).
        When you use Method 3 to create a custom image, take note of the following items:
        *   You can specify only one system disk snapshot. The device name of the system disk must be /dev/xvda.
        *   You can specify multiple data disk snapshots. The device names of the data disks are unique and in alphabetical order from /dev/xvdb to /dev/xvdz.
        *   `SnapshotId` may not be specified. In this case, an empty data disk with a specified size is created.
        *   The specified snapshot cannot be created on or before July 15, 2013.
        
        @param request: CreateImageRequest
        @return: CreateImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_image_with_options_async(request, runtime)

    def create_image_component_with_options(
        self,
        request: ecs_20140526_models.CreateImageComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImageComponentResponse:
        """
        When you call this operation, take note of the following items:
        * Only custom image components can be created.
        * Image components can be used to create only Linux images, so you must set the `SystemType` parameter to Linux.
        * You must configure the image component type to image building component by setting the `ComponentType` parameter to Build.
        * You can use Dockerfile to edit the content of image components and then pass the edited content into the `Content` parameter. The content cannot be greater than 16 KB in size and can contain up to 127 commands. `FROM` commands cannot be used in image components. For information about the commands that are supported, see [Commands supported by Image Builder](~~200206~~).
        You can use image components to create image templates in the Elastic Compute Service (ECS) console, but cannot call API operations to use image components to create image templates. For more information, see [Overview](~~197410~~).
        
        @param request: CreateImageComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.component_type):
            query['ComponentType'] = request.component_type
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_type):
            query['SystemType'] = request.system_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImageComponent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImageComponentResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_image_component_with_options_async(
        self,
        request: ecs_20140526_models.CreateImageComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImageComponentResponse:
        """
        When you call this operation, take note of the following items:
        * Only custom image components can be created.
        * Image components can be used to create only Linux images, so you must set the `SystemType` parameter to Linux.
        * You must configure the image component type to image building component by setting the `ComponentType` parameter to Build.
        * You can use Dockerfile to edit the content of image components and then pass the edited content into the `Content` parameter. The content cannot be greater than 16 KB in size and can contain up to 127 commands. `FROM` commands cannot be used in image components. For information about the commands that are supported, see [Commands supported by Image Builder](~~200206~~).
        You can use image components to create image templates in the Elastic Compute Service (ECS) console, but cannot call API operations to use image components to create image templates. For more information, see [Overview](~~197410~~).
        
        @param request: CreateImageComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.component_type):
            query['ComponentType'] = request.component_type
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_type):
            query['SystemType'] = request.system_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImageComponent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImageComponentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_image_component(
        self,
        request: ecs_20140526_models.CreateImageComponentRequest,
    ) -> ecs_20140526_models.CreateImageComponentResponse:
        """
        When you call this operation, take note of the following items:
        * Only custom image components can be created.
        * Image components can be used to create only Linux images, so you must set the `SystemType` parameter to Linux.
        * You must configure the image component type to image building component by setting the `ComponentType` parameter to Build.
        * You can use Dockerfile to edit the content of image components and then pass the edited content into the `Content` parameter. The content cannot be greater than 16 KB in size and can contain up to 127 commands. `FROM` commands cannot be used in image components. For information about the commands that are supported, see [Commands supported by Image Builder](~~200206~~).
        You can use image components to create image templates in the Elastic Compute Service (ECS) console, but cannot call API operations to use image components to create image templates. For more information, see [Overview](~~197410~~).
        
        @param request: CreateImageComponentRequest
        @return: CreateImageComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_image_component_with_options(request, runtime)

    async def create_image_component_async(
        self,
        request: ecs_20140526_models.CreateImageComponentRequest,
    ) -> ecs_20140526_models.CreateImageComponentResponse:
        """
        When you call this operation, take note of the following items:
        * Only custom image components can be created.
        * Image components can be used to create only Linux images, so you must set the `SystemType` parameter to Linux.
        * You must configure the image component type to image building component by setting the `ComponentType` parameter to Build.
        * You can use Dockerfile to edit the content of image components and then pass the edited content into the `Content` parameter. The content cannot be greater than 16 KB in size and can contain up to 127 commands. `FROM` commands cannot be used in image components. For information about the commands that are supported, see [Commands supported by Image Builder](~~200206~~).
        You can use image components to create image templates in the Elastic Compute Service (ECS) console, but cannot call API operations to use image components to create image templates. For more information, see [Overview](~~197410~~).
        
        @param request: CreateImageComponentRequest
        @return: CreateImageComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_image_component_with_options_async(request, runtime)

    def create_image_pipeline_with_options(
        self,
        request: ecs_20140526_models.CreateImagePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImagePipelineResponse:
        """
        ## Description
        You can use image templates to customize image content and create images across regions and accounts. When you call this operation, take note of the following items:
        *   You can create only custom image templates.
        *   You can configure only public, custom, or shared Linux images or image families as the source images to create custom image templates.
        *   When you use an image template to create an image, you must create an intermediate Elastic Compute Service (ECS) instance to help create the image. The intermediate instance is billed on a pay-as-you-go basis. For more information, see [Pay-as-you-go](~~40653~~).
        For the `BuildContent` parameter that specifies the content of image templates, take note of the following items:
        *   If the `BuildContent` value contains `FROM` commands, the values of `BaseImageType` that specifies the type of the source image and `BaseImage` that specifies the source image are overridden by the `FROM` commands.
        *   If the `BuildContent` value does not contain `FROM` commands, the system adds the `FROM` command that consists of the `BaseImageType` and `BaseImage` values to the first line of the template content in the format of `<BaseImageType>:<BaseImage>`.
        *   You can use Dockerfile to edit the content of image templates and then pass the edited content into the `BuildContent` parameter. The content cannot be greater than 16 KB in size, and can contain up to 127 commands. For information about the commands that are supported, see [Commands supported by Image Builder](~~200206~~).
        You can use image components to create image templates in the ECS console, but cannot call API operations to use image components to create image templates. For more information, see [Overview](~~197410~~).
        
        @param request: CreateImagePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImagePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_account):
            query['AddAccount'] = request.add_account
        if not UtilClient.is_unset(request.base_image):
            query['BaseImage'] = request.base_image
        if not UtilClient.is_unset(request.base_image_type):
            query['BaseImageType'] = request.base_image_type
        if not UtilClient.is_unset(request.build_content):
            query['BuildContent'] = request.build_content
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.delete_instance_on_failure):
            query['DeleteInstanceOnFailure'] = request.delete_instance_on_failure
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.to_region_id):
            query['ToRegionId'] = request.to_region_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImagePipeline',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImagePipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_image_pipeline_with_options_async(
        self,
        request: ecs_20140526_models.CreateImagePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImagePipelineResponse:
        """
        ## Description
        You can use image templates to customize image content and create images across regions and accounts. When you call this operation, take note of the following items:
        *   You can create only custom image templates.
        *   You can configure only public, custom, or shared Linux images or image families as the source images to create custom image templates.
        *   When you use an image template to create an image, you must create an intermediate Elastic Compute Service (ECS) instance to help create the image. The intermediate instance is billed on a pay-as-you-go basis. For more information, see [Pay-as-you-go](~~40653~~).
        For the `BuildContent` parameter that specifies the content of image templates, take note of the following items:
        *   If the `BuildContent` value contains `FROM` commands, the values of `BaseImageType` that specifies the type of the source image and `BaseImage` that specifies the source image are overridden by the `FROM` commands.
        *   If the `BuildContent` value does not contain `FROM` commands, the system adds the `FROM` command that consists of the `BaseImageType` and `BaseImage` values to the first line of the template content in the format of `<BaseImageType>:<BaseImage>`.
        *   You can use Dockerfile to edit the content of image templates and then pass the edited content into the `BuildContent` parameter. The content cannot be greater than 16 KB in size, and can contain up to 127 commands. For information about the commands that are supported, see [Commands supported by Image Builder](~~200206~~).
        You can use image components to create image templates in the ECS console, but cannot call API operations to use image components to create image templates. For more information, see [Overview](~~197410~~).
        
        @param request: CreateImagePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImagePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_account):
            query['AddAccount'] = request.add_account
        if not UtilClient.is_unset(request.base_image):
            query['BaseImage'] = request.base_image
        if not UtilClient.is_unset(request.base_image_type):
            query['BaseImageType'] = request.base_image_type
        if not UtilClient.is_unset(request.build_content):
            query['BuildContent'] = request.build_content
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.delete_instance_on_failure):
            query['DeleteInstanceOnFailure'] = request.delete_instance_on_failure
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.to_region_id):
            query['ToRegionId'] = request.to_region_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImagePipeline',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImagePipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_image_pipeline(
        self,
        request: ecs_20140526_models.CreateImagePipelineRequest,
    ) -> ecs_20140526_models.CreateImagePipelineResponse:
        """
        ## Description
        You can use image templates to customize image content and create images across regions and accounts. When you call this operation, take note of the following items:
        *   You can create only custom image templates.
        *   You can configure only public, custom, or shared Linux images or image families as the source images to create custom image templates.
        *   When you use an image template to create an image, you must create an intermediate Elastic Compute Service (ECS) instance to help create the image. The intermediate instance is billed on a pay-as-you-go basis. For more information, see [Pay-as-you-go](~~40653~~).
        For the `BuildContent` parameter that specifies the content of image templates, take note of the following items:
        *   If the `BuildContent` value contains `FROM` commands, the values of `BaseImageType` that specifies the type of the source image and `BaseImage` that specifies the source image are overridden by the `FROM` commands.
        *   If the `BuildContent` value does not contain `FROM` commands, the system adds the `FROM` command that consists of the `BaseImageType` and `BaseImage` values to the first line of the template content in the format of `<BaseImageType>:<BaseImage>`.
        *   You can use Dockerfile to edit the content of image templates and then pass the edited content into the `BuildContent` parameter. The content cannot be greater than 16 KB in size, and can contain up to 127 commands. For information about the commands that are supported, see [Commands supported by Image Builder](~~200206~~).
        You can use image components to create image templates in the ECS console, but cannot call API operations to use image components to create image templates. For more information, see [Overview](~~197410~~).
        
        @param request: CreateImagePipelineRequest
        @return: CreateImagePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_image_pipeline_with_options(request, runtime)

    async def create_image_pipeline_async(
        self,
        request: ecs_20140526_models.CreateImagePipelineRequest,
    ) -> ecs_20140526_models.CreateImagePipelineResponse:
        """
        ## Description
        You can use image templates to customize image content and create images across regions and accounts. When you call this operation, take note of the following items:
        *   You can create only custom image templates.
        *   You can configure only public, custom, or shared Linux images or image families as the source images to create custom image templates.
        *   When you use an image template to create an image, you must create an intermediate Elastic Compute Service (ECS) instance to help create the image. The intermediate instance is billed on a pay-as-you-go basis. For more information, see [Pay-as-you-go](~~40653~~).
        For the `BuildContent` parameter that specifies the content of image templates, take note of the following items:
        *   If the `BuildContent` value contains `FROM` commands, the values of `BaseImageType` that specifies the type of the source image and `BaseImage` that specifies the source image are overridden by the `FROM` commands.
        *   If the `BuildContent` value does not contain `FROM` commands, the system adds the `FROM` command that consists of the `BaseImageType` and `BaseImage` values to the first line of the template content in the format of `<BaseImageType>:<BaseImage>`.
        *   You can use Dockerfile to edit the content of image templates and then pass the edited content into the `BuildContent` parameter. The content cannot be greater than 16 KB in size, and can contain up to 127 commands. For information about the commands that are supported, see [Commands supported by Image Builder](~~200206~~).
        You can use image components to create image templates in the ECS console, but cannot call API operations to use image components to create image templates. For more information, see [Overview](~~197410~~).
        
        @param request: CreateImagePipelineRequest
        @return: CreateImagePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_image_pipeline_with_options_async(request, runtime)

    def create_instance_with_options(
        self,
        request: ecs_20140526_models.CreateInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateInstanceResponse:
        """
        > You can call the [DescribeAvailableResource](~~66186~~) operation to query available resources in a specific region or zone. If you want to batch create instances that automatically enter the Running state after they are created, we recommend that you call the [RunInstances](~~63440~~) operation.
        When you call this operation, take note of the following items:
        * **Billing**:
        * You must fully understand the ECS billing methods before you create an instance because you may be charged for resources used by the instance. For more information, see [Billing overview](~~25398~~).
        * If you create a subscription instance (`PrePaid`), available coupons within your account are used by default.
        * **Instance type**:
        * You can use the `IoOptimized` parameter to specify whether to create an I/O optimized instance.
        * Select an instance type. See [Instance families](~~25378~~) or call the [DescribeInstanceTypes](~~25620~~) operation to query the performance data of an instance type, or see [Best practices for instance type selection](~~58291~~) to learn about how to select instance types.
        * Query available resources. Call the [DescribeAvailableResource](~~66186~~) operation to query available resources in a specific region or zone.
        > If the `QuotaExceed.ElasticQuota` error is returned when you call this operation, it indicates that you have reached the maximum number of instances of the specified instance type that can be created within the specified region or the maximum number of vCPUs for all instance types in a zone. You can go to the [ECS console](https://ecs.console.aliyun.com/?spm=a2c8b.12215451.favorites.decs.5e3a336aMGTtzy#/privileges/quota) or [Quota Center](https://quotas.console.aliyun.com/products/ecs/quotas) to request a quota increase.
        * **Image**:
        * The image determines the system disk configurations of the new instance. The system disk of the new instance is a clone of the specified image.
        * If you want to create instances with 512 MiB of memory, you cannot use Windows Server images except for Windows Server Semi-Annual Channel images.
        * If you want to create instances with 4 GiB or more of memory, you cannot use 32-bit OS image.
        * **Network type**:
        * Each instance that resides in a virtual private cloud (VPC) must be connected to only a single vSwitch.
        * If the `VSwitchId` parameter is specified, the security group specified by `SecurityGroupId` and the vSwitch specified by `VSwitchId` must belong to the same VPC.
        * The value of `PrivateIpAddress` depends on that of `VSwitchId` and cannot be separately specified.`` If both the `VSwitchId` and `PrivateIpAddress` parameters are specified, the IP address specified by `PrivateIpAddress` must be available in the CIDR block of the specified vSwitch.
        * **Public bandwidth**:
        * As of November 27, 2020, the maximum bandwidth value available for you to create ECS instances or to change ECS instance configurations is subject to the throttling policy for your account. To increase the maximum bandwidth value, submit a ticket. The throttling policy imposes the following constraints: Within a single region, the total maximum bandwidth value of all instances that use the pay-by-traffic billing method for network usage cannot exceed 5 Gbit/s and that of all instances that use the pay-by-bandwidth billing method for network usage cannot exceed 50 Gbit/s.
        * If you call the `CreateInstance` operation to create an instance, no public IP addresses are assigned to the instance. You can call the [AllocatePublicIpAddress](~~25544~~) operation to manually assign public IP addresses to instances.
        * Network usage fees are determined based on the settings of `InternetChargeType` and `InternetMaxBandwidthOut`.
        * The `InternetMaxBandwidthIn` value is irrelevant to billing because inbound data traffic is free of charge.
        * If `InternetChargeType` is set to PayByBandwidth, `InternetMaxBandwidthOut` specifies the fixed bandwidth value. A fixed bandwidth is a specified amount of public bandwidth allocated to an instance that uses the pay-by-bandwidth billing method for network usage.
        * If `InternetChargeType` is set to PayByTraffic, `InternetMaxBandwidthOut` specifies the peak bandwidth value. A peak bandwidth is the maximum amount of public bandwidth that an instance can consume when it uses the pay-by-traffic billing method for network usage. Network usage costs are calculated based on the volume of network traffic.
        * **Security group**:
        * If no security groups are available in the region where you want to create an instance, you must call the [CreateSecurityGroup](~~25553~~) operation to create a security group in that region first.
        * The maximum number of instances that a security group can contain varies based on the security group type. For more information, see the "Security group limits" section in [Limits](~~25412~~).
        * Instances in the same security group can communicate with each other over the internal network. By default, instances in different security groups cannot communicate with each other. You can allow communication between instances by allowing mutual access between their security groups. For more information, see [AuthorizeSecurityGroup](~~25554~~) and [AuthorizeSecurityGroupEgress](~~25560~~).
        * **Storage**:
        * The instance is assigned a system disk whose size is determined based on the specified image. The size of the system disk must be at least `20 GiB` and greater than or equal to the image size. For more information about system disk categories, see the description of the `SystemDisk.Category` parameter.
        * The system disk of an I/O optimized instance can only be an enhanced SSD (ESSD) (`cloud_essd`), a standard SSD (`cloud_ssd`), or an ultra disk (`cloud_efficiency`).
        * The maximum size of a data disk varies based on its category. For more information, see the description of the `DataDisk.N.Size` parameter.
        * A maximum of 16 data disks can be attached to each instance. The mount points of data disks are allocated by the system in alphabetical order from /dev/xvdb to /dev/xvdz.
        * **User data**: If the instance type supports [user data](~~49121~~), you can use the UserData parameter to pass in user data. User data is encoded in Base64. We recommend that you do not pass in confidential information (such as passwords or private keys) in plaintext as user data. This is because the system does not encrypt `UserData` values when API requests are transmitted. If you must pass in confidential information, we recommend that you encrypt and encode the information in Base64 and then decode and decrypt the information in the same way within the instance.
        * **Others**: When you call API operations by using Alibaba Cloud CLI or SDKs, you must delete periods (.) from some request parameters before you use the parameters. For example, use `SystemDiskCategory` instead of `SystemDisk.Category` as a request parameter.
        
        @param request: CreateInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.affinity):
            query['Affinity'] = request.affinity
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.credit_specification):
            query['CreditSpecification'] = request.credit_specification
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.dedicated_host_id):
            query['DedicatedHostId'] = request.dedicated_host_id
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.deployment_set_group_no):
            query['DeploymentSetGroupNo'] = request.deployment_set_group_no
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.hpc_cluster_id):
            query['HpcClusterId'] = request.hpc_cluster_id
        if not UtilClient.is_unset(request.http_endpoint):
            query['HttpEndpoint'] = request.http_endpoint
        if not UtilClient.is_unset(request.http_put_response_hop_limit):
            query['HttpPutResponseHopLimit'] = request.http_put_response_hop_limit
        if not UtilClient.is_unset(request.http_tokens):
            query['HttpTokens'] = request.http_tokens
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.inner_ip_address):
            query['InnerIpAddress'] = request.inner_ip_address
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.node_controller_id):
            query['NodeControllerId'] = request.node_controller_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_interruption_behavior):
            query['SpotInterruptionBehavior'] = request.spot_interruption_behavior
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        if not UtilClient.is_unset(request.storage_set_partition_number):
            query['StorageSetPartitionNumber'] = request.storage_set_partition_number
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tenancy):
            query['Tenancy'] = request.tenancy
        if not UtilClient.is_unset(request.use_additional_service):
            query['UseAdditionalService'] = request.use_additional_service
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.hibernation_options):
            query['HibernationOptions'] = request.hibernation_options
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_instance_with_options_async(
        self,
        request: ecs_20140526_models.CreateInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateInstanceResponse:
        """
        > You can call the [DescribeAvailableResource](~~66186~~) operation to query available resources in a specific region or zone. If you want to batch create instances that automatically enter the Running state after they are created, we recommend that you call the [RunInstances](~~63440~~) operation.
        When you call this operation, take note of the following items:
        * **Billing**:
        * You must fully understand the ECS billing methods before you create an instance because you may be charged for resources used by the instance. For more information, see [Billing overview](~~25398~~).
        * If you create a subscription instance (`PrePaid`), available coupons within your account are used by default.
        * **Instance type**:
        * You can use the `IoOptimized` parameter to specify whether to create an I/O optimized instance.
        * Select an instance type. See [Instance families](~~25378~~) or call the [DescribeInstanceTypes](~~25620~~) operation to query the performance data of an instance type, or see [Best practices for instance type selection](~~58291~~) to learn about how to select instance types.
        * Query available resources. Call the [DescribeAvailableResource](~~66186~~) operation to query available resources in a specific region or zone.
        > If the `QuotaExceed.ElasticQuota` error is returned when you call this operation, it indicates that you have reached the maximum number of instances of the specified instance type that can be created within the specified region or the maximum number of vCPUs for all instance types in a zone. You can go to the [ECS console](https://ecs.console.aliyun.com/?spm=a2c8b.12215451.favorites.decs.5e3a336aMGTtzy#/privileges/quota) or [Quota Center](https://quotas.console.aliyun.com/products/ecs/quotas) to request a quota increase.
        * **Image**:
        * The image determines the system disk configurations of the new instance. The system disk of the new instance is a clone of the specified image.
        * If you want to create instances with 512 MiB of memory, you cannot use Windows Server images except for Windows Server Semi-Annual Channel images.
        * If you want to create instances with 4 GiB or more of memory, you cannot use 32-bit OS image.
        * **Network type**:
        * Each instance that resides in a virtual private cloud (VPC) must be connected to only a single vSwitch.
        * If the `VSwitchId` parameter is specified, the security group specified by `SecurityGroupId` and the vSwitch specified by `VSwitchId` must belong to the same VPC.
        * The value of `PrivateIpAddress` depends on that of `VSwitchId` and cannot be separately specified.`` If both the `VSwitchId` and `PrivateIpAddress` parameters are specified, the IP address specified by `PrivateIpAddress` must be available in the CIDR block of the specified vSwitch.
        * **Public bandwidth**:
        * As of November 27, 2020, the maximum bandwidth value available for you to create ECS instances or to change ECS instance configurations is subject to the throttling policy for your account. To increase the maximum bandwidth value, submit a ticket. The throttling policy imposes the following constraints: Within a single region, the total maximum bandwidth value of all instances that use the pay-by-traffic billing method for network usage cannot exceed 5 Gbit/s and that of all instances that use the pay-by-bandwidth billing method for network usage cannot exceed 50 Gbit/s.
        * If you call the `CreateInstance` operation to create an instance, no public IP addresses are assigned to the instance. You can call the [AllocatePublicIpAddress](~~25544~~) operation to manually assign public IP addresses to instances.
        * Network usage fees are determined based on the settings of `InternetChargeType` and `InternetMaxBandwidthOut`.
        * The `InternetMaxBandwidthIn` value is irrelevant to billing because inbound data traffic is free of charge.
        * If `InternetChargeType` is set to PayByBandwidth, `InternetMaxBandwidthOut` specifies the fixed bandwidth value. A fixed bandwidth is a specified amount of public bandwidth allocated to an instance that uses the pay-by-bandwidth billing method for network usage.
        * If `InternetChargeType` is set to PayByTraffic, `InternetMaxBandwidthOut` specifies the peak bandwidth value. A peak bandwidth is the maximum amount of public bandwidth that an instance can consume when it uses the pay-by-traffic billing method for network usage. Network usage costs are calculated based on the volume of network traffic.
        * **Security group**:
        * If no security groups are available in the region where you want to create an instance, you must call the [CreateSecurityGroup](~~25553~~) operation to create a security group in that region first.
        * The maximum number of instances that a security group can contain varies based on the security group type. For more information, see the "Security group limits" section in [Limits](~~25412~~).
        * Instances in the same security group can communicate with each other over the internal network. By default, instances in different security groups cannot communicate with each other. You can allow communication between instances by allowing mutual access between their security groups. For more information, see [AuthorizeSecurityGroup](~~25554~~) and [AuthorizeSecurityGroupEgress](~~25560~~).
        * **Storage**:
        * The instance is assigned a system disk whose size is determined based on the specified image. The size of the system disk must be at least `20 GiB` and greater than or equal to the image size. For more information about system disk categories, see the description of the `SystemDisk.Category` parameter.
        * The system disk of an I/O optimized instance can only be an enhanced SSD (ESSD) (`cloud_essd`), a standard SSD (`cloud_ssd`), or an ultra disk (`cloud_efficiency`).
        * The maximum size of a data disk varies based on its category. For more information, see the description of the `DataDisk.N.Size` parameter.
        * A maximum of 16 data disks can be attached to each instance. The mount points of data disks are allocated by the system in alphabetical order from /dev/xvdb to /dev/xvdz.
        * **User data**: If the instance type supports [user data](~~49121~~), you can use the UserData parameter to pass in user data. User data is encoded in Base64. We recommend that you do not pass in confidential information (such as passwords or private keys) in plaintext as user data. This is because the system does not encrypt `UserData` values when API requests are transmitted. If you must pass in confidential information, we recommend that you encrypt and encode the information in Base64 and then decode and decrypt the information in the same way within the instance.
        * **Others**: When you call API operations by using Alibaba Cloud CLI or SDKs, you must delete periods (.) from some request parameters before you use the parameters. For example, use `SystemDiskCategory` instead of `SystemDisk.Category` as a request parameter.
        
        @param request: CreateInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.affinity):
            query['Affinity'] = request.affinity
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.credit_specification):
            query['CreditSpecification'] = request.credit_specification
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.dedicated_host_id):
            query['DedicatedHostId'] = request.dedicated_host_id
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.deployment_set_group_no):
            query['DeploymentSetGroupNo'] = request.deployment_set_group_no
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.hpc_cluster_id):
            query['HpcClusterId'] = request.hpc_cluster_id
        if not UtilClient.is_unset(request.http_endpoint):
            query['HttpEndpoint'] = request.http_endpoint
        if not UtilClient.is_unset(request.http_put_response_hop_limit):
            query['HttpPutResponseHopLimit'] = request.http_put_response_hop_limit
        if not UtilClient.is_unset(request.http_tokens):
            query['HttpTokens'] = request.http_tokens
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.inner_ip_address):
            query['InnerIpAddress'] = request.inner_ip_address
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.node_controller_id):
            query['NodeControllerId'] = request.node_controller_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_interruption_behavior):
            query['SpotInterruptionBehavior'] = request.spot_interruption_behavior
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        if not UtilClient.is_unset(request.storage_set_partition_number):
            query['StorageSetPartitionNumber'] = request.storage_set_partition_number
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tenancy):
            query['Tenancy'] = request.tenancy
        if not UtilClient.is_unset(request.use_additional_service):
            query['UseAdditionalService'] = request.use_additional_service
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.hibernation_options):
            query['HibernationOptions'] = request.hibernation_options
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_instance(
        self,
        request: ecs_20140526_models.CreateInstanceRequest,
    ) -> ecs_20140526_models.CreateInstanceResponse:
        """
        > You can call the [DescribeAvailableResource](~~66186~~) operation to query available resources in a specific region or zone. If you want to batch create instances that automatically enter the Running state after they are created, we recommend that you call the [RunInstances](~~63440~~) operation.
        When you call this operation, take note of the following items:
        * **Billing**:
        * You must fully understand the ECS billing methods before you create an instance because you may be charged for resources used by the instance. For more information, see [Billing overview](~~25398~~).
        * If you create a subscription instance (`PrePaid`), available coupons within your account are used by default.
        * **Instance type**:
        * You can use the `IoOptimized` parameter to specify whether to create an I/O optimized instance.
        * Select an instance type. See [Instance families](~~25378~~) or call the [DescribeInstanceTypes](~~25620~~) operation to query the performance data of an instance type, or see [Best practices for instance type selection](~~58291~~) to learn about how to select instance types.
        * Query available resources. Call the [DescribeAvailableResource](~~66186~~) operation to query available resources in a specific region or zone.
        > If the `QuotaExceed.ElasticQuota` error is returned when you call this operation, it indicates that you have reached the maximum number of instances of the specified instance type that can be created within the specified region or the maximum number of vCPUs for all instance types in a zone. You can go to the [ECS console](https://ecs.console.aliyun.com/?spm=a2c8b.12215451.favorites.decs.5e3a336aMGTtzy#/privileges/quota) or [Quota Center](https://quotas.console.aliyun.com/products/ecs/quotas) to request a quota increase.
        * **Image**:
        * The image determines the system disk configurations of the new instance. The system disk of the new instance is a clone of the specified image.
        * If you want to create instances with 512 MiB of memory, you cannot use Windows Server images except for Windows Server Semi-Annual Channel images.
        * If you want to create instances with 4 GiB or more of memory, you cannot use 32-bit OS image.
        * **Network type**:
        * Each instance that resides in a virtual private cloud (VPC) must be connected to only a single vSwitch.
        * If the `VSwitchId` parameter is specified, the security group specified by `SecurityGroupId` and the vSwitch specified by `VSwitchId` must belong to the same VPC.
        * The value of `PrivateIpAddress` depends on that of `VSwitchId` and cannot be separately specified.`` If both the `VSwitchId` and `PrivateIpAddress` parameters are specified, the IP address specified by `PrivateIpAddress` must be available in the CIDR block of the specified vSwitch.
        * **Public bandwidth**:
        * As of November 27, 2020, the maximum bandwidth value available for you to create ECS instances or to change ECS instance configurations is subject to the throttling policy for your account. To increase the maximum bandwidth value, submit a ticket. The throttling policy imposes the following constraints: Within a single region, the total maximum bandwidth value of all instances that use the pay-by-traffic billing method for network usage cannot exceed 5 Gbit/s and that of all instances that use the pay-by-bandwidth billing method for network usage cannot exceed 50 Gbit/s.
        * If you call the `CreateInstance` operation to create an instance, no public IP addresses are assigned to the instance. You can call the [AllocatePublicIpAddress](~~25544~~) operation to manually assign public IP addresses to instances.
        * Network usage fees are determined based on the settings of `InternetChargeType` and `InternetMaxBandwidthOut`.
        * The `InternetMaxBandwidthIn` value is irrelevant to billing because inbound data traffic is free of charge.
        * If `InternetChargeType` is set to PayByBandwidth, `InternetMaxBandwidthOut` specifies the fixed bandwidth value. A fixed bandwidth is a specified amount of public bandwidth allocated to an instance that uses the pay-by-bandwidth billing method for network usage.
        * If `InternetChargeType` is set to PayByTraffic, `InternetMaxBandwidthOut` specifies the peak bandwidth value. A peak bandwidth is the maximum amount of public bandwidth that an instance can consume when it uses the pay-by-traffic billing method for network usage. Network usage costs are calculated based on the volume of network traffic.
        * **Security group**:
        * If no security groups are available in the region where you want to create an instance, you must call the [CreateSecurityGroup](~~25553~~) operation to create a security group in that region first.
        * The maximum number of instances that a security group can contain varies based on the security group type. For more information, see the "Security group limits" section in [Limits](~~25412~~).
        * Instances in the same security group can communicate with each other over the internal network. By default, instances in different security groups cannot communicate with each other. You can allow communication between instances by allowing mutual access between their security groups. For more information, see [AuthorizeSecurityGroup](~~25554~~) and [AuthorizeSecurityGroupEgress](~~25560~~).
        * **Storage**:
        * The instance is assigned a system disk whose size is determined based on the specified image. The size of the system disk must be at least `20 GiB` and greater than or equal to the image size. For more information about system disk categories, see the description of the `SystemDisk.Category` parameter.
        * The system disk of an I/O optimized instance can only be an enhanced SSD (ESSD) (`cloud_essd`), a standard SSD (`cloud_ssd`), or an ultra disk (`cloud_efficiency`).
        * The maximum size of a data disk varies based on its category. For more information, see the description of the `DataDisk.N.Size` parameter.
        * A maximum of 16 data disks can be attached to each instance. The mount points of data disks are allocated by the system in alphabetical order from /dev/xvdb to /dev/xvdz.
        * **User data**: If the instance type supports [user data](~~49121~~), you can use the UserData parameter to pass in user data. User data is encoded in Base64. We recommend that you do not pass in confidential information (such as passwords or private keys) in plaintext as user data. This is because the system does not encrypt `UserData` values when API requests are transmitted. If you must pass in confidential information, we recommend that you encrypt and encode the information in Base64 and then decode and decrypt the information in the same way within the instance.
        * **Others**: When you call API operations by using Alibaba Cloud CLI or SDKs, you must delete periods (.) from some request parameters before you use the parameters. For example, use `SystemDiskCategory` instead of `SystemDisk.Category` as a request parameter.
        
        @param request: CreateInstanceRequest
        @return: CreateInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_instance_with_options(request, runtime)

    async def create_instance_async(
        self,
        request: ecs_20140526_models.CreateInstanceRequest,
    ) -> ecs_20140526_models.CreateInstanceResponse:
        """
        > You can call the [DescribeAvailableResource](~~66186~~) operation to query available resources in a specific region or zone. If you want to batch create instances that automatically enter the Running state after they are created, we recommend that you call the [RunInstances](~~63440~~) operation.
        When you call this operation, take note of the following items:
        * **Billing**:
        * You must fully understand the ECS billing methods before you create an instance because you may be charged for resources used by the instance. For more information, see [Billing overview](~~25398~~).
        * If you create a subscription instance (`PrePaid`), available coupons within your account are used by default.
        * **Instance type**:
        * You can use the `IoOptimized` parameter to specify whether to create an I/O optimized instance.
        * Select an instance type. See [Instance families](~~25378~~) or call the [DescribeInstanceTypes](~~25620~~) operation to query the performance data of an instance type, or see [Best practices for instance type selection](~~58291~~) to learn about how to select instance types.
        * Query available resources. Call the [DescribeAvailableResource](~~66186~~) operation to query available resources in a specific region or zone.
        > If the `QuotaExceed.ElasticQuota` error is returned when you call this operation, it indicates that you have reached the maximum number of instances of the specified instance type that can be created within the specified region or the maximum number of vCPUs for all instance types in a zone. You can go to the [ECS console](https://ecs.console.aliyun.com/?spm=a2c8b.12215451.favorites.decs.5e3a336aMGTtzy#/privileges/quota) or [Quota Center](https://quotas.console.aliyun.com/products/ecs/quotas) to request a quota increase.
        * **Image**:
        * The image determines the system disk configurations of the new instance. The system disk of the new instance is a clone of the specified image.
        * If you want to create instances with 512 MiB of memory, you cannot use Windows Server images except for Windows Server Semi-Annual Channel images.
        * If you want to create instances with 4 GiB or more of memory, you cannot use 32-bit OS image.
        * **Network type**:
        * Each instance that resides in a virtual private cloud (VPC) must be connected to only a single vSwitch.
        * If the `VSwitchId` parameter is specified, the security group specified by `SecurityGroupId` and the vSwitch specified by `VSwitchId` must belong to the same VPC.
        * The value of `PrivateIpAddress` depends on that of `VSwitchId` and cannot be separately specified.`` If both the `VSwitchId` and `PrivateIpAddress` parameters are specified, the IP address specified by `PrivateIpAddress` must be available in the CIDR block of the specified vSwitch.
        * **Public bandwidth**:
        * As of November 27, 2020, the maximum bandwidth value available for you to create ECS instances or to change ECS instance configurations is subject to the throttling policy for your account. To increase the maximum bandwidth value, submit a ticket. The throttling policy imposes the following constraints: Within a single region, the total maximum bandwidth value of all instances that use the pay-by-traffic billing method for network usage cannot exceed 5 Gbit/s and that of all instances that use the pay-by-bandwidth billing method for network usage cannot exceed 50 Gbit/s.
        * If you call the `CreateInstance` operation to create an instance, no public IP addresses are assigned to the instance. You can call the [AllocatePublicIpAddress](~~25544~~) operation to manually assign public IP addresses to instances.
        * Network usage fees are determined based on the settings of `InternetChargeType` and `InternetMaxBandwidthOut`.
        * The `InternetMaxBandwidthIn` value is irrelevant to billing because inbound data traffic is free of charge.
        * If `InternetChargeType` is set to PayByBandwidth, `InternetMaxBandwidthOut` specifies the fixed bandwidth value. A fixed bandwidth is a specified amount of public bandwidth allocated to an instance that uses the pay-by-bandwidth billing method for network usage.
        * If `InternetChargeType` is set to PayByTraffic, `InternetMaxBandwidthOut` specifies the peak bandwidth value. A peak bandwidth is the maximum amount of public bandwidth that an instance can consume when it uses the pay-by-traffic billing method for network usage. Network usage costs are calculated based on the volume of network traffic.
        * **Security group**:
        * If no security groups are available in the region where you want to create an instance, you must call the [CreateSecurityGroup](~~25553~~) operation to create a security group in that region first.
        * The maximum number of instances that a security group can contain varies based on the security group type. For more information, see the "Security group limits" section in [Limits](~~25412~~).
        * Instances in the same security group can communicate with each other over the internal network. By default, instances in different security groups cannot communicate with each other. You can allow communication between instances by allowing mutual access between their security groups. For more information, see [AuthorizeSecurityGroup](~~25554~~) and [AuthorizeSecurityGroupEgress](~~25560~~).
        * **Storage**:
        * The instance is assigned a system disk whose size is determined based on the specified image. The size of the system disk must be at least `20 GiB` and greater than or equal to the image size. For more information about system disk categories, see the description of the `SystemDisk.Category` parameter.
        * The system disk of an I/O optimized instance can only be an enhanced SSD (ESSD) (`cloud_essd`), a standard SSD (`cloud_ssd`), or an ultra disk (`cloud_efficiency`).
        * The maximum size of a data disk varies based on its category. For more information, see the description of the `DataDisk.N.Size` parameter.
        * A maximum of 16 data disks can be attached to each instance. The mount points of data disks are allocated by the system in alphabetical order from /dev/xvdb to /dev/xvdz.
        * **User data**: If the instance type supports [user data](~~49121~~), you can use the UserData parameter to pass in user data. User data is encoded in Base64. We recommend that you do not pass in confidential information (such as passwords or private keys) in plaintext as user data. This is because the system does not encrypt `UserData` values when API requests are transmitted. If you must pass in confidential information, we recommend that you encrypt and encode the information in Base64 and then decode and decrypt the information in the same way within the instance.
        * **Others**: When you call API operations by using Alibaba Cloud CLI or SDKs, you must delete periods (.) from some request parameters before you use the parameters. For example, use `SystemDiskCategory` instead of `SystemDisk.Category` as a request parameter.
        
        @param request: CreateInstanceRequest
        @return: CreateInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_instance_with_options_async(request, runtime)

    def create_key_pair_with_options(
        self,
        request: ecs_20140526_models.CreateKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateKeyPairResponse:
        """
        ## Description
        In addition to calling CreateKeyPair, you can create a key pair by using a third-party key pair generation tool and call the [ImportKeyPair](~~51774~~) operation to upload the key pair to an Alibaba Cloud region.
        A maximum of 500 key pairs can be created in each region. For more information, see [Limits](~~25412~~).
        
        @param request: CreateKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateKeyPair',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateKeyPairResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_key_pair_with_options_async(
        self,
        request: ecs_20140526_models.CreateKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateKeyPairResponse:
        """
        ## Description
        In addition to calling CreateKeyPair, you can create a key pair by using a third-party key pair generation tool and call the [ImportKeyPair](~~51774~~) operation to upload the key pair to an Alibaba Cloud region.
        A maximum of 500 key pairs can be created in each region. For more information, see [Limits](~~25412~~).
        
        @param request: CreateKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateKeyPair',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateKeyPairResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_key_pair(
        self,
        request: ecs_20140526_models.CreateKeyPairRequest,
    ) -> ecs_20140526_models.CreateKeyPairResponse:
        """
        ## Description
        In addition to calling CreateKeyPair, you can create a key pair by using a third-party key pair generation tool and call the [ImportKeyPair](~~51774~~) operation to upload the key pair to an Alibaba Cloud region.
        A maximum of 500 key pairs can be created in each region. For more information, see [Limits](~~25412~~).
        
        @param request: CreateKeyPairRequest
        @return: CreateKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_key_pair_with_options(request, runtime)

    async def create_key_pair_async(
        self,
        request: ecs_20140526_models.CreateKeyPairRequest,
    ) -> ecs_20140526_models.CreateKeyPairResponse:
        """
        ## Description
        In addition to calling CreateKeyPair, you can create a key pair by using a third-party key pair generation tool and call the [ImportKeyPair](~~51774~~) operation to upload the key pair to an Alibaba Cloud region.
        A maximum of 500 key pairs can be created in each region. For more information, see [Limits](~~25412~~).
        
        @param request: CreateKeyPairRequest
        @return: CreateKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_key_pair_with_options_async(request, runtime)

    def create_launch_template_with_options(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateLaunchTemplateResponse:
        """
        Launch templates contain preset configurations used to create instances, such as the region, image ID, instance type, security group ID, and public bandwidth settings. If a specific parameter is not included in a launch template, you must manually specify the parameter when you use the launch template to create an instance.
        After you create a launch template (`CreateLaunchTemplate`), its version number is set to 1 by default. You can create multiple versions (`CreateLaunchTemplateVersion`) for the launch template. Version numbers start from 1 and increment by one. If you do not specify a template version number when you use a launch template to create instances ([RunInstances](~~63440~~)), the default version is used.
        When you call this operation, take note of the following items:
        * You can create up to 30 launch templates in each region. Each launch template can have up to 30 versions.
        * Most parameters in launch templates are optional. When you create a launch template, ECS does not verify the existence or validity of specified parameter values. The validity of the parameter values are verified only when you use the launch template to create instances.
        * If you set a specific parameter in a launch template, you cannot filter out this parameter when you use the launch template to create instances ([RunInstances](~~63440~~)). For example, if you set the `HostName` parameter to LocalHost in a launch template and do not specify the `HostName` parameter when you call the `RunInstances` operation to create instances from the launch template, the instance hostname is still `LocalHost`. If you want to overwrite the `LocalHost` value of HostName provided by the launch template, you can set `HostName` to MyHost or another value when you call the `RunInstances` operation.
        
        @param request: CreateLaunchTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLaunchTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_vm_os_config):
            query['EnableVmOsConfig'] = request.enable_vm_os_config
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_owner_alias):
            query['ImageOwnerAlias'] = request.image_owner_alias
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.network_interface):
            query['NetworkInterface'] = request.network_interface
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.template_resource_group_id):
            query['TemplateResourceGroupId'] = request.template_resource_group_id
        if not UtilClient.is_unset(request.template_tag):
            query['TemplateTag'] = request.template_tag
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.version_description):
            query['VersionDescription'] = request.version_description
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLaunchTemplate',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateLaunchTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_launch_template_with_options_async(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateLaunchTemplateResponse:
        """
        Launch templates contain preset configurations used to create instances, such as the region, image ID, instance type, security group ID, and public bandwidth settings. If a specific parameter is not included in a launch template, you must manually specify the parameter when you use the launch template to create an instance.
        After you create a launch template (`CreateLaunchTemplate`), its version number is set to 1 by default. You can create multiple versions (`CreateLaunchTemplateVersion`) for the launch template. Version numbers start from 1 and increment by one. If you do not specify a template version number when you use a launch template to create instances ([RunInstances](~~63440~~)), the default version is used.
        When you call this operation, take note of the following items:
        * You can create up to 30 launch templates in each region. Each launch template can have up to 30 versions.
        * Most parameters in launch templates are optional. When you create a launch template, ECS does not verify the existence or validity of specified parameter values. The validity of the parameter values are verified only when you use the launch template to create instances.
        * If you set a specific parameter in a launch template, you cannot filter out this parameter when you use the launch template to create instances ([RunInstances](~~63440~~)). For example, if you set the `HostName` parameter to LocalHost in a launch template and do not specify the `HostName` parameter when you call the `RunInstances` operation to create instances from the launch template, the instance hostname is still `LocalHost`. If you want to overwrite the `LocalHost` value of HostName provided by the launch template, you can set `HostName` to MyHost or another value when you call the `RunInstances` operation.
        
        @param request: CreateLaunchTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLaunchTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_vm_os_config):
            query['EnableVmOsConfig'] = request.enable_vm_os_config
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_owner_alias):
            query['ImageOwnerAlias'] = request.image_owner_alias
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.network_interface):
            query['NetworkInterface'] = request.network_interface
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.template_resource_group_id):
            query['TemplateResourceGroupId'] = request.template_resource_group_id
        if not UtilClient.is_unset(request.template_tag):
            query['TemplateTag'] = request.template_tag
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.version_description):
            query['VersionDescription'] = request.version_description
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLaunchTemplate',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateLaunchTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_launch_template(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateRequest,
    ) -> ecs_20140526_models.CreateLaunchTemplateResponse:
        """
        Launch templates contain preset configurations used to create instances, such as the region, image ID, instance type, security group ID, and public bandwidth settings. If a specific parameter is not included in a launch template, you must manually specify the parameter when you use the launch template to create an instance.
        After you create a launch template (`CreateLaunchTemplate`), its version number is set to 1 by default. You can create multiple versions (`CreateLaunchTemplateVersion`) for the launch template. Version numbers start from 1 and increment by one. If you do not specify a template version number when you use a launch template to create instances ([RunInstances](~~63440~~)), the default version is used.
        When you call this operation, take note of the following items:
        * You can create up to 30 launch templates in each region. Each launch template can have up to 30 versions.
        * Most parameters in launch templates are optional. When you create a launch template, ECS does not verify the existence or validity of specified parameter values. The validity of the parameter values are verified only when you use the launch template to create instances.
        * If you set a specific parameter in a launch template, you cannot filter out this parameter when you use the launch template to create instances ([RunInstances](~~63440~~)). For example, if you set the `HostName` parameter to LocalHost in a launch template and do not specify the `HostName` parameter when you call the `RunInstances` operation to create instances from the launch template, the instance hostname is still `LocalHost`. If you want to overwrite the `LocalHost` value of HostName provided by the launch template, you can set `HostName` to MyHost or another value when you call the `RunInstances` operation.
        
        @param request: CreateLaunchTemplateRequest
        @return: CreateLaunchTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_launch_template_with_options(request, runtime)

    async def create_launch_template_async(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateRequest,
    ) -> ecs_20140526_models.CreateLaunchTemplateResponse:
        """
        Launch templates contain preset configurations used to create instances, such as the region, image ID, instance type, security group ID, and public bandwidth settings. If a specific parameter is not included in a launch template, you must manually specify the parameter when you use the launch template to create an instance.
        After you create a launch template (`CreateLaunchTemplate`), its version number is set to 1 by default. You can create multiple versions (`CreateLaunchTemplateVersion`) for the launch template. Version numbers start from 1 and increment by one. If you do not specify a template version number when you use a launch template to create instances ([RunInstances](~~63440~~)), the default version is used.
        When you call this operation, take note of the following items:
        * You can create up to 30 launch templates in each region. Each launch template can have up to 30 versions.
        * Most parameters in launch templates are optional. When you create a launch template, ECS does not verify the existence or validity of specified parameter values. The validity of the parameter values are verified only when you use the launch template to create instances.
        * If you set a specific parameter in a launch template, you cannot filter out this parameter when you use the launch template to create instances ([RunInstances](~~63440~~)). For example, if you set the `HostName` parameter to LocalHost in a launch template and do not specify the `HostName` parameter when you call the `RunInstances` operation to create instances from the launch template, the instance hostname is still `LocalHost`. If you want to overwrite the `LocalHost` value of HostName provided by the launch template, you can set `HostName` to MyHost or another value when you call the `RunInstances` operation.
        
        @param request: CreateLaunchTemplateRequest
        @return: CreateLaunchTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_launch_template_with_options_async(request, runtime)

    def create_launch_template_version_with_options(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateLaunchTemplateVersionResponse:
        """
        ## Description
        To modify the parameters of a launch template version, you can create another version for the launch template. To modify the parameters of a launch template version, you can create another version for the launch template.
        
        @param request: CreateLaunchTemplateVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLaunchTemplateVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_vm_os_config):
            query['EnableVmOsConfig'] = request.enable_vm_os_config
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_owner_alias):
            query['ImageOwnerAlias'] = request.image_owner_alias
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.network_interface):
            query['NetworkInterface'] = request.network_interface
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.version_description):
            query['VersionDescription'] = request.version_description
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLaunchTemplateVersion',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateLaunchTemplateVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_launch_template_version_with_options_async(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateLaunchTemplateVersionResponse:
        """
        ## Description
        To modify the parameters of a launch template version, you can create another version for the launch template. To modify the parameters of a launch template version, you can create another version for the launch template.
        
        @param request: CreateLaunchTemplateVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLaunchTemplateVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_vm_os_config):
            query['EnableVmOsConfig'] = request.enable_vm_os_config
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_owner_alias):
            query['ImageOwnerAlias'] = request.image_owner_alias
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.network_interface):
            query['NetworkInterface'] = request.network_interface
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.version_description):
            query['VersionDescription'] = request.version_description
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLaunchTemplateVersion',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateLaunchTemplateVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_launch_template_version(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateVersionRequest,
    ) -> ecs_20140526_models.CreateLaunchTemplateVersionResponse:
        """
        ## Description
        To modify the parameters of a launch template version, you can create another version for the launch template. To modify the parameters of a launch template version, you can create another version for the launch template.
        
        @param request: CreateLaunchTemplateVersionRequest
        @return: CreateLaunchTemplateVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_launch_template_version_with_options(request, runtime)

    async def create_launch_template_version_async(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateVersionRequest,
    ) -> ecs_20140526_models.CreateLaunchTemplateVersionResponse:
        """
        ## Description
        To modify the parameters of a launch template version, you can create another version for the launch template. To modify the parameters of a launch template version, you can create another version for the launch template.
        
        @param request: CreateLaunchTemplateVersionRequest
        @return: CreateLaunchTemplateVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_launch_template_version_with_options_async(request, runtime)

    def create_nat_gateway_with_options(
        self,
        request: ecs_20140526_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNatGatewayResponse:
        """
        @deprecated
        
        @param request: CreateNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatGatewayResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package):
            query['BandwidthPackage'] = request.bandwidth_package
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_gateway_with_options_async(
        self,
        request: ecs_20140526_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNatGatewayResponse:
        """
        @deprecated
        
        @param request: CreateNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatGatewayResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package):
            query['BandwidthPackage'] = request.bandwidth_package
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_gateway(
        self,
        request: ecs_20140526_models.CreateNatGatewayRequest,
    ) -> ecs_20140526_models.CreateNatGatewayResponse:
        """
        @deprecated
        
        @param request: CreateNatGatewayRequest
        @return: CreateNatGatewayResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nat_gateway_with_options(request, runtime)

    async def create_nat_gateway_async(
        self,
        request: ecs_20140526_models.CreateNatGatewayRequest,
    ) -> ecs_20140526_models.CreateNatGatewayResponse:
        """
        @deprecated
        
        @param request: CreateNatGatewayRequest
        @return: CreateNatGatewayResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_gateway_with_options_async(request, runtime)

    def create_network_interface_with_options(
        self,
        request: ecs_20140526_models.CreateNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNetworkInterfaceResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   This operation is a synchronous operation. After an ENI is created, it immediately enters the Available state and can be attached to an Elastic Compute Service (ECS) instance.
        *   If the NetworkInterfaceId parameter is empty in the response, it indicates that no ENI is created. Call the operation again to create an ENI.
        *   An ENI can be attached only to a single instance that resides in a virtual private cloud (VPC).
        *   When an ENI is attached to a different instance, the attributes of the ENI remain unchanged and the data traffic is redirected to the instance.
        *   If you want to assign IPv6 addresses when you create an ENI, make sure that IPv6 has been enabled for the vSwitch with which to associate the ENI. For more information, see [What is an IPv6 gateway?](~~98896~~)
        *   A quota is imposed on the number of ENIs that can be created per Alibaba Cloud region per account. You can view resource quotas in the ECS console. For more information, see [View and increase resource quotas](~~184115~~).
        **For information about examples on how to call this operation, see **[Create an ENI](~~471552~~).
        
        @param request: CreateNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_4prefix):
            query['Ipv4Prefix'] = request.ipv_4prefix
        if not UtilClient.is_unset(request.ipv_4prefix_count):
            query['Ipv4PrefixCount'] = request.ipv_4prefix_count
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.ipv_6prefix):
            query['Ipv6Prefix'] = request.ipv_6prefix
        if not UtilClient.is_unset(request.ipv_6prefix_count):
            query['Ipv6PrefixCount'] = request.ipv_6prefix_count
        if not UtilClient.is_unset(request.network_interface_name):
            query['NetworkInterfaceName'] = request.network_interface_name
        if not UtilClient.is_unset(request.network_interface_traffic_mode):
            query['NetworkInterfaceTrafficMode'] = request.network_interface_traffic_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.primary_ip_address):
            query['PrimaryIpAddress'] = request.primary_ip_address
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.queue_number):
            query['QueueNumber'] = request.queue_number
        if not UtilClient.is_unset(request.queue_pair_number):
            query['QueuePairNumber'] = request.queue_pair_number
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_private_ip_address_count):
            query['SecondaryPrivateIpAddressCount'] = request.secondary_private_ip_address_count
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.visible):
            query['Visible'] = request.visible
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNetworkInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_interface_with_options_async(
        self,
        request: ecs_20140526_models.CreateNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNetworkInterfaceResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   This operation is a synchronous operation. After an ENI is created, it immediately enters the Available state and can be attached to an Elastic Compute Service (ECS) instance.
        *   If the NetworkInterfaceId parameter is empty in the response, it indicates that no ENI is created. Call the operation again to create an ENI.
        *   An ENI can be attached only to a single instance that resides in a virtual private cloud (VPC).
        *   When an ENI is attached to a different instance, the attributes of the ENI remain unchanged and the data traffic is redirected to the instance.
        *   If you want to assign IPv6 addresses when you create an ENI, make sure that IPv6 has been enabled for the vSwitch with which to associate the ENI. For more information, see [What is an IPv6 gateway?](~~98896~~)
        *   A quota is imposed on the number of ENIs that can be created per Alibaba Cloud region per account. You can view resource quotas in the ECS console. For more information, see [View and increase resource quotas](~~184115~~).
        **For information about examples on how to call this operation, see **[Create an ENI](~~471552~~).
        
        @param request: CreateNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_4prefix):
            query['Ipv4Prefix'] = request.ipv_4prefix
        if not UtilClient.is_unset(request.ipv_4prefix_count):
            query['Ipv4PrefixCount'] = request.ipv_4prefix_count
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.ipv_6prefix):
            query['Ipv6Prefix'] = request.ipv_6prefix
        if not UtilClient.is_unset(request.ipv_6prefix_count):
            query['Ipv6PrefixCount'] = request.ipv_6prefix_count
        if not UtilClient.is_unset(request.network_interface_name):
            query['NetworkInterfaceName'] = request.network_interface_name
        if not UtilClient.is_unset(request.network_interface_traffic_mode):
            query['NetworkInterfaceTrafficMode'] = request.network_interface_traffic_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.primary_ip_address):
            query['PrimaryIpAddress'] = request.primary_ip_address
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.queue_number):
            query['QueueNumber'] = request.queue_number
        if not UtilClient.is_unset(request.queue_pair_number):
            query['QueuePairNumber'] = request.queue_pair_number
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_private_ip_address_count):
            query['SecondaryPrivateIpAddressCount'] = request.secondary_private_ip_address_count
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.visible):
            query['Visible'] = request.visible
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNetworkInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_interface(
        self,
        request: ecs_20140526_models.CreateNetworkInterfaceRequest,
    ) -> ecs_20140526_models.CreateNetworkInterfaceResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   This operation is a synchronous operation. After an ENI is created, it immediately enters the Available state and can be attached to an Elastic Compute Service (ECS) instance.
        *   If the NetworkInterfaceId parameter is empty in the response, it indicates that no ENI is created. Call the operation again to create an ENI.
        *   An ENI can be attached only to a single instance that resides in a virtual private cloud (VPC).
        *   When an ENI is attached to a different instance, the attributes of the ENI remain unchanged and the data traffic is redirected to the instance.
        *   If you want to assign IPv6 addresses when you create an ENI, make sure that IPv6 has been enabled for the vSwitch with which to associate the ENI. For more information, see [What is an IPv6 gateway?](~~98896~~)
        *   A quota is imposed on the number of ENIs that can be created per Alibaba Cloud region per account. You can view resource quotas in the ECS console. For more information, see [View and increase resource quotas](~~184115~~).
        **For information about examples on how to call this operation, see **[Create an ENI](~~471552~~).
        
        @param request: CreateNetworkInterfaceRequest
        @return: CreateNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_network_interface_with_options(request, runtime)

    async def create_network_interface_async(
        self,
        request: ecs_20140526_models.CreateNetworkInterfaceRequest,
    ) -> ecs_20140526_models.CreateNetworkInterfaceResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   This operation is a synchronous operation. After an ENI is created, it immediately enters the Available state and can be attached to an Elastic Compute Service (ECS) instance.
        *   If the NetworkInterfaceId parameter is empty in the response, it indicates that no ENI is created. Call the operation again to create an ENI.
        *   An ENI can be attached only to a single instance that resides in a virtual private cloud (VPC).
        *   When an ENI is attached to a different instance, the attributes of the ENI remain unchanged and the data traffic is redirected to the instance.
        *   If you want to assign IPv6 addresses when you create an ENI, make sure that IPv6 has been enabled for the vSwitch with which to associate the ENI. For more information, see [What is an IPv6 gateway?](~~98896~~)
        *   A quota is imposed on the number of ENIs that can be created per Alibaba Cloud region per account. You can view resource quotas in the ECS console. For more information, see [View and increase resource quotas](~~184115~~).
        **For information about examples on how to call this operation, see **[Create an ENI](~~471552~~).
        
        @param request: CreateNetworkInterfaceRequest
        @return: CreateNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_network_interface_with_options_async(request, runtime)

    def create_network_interface_permission_with_options(
        self,
        request: ecs_20140526_models.CreateNetworkInterfacePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNetworkInterfacePermissionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_id):
            query['AccountId'] = request.account_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permission):
            query['Permission'] = request.permission
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterfacePermission',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNetworkInterfacePermissionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_interface_permission_with_options_async(
        self,
        request: ecs_20140526_models.CreateNetworkInterfacePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNetworkInterfacePermissionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_id):
            query['AccountId'] = request.account_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permission):
            query['Permission'] = request.permission
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterfacePermission',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNetworkInterfacePermissionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_interface_permission(
        self,
        request: ecs_20140526_models.CreateNetworkInterfacePermissionRequest,
    ) -> ecs_20140526_models.CreateNetworkInterfacePermissionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_network_interface_permission_with_options(request, runtime)

    async def create_network_interface_permission_async(
        self,
        request: ecs_20140526_models.CreateNetworkInterfacePermissionRequest,
    ) -> ecs_20140526_models.CreateNetworkInterfacePermissionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_network_interface_permission_with_options_async(request, runtime)

    def create_physical_connection_with_options(
        self,
        request: ecs_20140526_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: CreatePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.bandwidth):
            query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_with_options_async(
        self,
        request: ecs_20140526_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: CreatePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.bandwidth):
            query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection(
        self,
        request: ecs_20140526_models.CreatePhysicalConnectionRequest,
    ) -> ecs_20140526_models.CreatePhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: CreatePhysicalConnectionRequest
        @return: CreatePhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_with_options(request, runtime)

    async def create_physical_connection_async(
        self,
        request: ecs_20140526_models.CreatePhysicalConnectionRequest,
    ) -> ecs_20140526_models.CreatePhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: CreatePhysicalConnectionRequest
        @return: CreatePhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_with_options_async(request, runtime)

    def create_prefix_list_with_options(
        self,
        request: ecs_20140526_models.CreatePrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePrefixListResponse:
        """
        ## Description
        *   A prefix list is a set of one or more network prefixes (CIDR blocks). You can reference prefix lists to configure network rules for other network resources. For more information, see [Overview](~~206223~~).
        *   When you create a prefix list, take note of the following items:
        *   You must specify an IP address family (IPv4 or IPv6) for the prefix list, and cannot change the IP address family after the prefix list is created. You cannot combine IPv4 and IPv6 CIDR blocks in a single prefix list.
        *   You must specify the maximum number of entries that the prefix list can contain. You cannot modify the maximum number of entries after the prefix list is created.
        *   You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and a description for the CIDR block. The total number of your specified entries cannot exceed the maximum number.
        *   For more information about the limits on prefix lists and other resources, see [Limits](~~25412~~).
        *   You can create RAM users and grant them minimum permissions. This eliminates the need to share the AccessKey pair of your Alibaba Cloud account with other users and reduces security risks for your enterprises. For information about how to grant permissions on prefix lists to RAM users, see [Grant permissions on prefix lists to RAM users](~~206175~~)
        
        @param request: CreatePrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_family):
            query['AddressFamily'] = request.address_family
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.entry):
            query['Entry'] = request.entry
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_name):
            query['PrefixListName'] = request.prefix_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePrefixList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePrefixListResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_prefix_list_with_options_async(
        self,
        request: ecs_20140526_models.CreatePrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePrefixListResponse:
        """
        ## Description
        *   A prefix list is a set of one or more network prefixes (CIDR blocks). You can reference prefix lists to configure network rules for other network resources. For more information, see [Overview](~~206223~~).
        *   When you create a prefix list, take note of the following items:
        *   You must specify an IP address family (IPv4 or IPv6) for the prefix list, and cannot change the IP address family after the prefix list is created. You cannot combine IPv4 and IPv6 CIDR blocks in a single prefix list.
        *   You must specify the maximum number of entries that the prefix list can contain. You cannot modify the maximum number of entries after the prefix list is created.
        *   You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and a description for the CIDR block. The total number of your specified entries cannot exceed the maximum number.
        *   For more information about the limits on prefix lists and other resources, see [Limits](~~25412~~).
        *   You can create RAM users and grant them minimum permissions. This eliminates the need to share the AccessKey pair of your Alibaba Cloud account with other users and reduces security risks for your enterprises. For information about how to grant permissions on prefix lists to RAM users, see [Grant permissions on prefix lists to RAM users](~~206175~~)
        
        @param request: CreatePrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_family):
            query['AddressFamily'] = request.address_family
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.entry):
            query['Entry'] = request.entry
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_name):
            query['PrefixListName'] = request.prefix_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePrefixList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePrefixListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_prefix_list(
        self,
        request: ecs_20140526_models.CreatePrefixListRequest,
    ) -> ecs_20140526_models.CreatePrefixListResponse:
        """
        ## Description
        *   A prefix list is a set of one or more network prefixes (CIDR blocks). You can reference prefix lists to configure network rules for other network resources. For more information, see [Overview](~~206223~~).
        *   When you create a prefix list, take note of the following items:
        *   You must specify an IP address family (IPv4 or IPv6) for the prefix list, and cannot change the IP address family after the prefix list is created. You cannot combine IPv4 and IPv6 CIDR blocks in a single prefix list.
        *   You must specify the maximum number of entries that the prefix list can contain. You cannot modify the maximum number of entries after the prefix list is created.
        *   You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and a description for the CIDR block. The total number of your specified entries cannot exceed the maximum number.
        *   For more information about the limits on prefix lists and other resources, see [Limits](~~25412~~).
        *   You can create RAM users and grant them minimum permissions. This eliminates the need to share the AccessKey pair of your Alibaba Cloud account with other users and reduces security risks for your enterprises. For information about how to grant permissions on prefix lists to RAM users, see [Grant permissions on prefix lists to RAM users](~~206175~~)
        
        @param request: CreatePrefixListRequest
        @return: CreatePrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_prefix_list_with_options(request, runtime)

    async def create_prefix_list_async(
        self,
        request: ecs_20140526_models.CreatePrefixListRequest,
    ) -> ecs_20140526_models.CreatePrefixListResponse:
        """
        ## Description
        *   A prefix list is a set of one or more network prefixes (CIDR blocks). You can reference prefix lists to configure network rules for other network resources. For more information, see [Overview](~~206223~~).
        *   When you create a prefix list, take note of the following items:
        *   You must specify an IP address family (IPv4 or IPv6) for the prefix list, and cannot change the IP address family after the prefix list is created. You cannot combine IPv4 and IPv6 CIDR blocks in a single prefix list.
        *   You must specify the maximum number of entries that the prefix list can contain. You cannot modify the maximum number of entries after the prefix list is created.
        *   You can specify one or more entries for the prefix list. Each entry consists of a CIDR block and a description for the CIDR block. The total number of your specified entries cannot exceed the maximum number.
        *   For more information about the limits on prefix lists and other resources, see [Limits](~~25412~~).
        *   You can create RAM users and grant them minimum permissions. This eliminates the need to share the AccessKey pair of your Alibaba Cloud account with other users and reduces security risks for your enterprises. For information about how to grant permissions on prefix lists to RAM users, see [Grant permissions on prefix lists to RAM users](~~206175~~)
        
        @param request: CreatePrefixListRequest
        @return: CreatePrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_prefix_list_with_options_async(request, runtime)

    def create_route_entry_with_options(
        self,
        request: ecs_20140526_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateRouteEntryResponse:
        """
        @deprecated
        
        @param request: CreateRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_route_entry_with_options_async(
        self,
        request: ecs_20140526_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateRouteEntryResponse:
        """
        @deprecated
        
        @param request: CreateRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_route_entry(
        self,
        request: ecs_20140526_models.CreateRouteEntryRequest,
    ) -> ecs_20140526_models.CreateRouteEntryResponse:
        """
        @deprecated
        
        @param request: CreateRouteEntryRequest
        @return: CreateRouteEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_route_entry_with_options(request, runtime)

    async def create_route_entry_async(
        self,
        request: ecs_20140526_models.CreateRouteEntryRequest,
    ) -> ecs_20140526_models.CreateRouteEntryResponse:
        """
        @deprecated
        
        @param request: CreateRouteEntryRequest
        @return: CreateRouteEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_route_entry_with_options_async(request, runtime)

    def create_router_interface_with_options(
        self,
        request: ecs_20140526_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: CreateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.health_check_source_ip):
            query['HealthCheckSourceIp'] = request.health_check_source_ip
        if not UtilClient.is_unset(request.health_check_target_ip):
            query['HealthCheckTargetIp'] = request.health_check_target_ip
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.opposite_access_point_id):
            query['OppositeAccessPointId'] = request.opposite_access_point_id
        if not UtilClient.is_unset(request.opposite_interface_id):
            query['OppositeInterfaceId'] = request.opposite_interface_id
        if not UtilClient.is_unset(request.opposite_interface_owner_id):
            query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        if not UtilClient.is_unset(request.opposite_region_id):
            query['OppositeRegionId'] = request.opposite_region_id
        if not UtilClient.is_unset(request.opposite_router_id):
            query['OppositeRouterId'] = request.opposite_router_id
        if not UtilClient.is_unset(request.opposite_router_type):
            query['OppositeRouterType'] = request.opposite_router_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: CreateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.health_check_source_ip):
            query['HealthCheckSourceIp'] = request.health_check_source_ip
        if not UtilClient.is_unset(request.health_check_target_ip):
            query['HealthCheckTargetIp'] = request.health_check_target_ip
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.opposite_access_point_id):
            query['OppositeAccessPointId'] = request.opposite_access_point_id
        if not UtilClient.is_unset(request.opposite_interface_id):
            query['OppositeInterfaceId'] = request.opposite_interface_id
        if not UtilClient.is_unset(request.opposite_interface_owner_id):
            query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        if not UtilClient.is_unset(request.opposite_region_id):
            query['OppositeRegionId'] = request.opposite_region_id
        if not UtilClient.is_unset(request.opposite_router_id):
            query['OppositeRouterId'] = request.opposite_router_id
        if not UtilClient.is_unset(request.opposite_router_type):
            query['OppositeRouterType'] = request.opposite_router_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_router_interface(
        self,
        request: ecs_20140526_models.CreateRouterInterfaceRequest,
    ) -> ecs_20140526_models.CreateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: CreateRouterInterfaceRequest
        @return: CreateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_router_interface_with_options(request, runtime)

    async def create_router_interface_async(
        self,
        request: ecs_20140526_models.CreateRouterInterfaceRequest,
    ) -> ecs_20140526_models.CreateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: CreateRouterInterfaceRequest
        @return: CreateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_router_interface_with_options_async(request, runtime)

    def create_security_group_with_options(
        self,
        request: ecs_20140526_models.CreateSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSecurityGroupResponse:
        """
        When you call this operation, take note of the following items:
        * You can create a maximum of 100 security groups within a single Alibaba Cloud region.
        * To create a security group of the Virtual Private Cloud (VPC) type, you must specify the VpcId parameter.
        
        @param request: CreateSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_name):
            query['SecurityGroupName'] = request.security_group_name
        if not UtilClient.is_unset(request.security_group_type):
            query['SecurityGroupType'] = request.security_group_type
        if not UtilClient.is_unset(request.service_managed):
            query['ServiceManaged'] = request.service_managed
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_security_group_with_options_async(
        self,
        request: ecs_20140526_models.CreateSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSecurityGroupResponse:
        """
        When you call this operation, take note of the following items:
        * You can create a maximum of 100 security groups within a single Alibaba Cloud region.
        * To create a security group of the Virtual Private Cloud (VPC) type, you must specify the VpcId parameter.
        
        @param request: CreateSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_name):
            query['SecurityGroupName'] = request.security_group_name
        if not UtilClient.is_unset(request.security_group_type):
            query['SecurityGroupType'] = request.security_group_type
        if not UtilClient.is_unset(request.service_managed):
            query['ServiceManaged'] = request.service_managed
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_security_group(
        self,
        request: ecs_20140526_models.CreateSecurityGroupRequest,
    ) -> ecs_20140526_models.CreateSecurityGroupResponse:
        """
        When you call this operation, take note of the following items:
        * You can create a maximum of 100 security groups within a single Alibaba Cloud region.
        * To create a security group of the Virtual Private Cloud (VPC) type, you must specify the VpcId parameter.
        
        @param request: CreateSecurityGroupRequest
        @return: CreateSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_security_group_with_options(request, runtime)

    async def create_security_group_async(
        self,
        request: ecs_20140526_models.CreateSecurityGroupRequest,
    ) -> ecs_20140526_models.CreateSecurityGroupResponse:
        """
        When you call this operation, take note of the following items:
        * You can create a maximum of 100 security groups within a single Alibaba Cloud region.
        * To create a security group of the Virtual Private Cloud (VPC) type, you must specify the VpcId parameter.
        
        @param request: CreateSecurityGroupRequest
        @return: CreateSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_security_group_with_options_async(request, runtime)

    def create_simulated_system_events_with_options(
        self,
        request: ecs_20140526_models.CreateSimulatedSystemEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSimulatedSystemEventsResponse:
        """
        You can use the ECS console, call the [](~~63962~~)operation, or use CloudMonitor to view the scheduled simulated system events.
        The following section describes the lifecycle of a simulated system event:
        *   Scheduled: The state of the simulated system event is automatically changed to Scheduled after it is scheduled.
        *   Executed: The state of the simulated system event is automatically changed to Executed at the scheduled time specified by the NotBefore parameter if no manual intervention is involved.
        *   Canceled: The state of the simulated system event is changed to Canceled if you cancel the event by calling the [CancelSimulatedSystemEvents](~~88808~~) operation.
        *   Avoided: The state of the simulated system event generated from maintenance-triggered instance restart can be changed to Avoided if you restart the instance before the scheduled time of the simulated system event. The maintenance-triggered instance restart is indicated by the SystemMaintenance.Reboot value. For more information, see [RebootInstance](~~25502~~).
        
        @param request: CreateSimulatedSystemEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSimulatedSystemEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.not_before):
            query['NotBefore'] = request.not_before
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimulatedSystemEvents',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSimulatedSystemEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_simulated_system_events_with_options_async(
        self,
        request: ecs_20140526_models.CreateSimulatedSystemEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSimulatedSystemEventsResponse:
        """
        You can use the ECS console, call the [](~~63962~~)operation, or use CloudMonitor to view the scheduled simulated system events.
        The following section describes the lifecycle of a simulated system event:
        *   Scheduled: The state of the simulated system event is automatically changed to Scheduled after it is scheduled.
        *   Executed: The state of the simulated system event is automatically changed to Executed at the scheduled time specified by the NotBefore parameter if no manual intervention is involved.
        *   Canceled: The state of the simulated system event is changed to Canceled if you cancel the event by calling the [CancelSimulatedSystemEvents](~~88808~~) operation.
        *   Avoided: The state of the simulated system event generated from maintenance-triggered instance restart can be changed to Avoided if you restart the instance before the scheduled time of the simulated system event. The maintenance-triggered instance restart is indicated by the SystemMaintenance.Reboot value. For more information, see [RebootInstance](~~25502~~).
        
        @param request: CreateSimulatedSystemEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSimulatedSystemEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.not_before):
            query['NotBefore'] = request.not_before
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimulatedSystemEvents',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSimulatedSystemEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_simulated_system_events(
        self,
        request: ecs_20140526_models.CreateSimulatedSystemEventsRequest,
    ) -> ecs_20140526_models.CreateSimulatedSystemEventsResponse:
        """
        You can use the ECS console, call the [](~~63962~~)operation, or use CloudMonitor to view the scheduled simulated system events.
        The following section describes the lifecycle of a simulated system event:
        *   Scheduled: The state of the simulated system event is automatically changed to Scheduled after it is scheduled.
        *   Executed: The state of the simulated system event is automatically changed to Executed at the scheduled time specified by the NotBefore parameter if no manual intervention is involved.
        *   Canceled: The state of the simulated system event is changed to Canceled if you cancel the event by calling the [CancelSimulatedSystemEvents](~~88808~~) operation.
        *   Avoided: The state of the simulated system event generated from maintenance-triggered instance restart can be changed to Avoided if you restart the instance before the scheduled time of the simulated system event. The maintenance-triggered instance restart is indicated by the SystemMaintenance.Reboot value. For more information, see [RebootInstance](~~25502~~).
        
        @param request: CreateSimulatedSystemEventsRequest
        @return: CreateSimulatedSystemEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_simulated_system_events_with_options(request, runtime)

    async def create_simulated_system_events_async(
        self,
        request: ecs_20140526_models.CreateSimulatedSystemEventsRequest,
    ) -> ecs_20140526_models.CreateSimulatedSystemEventsResponse:
        """
        You can use the ECS console, call the [](~~63962~~)operation, or use CloudMonitor to view the scheduled simulated system events.
        The following section describes the lifecycle of a simulated system event:
        *   Scheduled: The state of the simulated system event is automatically changed to Scheduled after it is scheduled.
        *   Executed: The state of the simulated system event is automatically changed to Executed at the scheduled time specified by the NotBefore parameter if no manual intervention is involved.
        *   Canceled: The state of the simulated system event is changed to Canceled if you cancel the event by calling the [CancelSimulatedSystemEvents](~~88808~~) operation.
        *   Avoided: The state of the simulated system event generated from maintenance-triggered instance restart can be changed to Avoided if you restart the instance before the scheduled time of the simulated system event. The maintenance-triggered instance restart is indicated by the SystemMaintenance.Reboot value. For more information, see [RebootInstance](~~25502~~).
        
        @param request: CreateSimulatedSystemEventsRequest
        @return: CreateSimulatedSystemEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_simulated_system_events_with_options_async(request, runtime)

    def create_snapshot_with_options(
        self,
        request: ecs_20140526_models.CreateSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSnapshotResponse:
        """
        ## Description
        The local snapshot feature is replaced by the instant access feature.
        *   If you have used the local snapshot feature before December 14, 2020, you can use the `Category` or `InstantAccess` parameter as expected and must take note of the following items:
        *   The `Category` and `InstantAccess` parameters cannot be specified at the same time.
        *   If neither of the `Category` and `InstantAccess` parameters is specified, normal snapshots are created.
        *   If you have not used the local snapshot feature before December 14, 2020, you can use the `InstantAccess` parameter and cannot use the `Category` parameter.
        For more information, see [Snapshot service upgrade and addition of a new billable item on December 14, 2020](https://help.aliyun.com/noticelist/articleid/1060755542.html).
        In the following scenarios, you cannot create snapshots for a disk:
        *   The number of manual snapshots of the disk has reached 256.
        *   A snapshot is being created for the disk.
        *   The Elastic Compute Service (ECS) instance to which the disk is attached has never been started.
        *   The ECS instance to which the disk is attached is not in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        When you create a snapshot, take note of the following items:
        *   If a snapshot is being created, you cannot use this snapshot to create a custom image by calling the [CreateImage](~~25535~~) operation.
        *   When a snapshot is being created for a disk that is attached to an ECS instance, do not change the instance state.
        *   You can create snapshots for a disk that is in the **Expired** (`Expired`) state. If the release time scheduled for a disk arrives when a snapshot is being created for the disk, the snapshot is in the **Creating** (`Creating`) state and is deleted when the disk is released.
        
        @param request: CreateSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instant_access):
            query['InstantAccess'] = request.instant_access
        if not UtilClient.is_unset(request.instant_access_retention_days):
            query['InstantAccessRetentionDays'] = request.instant_access_retention_days
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_snapshot_with_options_async(
        self,
        request: ecs_20140526_models.CreateSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSnapshotResponse:
        """
        ## Description
        The local snapshot feature is replaced by the instant access feature.
        *   If you have used the local snapshot feature before December 14, 2020, you can use the `Category` or `InstantAccess` parameter as expected and must take note of the following items:
        *   The `Category` and `InstantAccess` parameters cannot be specified at the same time.
        *   If neither of the `Category` and `InstantAccess` parameters is specified, normal snapshots are created.
        *   If you have not used the local snapshot feature before December 14, 2020, you can use the `InstantAccess` parameter and cannot use the `Category` parameter.
        For more information, see [Snapshot service upgrade and addition of a new billable item on December 14, 2020](https://help.aliyun.com/noticelist/articleid/1060755542.html).
        In the following scenarios, you cannot create snapshots for a disk:
        *   The number of manual snapshots of the disk has reached 256.
        *   A snapshot is being created for the disk.
        *   The Elastic Compute Service (ECS) instance to which the disk is attached has never been started.
        *   The ECS instance to which the disk is attached is not in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        When you create a snapshot, take note of the following items:
        *   If a snapshot is being created, you cannot use this snapshot to create a custom image by calling the [CreateImage](~~25535~~) operation.
        *   When a snapshot is being created for a disk that is attached to an ECS instance, do not change the instance state.
        *   You can create snapshots for a disk that is in the **Expired** (`Expired`) state. If the release time scheduled for a disk arrives when a snapshot is being created for the disk, the snapshot is in the **Creating** (`Creating`) state and is deleted when the disk is released.
        
        @param request: CreateSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instant_access):
            query['InstantAccess'] = request.instant_access
        if not UtilClient.is_unset(request.instant_access_retention_days):
            query['InstantAccessRetentionDays'] = request.instant_access_retention_days
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_snapshot(
        self,
        request: ecs_20140526_models.CreateSnapshotRequest,
    ) -> ecs_20140526_models.CreateSnapshotResponse:
        """
        ## Description
        The local snapshot feature is replaced by the instant access feature.
        *   If you have used the local snapshot feature before December 14, 2020, you can use the `Category` or `InstantAccess` parameter as expected and must take note of the following items:
        *   The `Category` and `InstantAccess` parameters cannot be specified at the same time.
        *   If neither of the `Category` and `InstantAccess` parameters is specified, normal snapshots are created.
        *   If you have not used the local snapshot feature before December 14, 2020, you can use the `InstantAccess` parameter and cannot use the `Category` parameter.
        For more information, see [Snapshot service upgrade and addition of a new billable item on December 14, 2020](https://help.aliyun.com/noticelist/articleid/1060755542.html).
        In the following scenarios, you cannot create snapshots for a disk:
        *   The number of manual snapshots of the disk has reached 256.
        *   A snapshot is being created for the disk.
        *   The Elastic Compute Service (ECS) instance to which the disk is attached has never been started.
        *   The ECS instance to which the disk is attached is not in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        When you create a snapshot, take note of the following items:
        *   If a snapshot is being created, you cannot use this snapshot to create a custom image by calling the [CreateImage](~~25535~~) operation.
        *   When a snapshot is being created for a disk that is attached to an ECS instance, do not change the instance state.
        *   You can create snapshots for a disk that is in the **Expired** (`Expired`) state. If the release time scheduled for a disk arrives when a snapshot is being created for the disk, the snapshot is in the **Creating** (`Creating`) state and is deleted when the disk is released.
        
        @param request: CreateSnapshotRequest
        @return: CreateSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_snapshot_with_options(request, runtime)

    async def create_snapshot_async(
        self,
        request: ecs_20140526_models.CreateSnapshotRequest,
    ) -> ecs_20140526_models.CreateSnapshotResponse:
        """
        ## Description
        The local snapshot feature is replaced by the instant access feature.
        *   If you have used the local snapshot feature before December 14, 2020, you can use the `Category` or `InstantAccess` parameter as expected and must take note of the following items:
        *   The `Category` and `InstantAccess` parameters cannot be specified at the same time.
        *   If neither of the `Category` and `InstantAccess` parameters is specified, normal snapshots are created.
        *   If you have not used the local snapshot feature before December 14, 2020, you can use the `InstantAccess` parameter and cannot use the `Category` parameter.
        For more information, see [Snapshot service upgrade and addition of a new billable item on December 14, 2020](https://help.aliyun.com/noticelist/articleid/1060755542.html).
        In the following scenarios, you cannot create snapshots for a disk:
        *   The number of manual snapshots of the disk has reached 256.
        *   A snapshot is being created for the disk.
        *   The Elastic Compute Service (ECS) instance to which the disk is attached has never been started.
        *   The ECS instance to which the disk is attached is not in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        *   If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query the information of the instance, the instance is locked for security reasons and all operations are prohibited on it.
        When you create a snapshot, take note of the following items:
        *   If a snapshot is being created, you cannot use this snapshot to create a custom image by calling the [CreateImage](~~25535~~) operation.
        *   When a snapshot is being created for a disk that is attached to an ECS instance, do not change the instance state.
        *   You can create snapshots for a disk that is in the **Expired** (`Expired`) state. If the release time scheduled for a disk arrives when a snapshot is being created for the disk, the snapshot is in the **Creating** (`Creating`) state and is deleted when the disk is released.
        
        @param request: CreateSnapshotRequest
        @return: CreateSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_snapshot_with_options_async(request, runtime)

    def create_snapshot_group_with_options(
        self,
        request: ecs_20140526_models.CreateSnapshotGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSnapshotGroupResponse:
        """
        ## Description
        You can specify `InstanceId` to create a snapshot-consistent group for the specified disks in an instance. You can also specify `DiskId.N` to create a snapshot-consistent group for multiple disks that are attached to multiple instances within the same zone.
        > You cannot specify both `DiskId.N` and `ExcludeDiskId.N`. If `InstanceId` is set, you can use `DiskId.N` to specify only disks attached to the instance specified by InstanceId. You cannot use DiskId.N to specify disks attached to multiple instances.
        When you call this operation, take note of the following items:
        *   The disk for which you want to create a snapshot must be in the **In Use** (`In_use`) or **Unattached** (`Available`) state.
        *   If the disk is in the **In Use** (`In_use`) state, the instance to which the disk is attached must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If the disk is in the **Unattached** (`Available`) state, make sure that the disk has been attached to an ECS instance. Snapshots cannot be created for disks that have never been attached to ECS instances.
        *   The snapshot-consistent group feature can be used to create snapshots only for enhanced SSDs (ESSDs).
        *   A single snapshot-consistent group can contain snapshots of up to 16 disks including the system disk and data disks and cannot exceed 32 TiB in size.
        *   Snapshots that you created by using the snapshot-consistent group feature are retained until they are deleted. We recommend that you delete unnecessary snapshots on a regular basis to prevent them from incurring excessive fees.
        *   Snapshot-consistent groups cannot be created for disks that have the multi-attach feature enabled. If disks that have the multi-attach feature enabled are attached to an instance, you must set the `ExcludeDiskId.N` parameter to exclude these disks.
        For information about the snapshot-consistent group feature and its billing, see [Create a snapshot-consistent group](~~199625~~).
        
        @param request: CreateSnapshotGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.exclude_disk_id):
            query['ExcludeDiskId'] = request.exclude_disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instant_access):
            query['InstantAccess'] = request.instant_access
        if not UtilClient.is_unset(request.instant_access_retention_days):
            query['InstantAccessRetentionDays'] = request.instant_access_retention_days
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshotGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSnapshotGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_snapshot_group_with_options_async(
        self,
        request: ecs_20140526_models.CreateSnapshotGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSnapshotGroupResponse:
        """
        ## Description
        You can specify `InstanceId` to create a snapshot-consistent group for the specified disks in an instance. You can also specify `DiskId.N` to create a snapshot-consistent group for multiple disks that are attached to multiple instances within the same zone.
        > You cannot specify both `DiskId.N` and `ExcludeDiskId.N`. If `InstanceId` is set, you can use `DiskId.N` to specify only disks attached to the instance specified by InstanceId. You cannot use DiskId.N to specify disks attached to multiple instances.
        When you call this operation, take note of the following items:
        *   The disk for which you want to create a snapshot must be in the **In Use** (`In_use`) or **Unattached** (`Available`) state.
        *   If the disk is in the **In Use** (`In_use`) state, the instance to which the disk is attached must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If the disk is in the **Unattached** (`Available`) state, make sure that the disk has been attached to an ECS instance. Snapshots cannot be created for disks that have never been attached to ECS instances.
        *   The snapshot-consistent group feature can be used to create snapshots only for enhanced SSDs (ESSDs).
        *   A single snapshot-consistent group can contain snapshots of up to 16 disks including the system disk and data disks and cannot exceed 32 TiB in size.
        *   Snapshots that you created by using the snapshot-consistent group feature are retained until they are deleted. We recommend that you delete unnecessary snapshots on a regular basis to prevent them from incurring excessive fees.
        *   Snapshot-consistent groups cannot be created for disks that have the multi-attach feature enabled. If disks that have the multi-attach feature enabled are attached to an instance, you must set the `ExcludeDiskId.N` parameter to exclude these disks.
        For information about the snapshot-consistent group feature and its billing, see [Create a snapshot-consistent group](~~199625~~).
        
        @param request: CreateSnapshotGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.exclude_disk_id):
            query['ExcludeDiskId'] = request.exclude_disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instant_access):
            query['InstantAccess'] = request.instant_access
        if not UtilClient.is_unset(request.instant_access_retention_days):
            query['InstantAccessRetentionDays'] = request.instant_access_retention_days
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshotGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSnapshotGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_snapshot_group(
        self,
        request: ecs_20140526_models.CreateSnapshotGroupRequest,
    ) -> ecs_20140526_models.CreateSnapshotGroupResponse:
        """
        ## Description
        You can specify `InstanceId` to create a snapshot-consistent group for the specified disks in an instance. You can also specify `DiskId.N` to create a snapshot-consistent group for multiple disks that are attached to multiple instances within the same zone.
        > You cannot specify both `DiskId.N` and `ExcludeDiskId.N`. If `InstanceId` is set, you can use `DiskId.N` to specify only disks attached to the instance specified by InstanceId. You cannot use DiskId.N to specify disks attached to multiple instances.
        When you call this operation, take note of the following items:
        *   The disk for which you want to create a snapshot must be in the **In Use** (`In_use`) or **Unattached** (`Available`) state.
        *   If the disk is in the **In Use** (`In_use`) state, the instance to which the disk is attached must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If the disk is in the **Unattached** (`Available`) state, make sure that the disk has been attached to an ECS instance. Snapshots cannot be created for disks that have never been attached to ECS instances.
        *   The snapshot-consistent group feature can be used to create snapshots only for enhanced SSDs (ESSDs).
        *   A single snapshot-consistent group can contain snapshots of up to 16 disks including the system disk and data disks and cannot exceed 32 TiB in size.
        *   Snapshots that you created by using the snapshot-consistent group feature are retained until they are deleted. We recommend that you delete unnecessary snapshots on a regular basis to prevent them from incurring excessive fees.
        *   Snapshot-consistent groups cannot be created for disks that have the multi-attach feature enabled. If disks that have the multi-attach feature enabled are attached to an instance, you must set the `ExcludeDiskId.N` parameter to exclude these disks.
        For information about the snapshot-consistent group feature and its billing, see [Create a snapshot-consistent group](~~199625~~).
        
        @param request: CreateSnapshotGroupRequest
        @return: CreateSnapshotGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_snapshot_group_with_options(request, runtime)

    async def create_snapshot_group_async(
        self,
        request: ecs_20140526_models.CreateSnapshotGroupRequest,
    ) -> ecs_20140526_models.CreateSnapshotGroupResponse:
        """
        ## Description
        You can specify `InstanceId` to create a snapshot-consistent group for the specified disks in an instance. You can also specify `DiskId.N` to create a snapshot-consistent group for multiple disks that are attached to multiple instances within the same zone.
        > You cannot specify both `DiskId.N` and `ExcludeDiskId.N`. If `InstanceId` is set, you can use `DiskId.N` to specify only disks attached to the instance specified by InstanceId. You cannot use DiskId.N to specify disks attached to multiple instances.
        When you call this operation, take note of the following items:
        *   The disk for which you want to create a snapshot must be in the **In Use** (`In_use`) or **Unattached** (`Available`) state.
        *   If the disk is in the **In Use** (`In_use`) state, the instance to which the disk is attached must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        *   If the disk is in the **Unattached** (`Available`) state, make sure that the disk has been attached to an ECS instance. Snapshots cannot be created for disks that have never been attached to ECS instances.
        *   The snapshot-consistent group feature can be used to create snapshots only for enhanced SSDs (ESSDs).
        *   A single snapshot-consistent group can contain snapshots of up to 16 disks including the system disk and data disks and cannot exceed 32 TiB in size.
        *   Snapshots that you created by using the snapshot-consistent group feature are retained until they are deleted. We recommend that you delete unnecessary snapshots on a regular basis to prevent them from incurring excessive fees.
        *   Snapshot-consistent groups cannot be created for disks that have the multi-attach feature enabled. If disks that have the multi-attach feature enabled are attached to an instance, you must set the `ExcludeDiskId.N` parameter to exclude these disks.
        For information about the snapshot-consistent group feature and its billing, see [Create a snapshot-consistent group](~~199625~~).
        
        @param request: CreateSnapshotGroupRequest
        @return: CreateSnapshotGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_snapshot_group_with_options_async(request, runtime)

    def create_storage_set_with_options(
        self,
        request: ecs_20140526_models.CreateStorageSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateStorageSetResponse:
        """
        ## Description
        A storage set can distribute disks or Shared Block Storage devices to different locations. You can specify the number of partitions in a storage set. A larger number of partitions indicate more discrete distribution of disks or Shared Block Storage devices.
        When you call this operation, take note of the following items:
        *   A limitation exists on the number of storage sets that you can create in a region. You can call the [DescribeAccountAttributes](~~73772~~) operation to query the allowed number of storage sets in a region.
        *   A limitation exists on the number of partitions in a zone. You can call the [DescribeAccountAttributes](~~73772~~) operation to query the allowed number of storage sets in a zone.
        
        @param request: CreateStorageSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStorageSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.max_partition_number):
            query['MaxPartitionNumber'] = request.max_partition_number
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_set_name):
            query['StorageSetName'] = request.storage_set_name
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStorageSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateStorageSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_storage_set_with_options_async(
        self,
        request: ecs_20140526_models.CreateStorageSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateStorageSetResponse:
        """
        ## Description
        A storage set can distribute disks or Shared Block Storage devices to different locations. You can specify the number of partitions in a storage set. A larger number of partitions indicate more discrete distribution of disks or Shared Block Storage devices.
        When you call this operation, take note of the following items:
        *   A limitation exists on the number of storage sets that you can create in a region. You can call the [DescribeAccountAttributes](~~73772~~) operation to query the allowed number of storage sets in a region.
        *   A limitation exists on the number of partitions in a zone. You can call the [DescribeAccountAttributes](~~73772~~) operation to query the allowed number of storage sets in a zone.
        
        @param request: CreateStorageSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStorageSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.max_partition_number):
            query['MaxPartitionNumber'] = request.max_partition_number
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_set_name):
            query['StorageSetName'] = request.storage_set_name
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStorageSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateStorageSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_storage_set(
        self,
        request: ecs_20140526_models.CreateStorageSetRequest,
    ) -> ecs_20140526_models.CreateStorageSetResponse:
        """
        ## Description
        A storage set can distribute disks or Shared Block Storage devices to different locations. You can specify the number of partitions in a storage set. A larger number of partitions indicate more discrete distribution of disks or Shared Block Storage devices.
        When you call this operation, take note of the following items:
        *   A limitation exists on the number of storage sets that you can create in a region. You can call the [DescribeAccountAttributes](~~73772~~) operation to query the allowed number of storage sets in a region.
        *   A limitation exists on the number of partitions in a zone. You can call the [DescribeAccountAttributes](~~73772~~) operation to query the allowed number of storage sets in a zone.
        
        @param request: CreateStorageSetRequest
        @return: CreateStorageSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_storage_set_with_options(request, runtime)

    async def create_storage_set_async(
        self,
        request: ecs_20140526_models.CreateStorageSetRequest,
    ) -> ecs_20140526_models.CreateStorageSetResponse:
        """
        ## Description
        A storage set can distribute disks or Shared Block Storage devices to different locations. You can specify the number of partitions in a storage set. A larger number of partitions indicate more discrete distribution of disks or Shared Block Storage devices.
        When you call this operation, take note of the following items:
        *   A limitation exists on the number of storage sets that you can create in a region. You can call the [DescribeAccountAttributes](~~73772~~) operation to query the allowed number of storage sets in a region.
        *   A limitation exists on the number of partitions in a zone. You can call the [DescribeAccountAttributes](~~73772~~) operation to query the allowed number of storage sets in a zone.
        
        @param request: CreateStorageSetRequest
        @return: CreateStorageSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_storage_set_with_options_async(request, runtime)

    def create_vswitch_with_options(
        self,
        request: ecs_20140526_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVSwitchResponse:
        """
        @deprecated
        
        @param request: CreateVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVSwitchResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vswitch_with_options_async(
        self,
        request: ecs_20140526_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVSwitchResponse:
        """
        @deprecated
        
        @param request: CreateVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVSwitchResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vswitch(
        self,
        request: ecs_20140526_models.CreateVSwitchRequest,
    ) -> ecs_20140526_models.CreateVSwitchResponse:
        """
        @deprecated
        
        @param request: CreateVSwitchRequest
        @return: CreateVSwitchResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vswitch_with_options(request, runtime)

    async def create_vswitch_async(
        self,
        request: ecs_20140526_models.CreateVSwitchRequest,
    ) -> ecs_20140526_models.CreateVSwitchResponse:
        """
        @deprecated
        
        @param request: CreateVSwitchRequest
        @return: CreateVSwitchResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vswitch_with_options_async(request, runtime)

    def create_virtual_border_router_with_options(
        self,
        request: ecs_20140526_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVirtualBorderRouterResponse:
        """
        @deprecated
        
        @param request: CreateVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirtualBorderRouterResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vbr_owner_id):
            query['VbrOwnerId'] = request.vbr_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_virtual_border_router_with_options_async(
        self,
        request: ecs_20140526_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVirtualBorderRouterResponse:
        """
        @deprecated
        
        @param request: CreateVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirtualBorderRouterResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vbr_owner_id):
            query['VbrOwnerId'] = request.vbr_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_virtual_border_router(
        self,
        request: ecs_20140526_models.CreateVirtualBorderRouterRequest,
    ) -> ecs_20140526_models.CreateVirtualBorderRouterResponse:
        """
        @deprecated
        
        @param request: CreateVirtualBorderRouterRequest
        @return: CreateVirtualBorderRouterResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_virtual_border_router_with_options(request, runtime)

    async def create_virtual_border_router_async(
        self,
        request: ecs_20140526_models.CreateVirtualBorderRouterRequest,
    ) -> ecs_20140526_models.CreateVirtualBorderRouterResponse:
        """
        @deprecated
        
        @param request: CreateVirtualBorderRouterRequest
        @return: CreateVirtualBorderRouterResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_virtual_border_router_with_options_async(request, runtime)

    def create_vpc_with_options(
        self,
        request: ecs_20140526_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVpcResponse:
        """
        @deprecated : CreateVpc is deprecated, please use Vpc::2016-04-28::CreateVpc instead.
        
        @param request: CreateVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_with_options_async(
        self,
        request: ecs_20140526_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVpcResponse:
        """
        @deprecated : CreateVpc is deprecated, please use Vpc::2016-04-28::CreateVpc instead.
        
        @param request: CreateVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc(
        self,
        request: ecs_20140526_models.CreateVpcRequest,
    ) -> ecs_20140526_models.CreateVpcResponse:
        """
        @deprecated : CreateVpc is deprecated, please use Vpc::2016-04-28::CreateVpc instead.
        
        @param request: CreateVpcRequest
        @return: CreateVpcResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_with_options(request, runtime)

    async def create_vpc_async(
        self,
        request: ecs_20140526_models.CreateVpcRequest,
    ) -> ecs_20140526_models.CreateVpcResponse:
        """
        @deprecated : CreateVpc is deprecated, please use Vpc::2016-04-28::CreateVpc instead.
        
        @param request: CreateVpcRequest
        @return: CreateVpcResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_with_options_async(request, runtime)

    def deactivate_router_interface_with_options(
        self,
        request: ecs_20140526_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeactivateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: DeactivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeactivateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeactivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def deactivate_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeactivateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: DeactivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeactivateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeactivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deactivate_router_interface(
        self,
        request: ecs_20140526_models.DeactivateRouterInterfaceRequest,
    ) -> ecs_20140526_models.DeactivateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: DeactivateRouterInterfaceRequest
        @return: DeactivateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.deactivate_router_interface_with_options(request, runtime)

    async def deactivate_router_interface_async(
        self,
        request: ecs_20140526_models.DeactivateRouterInterfaceRequest,
    ) -> ecs_20140526_models.DeactivateRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: DeactivateRouterInterfaceRequest
        @return: DeactivateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.deactivate_router_interface_with_options_async(request, runtime)

    def delete_activation_with_options(
        self,
        request: ecs_20140526_models.DeleteActivationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteActivationResponse:
        """
        ## Description
        Before you call this operation to delete an activation code, make sure that the activation code has never been used to register managed instances.
        
        @param request: DeleteActivationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteActivationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_id):
            query['ActivationId'] = request.activation_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteActivation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteActivationResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_activation_with_options_async(
        self,
        request: ecs_20140526_models.DeleteActivationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteActivationResponse:
        """
        ## Description
        Before you call this operation to delete an activation code, make sure that the activation code has never been used to register managed instances.
        
        @param request: DeleteActivationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteActivationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_id):
            query['ActivationId'] = request.activation_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteActivation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteActivationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_activation(
        self,
        request: ecs_20140526_models.DeleteActivationRequest,
    ) -> ecs_20140526_models.DeleteActivationResponse:
        """
        ## Description
        Before you call this operation to delete an activation code, make sure that the activation code has never been used to register managed instances.
        
        @param request: DeleteActivationRequest
        @return: DeleteActivationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_activation_with_options(request, runtime)

    async def delete_activation_async(
        self,
        request: ecs_20140526_models.DeleteActivationRequest,
    ) -> ecs_20140526_models.DeleteActivationResponse:
        """
        ## Description
        Before you call this operation to delete an activation code, make sure that the activation code has never been used to register managed instances.
        
        @param request: DeleteActivationRequest
        @return: DeleteActivationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_activation_with_options_async(request, runtime)

    def delete_auto_provisioning_group_with_options(
        self,
        request: ecs_20140526_models.DeleteAutoProvisioningGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteAutoProvisioningGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_instances):
            query['TerminateInstances'] = request.terminate_instances
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoProvisioningGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteAutoProvisioningGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_auto_provisioning_group_with_options_async(
        self,
        request: ecs_20140526_models.DeleteAutoProvisioningGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteAutoProvisioningGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_instances):
            query['TerminateInstances'] = request.terminate_instances
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoProvisioningGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteAutoProvisioningGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_auto_provisioning_group(
        self,
        request: ecs_20140526_models.DeleteAutoProvisioningGroupRequest,
    ) -> ecs_20140526_models.DeleteAutoProvisioningGroupResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_auto_provisioning_group_with_options(request, runtime)

    async def delete_auto_provisioning_group_async(
        self,
        request: ecs_20140526_models.DeleteAutoProvisioningGroupRequest,
    ) -> ecs_20140526_models.DeleteAutoProvisioningGroupResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_auto_provisioning_group_with_options_async(request, runtime)

    def delete_auto_snapshot_policy_with_options(
        self,
        request: ecs_20140526_models.DeleteAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteAutoSnapshotPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteAutoSnapshotPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_auto_snapshot_policy_with_options_async(
        self,
        request: ecs_20140526_models.DeleteAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteAutoSnapshotPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteAutoSnapshotPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_auto_snapshot_policy(
        self,
        request: ecs_20140526_models.DeleteAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.DeleteAutoSnapshotPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_auto_snapshot_policy_with_options(request, runtime)

    async def delete_auto_snapshot_policy_async(
        self,
        request: ecs_20140526_models.DeleteAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.DeleteAutoSnapshotPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_auto_snapshot_policy_with_options_async(request, runtime)

    def delete_bandwidth_package_with_options(
        self,
        request: ecs_20140526_models.DeleteBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteBandwidthPackageResponse:
        """
        @deprecated
        
        @param request: DeleteBandwidthPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBandwidthPackageResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBandwidthPackage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bandwidth_package_with_options_async(
        self,
        request: ecs_20140526_models.DeleteBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteBandwidthPackageResponse:
        """
        @deprecated
        
        @param request: DeleteBandwidthPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBandwidthPackageResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBandwidthPackage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bandwidth_package(
        self,
        request: ecs_20140526_models.DeleteBandwidthPackageRequest,
    ) -> ecs_20140526_models.DeleteBandwidthPackageResponse:
        """
        @deprecated
        
        @param request: DeleteBandwidthPackageRequest
        @return: DeleteBandwidthPackageResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_bandwidth_package_with_options(request, runtime)

    async def delete_bandwidth_package_async(
        self,
        request: ecs_20140526_models.DeleteBandwidthPackageRequest,
    ) -> ecs_20140526_models.DeleteBandwidthPackageResponse:
        """
        @deprecated
        
        @param request: DeleteBandwidthPackageRequest
        @return: DeleteBandwidthPackageResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_bandwidth_package_with_options_async(request, runtime)

    def delete_command_with_options(
        self,
        request: ecs_20140526_models.DeleteCommandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteCommandResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_id):
            query['CommandId'] = request.command_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCommand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteCommandResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_command_with_options_async(
        self,
        request: ecs_20140526_models.DeleteCommandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteCommandResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_id):
            query['CommandId'] = request.command_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCommand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteCommandResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_command(
        self,
        request: ecs_20140526_models.DeleteCommandRequest,
    ) -> ecs_20140526_models.DeleteCommandResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_command_with_options(request, runtime)

    async def delete_command_async(
        self,
        request: ecs_20140526_models.DeleteCommandRequest,
    ) -> ecs_20140526_models.DeleteCommandResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_command_with_options_async(request, runtime)

    def delete_dedicated_host_cluster_with_options(
        self,
        request: ecs_20140526_models.DeleteDedicatedHostClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDedicatedHostClusterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDedicatedHostCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDedicatedHostClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dedicated_host_cluster_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDedicatedHostClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDedicatedHostClusterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDedicatedHostCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDedicatedHostClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dedicated_host_cluster(
        self,
        request: ecs_20140526_models.DeleteDedicatedHostClusterRequest,
    ) -> ecs_20140526_models.DeleteDedicatedHostClusterResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_dedicated_host_cluster_with_options(request, runtime)

    async def delete_dedicated_host_cluster_async(
        self,
        request: ecs_20140526_models.DeleteDedicatedHostClusterRequest,
    ) -> ecs_20140526_models.DeleteDedicatedHostClusterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_dedicated_host_cluster_with_options_async(request, runtime)

    def delete_demand_with_options(
        self,
        request: ecs_20140526_models.DeleteDemandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDemandResponse:
        """
        >  This operation is in internal preview and has not been officially released. We recommend that you avoid using this operation.
        
        @param request: DeleteDemandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDemandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.demand_id):
            query['DemandId'] = request.demand_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDemand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDemandResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_demand_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDemandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDemandResponse:
        """
        >  This operation is in internal preview and has not been officially released. We recommend that you avoid using this operation.
        
        @param request: DeleteDemandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDemandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.demand_id):
            query['DemandId'] = request.demand_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDemand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDemandResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_demand(
        self,
        request: ecs_20140526_models.DeleteDemandRequest,
    ) -> ecs_20140526_models.DeleteDemandResponse:
        """
        >  This operation is in internal preview and has not been officially released. We recommend that you avoid using this operation.
        
        @param request: DeleteDemandRequest
        @return: DeleteDemandResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_demand_with_options(request, runtime)

    async def delete_demand_async(
        self,
        request: ecs_20140526_models.DeleteDemandRequest,
    ) -> ecs_20140526_models.DeleteDemandResponse:
        """
        >  This operation is in internal preview and has not been officially released. We recommend that you avoid using this operation.
        
        @param request: DeleteDemandRequest
        @return: DeleteDemandResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_demand_with_options_async(request, runtime)

    def delete_deployment_set_with_options(
        self,
        request: ecs_20140526_models.DeleteDeploymentSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDeploymentSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDeploymentSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDeploymentSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_deployment_set_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDeploymentSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDeploymentSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDeploymentSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDeploymentSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_deployment_set(
        self,
        request: ecs_20140526_models.DeleteDeploymentSetRequest,
    ) -> ecs_20140526_models.DeleteDeploymentSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_deployment_set_with_options(request, runtime)

    async def delete_deployment_set_async(
        self,
        request: ecs_20140526_models.DeleteDeploymentSetRequest,
    ) -> ecs_20140526_models.DeleteDeploymentSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_deployment_set_with_options_async(request, runtime)

    def delete_diagnostic_metric_sets_with_options(
        self,
        request: ecs_20140526_models.DeleteDiagnosticMetricSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiagnosticMetricSetsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.metric_set_ids):
            query['MetricSetIds'] = request.metric_set_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDiagnosticMetricSets',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiagnosticMetricSetsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_diagnostic_metric_sets_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDiagnosticMetricSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiagnosticMetricSetsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.metric_set_ids):
            query['MetricSetIds'] = request.metric_set_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDiagnosticMetricSets',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiagnosticMetricSetsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_diagnostic_metric_sets(
        self,
        request: ecs_20140526_models.DeleteDiagnosticMetricSetsRequest,
    ) -> ecs_20140526_models.DeleteDiagnosticMetricSetsResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_diagnostic_metric_sets_with_options(request, runtime)

    async def delete_diagnostic_metric_sets_async(
        self,
        request: ecs_20140526_models.DeleteDiagnosticMetricSetsRequest,
    ) -> ecs_20140526_models.DeleteDiagnosticMetricSetsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_diagnostic_metric_sets_with_options_async(request, runtime)

    def delete_diagnostic_reports_with_options(
        self,
        request: ecs_20140526_models.DeleteDiagnosticReportsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiagnosticReportsResponse:
        """
        You can call this operation to delete the diagnostic reports that are no longer needed.
        
        @param request: DeleteDiagnosticReportsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiagnosticReportsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_ids):
            query['ReportIds'] = request.report_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDiagnosticReports',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiagnosticReportsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_diagnostic_reports_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDiagnosticReportsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiagnosticReportsResponse:
        """
        You can call this operation to delete the diagnostic reports that are no longer needed.
        
        @param request: DeleteDiagnosticReportsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiagnosticReportsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_ids):
            query['ReportIds'] = request.report_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDiagnosticReports',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiagnosticReportsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_diagnostic_reports(
        self,
        request: ecs_20140526_models.DeleteDiagnosticReportsRequest,
    ) -> ecs_20140526_models.DeleteDiagnosticReportsResponse:
        """
        You can call this operation to delete the diagnostic reports that are no longer needed.
        
        @param request: DeleteDiagnosticReportsRequest
        @return: DeleteDiagnosticReportsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_diagnostic_reports_with_options(request, runtime)

    async def delete_diagnostic_reports_async(
        self,
        request: ecs_20140526_models.DeleteDiagnosticReportsRequest,
    ) -> ecs_20140526_models.DeleteDiagnosticReportsResponse:
        """
        You can call this operation to delete the diagnostic reports that are no longer needed.
        
        @param request: DeleteDiagnosticReportsRequest
        @return: DeleteDiagnosticReportsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_diagnostic_reports_with_options_async(request, runtime)

    def delete_disk_with_options(
        self,
        request: ecs_20140526_models.DeleteDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiskResponse:
        """
        ## Description
        When you call this operation to release a pay-as-you-go data disk, take note of the following items:
        *   Manual snapshots of the disk are retained.
        *   You can call the [ModifyDiskAttribute](~~25517~~) operation to configure whether to release automatic snapshots together with the disk. We recommend that you delete unneeded snapshots to maintain an enough snapshot quota for new automatic snapshots.
        *   The disk must be in the Unattached (Available) state.
        *   If the specified disk does not exist, the request is ignored.
        
        @param request: DeleteDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_disk_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiskResponse:
        """
        ## Description
        When you call this operation to release a pay-as-you-go data disk, take note of the following items:
        *   Manual snapshots of the disk are retained.
        *   You can call the [ModifyDiskAttribute](~~25517~~) operation to configure whether to release automatic snapshots together with the disk. We recommend that you delete unneeded snapshots to maintain an enough snapshot quota for new automatic snapshots.
        *   The disk must be in the Unattached (Available) state.
        *   If the specified disk does not exist, the request is ignored.
        
        @param request: DeleteDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_disk(
        self,
        request: ecs_20140526_models.DeleteDiskRequest,
    ) -> ecs_20140526_models.DeleteDiskResponse:
        """
        ## Description
        When you call this operation to release a pay-as-you-go data disk, take note of the following items:
        *   Manual snapshots of the disk are retained.
        *   You can call the [ModifyDiskAttribute](~~25517~~) operation to configure whether to release automatic snapshots together with the disk. We recommend that you delete unneeded snapshots to maintain an enough snapshot quota for new automatic snapshots.
        *   The disk must be in the Unattached (Available) state.
        *   If the specified disk does not exist, the request is ignored.
        
        @param request: DeleteDiskRequest
        @return: DeleteDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_disk_with_options(request, runtime)

    async def delete_disk_async(
        self,
        request: ecs_20140526_models.DeleteDiskRequest,
    ) -> ecs_20140526_models.DeleteDiskResponse:
        """
        ## Description
        When you call this operation to release a pay-as-you-go data disk, take note of the following items:
        *   Manual snapshots of the disk are retained.
        *   You can call the [ModifyDiskAttribute](~~25517~~) operation to configure whether to release automatic snapshots together with the disk. We recommend that you delete unneeded snapshots to maintain an enough snapshot quota for new automatic snapshots.
        *   The disk must be in the Unattached (Available) state.
        *   If the specified disk does not exist, the request is ignored.
        
        @param request: DeleteDiskRequest
        @return: DeleteDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_disk_with_options_async(request, runtime)

    def delete_forward_entry_with_options(
        self,
        request: ecs_20140526_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteForwardEntryResponse:
        """
        @deprecated
        
        @param request: DeleteForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteForwardEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_forward_entry_with_options_async(
        self,
        request: ecs_20140526_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteForwardEntryResponse:
        """
        @deprecated
        
        @param request: DeleteForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteForwardEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_forward_entry(
        self,
        request: ecs_20140526_models.DeleteForwardEntryRequest,
    ) -> ecs_20140526_models.DeleteForwardEntryResponse:
        """
        @deprecated
        
        @param request: DeleteForwardEntryRequest
        @return: DeleteForwardEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_forward_entry_with_options(request, runtime)

    async def delete_forward_entry_async(
        self,
        request: ecs_20140526_models.DeleteForwardEntryRequest,
    ) -> ecs_20140526_models.DeleteForwardEntryResponse:
        """
        @deprecated
        
        @param request: DeleteForwardEntryRequest
        @return: DeleteForwardEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_forward_entry_with_options_async(request, runtime)

    def delete_ha_vip_with_options(
        self,
        request: ecs_20140526_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteHaVipResponse:
        """
        @deprecated
        
        @param request: DeleteHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ha_vip_with_options_async(
        self,
        request: ecs_20140526_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteHaVipResponse:
        """
        @deprecated
        
        @param request: DeleteHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ha_vip(
        self,
        request: ecs_20140526_models.DeleteHaVipRequest,
    ) -> ecs_20140526_models.DeleteHaVipResponse:
        """
        @deprecated
        
        @param request: DeleteHaVipRequest
        @return: DeleteHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ha_vip_with_options(request, runtime)

    async def delete_ha_vip_async(
        self,
        request: ecs_20140526_models.DeleteHaVipRequest,
    ) -> ecs_20140526_models.DeleteHaVipResponse:
        """
        @deprecated
        
        @param request: DeleteHaVipRequest
        @return: DeleteHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ha_vip_with_options_async(request, runtime)

    def delete_hpc_cluster_with_options(
        self,
        request: ecs_20140526_models.DeleteHpcClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteHpcClusterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.hpc_cluster_id):
            query['HpcClusterId'] = request.hpc_cluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHpcCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteHpcClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_hpc_cluster_with_options_async(
        self,
        request: ecs_20140526_models.DeleteHpcClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteHpcClusterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.hpc_cluster_id):
            query['HpcClusterId'] = request.hpc_cluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHpcCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteHpcClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_hpc_cluster(
        self,
        request: ecs_20140526_models.DeleteHpcClusterRequest,
    ) -> ecs_20140526_models.DeleteHpcClusterResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_hpc_cluster_with_options(request, runtime)

    async def delete_hpc_cluster_async(
        self,
        request: ecs_20140526_models.DeleteHpcClusterRequest,
    ) -> ecs_20140526_models.DeleteHpcClusterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_hpc_cluster_with_options_async(request, runtime)

    def delete_image_with_options(
        self,
        request: ecs_20140526_models.DeleteImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_image_with_options_async(
        self,
        request: ecs_20140526_models.DeleteImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_image(
        self,
        request: ecs_20140526_models.DeleteImageRequest,
    ) -> ecs_20140526_models.DeleteImageResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_image_with_options(request, runtime)

    async def delete_image_async(
        self,
        request: ecs_20140526_models.DeleteImageRequest,
    ) -> ecs_20140526_models.DeleteImageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_image_with_options_async(request, runtime)

    def delete_image_component_with_options(
        self,
        request: ecs_20140526_models.DeleteImageComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImageComponentResponse:
        """
        Only custom image components can be deleted.
        
        @param request: DeleteImageComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_component_id):
            query['ImageComponentId'] = request.image_component_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImageComponent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImageComponentResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_image_component_with_options_async(
        self,
        request: ecs_20140526_models.DeleteImageComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImageComponentResponse:
        """
        Only custom image components can be deleted.
        
        @param request: DeleteImageComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_component_id):
            query['ImageComponentId'] = request.image_component_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImageComponent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImageComponentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_image_component(
        self,
        request: ecs_20140526_models.DeleteImageComponentRequest,
    ) -> ecs_20140526_models.DeleteImageComponentResponse:
        """
        Only custom image components can be deleted.
        
        @param request: DeleteImageComponentRequest
        @return: DeleteImageComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_image_component_with_options(request, runtime)

    async def delete_image_component_async(
        self,
        request: ecs_20140526_models.DeleteImageComponentRequest,
    ) -> ecs_20140526_models.DeleteImageComponentResponse:
        """
        Only custom image components can be deleted.
        
        @param request: DeleteImageComponentRequest
        @return: DeleteImageComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_image_component_with_options_async(request, runtime)

    def delete_image_pipeline_with_options(
        self,
        request: ecs_20140526_models.DeleteImagePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImagePipelineResponse:
        """
        ## Description
        If an image build task based on an image template is in the BUILDING, DISTRIBUTING, RELEASING, or CANCELLING state, you cannot delete the template. You can delete the template only when the image build task is in the SUCCESS, FAILED, or CANCELLED state. You can call the DescribeImagePipelineExecutions operation to query the details of an image build task.
        
        @param request: DeleteImagePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImagePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_pipeline_id):
            query['ImagePipelineId'] = request.image_pipeline_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImagePipeline',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImagePipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_image_pipeline_with_options_async(
        self,
        request: ecs_20140526_models.DeleteImagePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImagePipelineResponse:
        """
        ## Description
        If an image build task based on an image template is in the BUILDING, DISTRIBUTING, RELEASING, or CANCELLING state, you cannot delete the template. You can delete the template only when the image build task is in the SUCCESS, FAILED, or CANCELLED state. You can call the DescribeImagePipelineExecutions operation to query the details of an image build task.
        
        @param request: DeleteImagePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImagePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_pipeline_id):
            query['ImagePipelineId'] = request.image_pipeline_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImagePipeline',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImagePipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_image_pipeline(
        self,
        request: ecs_20140526_models.DeleteImagePipelineRequest,
    ) -> ecs_20140526_models.DeleteImagePipelineResponse:
        """
        ## Description
        If an image build task based on an image template is in the BUILDING, DISTRIBUTING, RELEASING, or CANCELLING state, you cannot delete the template. You can delete the template only when the image build task is in the SUCCESS, FAILED, or CANCELLED state. You can call the DescribeImagePipelineExecutions operation to query the details of an image build task.
        
        @param request: DeleteImagePipelineRequest
        @return: DeleteImagePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_image_pipeline_with_options(request, runtime)

    async def delete_image_pipeline_async(
        self,
        request: ecs_20140526_models.DeleteImagePipelineRequest,
    ) -> ecs_20140526_models.DeleteImagePipelineResponse:
        """
        ## Description
        If an image build task based on an image template is in the BUILDING, DISTRIBUTING, RELEASING, or CANCELLING state, you cannot delete the template. You can delete the template only when the image build task is in the SUCCESS, FAILED, or CANCELLED state. You can call the DescribeImagePipelineExecutions operation to query the details of an image build task.
        
        @param request: DeleteImagePipelineRequest
        @return: DeleteImagePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_image_pipeline_with_options_async(request, runtime)

    def delete_instance_with_options(
        self,
        request: ecs_20140526_models.DeleteInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteInstanceResponse:
        """
        ## Description
        *   After an instance is released, all the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        *   Disks attached to the instance:
        *   The disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks.
        *   The disks for which `DeleteWithInstance` is set to true are released along with the instance.
        *   For disks for which `DeleteAutoSnapshot` is set to false, the automatic snapshots of the disks are retained.
        *   For disks for which `DeleteAutoSnapshot` is set to true, the automatic snapshots of the disks are released.
        *   Manual snapshots of the disks are retained.
        *   If `OperationLocks` in the response contains `"LockReason" : "security"` for an instance, the instance is locked for security reasons. For more information, see [API behavior when an instance is locked for security reasons](~~25695~~). Even if `DeleteWithInstance` is set to `false` for the data disks that are attached to the instance, this parameter is ignored and the data disks are released along with the instance.
        
        @param request: DeleteInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_subscription):
            query['TerminateSubscription'] = request.terminate_subscription
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_instance_with_options_async(
        self,
        request: ecs_20140526_models.DeleteInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteInstanceResponse:
        """
        ## Description
        *   After an instance is released, all the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        *   Disks attached to the instance:
        *   The disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks.
        *   The disks for which `DeleteWithInstance` is set to true are released along with the instance.
        *   For disks for which `DeleteAutoSnapshot` is set to false, the automatic snapshots of the disks are retained.
        *   For disks for which `DeleteAutoSnapshot` is set to true, the automatic snapshots of the disks are released.
        *   Manual snapshots of the disks are retained.
        *   If `OperationLocks` in the response contains `"LockReason" : "security"` for an instance, the instance is locked for security reasons. For more information, see [API behavior when an instance is locked for security reasons](~~25695~~). Even if `DeleteWithInstance` is set to `false` for the data disks that are attached to the instance, this parameter is ignored and the data disks are released along with the instance.
        
        @param request: DeleteInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_subscription):
            query['TerminateSubscription'] = request.terminate_subscription
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_instance(
        self,
        request: ecs_20140526_models.DeleteInstanceRequest,
    ) -> ecs_20140526_models.DeleteInstanceResponse:
        """
        ## Description
        *   After an instance is released, all the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        *   Disks attached to the instance:
        *   The disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks.
        *   The disks for which `DeleteWithInstance` is set to true are released along with the instance.
        *   For disks for which `DeleteAutoSnapshot` is set to false, the automatic snapshots of the disks are retained.
        *   For disks for which `DeleteAutoSnapshot` is set to true, the automatic snapshots of the disks are released.
        *   Manual snapshots of the disks are retained.
        *   If `OperationLocks` in the response contains `"LockReason" : "security"` for an instance, the instance is locked for security reasons. For more information, see [API behavior when an instance is locked for security reasons](~~25695~~). Even if `DeleteWithInstance` is set to `false` for the data disks that are attached to the instance, this parameter is ignored and the data disks are released along with the instance.
        
        @param request: DeleteInstanceRequest
        @return: DeleteInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_instance_with_options(request, runtime)

    async def delete_instance_async(
        self,
        request: ecs_20140526_models.DeleteInstanceRequest,
    ) -> ecs_20140526_models.DeleteInstanceResponse:
        """
        ## Description
        *   After an instance is released, all the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        *   Disks attached to the instance:
        *   The disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks.
        *   The disks for which `DeleteWithInstance` is set to true are released along with the instance.
        *   For disks for which `DeleteAutoSnapshot` is set to false, the automatic snapshots of the disks are retained.
        *   For disks for which `DeleteAutoSnapshot` is set to true, the automatic snapshots of the disks are released.
        *   Manual snapshots of the disks are retained.
        *   If `OperationLocks` in the response contains `"LockReason" : "security"` for an instance, the instance is locked for security reasons. For more information, see [API behavior when an instance is locked for security reasons](~~25695~~). Even if `DeleteWithInstance` is set to `false` for the data disks that are attached to the instance, this parameter is ignored and the data disks are released along with the instance.
        
        @param request: DeleteInstanceRequest
        @return: DeleteInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_instance_with_options_async(request, runtime)

    def delete_instances_with_options(
        self,
        request: ecs_20140526_models.DeleteInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteInstancesResponse:
        """
        After an instance is released, all the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        *   Disks attached to the instance:
        *   The disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks.
        *   The disks for which `DeleteWithInstance` is set to true are released along with the instance.
        *   For disks for which `DeleteAutoSnapshot` is set to false, the automatic snapshots of the disks are retained.
        *   For disks for which `DeleteAutoSnapshot` is set to true, the automatic snapshots of the disks are released.
        *   Manual snapshots of the disks are retained.
        *   If `OperationLocks` in the DescribeInstances response contains `"LockReason" : "security"` for an instance, the instance is locked for security reasons. Even if the `DeleteWithInstance` parameter is set to `false` for the data disks that are attached to the instance, the parameter is ignored and the data disks are released along with the instance. For more information, see [API behavior when an instance is locked for security reasons](~~25695~~).
        
        @param request: DeleteInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_subscription):
            query['TerminateSubscription'] = request.terminate_subscription
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_instances_with_options_async(
        self,
        request: ecs_20140526_models.DeleteInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteInstancesResponse:
        """
        After an instance is released, all the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        *   Disks attached to the instance:
        *   The disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks.
        *   The disks for which `DeleteWithInstance` is set to true are released along with the instance.
        *   For disks for which `DeleteAutoSnapshot` is set to false, the automatic snapshots of the disks are retained.
        *   For disks for which `DeleteAutoSnapshot` is set to true, the automatic snapshots of the disks are released.
        *   Manual snapshots of the disks are retained.
        *   If `OperationLocks` in the DescribeInstances response contains `"LockReason" : "security"` for an instance, the instance is locked for security reasons. Even if the `DeleteWithInstance` parameter is set to `false` for the data disks that are attached to the instance, the parameter is ignored and the data disks are released along with the instance. For more information, see [API behavior when an instance is locked for security reasons](~~25695~~).
        
        @param request: DeleteInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_subscription):
            query['TerminateSubscription'] = request.terminate_subscription
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_instances(
        self,
        request: ecs_20140526_models.DeleteInstancesRequest,
    ) -> ecs_20140526_models.DeleteInstancesResponse:
        """
        After an instance is released, all the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        *   Disks attached to the instance:
        *   The disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks.
        *   The disks for which `DeleteWithInstance` is set to true are released along with the instance.
        *   For disks for which `DeleteAutoSnapshot` is set to false, the automatic snapshots of the disks are retained.
        *   For disks for which `DeleteAutoSnapshot` is set to true, the automatic snapshots of the disks are released.
        *   Manual snapshots of the disks are retained.
        *   If `OperationLocks` in the DescribeInstances response contains `"LockReason" : "security"` for an instance, the instance is locked for security reasons. Even if the `DeleteWithInstance` parameter is set to `false` for the data disks that are attached to the instance, the parameter is ignored and the data disks are released along with the instance. For more information, see [API behavior when an instance is locked for security reasons](~~25695~~).
        
        @param request: DeleteInstancesRequest
        @return: DeleteInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_instances_with_options(request, runtime)

    async def delete_instances_async(
        self,
        request: ecs_20140526_models.DeleteInstancesRequest,
    ) -> ecs_20140526_models.DeleteInstancesResponse:
        """
        After an instance is released, all the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        *   Disks attached to the instance:
        *   The disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks.
        *   The disks for which `DeleteWithInstance` is set to true are released along with the instance.
        *   For disks for which `DeleteAutoSnapshot` is set to false, the automatic snapshots of the disks are retained.
        *   For disks for which `DeleteAutoSnapshot` is set to true, the automatic snapshots of the disks are released.
        *   Manual snapshots of the disks are retained.
        *   If `OperationLocks` in the DescribeInstances response contains `"LockReason" : "security"` for an instance, the instance is locked for security reasons. Even if the `DeleteWithInstance` parameter is set to `false` for the data disks that are attached to the instance, the parameter is ignored and the data disks are released along with the instance. For more information, see [API behavior when an instance is locked for security reasons](~~25695~~).
        
        @param request: DeleteInstancesRequest
        @return: DeleteInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_instances_with_options_async(request, runtime)

    def delete_key_pairs_with_options(
        self,
        request: ecs_20140526_models.DeleteKeyPairsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteKeyPairsResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   After an SSH key pair is deleted, you cannot query the SSH key pair by calling the [DescribeKeyPairs](~~51773~~) operation.
        *   If an SSH key pair is bound to one or more Elastic Compute Service (ECS) instances, the SSH key pair cannot be deleted.
        
        @param request: DeleteKeyPairsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteKeyPairsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_names):
            query['KeyPairNames'] = request.key_pair_names
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteKeyPairs',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteKeyPairsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_key_pairs_with_options_async(
        self,
        request: ecs_20140526_models.DeleteKeyPairsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteKeyPairsResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   After an SSH key pair is deleted, you cannot query the SSH key pair by calling the [DescribeKeyPairs](~~51773~~) operation.
        *   If an SSH key pair is bound to one or more Elastic Compute Service (ECS) instances, the SSH key pair cannot be deleted.
        
        @param request: DeleteKeyPairsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteKeyPairsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_names):
            query['KeyPairNames'] = request.key_pair_names
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteKeyPairs',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteKeyPairsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_key_pairs(
        self,
        request: ecs_20140526_models.DeleteKeyPairsRequest,
    ) -> ecs_20140526_models.DeleteKeyPairsResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   After an SSH key pair is deleted, you cannot query the SSH key pair by calling the [DescribeKeyPairs](~~51773~~) operation.
        *   If an SSH key pair is bound to one or more Elastic Compute Service (ECS) instances, the SSH key pair cannot be deleted.
        
        @param request: DeleteKeyPairsRequest
        @return: DeleteKeyPairsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_key_pairs_with_options(request, runtime)

    async def delete_key_pairs_async(
        self,
        request: ecs_20140526_models.DeleteKeyPairsRequest,
    ) -> ecs_20140526_models.DeleteKeyPairsResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   After an SSH key pair is deleted, you cannot query the SSH key pair by calling the [DescribeKeyPairs](~~51773~~) operation.
        *   If an SSH key pair is bound to one or more Elastic Compute Service (ECS) instances, the SSH key pair cannot be deleted.
        
        @param request: DeleteKeyPairsRequest
        @return: DeleteKeyPairsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_key_pairs_with_options_async(request, runtime)

    def delete_launch_template_with_options(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteLaunchTemplateResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLaunchTemplate',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteLaunchTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_launch_template_with_options_async(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteLaunchTemplateResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLaunchTemplate',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteLaunchTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_launch_template(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateRequest,
    ) -> ecs_20140526_models.DeleteLaunchTemplateResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_launch_template_with_options(request, runtime)

    async def delete_launch_template_async(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateRequest,
    ) -> ecs_20140526_models.DeleteLaunchTemplateResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_launch_template_with_options_async(request, runtime)

    def delete_launch_template_version_with_options(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteLaunchTemplateVersionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_version):
            query['DeleteVersion'] = request.delete_version
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLaunchTemplateVersion',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteLaunchTemplateVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_launch_template_version_with_options_async(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteLaunchTemplateVersionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_version):
            query['DeleteVersion'] = request.delete_version
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLaunchTemplateVersion',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteLaunchTemplateVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_launch_template_version(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateVersionRequest,
    ) -> ecs_20140526_models.DeleteLaunchTemplateVersionResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_launch_template_version_with_options(request, runtime)

    async def delete_launch_template_version_async(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateVersionRequest,
    ) -> ecs_20140526_models.DeleteLaunchTemplateVersionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_launch_template_version_with_options_async(request, runtime)

    def delete_nat_gateway_with_options(
        self,
        request: ecs_20140526_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNatGatewayResponse:
        """
        @deprecated
        
        @param request: DeleteNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatGatewayResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_gateway_with_options_async(
        self,
        request: ecs_20140526_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNatGatewayResponse:
        """
        @deprecated
        
        @param request: DeleteNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatGatewayResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_gateway(
        self,
        request: ecs_20140526_models.DeleteNatGatewayRequest,
    ) -> ecs_20140526_models.DeleteNatGatewayResponse:
        """
        @deprecated
        
        @param request: DeleteNatGatewayRequest
        @return: DeleteNatGatewayResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_gateway_with_options(request, runtime)

    async def delete_nat_gateway_async(
        self,
        request: ecs_20140526_models.DeleteNatGatewayRequest,
    ) -> ecs_20140526_models.DeleteNatGatewayResponse:
        """
        @deprecated
        
        @param request: DeleteNatGatewayRequest
        @return: DeleteNatGatewayResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_gateway_with_options_async(request, runtime)

    def delete_network_interface_with_options(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNetworkInterfaceResponse:
        """
        ## Description
        *   The ENI must be in the Available state.
        *   If the ENI is bound to an ECS instance, you must unbind the ENI from the ECS instance ([DetachNetworkInterface](~~58514~~)) before you can delete the ENI.
        *   After an ENI is deleted:
        *   The primary private IP address of the ENI is automatically released.
        *   The ENI is automatically removed from its security groups.
        
        @param request: DeleteNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNetworkInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_interface_with_options_async(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNetworkInterfaceResponse:
        """
        ## Description
        *   The ENI must be in the Available state.
        *   If the ENI is bound to an ECS instance, you must unbind the ENI from the ECS instance ([DetachNetworkInterface](~~58514~~)) before you can delete the ENI.
        *   After an ENI is deleted:
        *   The primary private IP address of the ENI is automatically released.
        *   The ENI is automatically removed from its security groups.
        
        @param request: DeleteNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNetworkInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_interface(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfaceRequest,
    ) -> ecs_20140526_models.DeleteNetworkInterfaceResponse:
        """
        ## Description
        *   The ENI must be in the Available state.
        *   If the ENI is bound to an ECS instance, you must unbind the ENI from the ECS instance ([DetachNetworkInterface](~~58514~~)) before you can delete the ENI.
        *   After an ENI is deleted:
        *   The primary private IP address of the ENI is automatically released.
        *   The ENI is automatically removed from its security groups.
        
        @param request: DeleteNetworkInterfaceRequest
        @return: DeleteNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_interface_with_options(request, runtime)

    async def delete_network_interface_async(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfaceRequest,
    ) -> ecs_20140526_models.DeleteNetworkInterfaceResponse:
        """
        ## Description
        *   The ENI must be in the Available state.
        *   If the ENI is bound to an ECS instance, you must unbind the ENI from the ECS instance ([DetachNetworkInterface](~~58514~~)) before you can delete the ENI.
        *   After an ENI is deleted:
        *   The primary private IP address of the ENI is automatically released.
        *   The ENI is automatically removed from its security groups.
        
        @param request: DeleteNetworkInterfaceRequest
        @return: DeleteNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_interface_with_options_async(request, runtime)

    def delete_network_interface_permission_with_options(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfacePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNetworkInterfacePermissionResponse:
        """
        @deprecated
        
        @param request: DeleteNetworkInterfacePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfacePermissionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.network_interface_permission_id):
            query['NetworkInterfacePermissionId'] = request.network_interface_permission_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterfacePermission',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNetworkInterfacePermissionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_interface_permission_with_options_async(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfacePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNetworkInterfacePermissionResponse:
        """
        @deprecated
        
        @param request: DeleteNetworkInterfacePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfacePermissionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.network_interface_permission_id):
            query['NetworkInterfacePermissionId'] = request.network_interface_permission_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterfacePermission',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNetworkInterfacePermissionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_interface_permission(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfacePermissionRequest,
    ) -> ecs_20140526_models.DeleteNetworkInterfacePermissionResponse:
        """
        @deprecated
        
        @param request: DeleteNetworkInterfacePermissionRequest
        @return: DeleteNetworkInterfacePermissionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_interface_permission_with_options(request, runtime)

    async def delete_network_interface_permission_async(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfacePermissionRequest,
    ) -> ecs_20140526_models.DeleteNetworkInterfacePermissionResponse:
        """
        @deprecated
        
        @param request: DeleteNetworkInterfacePermissionRequest
        @return: DeleteNetworkInterfacePermissionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_interface_permission_with_options_async(request, runtime)

    def delete_physical_connection_with_options(
        self,
        request: ecs_20140526_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: DeletePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_physical_connection_with_options_async(
        self,
        request: ecs_20140526_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: DeletePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_physical_connection(
        self,
        request: ecs_20140526_models.DeletePhysicalConnectionRequest,
    ) -> ecs_20140526_models.DeletePhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: DeletePhysicalConnectionRequest
        @return: DeletePhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_physical_connection_with_options(request, runtime)

    async def delete_physical_connection_async(
        self,
        request: ecs_20140526_models.DeletePhysicalConnectionRequest,
    ) -> ecs_20140526_models.DeletePhysicalConnectionResponse:
        """
        @deprecated
        
        @param request: DeletePhysicalConnectionRequest
        @return: DeletePhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_physical_connection_with_options_async(request, runtime)

    def delete_prefix_list_with_options(
        self,
        request: ecs_20140526_models.DeletePrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePrefixListResponse:
        """
        ## Description
        If a prefix list is associated with resources, you cannot delete the prefix list. You must disassociate the prefix list from the resources before you can delete the prefix list. You can call the [DescribePrefixListAssociations](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/describeprefixlistassociations) operation to query resources that are associated with a specific prefix list.
        
        @param request: DeletePrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_id):
            query['PrefixListId'] = request.prefix_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrefixList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePrefixListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_prefix_list_with_options_async(
        self,
        request: ecs_20140526_models.DeletePrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePrefixListResponse:
        """
        ## Description
        If a prefix list is associated with resources, you cannot delete the prefix list. You must disassociate the prefix list from the resources before you can delete the prefix list. You can call the [DescribePrefixListAssociations](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/describeprefixlistassociations) operation to query resources that are associated with a specific prefix list.
        
        @param request: DeletePrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_id):
            query['PrefixListId'] = request.prefix_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrefixList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePrefixListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_prefix_list(
        self,
        request: ecs_20140526_models.DeletePrefixListRequest,
    ) -> ecs_20140526_models.DeletePrefixListResponse:
        """
        ## Description
        If a prefix list is associated with resources, you cannot delete the prefix list. You must disassociate the prefix list from the resources before you can delete the prefix list. You can call the [DescribePrefixListAssociations](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/describeprefixlistassociations) operation to query resources that are associated with a specific prefix list.
        
        @param request: DeletePrefixListRequest
        @return: DeletePrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_prefix_list_with_options(request, runtime)

    async def delete_prefix_list_async(
        self,
        request: ecs_20140526_models.DeletePrefixListRequest,
    ) -> ecs_20140526_models.DeletePrefixListResponse:
        """
        ## Description
        If a prefix list is associated with resources, you cannot delete the prefix list. You must disassociate the prefix list from the resources before you can delete the prefix list. You can call the [DescribePrefixListAssociations](https://www.alibabacloud.com/help/en/elastic-compute-service/latest/describeprefixlistassociations) operation to query resources that are associated with a specific prefix list.
        
        @param request: DeletePrefixListRequest
        @return: DeletePrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_prefix_list_with_options_async(request, runtime)

    def delete_route_entry_with_options(
        self,
        request: ecs_20140526_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteRouteEntryResponse:
        """
        @deprecated
        
        @param request: DeleteRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_route_entry_with_options_async(
        self,
        request: ecs_20140526_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteRouteEntryResponse:
        """
        @deprecated
        
        @param request: DeleteRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_route_entry(
        self,
        request: ecs_20140526_models.DeleteRouteEntryRequest,
    ) -> ecs_20140526_models.DeleteRouteEntryResponse:
        """
        @deprecated
        
        @param request: DeleteRouteEntryRequest
        @return: DeleteRouteEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_route_entry_with_options(request, runtime)

    async def delete_route_entry_async(
        self,
        request: ecs_20140526_models.DeleteRouteEntryRequest,
    ) -> ecs_20140526_models.DeleteRouteEntryResponse:
        """
        @deprecated
        
        @param request: DeleteRouteEntryRequest
        @return: DeleteRouteEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_route_entry_with_options_async(request, runtime)

    def delete_router_interface_with_options(
        self,
        request: ecs_20140526_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: DeleteRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: DeleteRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_router_interface(
        self,
        request: ecs_20140526_models.DeleteRouterInterfaceRequest,
    ) -> ecs_20140526_models.DeleteRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: DeleteRouterInterfaceRequest
        @return: DeleteRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_router_interface_with_options(request, runtime)

    async def delete_router_interface_async(
        self,
        request: ecs_20140526_models.DeleteRouterInterfaceRequest,
    ) -> ecs_20140526_models.DeleteRouterInterfaceResponse:
        """
        @deprecated
        
        @param request: DeleteRouterInterfaceRequest
        @return: DeleteRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_router_interface_with_options_async(request, runtime)

    def delete_security_group_with_options(
        self,
        request: ecs_20140526_models.DeleteSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSecurityGroupResponse:
        """
        ## Description
        Before you delete a security group, make sure that no instances are present in the security group and that the security group is not referenced by other security groups [DescribeSecurityGroupReferences](~~57320~~)). Otherwise, the DeleteSecurityGroup request fails.
        
        @param request: DeleteSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_security_group_with_options_async(
        self,
        request: ecs_20140526_models.DeleteSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSecurityGroupResponse:
        """
        ## Description
        Before you delete a security group, make sure that no instances are present in the security group and that the security group is not referenced by other security groups [DescribeSecurityGroupReferences](~~57320~~)). Otherwise, the DeleteSecurityGroup request fails.
        
        @param request: DeleteSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_security_group(
        self,
        request: ecs_20140526_models.DeleteSecurityGroupRequest,
    ) -> ecs_20140526_models.DeleteSecurityGroupResponse:
        """
        ## Description
        Before you delete a security group, make sure that no instances are present in the security group and that the security group is not referenced by other security groups [DescribeSecurityGroupReferences](~~57320~~)). Otherwise, the DeleteSecurityGroup request fails.
        
        @param request: DeleteSecurityGroupRequest
        @return: DeleteSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_security_group_with_options(request, runtime)

    async def delete_security_group_async(
        self,
        request: ecs_20140526_models.DeleteSecurityGroupRequest,
    ) -> ecs_20140526_models.DeleteSecurityGroupResponse:
        """
        ## Description
        Before you delete a security group, make sure that no instances are present in the security group and that the security group is not referenced by other security groups [DescribeSecurityGroupReferences](~~57320~~)). Otherwise, the DeleteSecurityGroup request fails.
        
        @param request: DeleteSecurityGroupRequest
        @return: DeleteSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_security_group_with_options_async(request, runtime)

    def delete_snapshot_with_options(
        self,
        request: ecs_20140526_models.DeleteSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSnapshotResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   If the specified snapshot ID does not exist, the request is ignored.
        *   A snapshot that has been used to create custom images cannot be deleted. The snapshot can be deleted only after the created custom images are deleted ([DeleteImage](~~25537~~)).
        *   A snapshot that has been used to create disks cannot be deleted. If you do want to delete the snapshot, set the `Force` parameter to true to force delete the snapshot. The disks created from the snapshot cannot be re-initialized after the snapshot is force deleted.
        
        @param request: DeleteSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snapshot_with_options_async(
        self,
        request: ecs_20140526_models.DeleteSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSnapshotResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   If the specified snapshot ID does not exist, the request is ignored.
        *   A snapshot that has been used to create custom images cannot be deleted. The snapshot can be deleted only after the created custom images are deleted ([DeleteImage](~~25537~~)).
        *   A snapshot that has been used to create disks cannot be deleted. If you do want to delete the snapshot, set the `Force` parameter to true to force delete the snapshot. The disks created from the snapshot cannot be re-initialized after the snapshot is force deleted.
        
        @param request: DeleteSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snapshot(
        self,
        request: ecs_20140526_models.DeleteSnapshotRequest,
    ) -> ecs_20140526_models.DeleteSnapshotResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   If the specified snapshot ID does not exist, the request is ignored.
        *   A snapshot that has been used to create custom images cannot be deleted. The snapshot can be deleted only after the created custom images are deleted ([DeleteImage](~~25537~~)).
        *   A snapshot that has been used to create disks cannot be deleted. If you do want to delete the snapshot, set the `Force` parameter to true to force delete the snapshot. The disks created from the snapshot cannot be re-initialized after the snapshot is force deleted.
        
        @param request: DeleteSnapshotRequest
        @return: DeleteSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snapshot_with_options(request, runtime)

    async def delete_snapshot_async(
        self,
        request: ecs_20140526_models.DeleteSnapshotRequest,
    ) -> ecs_20140526_models.DeleteSnapshotResponse:
        """
        ## Description
        When you call this operation, take note of the following items:
        *   If the specified snapshot ID does not exist, the request is ignored.
        *   A snapshot that has been used to create custom images cannot be deleted. The snapshot can be deleted only after the created custom images are deleted ([DeleteImage](~~25537~~)).
        *   A snapshot that has been used to create disks cannot be deleted. If you do want to delete the snapshot, set the `Force` parameter to true to force delete the snapshot. The disks created from the snapshot cannot be re-initialized after the snapshot is force deleted.
        
        @param request: DeleteSnapshotRequest
        @return: DeleteSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snapshot_with_options_async(request, runtime)

    def delete_snapshot_group_with_options(
        self,
        request: ecs_20140526_models.DeleteSnapshotGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSnapshotGroupResponse:
        """
        ## Description
        If you have custom images that were created from a disk snapshot contained in a snapshot-consistent group, the disk snapshot is retained when the snapshot-consistent group is deleted. Before you can delete the disk snapshot, you must call the [DeleteImage](~~25537~~) operation to delete the custom images. Then, you can call the [DeleteSnapshot](~~25525~~) operation to delete the disk snapshot.
        
        @param request: DeleteSnapshotGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_group_id):
            query['SnapshotGroupId'] = request.snapshot_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshotGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSnapshotGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snapshot_group_with_options_async(
        self,
        request: ecs_20140526_models.DeleteSnapshotGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSnapshotGroupResponse:
        """
        ## Description
        If you have custom images that were created from a disk snapshot contained in a snapshot-consistent group, the disk snapshot is retained when the snapshot-consistent group is deleted. Before you can delete the disk snapshot, you must call the [DeleteImage](~~25537~~) operation to delete the custom images. Then, you can call the [DeleteSnapshot](~~25525~~) operation to delete the disk snapshot.
        
        @param request: DeleteSnapshotGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_group_id):
            query['SnapshotGroupId'] = request.snapshot_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshotGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSnapshotGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snapshot_group(
        self,
        request: ecs_20140526_models.DeleteSnapshotGroupRequest,
    ) -> ecs_20140526_models.DeleteSnapshotGroupResponse:
        """
        ## Description
        If you have custom images that were created from a disk snapshot contained in a snapshot-consistent group, the disk snapshot is retained when the snapshot-consistent group is deleted. Before you can delete the disk snapshot, you must call the [DeleteImage](~~25537~~) operation to delete the custom images. Then, you can call the [DeleteSnapshot](~~25525~~) operation to delete the disk snapshot.
        
        @param request: DeleteSnapshotGroupRequest
        @return: DeleteSnapshotGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snapshot_group_with_options(request, runtime)

    async def delete_snapshot_group_async(
        self,
        request: ecs_20140526_models.DeleteSnapshotGroupRequest,
    ) -> ecs_20140526_models.DeleteSnapshotGroupResponse:
        """
        ## Description
        If you have custom images that were created from a disk snapshot contained in a snapshot-consistent group, the disk snapshot is retained when the snapshot-consistent group is deleted. Before you can delete the disk snapshot, you must call the [DeleteImage](~~25537~~) operation to delete the custom images. Then, you can call the [DeleteSnapshot](~~25525~~) operation to delete the disk snapshot.
        
        @param request: DeleteSnapshotGroupRequest
        @return: DeleteSnapshotGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snapshot_group_with_options_async(request, runtime)

    def delete_storage_set_with_options(
        self,
        request: ecs_20140526_models.DeleteStorageSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteStorageSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStorageSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteStorageSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_storage_set_with_options_async(
        self,
        request: ecs_20140526_models.DeleteStorageSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteStorageSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStorageSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteStorageSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_storage_set(
        self,
        request: ecs_20140526_models.DeleteStorageSetRequest,
    ) -> ecs_20140526_models.DeleteStorageSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_storage_set_with_options(request, runtime)

    async def delete_storage_set_async(
        self,
        request: ecs_20140526_models.DeleteStorageSetRequest,
    ) -> ecs_20140526_models.DeleteStorageSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_storage_set_with_options_async(request, runtime)

    def delete_vswitch_with_options(
        self,
        request: ecs_20140526_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVSwitchResponse:
        """
        @deprecated
        
        @param request: DeleteVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVSwitchResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vswitch_with_options_async(
        self,
        request: ecs_20140526_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVSwitchResponse:
        """
        @deprecated
        
        @param request: DeleteVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVSwitchResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vswitch(
        self,
        request: ecs_20140526_models.DeleteVSwitchRequest,
    ) -> ecs_20140526_models.DeleteVSwitchResponse:
        """
        @deprecated
        
        @param request: DeleteVSwitchRequest
        @return: DeleteVSwitchResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vswitch_with_options(request, runtime)

    async def delete_vswitch_async(
        self,
        request: ecs_20140526_models.DeleteVSwitchRequest,
    ) -> ecs_20140526_models.DeleteVSwitchResponse:
        """
        @deprecated
        
        @param request: DeleteVSwitchRequest
        @return: DeleteVSwitchResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vswitch_with_options_async(request, runtime)

    def delete_virtual_border_router_with_options(
        self,
        request: ecs_20140526_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVirtualBorderRouterResponse:
        """
        @deprecated
        
        @param request: DeleteVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVirtualBorderRouterResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_virtual_border_router_with_options_async(
        self,
        request: ecs_20140526_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVirtualBorderRouterResponse:
        """
        @deprecated
        
        @param request: DeleteVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVirtualBorderRouterResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_virtual_border_router(
        self,
        request: ecs_20140526_models.DeleteVirtualBorderRouterRequest,
    ) -> ecs_20140526_models.DeleteVirtualBorderRouterResponse:
        """
        @deprecated
        
        @param request: DeleteVirtualBorderRouterRequest
        @return: DeleteVirtualBorderRouterResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_virtual_border_router_with_options(request, runtime)

    async def delete_virtual_border_router_async(
        self,
        request: ecs_20140526_models.DeleteVirtualBorderRouterRequest,
    ) -> ecs_20140526_models.DeleteVirtualBorderRouterResponse:
        """
        @deprecated
        
        @param request: DeleteVirtualBorderRouterRequest
        @return: DeleteVirtualBorderRouterResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_virtual_border_router_with_options_async(request, runtime)

    def delete_vpc_with_options(
        self,
        request: ecs_20140526_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVpcResponse:
        """
        @deprecated
        
        @param request: DeleteVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_with_options_async(
        self,
        request: ecs_20140526_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVpcResponse:
        """
        @deprecated
        
        @param request: DeleteVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc(
        self,
        request: ecs_20140526_models.DeleteVpcRequest,
    ) -> ecs_20140526_models.DeleteVpcResponse:
        """
        @deprecated
        
        @param request: DeleteVpcRequest
        @return: DeleteVpcResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_with_options(request, runtime)

    async def delete_vpc_async(
        self,
        request: ecs_20140526_models.DeleteVpcRequest,
    ) -> ecs_20140526_models.DeleteVpcResponse:
        """
        @deprecated
        
        @param request: DeleteVpcRequest
        @return: DeleteVpcResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_with_options_async(request, runtime)

    def deregister_managed_instance_with_options(
        self,
        request: ecs_20140526_models.DeregisterManagedInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeregisterManagedInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeregisterManagedInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeregisterManagedInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def deregister_managed_instance_with_options_async(
        self,
        request: ecs_20140526_models.DeregisterManagedInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeregisterManagedInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeregisterManagedInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeregisterManagedInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deregister_managed_instance(
        self,
        request: ecs_20140526_models.DeregisterManagedInstanceRequest,
    ) -> ecs_20140526_models.DeregisterManagedInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.deregister_managed_instance_with_options(request, runtime)

    async def deregister_managed_instance_async(
        self,
        request: ecs_20140526_models.DeregisterManagedInstanceRequest,
    ) -> ecs_20140526_models.DeregisterManagedInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.deregister_managed_instance_with_options_async(request, runtime)

    def describe_access_points_with_options(
        self,
        request: ecs_20140526_models.DescribeAccessPointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAccessPointsResponse:
        """
        @deprecated
        
        @param request: DescribeAccessPointsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessPointsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessPoints',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAccessPointsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_points_with_options_async(
        self,
        request: ecs_20140526_models.DescribeAccessPointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAccessPointsResponse:
        """
        @deprecated
        
        @param request: DescribeAccessPointsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessPointsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessPoints',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAccessPointsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_points(
        self,
        request: ecs_20140526_models.DescribeAccessPointsRequest,
    ) -> ecs_20140526_models.DescribeAccessPointsResponse:
        """
        @deprecated
        
        @param request: DescribeAccessPointsRequest
        @return: DescribeAccessPointsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_access_points_with_options(request, runtime)

    async def describe_access_points_async(
        self,
        request: ecs_20140526_models.DescribeAccessPointsRequest,
    ) -> ecs_20140526_models.DescribeAccessPointsResponse:
        """
        @deprecated
        
        @param request: DescribeAccessPointsRequest
        @return: DescribeAccessPointsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_points_with_options_async(request, runtime)

    def describe_account_attributes_with_options(
        self,
        request: ecs_20140526_models.DescribeAccountAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAccountAttributesResponse:
        """
        After you [create](https://account.alibabacloud.com/register/intl_register.htm) an Alibaba Cloud account, you can create a specific number of ECS instances in different regions within the account. For more information, see [Limits](~~25412~~).
        You can also [submit a ticket](https://workorder-intl.console.aliyun.com/#/ticket/createIndex) to request a quota increase.
        
        @param request: DescribeAccountAttributesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountAttributesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attribute_name):
            query['AttributeName'] = request.attribute_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccountAttributes',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAccountAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_account_attributes_with_options_async(
        self,
        request: ecs_20140526_models.DescribeAccountAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAccountAttributesResponse:
        """
        After you [create](https://account.alibabacloud.com/register/intl_register.htm) an Alibaba Cloud account, you can create a specific number of ECS instances in different regions within the account. For more information, see [Limits](~~25412~~).
        You can also [submit a ticket](https://workorder-intl.console.aliyun.com/#/ticket/createIndex) to request a quota increase.
        
        @param request: DescribeAccountAttributesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountAttributesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attribute_name):
            query['AttributeName'] = request.attribute_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccountAttributes',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAccountAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_account_attributes(
        self,
        request: ecs_20140526_models.DescribeAccountAttributesRequest,
    ) -> ecs_20140526_models.DescribeAccountAttributesResponse:
        """
        After you [create](https://account.alibabacloud.com/register/intl_register.htm) an Alibaba Cloud account, you can create a specific number of ECS instances in different regions within the account. For more information, see [Limits](~~25412~~).
        You can also [submit a ticket](https://workorder-intl.console.aliyun.com/#/ticket/createIndex) to request a quota increase.
        
        @param request: DescribeAccountAttributesRequest
        @return: DescribeAccountAttributesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_account_attributes_with_options(request, runtime)

    async def describe_account_attributes_async(
        self,
        request: ecs_20140526_models.DescribeAccountAttributesRequest,
    ) -> ecs_20140526_models.DescribeAccountAttributesResponse:
        """
        After you [create](https://account.alibabacloud.com/register/intl_register.htm) an Alibaba Cloud account, you can create a specific number of ECS instances in different regions within the account. For more information, see [Limits](~~25412~~).
        You can also [submit a ticket](https://workorder-intl.console.aliyun.com/#/ticket/createIndex) to request a quota increase.
        
        @param request: DescribeAccountAttributesRequest
        @return: DescribeAccountAttributesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_account_attributes_with_options_async(request, runtime)

    def describe_activations_with_options(
        self,
        request: ecs_20140526_models.DescribeActivationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeActivationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_id):
            query['ActivationId'] = request.activation_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActivations',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeActivationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_activations_with_options_async(
        self,
        request: ecs_20140526_models.DescribeActivationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeActivationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_id):
            query['ActivationId'] = request.activation_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActivations',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeActivationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_activations(
        self,
        request: ecs_20140526_models.DescribeActivationsRequest,
    ) -> ecs_20140526_models.DescribeActivationsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_activations_with_options(request, runtime)

    async def describe_activations_async(
        self,
        request: ecs_20140526_models.DescribeActivationsRequest,
    ) -> ecs_20140526_models.DescribeActivationsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_activations_with_options_async(request, runtime)

    def describe_auto_provisioning_group_history_with_options(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupHistoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupHistoryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoProvisioningGroupHistory',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAutoProvisioningGroupHistoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_auto_provisioning_group_history_with_options_async(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupHistoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupHistoryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoProvisioningGroupHistory',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAutoProvisioningGroupHistoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_auto_provisioning_group_history(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupHistoryRequest,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupHistoryResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_auto_provisioning_group_history_with_options(request, runtime)

    async def describe_auto_provisioning_group_history_async(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupHistoryRequest,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupHistoryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_auto_provisioning_group_history_with_options_async(request, runtime)

    def describe_auto_provisioning_group_instances_with_options(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoProvisioningGroupInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAutoProvisioningGroupInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_auto_provisioning_group_instances_with_options_async(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoProvisioningGroupInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAutoProvisioningGroupInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_auto_provisioning_group_instances(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupInstancesRequest,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_auto_provisioning_group_instances_with_options(request, runtime)

    async def describe_auto_provisioning_group_instances_async(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupInstancesRequest,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_auto_provisioning_group_instances_with_options_async(request, runtime)

    def describe_auto_provisioning_groups_with_options(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.auto_provisioning_group_name):
            query['AutoProvisioningGroupName'] = request.auto_provisioning_group_name
        if not UtilClient.is_unset(request.auto_provisioning_group_status):
            query['AutoProvisioningGroupStatus'] = request.auto_provisioning_group_status
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoProvisioningGroups',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAutoProvisioningGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_auto_provisioning_groups_with_options_async(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.auto_provisioning_group_name):
            query['AutoProvisioningGroupName'] = request.auto_provisioning_group_name
        if not UtilClient.is_unset(request.auto_provisioning_group_status):
            query['AutoProvisioningGroupStatus'] = request.auto_provisioning_group_status
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoProvisioningGroups',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAutoProvisioningGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_auto_provisioning_groups(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupsRequest,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_auto_provisioning_groups_with_options(request, runtime)

    async def describe_auto_provisioning_groups_async(
        self,
        request: ecs_20140526_models.DescribeAutoProvisioningGroupsRequest,
    ) -> ecs_20140526_models.DescribeAutoProvisioningGroupsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_auto_provisioning_groups_with_options_async(request, runtime)

    def describe_auto_snapshot_policy_ex_with_options(
        self,
        request: ecs_20140526_models.DescribeAutoSnapshotPolicyExRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAutoSnapshotPolicyExResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['AutoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_name):
            query['AutoSnapshotPolicyName'] = request.auto_snapshot_policy_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoSnapshotPolicyEx',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAutoSnapshotPolicyExResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_auto_snapshot_policy_ex_with_options_async(
        self,
        request: ecs_20140526_models.DescribeAutoSnapshotPolicyExRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAutoSnapshotPolicyExResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['AutoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_name):
            query['AutoSnapshotPolicyName'] = request.auto_snapshot_policy_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAutoSnapshotPolicyEx',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAutoSnapshotPolicyExResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_auto_snapshot_policy_ex(
        self,
        request: ecs_20140526_models.DescribeAutoSnapshotPolicyExRequest,
    ) -> ecs_20140526_models.DescribeAutoSnapshotPolicyExResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_auto_snapshot_policy_ex_with_options(request, runtime)

    async def describe_auto_snapshot_policy_ex_async(
        self,
        request: ecs_20140526_models.DescribeAutoSnapshotPolicyExRequest,
    ) -> ecs_20140526_models.DescribeAutoSnapshotPolicyExResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_auto_snapshot_policy_ex_with_options_async(request, runtime)

    def describe_available_resource_with_options(
        self,
        request: ecs_20140526_models.DescribeAvailableResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAvailableResourceResponse:
        """
        The value of the `DestinationResource` parameter determines whether you need to specify additional parameters. The following sequence provides the order by which resources are filtered. You cannot query a higher order resource by specifying a lower order resource.
        *   Sequence: `Zone > IoOptimized > InstanceType = Network = ddh > SystemDisk > DataDisk`
        *   Examples:
        *   If you set `DestinationResource` to `DataDisk`, you must specify the `InstanceType` parameter or set the `ResourceType` parameter to `disk`.
        *   If you set `DestinationResource` to `SystemDisk`, you must specify the `InstanceType` parameter.
        *   If you set `DestinationResource` to `InstanceType`, you must specify the `IoOptimized` and `InstanceType` parameters.
        *   If you want to query available ecs.g5.large resources in all zones of the China (Hangzhou) region, you must set RegionId to cn-hangzhou, DestinationResource to InstanceType, IoOptimized to optimized, and InstanceType to ecs.g5.large.``
        *   If you want to query the zones where ecs.g5.large resources are available in the China (Hangzhou) region, you must set RegionId to cn-hangzhou, DestinationResource to Zone, IoOptimized to optimized, and InstanceType to ecs.g5.large.``
        
        @param request: DescribeAvailableResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cores):
            query['Cores'] = request.cores
        if not UtilClient.is_unset(request.data_disk_category):
            query['DataDiskCategory'] = request.data_disk_category
        if not UtilClient.is_unset(request.dedicated_host_id):
            query['DedicatedHostId'] = request.dedicated_host_id
        if not UtilClient.is_unset(request.destination_resource):
            query['DestinationResource'] = request.destination_resource
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.memory):
            query['Memory'] = request.memory
        if not UtilClient.is_unset(request.network_category):
            query['NetworkCategory'] = request.network_category
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.system_disk_category):
            query['SystemDiskCategory'] = request.system_disk_category
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAvailableResource',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAvailableResourceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_available_resource_with_options_async(
        self,
        request: ecs_20140526_models.DescribeAvailableResourceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAvailableResourceResponse:
        """
        The value of the `DestinationResource` parameter determines whether you need to specify additional parameters. The following sequence provides the order by which resources are filtered. You cannot query a higher order resource by specifying a lower order resource.
        *   Sequence: `Zone > IoOptimized > InstanceType = Network = ddh > SystemDisk > DataDisk`
        *   Examples:
        *   If you set `DestinationResource` to `DataDisk`, you must specify the `InstanceType` parameter or set the `ResourceType` parameter to `disk`.
        *   If you set `DestinationResource` to `SystemDisk`, you must specify the `InstanceType` parameter.
        *   If you set `DestinationResource` to `InstanceType`, you must specify the `IoOptimized` and `InstanceType` parameters.
        *   If you want to query available ecs.g5.large resources in all zones of the China (Hangzhou) region, you must set RegionId to cn-hangzhou, DestinationResource to InstanceType, IoOptimized to optimized, and InstanceType to ecs.g5.large.``
        *   If you want to query the zones where ecs.g5.large resources are available in the China (Hangzhou) region, you must set RegionId to cn-hangzhou, DestinationResource to Zone, IoOptimized to optimized, and InstanceType to ecs.g5.large.``
        
        @param request: DescribeAvailableResourceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAvailableResourceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cores):
            query['Cores'] = request.cores
        if not UtilClient.is_unset(request.data_disk_category):
            query['DataDiskCategory'] = request.data_disk_category
        if not UtilClient.is_unset(request.dedicated_host_id):
            query['DedicatedHostId'] = request.dedicated_host_id
        if not UtilClient.is_unset(request.destination_resource):
            query['DestinationResource'] = request.destination_resource
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.memory):
            query['Memory'] = request.memory
        if not UtilClient.is_unset(request.network_category):
            query['NetworkCategory'] = request.network_category
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.scope):
            query['Scope'] = request.scope
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.system_disk_category):
            query['SystemDiskCategory'] = request.system_disk_category
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAvailableResource',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAvailableResourceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_available_resource(
        self,
        request: ecs_20140526_models.DescribeAvailableResourceRequest,
    ) -> ecs_20140526_models.DescribeAvailableResourceResponse:
        """
        The value of the `DestinationResource` parameter determines whether you need to specify additional parameters. The following sequence provides the order by which resources are filtered. You cannot query a higher order resource by specifying a lower order resource.
        *   Sequence: `Zone > IoOptimized > InstanceType = Network = ddh > SystemDisk > DataDisk`
        *   Examples:
        *   If you set `DestinationResource` to `DataDisk`, you must specify the `InstanceType` parameter or set the `ResourceType` parameter to `disk`.
        *   If you set `DestinationResource` to `SystemDisk`, you must specify the `InstanceType` parameter.
        *   If you set `DestinationResource` to `InstanceType`, you must specify the `IoOptimized` and `InstanceType` parameters.
        *   If you want to query available ecs.g5.large resources in all zones of the China (Hangzhou) region, you must set RegionId to cn-hangzhou, DestinationResource to InstanceType, IoOptimized to optimized, and InstanceType to ecs.g5.large.``
        *   If you want to query the zones where ecs.g5.large resources are available in the China (Hangzhou) region, you must set RegionId to cn-hangzhou, DestinationResource to Zone, IoOptimized to optimized, and InstanceType to ecs.g5.large.``
        
        @param request: DescribeAvailableResourceRequest
        @return: DescribeAvailableResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_available_resource_with_options(request, runtime)

    async def describe_available_resource_async(
        self,
        request: ecs_20140526_models.DescribeAvailableResourceRequest,
    ) -> ecs_20140526_models.DescribeAvailableResourceResponse:
        """
        The value of the `DestinationResource` parameter determines whether you need to specify additional parameters. The following sequence provides the order by which resources are filtered. You cannot query a higher order resource by specifying a lower order resource.
        *   Sequence: `Zone > IoOptimized > InstanceType = Network = ddh > SystemDisk > DataDisk`
        *   Examples:
        *   If you set `DestinationResource` to `DataDisk`, you must specify the `InstanceType` parameter or set the `ResourceType` parameter to `disk`.
        *   If you set `DestinationResource` to `SystemDisk`, you must specify the `InstanceType` parameter.
        *   If you set `DestinationResource` to `InstanceType`, you must specify the `IoOptimized` and `InstanceType` parameters.
        *   If you want to query available ecs.g5.large resources in all zones of the China (Hangzhou) region, you must set RegionId to cn-hangzhou, DestinationResource to InstanceType, IoOptimized to optimized, and InstanceType to ecs.g5.large.``
        *   If you want to query the zones where ecs.g5.large resources are available in the China (Hangzhou) region, you must set RegionId to cn-hangzhou, DestinationResource to Zone, IoOptimized to optimized, and InstanceType to ecs.g5.large.``
        
        @param request: DescribeAvailableResourceRequest
        @return: DescribeAvailableResourceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_available_resource_with_options_async(request, runtime)

    def describe_bandwidth_limitation_with_options(
        self,
        request: ecs_20140526_models.DescribeBandwidthLimitationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeBandwidthLimitationResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBandwidthLimitation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeBandwidthLimitationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_bandwidth_limitation_with_options_async(
        self,
        request: ecs_20140526_models.DescribeBandwidthLimitationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeBandwidthLimitationResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.operation_type):
            query['OperationType'] = request.operation_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBandwidthLimitation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeBandwidthLimitationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_bandwidth_limitation(
        self,
        request: ecs_20140526_models.DescribeBandwidthLimitationRequest,
    ) -> ecs_20140526_models.DescribeBandwidthLimitationResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_bandwidth_limitation_with_options(request, runtime)

    async def describe_bandwidth_limitation_async(
        self,
        request: ecs_20140526_models.DescribeBandwidthLimitationRequest,
    ) -> ecs_20140526_models.DescribeBandwidthLimitationResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_bandwidth_limitation_with_options_async(request, runtime)

    def describe_bandwidth_packages_with_options(
        self,
        request: ecs_20140526_models.DescribeBandwidthPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeBandwidthPackagesResponse:
        """
        @deprecated
        
        @param request: DescribeBandwidthPackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBandwidthPackagesResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBandwidthPackages',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeBandwidthPackagesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_bandwidth_packages_with_options_async(
        self,
        request: ecs_20140526_models.DescribeBandwidthPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeBandwidthPackagesResponse:
        """
        @deprecated
        
        @param request: DescribeBandwidthPackagesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBandwidthPackagesResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBandwidthPackages',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeBandwidthPackagesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_bandwidth_packages(
        self,
        request: ecs_20140526_models.DescribeBandwidthPackagesRequest,
    ) -> ecs_20140526_models.DescribeBandwidthPackagesResponse:
        """
        @deprecated
        
        @param request: DescribeBandwidthPackagesRequest
        @return: DescribeBandwidthPackagesResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_bandwidth_packages_with_options(request, runtime)

    async def describe_bandwidth_packages_async(
        self,
        request: ecs_20140526_models.DescribeBandwidthPackagesRequest,
    ) -> ecs_20140526_models.DescribeBandwidthPackagesResponse:
        """
        @deprecated
        
        @param request: DescribeBandwidthPackagesRequest
        @return: DescribeBandwidthPackagesResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_bandwidth_packages_with_options_async(request, runtime)

    def describe_capacity_reservation_instances_with_options(
        self,
        request: ecs_20140526_models.DescribeCapacityReservationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeCapacityReservationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCapacityReservationInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeCapacityReservationInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_capacity_reservation_instances_with_options_async(
        self,
        request: ecs_20140526_models.DescribeCapacityReservationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeCapacityReservationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCapacityReservationInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeCapacityReservationInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_capacity_reservation_instances(
        self,
        request: ecs_20140526_models.DescribeCapacityReservationInstancesRequest,
    ) -> ecs_20140526_models.DescribeCapacityReservationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_capacity_reservation_instances_with_options(request, runtime)

    async def describe_capacity_reservation_instances_async(
        self,
        request: ecs_20140526_models.DescribeCapacityReservationInstancesRequest,
    ) -> ecs_20140526_models.DescribeCapacityReservationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_capacity_reservation_instances_with_options_async(request, runtime)

    def describe_capacity_reservations_with_options(
        self,
        request: ecs_20140526_models.DescribeCapacityReservationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeCapacityReservationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCapacityReservations',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeCapacityReservationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_capacity_reservations_with_options_async(
        self,
        request: ecs_20140526_models.DescribeCapacityReservationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeCapacityReservationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCapacityReservations',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeCapacityReservationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_capacity_reservations(
        self,
        request: ecs_20140526_models.DescribeCapacityReservationsRequest,
    ) -> ecs_20140526_models.DescribeCapacityReservationsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_capacity_reservations_with_options(request, runtime)

    async def describe_capacity_reservations_async(
        self,
        request: ecs_20140526_models.DescribeCapacityReservationsRequest,
    ) -> ecs_20140526_models.DescribeCapacityReservationsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_capacity_reservations_with_options_async(request, runtime)

    def describe_classic_link_instances_with_options(
        self,
        request: ecs_20140526_models.DescribeClassicLinkInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeClassicLinkInstancesResponse:
        """
        When you call this operation, take note of the following items:
        *   This operation applies only to instances that reside in the classic network.
        *   You can query up to 100 instances that reside in the classic network at a time.
        *   At least one of the `VpcId` and `InstanceId` parameters must be specified.
        
        @param request: DescribeClassicLinkInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClassicLinkInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClassicLinkInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeClassicLinkInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_classic_link_instances_with_options_async(
        self,
        request: ecs_20140526_models.DescribeClassicLinkInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeClassicLinkInstancesResponse:
        """
        When you call this operation, take note of the following items:
        *   This operation applies only to instances that reside in the classic network.
        *   You can query up to 100 instances that reside in the classic network at a time.
        *   At least one of the `VpcId` and `InstanceId` parameters must be specified.
        
        @param request: DescribeClassicLinkInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClassicLinkInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClassicLinkInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeClassicLinkInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_classic_link_instances(
        self,
        request: ecs_20140526_models.DescribeClassicLinkInstancesRequest,
    ) -> ecs_20140526_models.DescribeClassicLinkInstancesResponse:
        """
        When you call this operation, take note of the following items:
        *   This operation applies only to instances that reside in the classic network.
        *   You can query up to 100 instances that reside in the classic network at a time.
        *   At least one of the `VpcId` and `InstanceId` parameters must be specified.
        
        @param request: DescribeClassicLinkInstancesRequest
        @return: DescribeClassicLinkInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_classic_link_instances_with_options(request, runtime)

    async def describe_classic_link_instances_async(
        self,
        request: ecs_20140526_models.DescribeClassicLinkInstancesRequest,
    ) -> ecs_20140526_models.DescribeClassicLinkInstancesResponse:
        """
        When you call this operation, take note of the following items:
        *   This operation applies only to instances that reside in the classic network.
        *   You can query up to 100 instances that reside in the classic network at a time.
        *   At least one of the `VpcId` and `InstanceId` parameters must be specified.
        
        @param request: DescribeClassicLinkInstancesRequest
        @return: DescribeClassicLinkInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_classic_link_instances_with_options_async(request, runtime)

    def describe_cloud_assistant_status_with_options(
        self,
        request: ecs_20140526_models.DescribeCloudAssistantStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeCloudAssistantStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ostype):
            query['OSType'] = request.ostype
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudAssistantStatus',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeCloudAssistantStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cloud_assistant_status_with_options_async(
        self,
        request: ecs_20140526_models.DescribeCloudAssistantStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeCloudAssistantStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ostype):
            query['OSType'] = request.ostype
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudAssistantStatus',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeCloudAssistantStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cloud_assistant_status(
        self,
        request: ecs_20140526_models.DescribeCloudAssistantStatusRequest,
    ) -> ecs_20140526_models.DescribeCloudAssistantStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_assistant_status_with_options(request, runtime)

    async def describe_cloud_assistant_status_async(
        self,
        request: ecs_20140526_models.DescribeCloudAssistantStatusRequest,
    ) -> ecs_20140526_models.DescribeCloudAssistantStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_assistant_status_with_options_async(request, runtime)

    def describe_clusters_with_options(
        self,
        request: ecs_20140526_models.DescribeClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeClustersResponse:
        """
        @deprecated
        
        @param request: DescribeClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClustersResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusters',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeClustersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_clusters_with_options_async(
        self,
        request: ecs_20140526_models.DescribeClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeClustersResponse:
        """
        @deprecated
        
        @param request: DescribeClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClustersResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusters',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeClustersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_clusters(
        self,
        request: ecs_20140526_models.DescribeClustersRequest,
    ) -> ecs_20140526_models.DescribeClustersResponse:
        """
        @deprecated
        
        @param request: DescribeClustersRequest
        @return: DescribeClustersResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_clusters_with_options(request, runtime)

    async def describe_clusters_async(
        self,
        request: ecs_20140526_models.DescribeClustersRequest,
    ) -> ecs_20140526_models.DescribeClustersResponse:
        """
        @deprecated
        
        @param request: DescribeClustersRequest
        @return: DescribeClustersResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_clusters_with_options_async(request, runtime)

    def describe_commands_with_options(
        self,
        request: ecs_20140526_models.DescribeCommandsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeCommandsResponse:
        """
        ## Description
        If you specify only the `Action` and `RegionId` parameters to call this operation, all the available commands (`CommandId`) that you created in the specified region are queried by default.
        
        @param request: DescribeCommandsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommandsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_id):
            query['CommandId'] = request.command_id
        if not UtilClient.is_unset(request.content_encoding):
            query['ContentEncoding'] = request.content_encoding
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.latest):
            query['Latest'] = request.latest
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.provider):
            query['Provider'] = request.provider
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommands',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeCommandsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_commands_with_options_async(
        self,
        request: ecs_20140526_models.DescribeCommandsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeCommandsResponse:
        """
        ## Description
        If you specify only the `Action` and `RegionId` parameters to call this operation, all the available commands (`CommandId`) that you created in the specified region are queried by default.
        
        @param request: DescribeCommandsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCommandsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_id):
            query['CommandId'] = request.command_id
        if not UtilClient.is_unset(request.content_encoding):
            query['ContentEncoding'] = request.content_encoding
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.latest):
            query['Latest'] = request.latest
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.provider):
            query['Provider'] = request.provider
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommands',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeCommandsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_commands(
        self,
        request: ecs_20140526_models.DescribeCommandsRequest,
    ) -> ecs_20140526_models.DescribeCommandsResponse:
        """
        ## Description
        If you specify only the `Action` and `RegionId` parameters to call this operation, all the available commands (`CommandId`) that you created in the specified region are queried by default.
        
        @param request: DescribeCommandsRequest
        @return: DescribeCommandsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_commands_with_options(request, runtime)

    async def describe_commands_async(
        self,
        request: ecs_20140526_models.DescribeCommandsRequest,
    ) -> ecs_20140526_models.DescribeCommandsResponse:
        """
        ## Description
        If you specify only the `Action` and `RegionId` parameters to call this operation, all the available commands (`CommandId`) that you created in the specified region are queried by default.
        
        @param request: DescribeCommandsRequest
        @return: DescribeCommandsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_commands_with_options_async(request, runtime)

    def describe_dedicated_host_auto_renew_with_options(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostAutoRenewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDedicatedHostAutoRenewResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_ids):
            query['DedicatedHostIds'] = request.dedicated_host_ids
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDedicatedHostAutoRenew',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDedicatedHostAutoRenewResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dedicated_host_auto_renew_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostAutoRenewRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDedicatedHostAutoRenewResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_ids):
            query['DedicatedHostIds'] = request.dedicated_host_ids
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDedicatedHostAutoRenew',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDedicatedHostAutoRenewResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dedicated_host_auto_renew(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostAutoRenewRequest,
    ) -> ecs_20140526_models.DescribeDedicatedHostAutoRenewResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_dedicated_host_auto_renew_with_options(request, runtime)

    async def describe_dedicated_host_auto_renew_async(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostAutoRenewRequest,
    ) -> ecs_20140526_models.DescribeDedicatedHostAutoRenewResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_dedicated_host_auto_renew_with_options_async(request, runtime)

    def describe_dedicated_host_clusters_with_options(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDedicatedHostClustersResponse:
        """
        You can specify multiple request parameters to be queried. Specified parameters have logical AND relations. Only the specified parameters are included in the filter conditions. However, if `DedicatedHostClusterIds` is set to an empty JSON array (`[]`), it is regarded as a valid filter condition and an empty result is returned.
        
        @param request: DescribeDedicatedHostClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDedicatedHostClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_ids):
            query['DedicatedHostClusterIds'] = request.dedicated_host_cluster_ids
        if not UtilClient.is_unset(request.dedicated_host_cluster_name):
            query['DedicatedHostClusterName'] = request.dedicated_host_cluster_name
        if not UtilClient.is_unset(request.lock_reason):
            query['LockReason'] = request.lock_reason
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDedicatedHostClusters',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDedicatedHostClustersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dedicated_host_clusters_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDedicatedHostClustersResponse:
        """
        You can specify multiple request parameters to be queried. Specified parameters have logical AND relations. Only the specified parameters are included in the filter conditions. However, if `DedicatedHostClusterIds` is set to an empty JSON array (`[]`), it is regarded as a valid filter condition and an empty result is returned.
        
        @param request: DescribeDedicatedHostClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDedicatedHostClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_ids):
            query['DedicatedHostClusterIds'] = request.dedicated_host_cluster_ids
        if not UtilClient.is_unset(request.dedicated_host_cluster_name):
            query['DedicatedHostClusterName'] = request.dedicated_host_cluster_name
        if not UtilClient.is_unset(request.lock_reason):
            query['LockReason'] = request.lock_reason
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDedicatedHostClusters',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDedicatedHostClustersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dedicated_host_clusters(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostClustersRequest,
    ) -> ecs_20140526_models.DescribeDedicatedHostClustersResponse:
        """
        You can specify multiple request parameters to be queried. Specified parameters have logical AND relations. Only the specified parameters are included in the filter conditions. However, if `DedicatedHostClusterIds` is set to an empty JSON array (`[]`), it is regarded as a valid filter condition and an empty result is returned.
        
        @param request: DescribeDedicatedHostClustersRequest
        @return: DescribeDedicatedHostClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dedicated_host_clusters_with_options(request, runtime)

    async def describe_dedicated_host_clusters_async(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostClustersRequest,
    ) -> ecs_20140526_models.DescribeDedicatedHostClustersResponse:
        """
        You can specify multiple request parameters to be queried. Specified parameters have logical AND relations. Only the specified parameters are included in the filter conditions. However, if `DedicatedHostClusterIds` is set to an empty JSON array (`[]`), it is regarded as a valid filter condition and an empty result is returned.
        
        @param request: DescribeDedicatedHostClustersRequest
        @return: DescribeDedicatedHostClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dedicated_host_clusters_with_options_async(request, runtime)

    def describe_dedicated_host_types_with_options(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDedicatedHostTypesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_type):
            query['DedicatedHostType'] = request.dedicated_host_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.supported_instance_type_family):
            query['SupportedInstanceTypeFamily'] = request.supported_instance_type_family
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDedicatedHostTypes',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDedicatedHostTypesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dedicated_host_types_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostTypesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDedicatedHostTypesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_type):
            query['DedicatedHostType'] = request.dedicated_host_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.supported_instance_type_family):
            query['SupportedInstanceTypeFamily'] = request.supported_instance_type_family
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDedicatedHostTypes',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDedicatedHostTypesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dedicated_host_types(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostTypesRequest,
    ) -> ecs_20140526_models.DescribeDedicatedHostTypesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_dedicated_host_types_with_options(request, runtime)

    async def describe_dedicated_host_types_async(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostTypesRequest,
    ) -> ecs_20140526_models.DescribeDedicatedHostTypesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_dedicated_host_types_with_options_async(request, runtime)

    def describe_dedicated_hosts_with_options(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDedicatedHostsResponse:
        """
        ## Description
        You can use one of the following methods to query the details of one or more dedicated hosts:
        *   Specify the `DedicatedHostIds` parameter to query the details of specified dedicated hosts.
        *   Specify the `DedicatedHostClusterId` parameter to query the details of the dedicated hosts in a dedicated host cluster.
        
        @param request: DescribeDedicatedHostsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDedicatedHostsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.dedicated_host_ids):
            query['DedicatedHostIds'] = request.dedicated_host_ids
        if not UtilClient.is_unset(request.dedicated_host_name):
            query['DedicatedHostName'] = request.dedicated_host_name
        if not UtilClient.is_unset(request.dedicated_host_type):
            query['DedicatedHostType'] = request.dedicated_host_type
        if not UtilClient.is_unset(request.lock_reason):
            query['LockReason'] = request.lock_reason
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDedicatedHosts',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDedicatedHostsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dedicated_hosts_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDedicatedHostsResponse:
        """
        ## Description
        You can use one of the following methods to query the details of one or more dedicated hosts:
        *   Specify the `DedicatedHostIds` parameter to query the details of specified dedicated hosts.
        *   Specify the `DedicatedHostClusterId` parameter to query the details of the dedicated hosts in a dedicated host cluster.
        
        @param request: DescribeDedicatedHostsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDedicatedHostsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.dedicated_host_ids):
            query['DedicatedHostIds'] = request.dedicated_host_ids
        if not UtilClient.is_unset(request.dedicated_host_name):
            query['DedicatedHostName'] = request.dedicated_host_name
        if not UtilClient.is_unset(request.dedicated_host_type):
            query['DedicatedHostType'] = request.dedicated_host_type
        if not UtilClient.is_unset(request.lock_reason):
            query['LockReason'] = request.lock_reason
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDedicatedHosts',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDedicatedHostsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dedicated_hosts(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostsRequest,
    ) -> ecs_20140526_models.DescribeDedicatedHostsResponse:
        """
        ## Description
        You can use one of the following methods to query the details of one or more dedicated hosts:
        *   Specify the `DedicatedHostIds` parameter to query the details of specified dedicated hosts.
        *   Specify the `DedicatedHostClusterId` parameter to query the details of the dedicated hosts in a dedicated host cluster.
        
        @param request: DescribeDedicatedHostsRequest
        @return: DescribeDedicatedHostsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dedicated_hosts_with_options(request, runtime)

    async def describe_dedicated_hosts_async(
        self,
        request: ecs_20140526_models.DescribeDedicatedHostsRequest,
    ) -> ecs_20140526_models.DescribeDedicatedHostsResponse:
        """
        ## Description
        You can use one of the following methods to query the details of one or more dedicated hosts:
        *   Specify the `DedicatedHostIds` parameter to query the details of specified dedicated hosts.
        *   Specify the `DedicatedHostClusterId` parameter to query the details of the dedicated hosts in a dedicated host cluster.
        
        @param request: DescribeDedicatedHostsRequest
        @return: DescribeDedicatedHostsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dedicated_hosts_with_options_async(request, runtime)

    def describe_demands_with_options(
        self,
        request: ecs_20140526_models.DescribeDemandsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDemandsResponse:
        """
        ## Description
        You can call this operation to query the details of resources filed by Alibaba Cloud, including the types, delivery status, and consumption status of the resources.
        By default, the filing tickets of I/O optimized VPC-type instances are queried.
        For information about how to create (CreateDemand), modify (ModifyDemand), and delete (DeleteDemand) filing tickets on ECS resources, contact your account manager.
        
        @param request: DescribeDemandsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDemandsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.demand_id):
            query['DemandId'] = request.demand_id
        if not UtilClient.is_unset(request.demand_status):
            query['DemandStatus'] = request.demand_status
        if not UtilClient.is_unset(request.demand_type):
            query['DemandType'] = request.demand_type
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.instance_type_family):
            query['InstanceTypeFamily'] = request.instance_type_family
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDemands',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDemandsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_demands_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDemandsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDemandsResponse:
        """
        ## Description
        You can call this operation to query the details of resources filed by Alibaba Cloud, including the types, delivery status, and consumption status of the resources.
        By default, the filing tickets of I/O optimized VPC-type instances are queried.
        For information about how to create (CreateDemand), modify (ModifyDemand), and delete (DeleteDemand) filing tickets on ECS resources, contact your account manager.
        
        @param request: DescribeDemandsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDemandsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.demand_id):
            query['DemandId'] = request.demand_id
        if not UtilClient.is_unset(request.demand_status):
            query['DemandStatus'] = request.demand_status
        if not UtilClient.is_unset(request.demand_type):
            query['DemandType'] = request.demand_type
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.instance_type_family):
            query['InstanceTypeFamily'] = request.instance_type_family
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDemands',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDemandsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_demands(
        self,
        request: ecs_20140526_models.DescribeDemandsRequest,
    ) -> ecs_20140526_models.DescribeDemandsResponse:
        """
        ## Description
        You can call this operation to query the details of resources filed by Alibaba Cloud, including the types, delivery status, and consumption status of the resources.
        By default, the filing tickets of I/O optimized VPC-type instances are queried.
        For information about how to create (CreateDemand), modify (ModifyDemand), and delete (DeleteDemand) filing tickets on ECS resources, contact your account manager.
        
        @param request: DescribeDemandsRequest
        @return: DescribeDemandsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_demands_with_options(request, runtime)

    async def describe_demands_async(
        self,
        request: ecs_20140526_models.DescribeDemandsRequest,
    ) -> ecs_20140526_models.DescribeDemandsResponse:
        """
        ## Description
        You can call this operation to query the details of resources filed by Alibaba Cloud, including the types, delivery status, and consumption status of the resources.
        By default, the filing tickets of I/O optimized VPC-type instances are queried.
        For information about how to create (CreateDemand), modify (ModifyDemand), and delete (DeleteDemand) filing tickets on ECS resources, contact your account manager.
        
        @param request: DescribeDemandsRequest
        @return: DescribeDemandsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_demands_with_options_async(request, runtime)

    def describe_deployment_set_supported_instance_type_family_with_options(
        self,
        request: ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyResponse:
        """
        For more information about instance families, see [Instance families](~~25378~~).
        
        @param request: DescribeDeploymentSetSupportedInstanceTypeFamilyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDeploymentSetSupportedInstanceTypeFamilyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDeploymentSetSupportedInstanceTypeFamily',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_deployment_set_supported_instance_type_family_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyResponse:
        """
        For more information about instance families, see [Instance families](~~25378~~).
        
        @param request: DescribeDeploymentSetSupportedInstanceTypeFamilyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDeploymentSetSupportedInstanceTypeFamilyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDeploymentSetSupportedInstanceTypeFamily',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_deployment_set_supported_instance_type_family(
        self,
        request: ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyRequest,
    ) -> ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyResponse:
        """
        For more information about instance families, see [Instance families](~~25378~~).
        
        @param request: DescribeDeploymentSetSupportedInstanceTypeFamilyRequest
        @return: DescribeDeploymentSetSupportedInstanceTypeFamilyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_deployment_set_supported_instance_type_family_with_options(request, runtime)

    async def describe_deployment_set_supported_instance_type_family_async(
        self,
        request: ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyRequest,
    ) -> ecs_20140526_models.DescribeDeploymentSetSupportedInstanceTypeFamilyResponse:
        """
        For more information about instance families, see [Instance families](~~25378~~).
        
        @param request: DescribeDeploymentSetSupportedInstanceTypeFamilyRequest
        @return: DescribeDeploymentSetSupportedInstanceTypeFamilyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_deployment_set_supported_instance_type_family_with_options_async(request, runtime)

    def describe_deployment_sets_with_options(
        self,
        request: ecs_20140526_models.DescribeDeploymentSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDeploymentSetsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deployment_set_ids):
            query['DeploymentSetIds'] = request.deployment_set_ids
        if not UtilClient.is_unset(request.deployment_set_name):
            query['DeploymentSetName'] = request.deployment_set_name
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.granularity):
            query['Granularity'] = request.granularity
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDeploymentSets',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDeploymentSetsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_deployment_sets_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDeploymentSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDeploymentSetsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deployment_set_ids):
            query['DeploymentSetIds'] = request.deployment_set_ids
        if not UtilClient.is_unset(request.deployment_set_name):
            query['DeploymentSetName'] = request.deployment_set_name
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.granularity):
            query['Granularity'] = request.granularity
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDeploymentSets',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDeploymentSetsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_deployment_sets(
        self,
        request: ecs_20140526_models.DescribeDeploymentSetsRequest,
    ) -> ecs_20140526_models.DescribeDeploymentSetsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_deployment_sets_with_options(request, runtime)

    async def describe_deployment_sets_async(
        self,
        request: ecs_20140526_models.DescribeDeploymentSetsRequest,
    ) -> ecs_20140526_models.DescribeDeploymentSetsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_deployment_sets_with_options_async(request, runtime)

    def describe_diagnostic_metric_sets_with_options(
        self,
        request: ecs_20140526_models.DescribeDiagnosticMetricSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiagnosticMetricSetsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.metric_set_ids):
            query['MetricSetIds'] = request.metric_set_ids
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosticMetricSets',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiagnosticMetricSetsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_diagnostic_metric_sets_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDiagnosticMetricSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiagnosticMetricSetsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.metric_set_ids):
            query['MetricSetIds'] = request.metric_set_ids
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosticMetricSets',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiagnosticMetricSetsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_diagnostic_metric_sets(
        self,
        request: ecs_20140526_models.DescribeDiagnosticMetricSetsRequest,
    ) -> ecs_20140526_models.DescribeDiagnosticMetricSetsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_diagnostic_metric_sets_with_options(request, runtime)

    async def describe_diagnostic_metric_sets_async(
        self,
        request: ecs_20140526_models.DescribeDiagnosticMetricSetsRequest,
    ) -> ecs_20140526_models.DescribeDiagnosticMetricSetsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_diagnostic_metric_sets_with_options_async(request, runtime)

    def describe_diagnostic_metrics_with_options(
        self,
        request: ecs_20140526_models.DescribeDiagnosticMetricsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiagnosticMetricsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.metric_ids):
            query['MetricIds'] = request.metric_ids
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosticMetrics',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiagnosticMetricsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_diagnostic_metrics_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDiagnosticMetricsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiagnosticMetricsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.metric_ids):
            query['MetricIds'] = request.metric_ids
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosticMetrics',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiagnosticMetricsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_diagnostic_metrics(
        self,
        request: ecs_20140526_models.DescribeDiagnosticMetricsRequest,
    ) -> ecs_20140526_models.DescribeDiagnosticMetricsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_diagnostic_metrics_with_options(request, runtime)

    async def describe_diagnostic_metrics_async(
        self,
        request: ecs_20140526_models.DescribeDiagnosticMetricsRequest,
    ) -> ecs_20140526_models.DescribeDiagnosticMetricsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_diagnostic_metrics_with_options_async(request, runtime)

    def describe_diagnostic_report_attributes_with_options(
        self,
        request: ecs_20140526_models.DescribeDiagnosticReportAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiagnosticReportAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosticReportAttributes',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiagnosticReportAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_diagnostic_report_attributes_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDiagnosticReportAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiagnosticReportAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_id):
            query['ReportId'] = request.report_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosticReportAttributes',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiagnosticReportAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_diagnostic_report_attributes(
        self,
        request: ecs_20140526_models.DescribeDiagnosticReportAttributesRequest,
    ) -> ecs_20140526_models.DescribeDiagnosticReportAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_diagnostic_report_attributes_with_options(request, runtime)

    async def describe_diagnostic_report_attributes_async(
        self,
        request: ecs_20140526_models.DescribeDiagnosticReportAttributesRequest,
    ) -> ecs_20140526_models.DescribeDiagnosticReportAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_diagnostic_report_attributes_with_options_async(request, runtime)

    def describe_diagnostic_reports_with_options(
        self,
        request: ecs_20140526_models.DescribeDiagnosticReportsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiagnosticReportsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_ids):
            query['ReportIds'] = request.report_ids
        if not UtilClient.is_unset(request.resource_ids):
            query['ResourceIds'] = request.resource_ids
        if not UtilClient.is_unset(request.severity):
            query['Severity'] = request.severity
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosticReports',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiagnosticReportsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_diagnostic_reports_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDiagnosticReportsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiagnosticReportsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_ids):
            query['ReportIds'] = request.report_ids
        if not UtilClient.is_unset(request.resource_ids):
            query['ResourceIds'] = request.resource_ids
        if not UtilClient.is_unset(request.severity):
            query['Severity'] = request.severity
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiagnosticReports',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiagnosticReportsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_diagnostic_reports(
        self,
        request: ecs_20140526_models.DescribeDiagnosticReportsRequest,
    ) -> ecs_20140526_models.DescribeDiagnosticReportsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_diagnostic_reports_with_options(request, runtime)

    async def describe_diagnostic_reports_async(
        self,
        request: ecs_20140526_models.DescribeDiagnosticReportsRequest,
    ) -> ecs_20140526_models.DescribeDiagnosticReportsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_diagnostic_reports_with_options_async(request, runtime)

    def describe_disk_monitor_data_with_options(
        self,
        request: ecs_20140526_models.DescribeDiskMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiskMonitorDataResponse:
        """
        The monitoring data includes read IOPS, write IOPS, read bandwidth (byte/s), write bandwidth (byte/s), read latency (microseconds), and write latency (microseconds) of the disk.
        When you call this operation, take note of the following items:
        *   Only the monitoring data of disks that are in the Running (`In_use`) state can be queried. For more information, see [Disk states](~~25689~~).
        > Some information may be missing from the monitoring data of a disk because the disk is not in the In Use (`In_Use`) state and the system cannot obtain the relevant information.
        *   Up to 400 monitoring data entries can be returned at a time. An error is returned if the value calculated based on the following formula is greater than 400: `(EndTime - StartTime)/Period`.
        *   You can query the monitoring data in the previous 30 days. If the value of `StartTime` is more than 30 days before the current time, an error is returned.
        
        @param request: DescribeDiskMonitorDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiskMonitorDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiskMonitorData',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiskMonitorDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_disk_monitor_data_with_options_async(
        self,
        request: ecs_20140526_models.DescribeDiskMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDiskMonitorDataResponse:
        """
        The monitoring data includes read IOPS, write IOPS, read bandwidth (byte/s), write bandwidth (byte/s), read latency (microseconds), and write latency (microseconds) of the disk.
        When you call this operation, take note of the following items:
        *   Only the monitoring data of disks that are in the Running (`In_use`) state can be queried. For more information, see [Disk states](~~25689~~).
        > Some information may be missing from the monitoring data of a disk because the disk is not in the In Use (`In_Use`) state and the system cannot obtain the relevant information.
        *   Up to 400 monitoring data entries can be returned at a time. An error is returned if the value calculated based on the following formula is greater than 400: `(EndTime - StartTime)/Period`.
        *   You can query the monitoring data in the previous 30 days. If the value of `StartTime` is more than 30 days before the current time, an error is returned.
        
        @param request: DescribeDiskMonitorDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDiskMonitorDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDiskMonitorData',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeDiskMonitorDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_disk_monitor_data(
        self,
        request: ecs_20140526_models.DescribeDiskMonitorDataRequest,
    ) -> ecs_20140526_models.DescribeDiskMonitorDataResponse:
        """
        The monitoring data includes read IOPS, write IOPS, read bandwidth (byte/s), write bandwidth (byte/s), read latency (microseconds), and write latency (microseconds) of the disk.
        When you call this operation, take note of the following items:
        *   Only the monitoring data of disks that are in the Running (`In_use`) state can be queried. For more information, see [Disk states](~~25689~~).
        > Some information may be missing from the monitoring data of a disk because the disk is not in the In Use (`In_Use`) state and the system cannot obtain the relevant information.
        *   Up to 400 monitoring data entries can be returned at a time. An error is returned if the value calculated based on the following formula is greater than 400: `(EndTime - StartTime)/Period`.
        *   You can query the monitoring data in the previous 30 days. If the value of `StartTime` is more than 30 days before the current time, an error is returned.
        
        @param request: DescribeDiskMonitorDataRequest
        @return: DescribeDiskMonitorDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_disk_monitor_data_with_options(request, runtime)

    async def describe_disk_monitor_data_async(
        self,
        request: ecs_20140526_models.DescribeDiskMonitorDataRequest,
    ) -> ecs_20140526_models.DescribeDiskMonitorDataResponse:
        """
        The monitoring data includes read IOPS, write IOPS, read bandwidth (byte/s), write bandwidth (byte/s), read latency (microseconds), and write latency (microseconds) of the disk.
        When you call this operation, take note of the following items:
        *   Only the monitoring data of disks that are in the Running (`In_use`) state can be queried. For more information, see [Disk states](~~25689~~).
        > Some information may be missing from the monitoring data of a disk because the disk is not in the In Use (`In_Use`) state and the system cannot obtain the relevant information.
        *   Up to 400 monitoring data entries can be returned at a time. An error is returned if the value calculated based on the following formula is greater than 400: `(EndTime - StartTime)/Period`.
        *   You can query the monitoring data in the previous 30 days. If the value of `StartTime` is more than 30 days before the current time, an error is returned.
        
        @param request: DescribeDiskMonitorDataRequest
        @return: DescribeDiskMonitorDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_disk_monitor_data_with_options_async(request, runtime)

    def describe_disks_with_options(
        self,
        request: ecs_20140526_models.DescribeDisksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeDisksResponse:
        """
        You can specify multiple request parameters such as `RegionId`, `ZoneId`, `DiskIds`, and `InstanceId` to be queried. Specified parameters have logical AND relations. Only the specified parameters are included in the filter conditions.
        * The `DiskIds` value is a JSON array. If DiskIds is not specified, it is not used as a filter condition. If `DiskIds` is set to an empty JSON array, it is regarded as a valid filter condition, and an empty result is returned.
        * You can use one of the following methods to check the responses:
        * Method 1: Use `NextToken` to configure the query token. Set the value to the `NextToken` value that is returned in the last call to the DescribeDisks operation. Then, use `MaxResults` to specify the maximum number of entries to return on each page.
        * Method 2: Use `PageSize` to specify the num