April 1, 2019.
Boston, MA.

# SayTeX+

After thinking a lot about how to implement SayTeX+ as a context-free grammar, I have realized that I have put too much blind faith into that concept. While a context-free grammar would enable SayTeX+ to have a better semantical understanding, it comes with the cost of being harder to implement.

Decision: Create a sample CFG implementation specifically for recognizing the "divided by" command. In parallel, create a basic structure of SayTeX+ that supports a layering approach, in which the CFG can be one of many layers.

The reason for doing layering is that it really seems uncalled for to add spoken number recognition and spacing additions into a CFG. It would be harder to implement, more error-prone and less modular.

The CFG will assume that the input will consist of pure SayTeX, with the addition of the word "over." That is, it will base its understanding on SayTeX objects, like "superscript", and not on the semantical versions, like "to the power of." If the CFG definition seems worthwhile, I might extend it to the recognition of other things, such as from-to sequences.

## Proposal of layers

The order of them need not be specified unless absolutely necessary. In practice, of course, all layers will be executed in sequence, but theoretically, layers with the same priority can be thought of as executing at the same time. In the design of layers, one should strive for as few priority levels as possible.

- Speech recognition error correction. Priority 0.
- Case insensitive input. Priority 0.
- Capitalization. Priority 1.
- Spoken number recognition. Priority 1.
- Convenience dictionary compilation. Priority 1.
- Recognition of from-to sequences. Priority 2.
- CFG for "over". Priority 2.
- Completion of expressions to avoid compile errors. Priority 3.
- Prettification (including insertion of spaces). Priority 3.