March 28, 2019.
Malmö, Sweden.

# First Blog Post

This is the first SayTeX blog post. Many more will come, hopefully. Maintaining this blog will (1) make me focused on achieving clear results, and (2) give the SayTeX project a well-documented history, both of which are admirable goals.

## The Current State of SayTeX

Since this is the first blog post, let us examine in what state SayTeX currently is in. For reference, SayTeX was conceptually redesigned a month ago: a vision to split the functionality into two separate levels, SayTeX Syntax and SayTeX+, was proposed, aiming to make the engine more robust and more extensible.

As of today, the compiler framework of SayTeX Syntax is implemented, and a small subset of common LaTeX commands have been added to the SayTeX Syntax dictionary. SayTeX+ has not yet been started.

## Next Steps

For SayTeX Syntax, more commands need to be added. This is not urgent and should not be the next step, though.

Rather, the next step should be to start implementing SayTeX+. A general idea for how it should work has already been laid out, but a more detailed plan needs to be created.

In case I need a break from SayTeX+, a parallel task that needs to be done is an update of the website. Particularly useful would be the addition of an input text field and a SayTeX Syntax text field, so as to not require voice input for testing purposes. Also, switching from MathJax to KaTeX would be good.

## SayTeX+ Design

My current thoughts are that SayTeX+ should operate in a layered manner. First, it should correct common misconceptions ("eggs" -> "x"). Second, it should convert spoken numbers to digits. Then, it should build the formal grammar and compute the result of things like "over". Finally, it should standardize into SayTeX syntax ("to the power of" -> "superscript").

I am not entirely sure about this, though. I am especially uncertain what the middle layer will look like. Should it really come before the standardization? (Arguments for: building a formal grammar will be much easier after standardization. Arguments against: some semantical information that might be crucial to the formal grammar system is lost in standardization.) What will the formal grammar system even look like? How can I incoroporate SayTeX syntax as a subset of a formal grammar, without SayTeX+ having full knowledge of SayTeX syntax beforehand? There really is no real reason to build a full parse tree, since it will be flattened in the end anyway, except maybe to better understand things like "over", where precedence information is needed.

Regardless of how the formal grammar layer pans out, it seems like SayTeX+ will need to consist of that as well as some simple string transformation layers. I want them to be modular and nicely structured, so I am thinking I implement a very clear layered system that invokes different submodules in a config-defined order. Every layer needs to have very clear the assumptions about its input and the result of its output (ideally, these assumptions should be formalized, so that the compiler can verify if a layer ordering is valid or not). It should be easy to add layers.