"""Update InstanceStatus

Revision ID: 0e33559e16ed
Revises: 4b4319398164
Create Date: 2024-03-07 17:21:57.570495

"""

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision = "0e33559e16ed"
down_revision = "4b4319398164"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column(
            "status",
            existing_type=sa.VARCHAR(length=11),
            type_=sa.Enum(
                "PENDING",
                "CREATING",
                "STARTING",
                "READY",
                "PROVISIONING",
                "IDLE",
                "BUSY",
                "TERMINATING",
                "TERMINATED",
                name="instancestatus",
            ),
            existing_nullable=False,
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("instances", schema=None) as batch_op:
        batch_op.alter_column(
            "status",
            existing_type=sa.Enum(
                "PENDING",
                "CREATING",
                "STARTING",
                "READY",
                "PROVISIONING",
                "IDLE",
                "BUSY",
                "TERMINATING",
                "TERMINATED",
                name="instancestatus",
            ),
            type_=sa.VARCHAR(length=11),
            existing_nullable=False,
        )

    # ### end Alembic commands ###
