# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import List, Dict, Any
from ....utils.dt import to_json_decorator
from ....event.model.event import *
import attr




@to_json_decorator
@attr.s
class TextRun(object):
    text = attr.ib(type=str, default=None, metadata={'json': 'text'})


@to_json_decorator
@attr.s
class Person(object):
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})


@to_json_decorator
@attr.s
class ImportTaskMountPoint(object):
    mount_type = attr.ib(type=int, default=None, metadata={'json': 'mount_type'})
    mount_key = attr.ib(type=str, default=None, metadata={'json': 'mount_key'})


@to_json_decorator
@attr.s
class ImportTask(object):
    ticket = attr.ib(type=str, default=None, metadata={'json': 'ticket'})
    file_extension = attr.ib(type=str, default=None, metadata={'json': 'file_extension'})
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    type = attr.ib(type=str, default=None, metadata={'json': 'type'})
    file_name = attr.ib(type=str, default=None, metadata={'json': 'file_name'})
    point = attr.ib(type=ImportTaskMountPoint, default=None, metadata={'json': 'point'})
    job_status = attr.ib(type=int, default=None, metadata={'json': 'job_status'})
    job_error_msg = attr.ib(type=str, default=None, metadata={'json': 'job_error_msg'})
    token = attr.ib(type=str, default=None, metadata={'json': 'token'})
    url = attr.ib(type=str, default=None, metadata={'json': 'url'})
    extra = attr.ib(type=List[str], default=None, metadata={'json': 'extra'})


@to_json_decorator
@attr.s
class DocsLink(object):
    url = attr.ib(type=str, default=None, metadata={'json': 'url'})


@to_json_decorator
@attr.s
class ReplyElement(object):
    type = attr.ib(type=str, default=None, metadata={'json': 'type'})
    text_run = attr.ib(type=TextRun, default=None, metadata={'json': 'text_run'})
    docs_link = attr.ib(type=DocsLink, default=None, metadata={'json': 'docs_link'})
    person = attr.ib(type=Person, default=None, metadata={'json': 'person'})


@to_json_decorator
@attr.s
class ReplyContent(object):
    elements = attr.ib(type=List[ReplyElement], default=None, metadata={'json': 'elements'})


@to_json_decorator
@attr.s
class FileCommentReply(object):
    reply_id = attr.ib(type=str, default=None, metadata={'json': 'reply_id'})
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})
    create_time = attr.ib(type=int, default=None, metadata={'json': 'create_time'})
    update_time = attr.ib(type=int, default=None, metadata={'json': 'update_time'})
    content = attr.ib(type=ReplyContent, default=None, metadata={'json': 'content'})


@to_json_decorator
@attr.s
class ReplyList(object):
    replies = attr.ib(type=List[FileCommentReply], default=None, metadata={'json': 'replies'})


@to_json_decorator
@attr.s
class FileComment(object):
    comment_id = attr.ib(type=str, default=None, metadata={'json': 'comment_id'})
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})
    create_time = attr.ib(type=int, default=None, metadata={'json': 'create_time'})
    update_time = attr.ib(type=int, default=None, metadata={'json': 'update_time'})
    is_solved = attr.ib(type=bool, default=None, metadata={'json': 'is_solved'})
    solved_time = attr.ib(type=int, default=None, metadata={'json': 'solved_time'})
    solver_user_id = attr.ib(type=str, default=None, metadata={'json': 'solver_user_id'})
    reply_list = attr.ib(type=ReplyList, default=None, metadata={'json': 'reply_list'})


@to_json_decorator
@attr.s
class UserId(object):
    user_id = attr.ib(type=str, default=None, metadata={'json': 'user_id'})
    open_id = attr.ib(type=str, default=None, metadata={'json': 'open_id'})
    union_id = attr.ib(type=str, default=None, metadata={'json': 'union_id'})


@to_json_decorator
@attr.s
class Collaborator(object):
    member_type = attr.ib(type=str, default=None, metadata={'json': 'member_type'})
    member_open_id = attr.ib(type=str, default=None, metadata={'json': 'member_open_id'})
    member_user_id = attr.ib(type=str, default=None, metadata={'json': 'member_user_id'})
    perm = attr.ib(type=str, default=None, metadata={'json': 'perm'})


@to_json_decorator
@attr.s
class File(object):
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    file_name = attr.ib(type=str, default=None, metadata={'json': 'file_name'})
    size = attr.ib(type=int, default=None, metadata={'json': 'size'})
    mime_type = attr.ib(type=str, default=None, metadata={'json': 'mime_type'})


@to_json_decorator
@attr.s
class FileUploadInfo(object):
    file_name = attr.ib(type=str, default=None, metadata={'json': 'file_name'})
    parent_type = attr.ib(type=str, default=None, metadata={'json': 'parent_type'})
    parent_node = attr.ib(type=str, default=None, metadata={'json': 'parent_node'})
    size = attr.ib(type=int, default=None, metadata={'json': 'size'})


@to_json_decorator
@attr.s
class Media(object):
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    file_name = attr.ib(type=str, default=None, metadata={'json': 'file_name'})
    size = attr.ib(type=int, default=None, metadata={'json': 'size'})
    mime_type = attr.ib(type=str, default=None, metadata={'json': 'mime_type'})


@to_json_decorator
@attr.s
class MediaUploadInfo(object):
    file_name = attr.ib(type=str, default=None, metadata={'json': 'file_name'})
    parent_type = attr.ib(type=str, default=None, metadata={'json': 'parent_type'})
    parent_node = attr.ib(type=str, default=None, metadata={'json': 'parent_node'})
    size = attr.ib(type=int, default=None, metadata={'json': 'size'})
    extra = attr.ib(type=str, default=None, metadata={'json': 'extra'})


@to_json_decorator
@attr.s
class Member(object):
    member_type = attr.ib(type=str, default=None, metadata={'json': 'member_type'})
    member_id = attr.ib(type=str, default=None, metadata={'json': 'member_id'})
    perm = attr.ib(type=str, default=None, metadata={'json': 'perm'})


@to_json_decorator
@attr.s
class Owner(object):
    member_type = attr.ib(type=str, default=None, metadata={'json': 'member_type'})
    member_id = attr.ib(type=str, default=None, metadata={'json': 'member_id'})


@to_json_decorator
@attr.s
class PermissionPublic(object):
    external_access = attr.ib(type=bool, default=None, metadata={'json': 'external_access'})
    security_entity = attr.ib(type=str, default=None, metadata={'json': 'security_entity'})
    comment_entity = attr.ib(type=str, default=None, metadata={'json': 'comment_entity'})
    share_entity = attr.ib(type=str, default=None, metadata={'json': 'share_entity'})
    link_share_entity = attr.ib(type=str, default=None, metadata={'json': 'link_share_entity'})
    invite_external = attr.ib(type=bool, default=None, metadata={'json': 'invite_external'})


@to_json_decorator
@attr.s
class TmpDownloadUrl(object):
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    tmp_download_url = attr.ib(type=str, default=None, metadata={'json': 'tmp_download_url'})


@to_json_decorator
@attr.s
class TokenType(object):
    token = attr.ib(type=str, default=None, metadata={'json': 'token'})
    type = attr.ib(type=str, default=None, metadata={'json': 'type'})


@to_json_decorator
@attr.s
class UploadInfo(object):
    file_name = attr.ib(type=str, default=None, metadata={'json': 'file_name'})
    parent_type = attr.ib(type=str, default=None, metadata={'json': 'parent_type'})
    parent_node = attr.ib(type=str, default=None, metadata={'json': 'parent_node'})
    size = attr.ib(type=int, default=None, metadata={'json': 'size'})


@to_json_decorator
@attr.s
class FileStatistics(object):
    uv = attr.ib(type=int, default=None, metadata={'json': 'uv'})
    pv = attr.ib(type=int, default=None, metadata={'json': 'pv'})
    like_count = attr.ib(type=int, default=None, metadata={'json': 'like_count'})
    timestamp = attr.ib(type=int, default=None, metadata={'json': 'timestamp'})



@to_json_decorator
@attr.s
class FileUploadFinishReqBody(object):
    upload_id = attr.ib(type=str, default=None, metadata={'json': 'upload_id'})
    block_num = attr.ib(type=int, default=None, metadata={'json': 'block_num'})


@attr.s
class FileUploadFinishResult(object):
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})



@attr.s
class FileUploadPrepareResult(object):
    upload_id = attr.ib(type=str, default=None, metadata={'json': 'upload_id'})
    block_size = attr.ib(type=int, default=None, metadata={'json': 'block_size'})
    block_num = attr.ib(type=int, default=None, metadata={'json': 'block_num'})



@attr.s
class FileUploadAllResult(object):
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})













@attr.s
class FileCommentListResult(object):
    has_more = attr.ib(type=bool, default=None, metadata={'json': 'has_more'})
    page_token = attr.ib(type=str, default=None, metadata={'json': 'page_token'})
    items = attr.ib(type=List[FileComment], default=None, metadata={'json': 'items'})


@to_json_decorator
@attr.s
class FileCommentPatchReqBody(object):
    is_solved = attr.ib(type=bool, default=None, metadata={'json': 'is_solved'})



@to_json_decorator
@attr.s
class FileCommentReplyUpdateReqBody(object):
    content = attr.ib(type=ReplyContent, default=None, metadata={'json': 'content'})






@attr.s
class FileStatisticsGetResult(object):
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    file_type = attr.ib(type=str, default=None, metadata={'json': 'file_type'})
    statistics = attr.ib(type=FileStatistics, default=None, metadata={'json': 'statistics'})



@attr.s
class ImportTaskCreateResult(object):
    ticket = attr.ib(type=str, default=None, metadata={'json': 'ticket'})



@attr.s
class ImportTaskGetResult(object):
    result = attr.ib(type=ImportTask, default=None, metadata={'json': 'result'})





@attr.s
class MediaUploadAllResult(object):
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})


@to_json_decorator
@attr.s
class MediaUploadFinishReqBody(object):
    upload_id = attr.ib(type=str, default=None, metadata={'json': 'upload_id'})
    block_num = attr.ib(type=int, default=None, metadata={'json': 'block_num'})


@attr.s
class MediaUploadFinishResult(object):
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})



@attr.s
class MediaUploadPrepareResult(object):
    upload_id = attr.ib(type=str, default=None, metadata={'json': 'upload_id'})
    block_size = attr.ib(type=int, default=None, metadata={'json': 'block_size'})
    block_num = attr.ib(type=int, default=None, metadata={'json': 'block_num'})



@attr.s
class MediaBatchGetTmpDownloadUrlResult(object):
    tmp_download_urls = attr.ib(type=List[TmpDownloadUrl], default=None, metadata={'json': 'tmp_download_urls'})





@attr.s
class PermissionMemberCreateResult(object):
    member = attr.ib(type=Member, default=None, metadata={'json': 'member'})





@attr.s
class PermissionMemberUpdateResult(object):
    member = attr.ib(type=Member, default=None, metadata={'json': 'member'})



@attr.s
class PermissionPublicPatchResult(object):
    permission_public = attr.ib(type=PermissionPublic, default=None, metadata={'json': 'permission_public'})


@attr.s
class FileDeletedEventData(object):
    file_type = attr.ib(type=str, default=None, metadata={'json': 'file_type'})
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    operator_id = attr.ib(type=UserId, default=None, metadata={'json': 'operator_id'})
    subscriber_id_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'subscriber_id_list'})


@attr.s
class FileDeletedEvent(BaseEventV2):
    event = attr.ib(type=FileDeletedEventData, default=None)



@attr.s
class FilePermissionMemberAddedEventData(object):
    file_type = attr.ib(type=str, default=None, metadata={'json': 'file_type'})
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    operator_id = attr.ib(type=UserId, default=None, metadata={'json': 'operator_id'})
    user_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'user_list'})
    chat_list = attr.ib(type=List[str], default=None, metadata={'json': 'chat_list'})
    subscriber_id_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'subscriber_id_list'})


@attr.s
class FilePermissionMemberAddedEvent(BaseEventV2):
    event = attr.ib(type=FilePermissionMemberAddedEventData, default=None)



@attr.s
class FilePermissionMemberRemovedEventData(object):
    file_type = attr.ib(type=str, default=None, metadata={'json': 'file_type'})
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    operator_id = attr.ib(type=UserId, default=None, metadata={'json': 'operator_id'})
    user_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'user_list'})
    chat_list = attr.ib(type=List[str], default=None, metadata={'json': 'chat_list'})
    subscriber_id_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'subscriber_id_list'})


@attr.s
class FilePermissionMemberRemovedEvent(BaseEventV2):
    event = attr.ib(type=FilePermissionMemberRemovedEventData, default=None)



@attr.s
class FileReadEventData(object):
    file_type = attr.ib(type=str, default=None, metadata={'json': 'file_type'})
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    operator_id_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'operator_id_list'})
    subscriber_id_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'subscriber_id_list'})


@attr.s
class FileReadEvent(BaseEventV2):
    event = attr.ib(type=FileReadEventData, default=None)



@attr.s
class FileTitleUpdatedEventData(object):
    file_type = attr.ib(type=str, default=None, metadata={'json': 'file_type'})
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    operator_id = attr.ib(type=UserId, default=None, metadata={'json': 'operator_id'})
    subscriber_id_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'subscriber_id_list'})


@attr.s
class FileTitleUpdatedEvent(BaseEventV2):
    event = attr.ib(type=FileTitleUpdatedEventData, default=None)



@attr.s
class FileTrashedEventData(object):
    file_type = attr.ib(type=str, default=None, metadata={'json': 'file_type'})
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    operator_id = attr.ib(type=UserId, default=None, metadata={'json': 'operator_id'})
    subscriber_id_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'subscriber_id_list'})


@attr.s
class FileTrashedEvent(BaseEventV2):
    event = attr.ib(type=FileTrashedEventData, default=None)



@attr.s
class FileEditEventData(object):
    file_type = attr.ib(type=str, default=None, metadata={'json': 'file_type'})
    file_token = attr.ib(type=str, default=None, metadata={'json': 'file_token'})
    operator_id_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'operator_id_list'})
    subscriber_id_list = attr.ib(type=List[UserId], default=None, metadata={'json': 'subscriber_id_list'})


@attr.s
class FileEditEvent(BaseEventV2):
    event = attr.ib(type=FileEditEventData, default=None)
