# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import *

from ....api import Request as APIRequest, Response as APIResponse, set_timeout, set_tenant_key, set_user_access_token, set_path_params, \
    set_query_params, set_response_stream, set_is_response_stream, FormData, FormDataFile
from ....config import Config
from ....consts import ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_APP
from .model import *


class Service(object):
    def __init__(self, conf):
        # type: (Config) -> None
        self.conf = conf
        self.files = FileService(self)
        self.file_comments = FileCommentService(self)
        self.file_comment_replys = FileCommentReplyService(self)
        self.import_tasks = ImportTaskService(self)
        self.medias = MediaService(self)
        self.permission_members = PermissionMemberService(self)
        self.permission_publics = PermissionPublicService(self)
        self.file_statisticss = FileStatisticsService(self)
        



class FileService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def upload_finish(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (FileUploadFinishReqBody, str, str, int) -> FileUploadFinishReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileUploadFinishReqCall(self, body, request_opts=request_opts)

    def upload_prepare(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (FileUploadInfo, str, str, int) -> FileUploadPrepareReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileUploadPrepareReqCall(self, body, request_opts=request_opts)

    def upload_all(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> FileUploadAllReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileUploadAllReqCall(self, request_opts=request_opts)

    def upload_part(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> FileUploadPartReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileUploadPartReqCall(self, request_opts=request_opts)

    def download(self, tenant_key=None, user_access_token=None, response_stream=None, timeout=None):
        # type: (str, str, Union[None, IO], int) -> FileDownloadReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        if response_stream is not None:
            request_opts += [set_response_stream(response_stream)]

        return FileDownloadReqCall(self, request_opts=request_opts)

    def subscribe(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> FileSubscribeReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileSubscribeReqCall(self, request_opts=request_opts)


class FileCommentService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (FileComment, str, str, int) -> FileCommentCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileCommentCreateReqCall(self, body, request_opts=request_opts)

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> FileCommentGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileCommentGetReqCall(self, request_opts=request_opts)

    def list(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> FileCommentListReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileCommentListReqCall(self, request_opts=request_opts)

    def patch(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (FileCommentPatchReqBody, str, str, int) -> FileCommentPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileCommentPatchReqCall(self, body, request_opts=request_opts)


class FileCommentReplyService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (FileCommentReplyUpdateReqBody, str, str, int) -> FileCommentReplyUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileCommentReplyUpdateReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> FileCommentReplyDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileCommentReplyDeleteReqCall(self, request_opts=request_opts)


class ImportTaskService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (ImportTask, str, str, int) -> ImportTaskCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ImportTaskCreateReqCall(self, body, request_opts=request_opts)

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> ImportTaskGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return ImportTaskGetReqCall(self, request_opts=request_opts)


class MediaService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def upload_part(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> MediaUploadPartReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaUploadPartReqCall(self, request_opts=request_opts)

    def upload_all(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> MediaUploadAllReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaUploadAllReqCall(self, request_opts=request_opts)

    def upload_finish(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MediaUploadFinishReqBody, str, str, int) -> MediaUploadFinishReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaUploadFinishReqCall(self, body, request_opts=request_opts)

    def upload_prepare(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (MediaUploadInfo, str, str, int) -> MediaUploadPrepareReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaUploadPrepareReqCall(self, body, request_opts=request_opts)

    def batch_get_tmp_download_url(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> MediaBatchGetTmpDownloadUrlReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return MediaBatchGetTmpDownloadUrlReqCall(self, request_opts=request_opts)

    def download(self, tenant_key=None, user_access_token=None, response_stream=None, timeout=None):
        # type: (str, str, Union[None, IO], int) -> MediaDownloadReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        if response_stream is not None:
            request_opts += [set_response_stream(response_stream)]

        return MediaDownloadReqCall(self, request_opts=request_opts)


class PermissionMemberService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def create(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (Member, str, str, int) -> PermissionMemberCreateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return PermissionMemberCreateReqCall(self, body, request_opts=request_opts)

    def delete(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> PermissionMemberDeleteReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return PermissionMemberDeleteReqCall(self, request_opts=request_opts)

    def update(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (Member, str, str, int) -> PermissionMemberUpdateReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return PermissionMemberUpdateReqCall(self, body, request_opts=request_opts)


class PermissionPublicService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def patch(self, body, tenant_key=None, user_access_token=None, timeout=None):
        # type: (PermissionPublic, str, str, int) -> PermissionPublicPatchReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return PermissionPublicPatchReqCall(self, body, request_opts=request_opts)


class FileStatisticsService(object):
    def __init__(self, service):
        # type: (Service) -> None
        self.service = service

    def get(self, tenant_key=None, user_access_token=None, timeout=None):
        # type: (str, str, int) -> FileStatisticsGetReqCall

        request_opts = []   # type: List[Callable[[Any], Any]]

        if timeout is not None:
            request_opts += [set_timeout(timeout)]

        if tenant_key is not None:
            request_opts += [set_tenant_key(tenant_key)]

        if user_access_token is not None:
            request_opts += [set_user_access_token(user_access_token)]

        return FileStatisticsGetReqCall(self, request_opts=request_opts)



class FileUploadFinishReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (FileService, FileUploadFinishReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[FileUploadFinishResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/v1/files/upload_finish', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=FileUploadFinishResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileUploadPrepareReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (FileService, FileUploadInfo, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[FileUploadPrepareResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/v1/files/upload_prepare', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=FileUploadPrepareResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileUploadAllReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_name(self, file_name):
        # type: (str) -> FileUploadAllReqCall
        self.body.add_param('file_name', file_name)
        return self

    def set_parent_type(self, parent_type):
        # type: (str) -> FileUploadAllReqCall
        self.body.add_param('parent_type', parent_type)
        return self

    def set_parent_node(self, parent_node):
        # type: (str) -> FileUploadAllReqCall
        self.body.add_param('parent_node', parent_node)
        return self

    def set_size(self, size):
        # type: (int) -> FileUploadAllReqCall
        self.body.add_param('size', size)
        return self

    def set_checksum(self, checksum):
        # type: (str) -> FileUploadAllReqCall
        self.body.add_param('checksum', checksum)
        return self

    def set_file(self, file):
        # type: (IO[Any]) -> FileUploadAllReqCall
        self.body.add_file('file', FormDataFile(file))
        return self

    def do(self):
        # type: () -> APIResponse[Type[FileUploadAllResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/v1/files/upload_all', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT], self.body, output_class=FileUploadAllResult , request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileUploadPartReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_upload_id(self, upload_id):
        # type: (str) -> FileUploadPartReqCall
        self.body.add_param('upload_id', upload_id)
        return self

    def set_seq(self, seq):
        # type: (int) -> FileUploadPartReqCall
        self.body.add_param('seq', seq)
        return self

    def set_size(self, size):
        # type: (int) -> FileUploadPartReqCall
        self.body.add_param('size', size)
        return self

    def set_checksum(self, checksum):
        # type: (str) -> FileUploadPartReqCall
        self.body.add_param('checksum', checksum)
        return self

    def set_file(self, file):
        # type: (IO[Any]) -> FileUploadPartReqCall
        self.body.add_file('file', FormDataFile(file))
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/v1/files/upload_part', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT], self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileDownloadReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> FileDownloadReqCall
        self.path_params['file_token'] = file_token
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_is_response_stream()]
        req = APIRequest('/open-apis/drive/v1/files/:file_token/download', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileSubscribeReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> FileSubscribeReqCall
        self.path_params['file_token'] = file_token
        return self

    def set_file_type(self, file_type):
        # type: (str) -> FileSubscribeReqCall
        self.query_params['file_type'] = file_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/files/:file_token/subscribe', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileCommentCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (FileCommentService, FileComment, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> FileCommentCreateReqCall
        self.path_params['file_token'] = file_token
        return self

    def set_file_type(self, file_type):
        # type: (str) -> FileCommentCreateReqCall
        self.query_params['file_type'] = file_type
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> FileCommentCreateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[FileComment]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/files/:file_token/comments', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=FileComment, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileCommentGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileCommentService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> FileCommentGetReqCall
        self.path_params['file_token'] = file_token
        return self

    def set_comment_id(self, comment_id):
        # type: (int) -> FileCommentGetReqCall
        self.path_params['comment_id'] = comment_id
        return self

    def set_file_type(self, file_type):
        # type: (str) -> FileCommentGetReqCall
        self.query_params['file_type'] = file_type
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> FileCommentGetReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[FileComment]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/files/:file_token/comments/:comment_id', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=FileComment, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileCommentListReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileCommentService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> FileCommentListReqCall
        self.path_params['file_token'] = file_token
        return self

    def set_file_type(self, file_type):
        # type: (str) -> FileCommentListReqCall
        self.query_params['file_type'] = file_type
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> FileCommentListReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def set_is_solved(self, is_solved):
        # type: (bool) -> FileCommentListReqCall
        self.query_params['is_solved'] = is_solved
        return self

    def set_page_token(self, page_token):
        # type: (str) -> FileCommentListReqCall
        self.query_params['page_token'] = page_token
        return self

    def set_page_size(self, page_size):
        # type: (int) -> FileCommentListReqCall
        self.query_params['page_size'] = page_size
        return self

    def do(self):
        # type: () -> APIResponse[Type[FileCommentListResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/files/:file_token/comments', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=FileCommentListResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileCommentPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (FileCommentService, FileCommentPatchReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> FileCommentPatchReqCall
        self.path_params['file_token'] = file_token
        return self

    def set_comment_id(self, comment_id):
        # type: (int) -> FileCommentPatchReqCall
        self.path_params['comment_id'] = comment_id
        return self

    def set_file_type(self, file_type):
        # type: (str) -> FileCommentPatchReqCall
        self.query_params['file_type'] = file_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/files/:file_token/comments/:comment_id', 'PATCH', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileCommentReplyUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (FileCommentReplyService, FileCommentReplyUpdateReqBody, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> FileCommentReplyUpdateReqCall
        self.path_params['file_token'] = file_token
        return self

    def set_comment_id(self, comment_id):
        # type: (int) -> FileCommentReplyUpdateReqCall
        self.path_params['comment_id'] = comment_id
        return self

    def set_reply_id(self, reply_id):
        # type: (int) -> FileCommentReplyUpdateReqCall
        self.path_params['reply_id'] = reply_id
        return self

    def set_file_type(self, file_type):
        # type: (str) -> FileCommentReplyUpdateReqCall
        self.query_params['file_type'] = file_type
        return self

    def set_user_id_type(self, user_id_type):
        # type: (str) -> FileCommentReplyUpdateReqCall
        self.query_params['user_id_type'] = user_id_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id', 'PUT', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileCommentReplyDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileCommentReplyService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> FileCommentReplyDeleteReqCall
        self.path_params['file_token'] = file_token
        return self

    def set_comment_id(self, comment_id):
        # type: (int) -> FileCommentReplyDeleteReqCall
        self.path_params['comment_id'] = comment_id
        return self

    def set_reply_id(self, reply_id):
        # type: (int) -> FileCommentReplyDeleteReqCall
        self.path_params['reply_id'] = reply_id
        return self

    def set_file_type(self, file_type):
        # type: (str) -> FileCommentReplyDeleteReqCall
        self.query_params['file_type'] = file_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/files/:file_token/comments/:comment_id/replies/:reply_id', 'DELETE', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class FileStatisticsGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (FileStatisticsService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> FileStatisticsGetReqCall
        self.path_params['file_token'] = file_token
        return self

    def set_file_type(self, file_type):
        # type: (str) -> FileStatisticsGetReqCall
        self.query_params['file_type'] = file_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[FileStatisticsGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/files/:file_token/statistics', 'GET', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        None, output_class=FileStatisticsGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ImportTaskCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (ImportTaskService, ImportTask, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[ImportTaskCreateResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/v1/import_tasks', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=ImportTaskCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class ImportTaskGetReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (ImportTaskService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_ticket(self, ticket):
        # type: (str) -> ImportTaskGetReqCall
        self.path_params['ticket'] = ticket
        return self

    def do(self):
        # type: () -> APIResponse[Type[ImportTaskGetResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        req = APIRequest('/open-apis/drive/v1/import_tasks/:ticket', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=ImportTaskGetResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaUploadPartReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MediaService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_upload_id(self, upload_id):
        # type: (str) -> MediaUploadPartReqCall
        self.body.add_param('upload_id', upload_id)
        return self

    def set_seq(self, seq):
        # type: (int) -> MediaUploadPartReqCall
        self.body.add_param('seq', seq)
        return self

    def set_size(self, size):
        # type: (int) -> MediaUploadPartReqCall
        self.body.add_param('size', size)
        return self

    def set_checksum(self, checksum):
        # type: (str) -> MediaUploadPartReqCall
        self.body.add_param('checksum', checksum)
        return self

    def set_file(self, file):
        # type: (IO[Any]) -> MediaUploadPartReqCall
        self.body.add_file('file', FormDataFile(file))
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/v1/medias/upload_part', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT], self.body, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaUploadAllReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MediaService, List[Any]) -> None

        self.service = service
        self.body = FormData()

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_name(self, file_name):
        # type: (str) -> MediaUploadAllReqCall
        self.body.add_param('file_name', file_name)
        return self

    def set_parent_type(self, parent_type):
        # type: (str) -> MediaUploadAllReqCall
        self.body.add_param('parent_type', parent_type)
        return self

    def set_parent_node(self, parent_node):
        # type: (str) -> MediaUploadAllReqCall
        self.body.add_param('parent_node', parent_node)
        return self

    def set_size(self, size):
        # type: (int) -> MediaUploadAllReqCall
        self.body.add_param('size', size)
        return self

    def set_checksum(self, checksum):
        # type: (str) -> MediaUploadAllReqCall
        self.body.add_param('checksum', checksum)
        return self

    def set_extra(self, extra):
        # type: (str) -> MediaUploadAllReqCall
        self.body.add_param('extra', extra)
        return self

    def set_file(self, file):
        # type: (IO[Any]) -> MediaUploadAllReqCall
        self.body.add_file('file', FormDataFile(file))
        return self

    def do(self):
        # type: () -> APIResponse[Type[MediaUploadAllResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/v1/medias/upload_all', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT], self.body, output_class=MediaUploadAllResult , request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaUploadFinishReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MediaService, MediaUploadFinishReqBody, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[MediaUploadFinishResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/v1/medias/upload_finish', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MediaUploadFinishResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaUploadPrepareReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (MediaService, MediaUploadInfo, List[Any]) -> None

        self.service = service
        self.body = body

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def do(self):
        # type: () -> APIResponse[Type[MediaUploadPrepareResult]]
        root_service = self.service.service

        conf = root_service.conf
        req = APIRequest('/open-apis/drive/v1/medias/upload_prepare', 'POST', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        self.body, output_class=MediaUploadPrepareResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaBatchGetTmpDownloadUrlReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MediaService, List[Any]) -> None

        self.service = service
        
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_tokens(self, file_tokens):
        # type: (List[str]) -> MediaBatchGetTmpDownloadUrlReqCall
        self.query_params['file_tokens'] = file_tokens
        return self

    def set_extra(self, extra):
        # type: (str) -> MediaBatchGetTmpDownloadUrlReqCall
        self.query_params['extra'] = extra
        return self

    def do(self):
        # type: () -> APIResponse[Type[MediaBatchGetTmpDownloadUrlResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/medias/batch_get_tmp_download_url', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        None, output_class=MediaBatchGetTmpDownloadUrlResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class MediaDownloadReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (MediaService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_file_token(self, file_token):
        # type: (str) -> MediaDownloadReqCall
        self.path_params['file_token'] = file_token
        return self

    def set_extra(self, extra):
        # type: (str) -> MediaDownloadReqCall
        self.query_params['extra'] = extra
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        self.request_opts += [set_is_response_stream()]
        req = APIRequest('/open-apis/drive/v1/medias/:file_token/download', 'GET', [ACCESS_TOKEN_TYPE_USER, ACCESS_TOKEN_TYPE_TENANT],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PermissionMemberCreateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PermissionMemberService, Member, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_token(self, token):
        # type: (str) -> PermissionMemberCreateReqCall
        self.path_params['token'] = token
        return self

    def set_type(self, type):
        # type: (str) -> PermissionMemberCreateReqCall
        self.query_params['type'] = type
        return self

    def set_need_notification(self, need_notification):
        # type: (bool) -> PermissionMemberCreateReqCall
        self.query_params['need_notification'] = need_notification
        return self

    def do(self):
        # type: () -> APIResponse[Type[PermissionMemberCreateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/permissions/:token/members', 'POST', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=PermissionMemberCreateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PermissionMemberDeleteReqCall(object):
    def __init__(self, service, request_opts=None):
        # type: (PermissionMemberService, List[Any]) -> None

        self.service = service
        
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_token(self, token):
        # type: (str) -> PermissionMemberDeleteReqCall
        self.path_params['token'] = token
        return self

    def set_member_id(self, member_id):
        # type: (str) -> PermissionMemberDeleteReqCall
        self.path_params['member_id'] = member_id
        return self

    def set_type(self, type):
        # type: (str) -> PermissionMemberDeleteReqCall
        self.query_params['type'] = type
        return self

    def set_member_type(self, member_type):
        # type: (str) -> PermissionMemberDeleteReqCall
        self.query_params['member_type'] = member_type
        return self

    def do(self):
        # type: () -> APIResponse[Type[None]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/permissions/:token/members/:member_id', 'DELETE', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        None, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PermissionMemberUpdateReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PermissionMemberService, Member, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_token(self, token):
        # type: (str) -> PermissionMemberUpdateReqCall
        self.path_params['token'] = token
        return self

    def set_member_id(self, member_id):
        # type: (str) -> PermissionMemberUpdateReqCall
        self.path_params['member_id'] = member_id
        return self

    def set_need_notification(self, need_notification):
        # type: (bool) -> PermissionMemberUpdateReqCall
        self.query_params['need_notification'] = need_notification
        return self

    def set_type(self, type):
        # type: (str) -> PermissionMemberUpdateReqCall
        self.query_params['type'] = type
        return self

    def do(self):
        # type: () -> APIResponse[Type[PermissionMemberUpdateResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/permissions/:token/members/:member_id', 'PUT', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=PermissionMemberUpdateResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp


class PermissionPublicPatchReqCall(object):
    def __init__(self, service, body, request_opts=None):
        # type: (PermissionPublicService, PermissionPublic, List[Any]) -> None

        self.service = service
        self.body = body
        self.path_params = {}   # type: Dict[str, Any]
        self.query_params = {}  # type: Dict[str, Any]

        if request_opts:
            self.request_opts = request_opts
        else:
            self.request_opts = []  # type: List[Any]

    def set_token(self, token):
        # type: (str) -> PermissionPublicPatchReqCall
        self.path_params['token'] = token
        return self

    def set_type(self, type):
        # type: (str) -> PermissionPublicPatchReqCall
        self.query_params['type'] = type
        return self

    def do(self):
        # type: () -> APIResponse[Type[PermissionPublicPatchResult]]
        root_service = self.service.service

        conf = root_service.conf
        self.request_opts += [set_path_params(self.path_params)]
        self.request_opts += [set_query_params(self.query_params)]
        req = APIRequest('/open-apis/drive/v1/permissions/:token/public', 'PATCH', [ACCESS_TOKEN_TYPE_TENANT, ACCESS_TOKEN_TYPE_USER],
                        self.body, output_class=PermissionPublicPatchResult, request_opts=self.request_opts)
        resp = req.do(conf)
        return resp

