# -*- coding: UTF-8 -*-
# Code generated by lark suite oapi sdk gen

from typing import Callable

from ....config import Config
from ....context import Context
from ....event.event import set_event_callback

from .model import *


class AccessRecordCreatedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, AccessRecordCreatedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, AccessRecordCreatedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, AccessRecordCreatedEvent], Any]) -> None
        handler = AccessRecordCreatedEventHandler(callback)
        set_event_callback(conf, "acs.access_record.created_v1",
                          handler.handle, clazz=AccessRecordCreatedEvent)


class UserUpdatedEventHandler(object):
    def __init__(self, callback):
        # type: (Callable[[Context, Config, UserUpdatedEvent], Any]) -> None
        self.handler = callback

    def handle(self, ctx, conf, event):  # type: (Context, Config, UserUpdatedEvent) -> Any
        return self.handler(ctx, conf, event)

    @staticmethod
    def set_callback(conf, callback):
        # type: (Config, Callable[[Context, Config, UserUpdatedEvent], Any]) -> None
        handler = UserUpdatedEventHandler(callback)
        set_event_callback(conf, "acs.user.updated_v1",
                          handler.handle, clazz=UserUpdatedEvent)
