# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['SLOArgs', 'SLO']

@pulumi.input_type
class SLOArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 sli: pulumi.Input[str],
                 target_percentage: pulumi.Input[float],
                 time_period: pulumi.Input[int],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SLO resource.
        :param pulumi.Input[str] dataset: The dataset this SLO is created in. Must be the same dataset as the SLI.
        :param pulumi.Input[str] sli: The alias of the Derived Column that will be used as the SLI to indicate event success.
               The derived column used as the SLI must be in the same dataset as the SLO. Additionally,
               the column evaluation should consistently return nil, true, or false, as these are the only valid values for an SLI.
        :param pulumi.Input[float] target_percentage: The percentage of qualified events that you expect to succeed during the `time_period`.
        :param pulumi.Input[int] time_period: The time period, in days, over which your SLO will be evaluated.
        :param pulumi.Input[str] description: A description of the SLO's intent and context.
        :param pulumi.Input[str] name: The name of the SLO.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "sli", sli)
        pulumi.set(__self__, "target_percentage", target_percentage)
        pulumi.set(__self__, "time_period", time_period)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The dataset this SLO is created in. Must be the same dataset as the SLI.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def sli(self) -> pulumi.Input[str]:
        """
        The alias of the Derived Column that will be used as the SLI to indicate event success.
        The derived column used as the SLI must be in the same dataset as the SLO. Additionally,
        the column evaluation should consistently return nil, true, or false, as these are the only valid values for an SLI.
        """
        return pulumi.get(self, "sli")

    @sli.setter
    def sli(self, value: pulumi.Input[str]):
        pulumi.set(self, "sli", value)

    @property
    @pulumi.getter(name="targetPercentage")
    def target_percentage(self) -> pulumi.Input[float]:
        """
        The percentage of qualified events that you expect to succeed during the `time_period`.
        """
        return pulumi.get(self, "target_percentage")

    @target_percentage.setter
    def target_percentage(self, value: pulumi.Input[float]):
        pulumi.set(self, "target_percentage", value)

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> pulumi.Input[int]:
        """
        The time period, in days, over which your SLO will be evaluated.
        """
        return pulumi.get(self, "time_period")

    @time_period.setter
    def time_period(self, value: pulumi.Input[int]):
        pulumi.set(self, "time_period", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the SLO's intent and context.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SLO.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SLOState:
    def __init__(__self__, *,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sli: Optional[pulumi.Input[str]] = None,
                 target_percentage: Optional[pulumi.Input[float]] = None,
                 time_period: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SLO resources.
        :param pulumi.Input[str] dataset: The dataset this SLO is created in. Must be the same dataset as the SLI.
        :param pulumi.Input[str] description: A description of the SLO's intent and context.
        :param pulumi.Input[str] name: The name of the SLO.
        :param pulumi.Input[str] sli: The alias of the Derived Column that will be used as the SLI to indicate event success.
               The derived column used as the SLI must be in the same dataset as the SLO. Additionally,
               the column evaluation should consistently return nil, true, or false, as these are the only valid values for an SLI.
        :param pulumi.Input[float] target_percentage: The percentage of qualified events that you expect to succeed during the `time_period`.
        :param pulumi.Input[int] time_period: The time period, in days, over which your SLO will be evaluated.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sli is not None:
            pulumi.set(__self__, "sli", sli)
        if target_percentage is not None:
            pulumi.set(__self__, "target_percentage", target_percentage)
        if time_period is not None:
            pulumi.set(__self__, "time_period", time_period)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset this SLO is created in. Must be the same dataset as the SLI.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the SLO's intent and context.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the SLO.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def sli(self) -> Optional[pulumi.Input[str]]:
        """
        The alias of the Derived Column that will be used as the SLI to indicate event success.
        The derived column used as the SLI must be in the same dataset as the SLO. Additionally,
        the column evaluation should consistently return nil, true, or false, as these are the only valid values for an SLI.
        """
        return pulumi.get(self, "sli")

    @sli.setter
    def sli(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sli", value)

    @property
    @pulumi.getter(name="targetPercentage")
    def target_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        The percentage of qualified events that you expect to succeed during the `time_period`.
        """
        return pulumi.get(self, "target_percentage")

    @target_percentage.setter
    def target_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "target_percentage", value)

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> Optional[pulumi.Input[int]]:
        """
        The time period, in days, over which your SLO will be evaluated.
        """
        return pulumi.get(self, "time_period")

    @time_period.setter
    def time_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "time_period", value)


class SLO(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sli: Optional[pulumi.Input[str]] = None,
                 target_percentage: Optional[pulumi.Input[float]] = None,
                 time_period: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## # Resource: SLO

        Creates a service level objective (SLO). For more information about SLOs, check out [Set Service Level Objectives (SLOs)](https://docs.honeycomb.io/working-with-your-data/slos/).

        ## Import

        SLOs can be imported using a combination of the dataset name and their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/sLO:SLO my_slo my-dataset/bj9BwOb1uKz
        ```

         You can find the ID in the URL bar when visiting the SLO from the UI.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this SLO is created in. Must be the same dataset as the SLI.
        :param pulumi.Input[str] description: A description of the SLO's intent and context.
        :param pulumi.Input[str] name: The name of the SLO.
        :param pulumi.Input[str] sli: The alias of the Derived Column that will be used as the SLI to indicate event success.
               The derived column used as the SLI must be in the same dataset as the SLO. Additionally,
               the column evaluation should consistently return nil, true, or false, as these are the only valid values for an SLI.
        :param pulumi.Input[float] target_percentage: The percentage of qualified events that you expect to succeed during the `time_period`.
        :param pulumi.Input[int] time_period: The time period, in days, over which your SLO will be evaluated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SLOArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: SLO

        Creates a service level objective (SLO). For more information about SLOs, check out [Set Service Level Objectives (SLOs)](https://docs.honeycomb.io/working-with-your-data/slos/).

        ## Import

        SLOs can be imported using a combination of the dataset name and their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/sLO:SLO my_slo my-dataset/bj9BwOb1uKz
        ```

         You can find the ID in the URL bar when visiting the SLO from the UI.

        :param str resource_name: The name of the resource.
        :param SLOArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SLOArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sli: Optional[pulumi.Input[str]] = None,
                 target_percentage: Optional[pulumi.Input[float]] = None,
                 time_period: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SLOArgs.__new__(SLOArgs)

            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if sli is None and not opts.urn:
                raise TypeError("Missing required property 'sli'")
            __props__.__dict__["sli"] = sli
            if target_percentage is None and not opts.urn:
                raise TypeError("Missing required property 'target_percentage'")
            __props__.__dict__["target_percentage"] = target_percentage
            if time_period is None and not opts.urn:
                raise TypeError("Missing required property 'time_period'")
            __props__.__dict__["time_period"] = time_period
        super(SLO, __self__).__init__(
            'honeycomb:index/sLO:SLO',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dataset: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            sli: Optional[pulumi.Input[str]] = None,
            target_percentage: Optional[pulumi.Input[float]] = None,
            time_period: Optional[pulumi.Input[int]] = None) -> 'SLO':
        """
        Get an existing SLO resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this SLO is created in. Must be the same dataset as the SLI.
        :param pulumi.Input[str] description: A description of the SLO's intent and context.
        :param pulumi.Input[str] name: The name of the SLO.
        :param pulumi.Input[str] sli: The alias of the Derived Column that will be used as the SLI to indicate event success.
               The derived column used as the SLI must be in the same dataset as the SLO. Additionally,
               the column evaluation should consistently return nil, true, or false, as these are the only valid values for an SLI.
        :param pulumi.Input[float] target_percentage: The percentage of qualified events that you expect to succeed during the `time_period`.
        :param pulumi.Input[int] time_period: The time period, in days, over which your SLO will be evaluated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SLOState.__new__(_SLOState)

        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["sli"] = sli
        __props__.__dict__["target_percentage"] = target_percentage
        __props__.__dict__["time_period"] = time_period
        return SLO(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[str]:
        """
        The dataset this SLO is created in. Must be the same dataset as the SLI.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the SLO's intent and context.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the SLO.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sli(self) -> pulumi.Output[str]:
        """
        The alias of the Derived Column that will be used as the SLI to indicate event success.
        The derived column used as the SLI must be in the same dataset as the SLO. Additionally,
        the column evaluation should consistently return nil, true, or false, as these are the only valid values for an SLI.
        """
        return pulumi.get(self, "sli")

    @property
    @pulumi.getter(name="targetPercentage")
    def target_percentage(self) -> pulumi.Output[float]:
        """
        The percentage of qualified events that you expect to succeed during the `time_period`.
        """
        return pulumi.get(self, "target_percentage")

    @property
    @pulumi.getter(name="timePeriod")
    def time_period(self) -> pulumi.Output[int]:
        """
        The time period, in days, over which your SLO will be evaluated.
        """
        return pulumi.get(self, "time_period")

