# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['QueryAnnotationArgs', 'QueryAnnotation']

@pulumi.input_type
class QueryAnnotationArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 query_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a QueryAnnotation resource.
        :param pulumi.Input[str] dataset: The dataset this query is added to.
        :param pulumi.Input[str] query_id: The ID of the query that the annotation will be created on. Note that a query can have more than one annotation.
        :param pulumi.Input[str] description: The description for the query annotation.
        :param pulumi.Input[str] name: The name of the query annotation that will display in the Honeycomb UI.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "query_id", query_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The dataset this query is added to.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Input[str]:
        """
        The ID of the query that the annotation will be created on. Note that a query can have more than one annotation.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "query_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for the query annotation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the query annotation that will display in the Honeycomb UI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _QueryAnnotationState:
    def __init__(__self__, *,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering QueryAnnotation resources.
        :param pulumi.Input[str] dataset: The dataset this query is added to.
        :param pulumi.Input[str] description: The description for the query annotation.
        :param pulumi.Input[str] name: The name of the query annotation that will display in the Honeycomb UI.
        :param pulumi.Input[str] query_id: The ID of the query that the annotation will be created on. Note that a query can have more than one annotation.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if query_id is not None:
            pulumi.set(__self__, "query_id", query_id)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset this query is added to.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description for the query annotation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the query annotation that will display in the Honeycomb UI.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the query that the annotation will be created on. Note that a query can have more than one annotation.
        """
        return pulumi.get(self, "query_id")

    @query_id.setter
    def query_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query_id", value)


class QueryAnnotation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        test_query_get_query_specification = honeycomb.get_query_specification(calculations=[honeycomb.GetQuerySpecificationCalculationArgs(
                op="AVG",
                column="duration_ms",
            )],
            filters=[honeycomb.GetQuerySpecificationFilterArgs(
                column="duration_ms",
                op=">",
                value="10",
            )])
        test_query_query = honeycomb.Query("testQueryQuery",
            dataset=dataset,
            query_json=test_query_get_query_specification.json)
        test_annotation = honeycomb.QueryAnnotation("testAnnotation",
            dataset=dataset,
            query_id=test_query_query.id,
            description="Describes my cool query (optional)")
        ```

        ## Import

        Query annotations cannot be imported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this query is added to.
        :param pulumi.Input[str] description: The description for the query annotation.
        :param pulumi.Input[str] name: The name of the query annotation that will display in the Honeycomb UI.
        :param pulumi.Input[str] query_id: The ID of the query that the annotation will be created on. Note that a query can have more than one annotation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueryAnnotationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        test_query_get_query_specification = honeycomb.get_query_specification(calculations=[honeycomb.GetQuerySpecificationCalculationArgs(
                op="AVG",
                column="duration_ms",
            )],
            filters=[honeycomb.GetQuerySpecificationFilterArgs(
                column="duration_ms",
                op=">",
                value="10",
            )])
        test_query_query = honeycomb.Query("testQueryQuery",
            dataset=dataset,
            query_json=test_query_get_query_specification.json)
        test_annotation = honeycomb.QueryAnnotation("testAnnotation",
            dataset=dataset,
            query_id=test_query_query.id,
            description="Describes my cool query (optional)")
        ```

        ## Import

        Query annotations cannot be imported.

        :param str resource_name: The name of the resource.
        :param QueryAnnotationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueryAnnotationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 query_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueryAnnotationArgs.__new__(QueryAnnotationArgs)

            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if query_id is None and not opts.urn:
                raise TypeError("Missing required property 'query_id'")
            __props__.__dict__["query_id"] = query_id
        super(QueryAnnotation, __self__).__init__(
            'honeycomb:index/queryAnnotation:QueryAnnotation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dataset: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            query_id: Optional[pulumi.Input[str]] = None) -> 'QueryAnnotation':
        """
        Get an existing QueryAnnotation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this query is added to.
        :param pulumi.Input[str] description: The description for the query annotation.
        :param pulumi.Input[str] name: The name of the query annotation that will display in the Honeycomb UI.
        :param pulumi.Input[str] query_id: The ID of the query that the annotation will be created on. Note that a query can have more than one annotation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueryAnnotationState.__new__(_QueryAnnotationState)

        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["query_id"] = query_id
        return QueryAnnotation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[str]:
        """
        The dataset this query is added to.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description for the query annotation.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the query annotation that will display in the Honeycomb UI.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="queryId")
    def query_id(self) -> pulumi.Output[str]:
        """
        The ID of the query that the annotation will be created on. Note that a query can have more than one annotation.
        """
        return pulumi.get(self, "query_id")

