# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['DerivedColumnArgs', 'DerivedColumn']

@pulumi.input_type
class DerivedColumnArgs:
    def __init__(__self__, *,
                 alias: pulumi.Input[str],
                 dataset: pulumi.Input[str],
                 expression: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DerivedColumn resource.
        :param pulumi.Input[str] alias: The name of the derived column. Must be unique per dataset.
        :param pulumi.Input[str] dataset: The dataset this derived column is added to.
        :param pulumi.Input[str] expression: The function of the derived column. See [Derived Column Syntax](https://docs.honeycomb.io/working-with-your-data/customizing-your-query/derived-columns/#derived-column-syntax).
        :param pulumi.Input[str] description: A description that is shown in the UI.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "expression", expression)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Input[str]:
        """
        The name of the derived column. Must be unique per dataset.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: pulumi.Input[str]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The dataset this derived column is added to.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Input[str]:
        """
        The function of the derived column. See [Derived Column Syntax](https://docs.honeycomb.io/working-with-your-data/customizing-your-query/derived-columns/#derived-column-syntax).
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: pulumi.Input[str]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description that is shown in the UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class _DerivedColumnState:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DerivedColumn resources.
        :param pulumi.Input[str] alias: The name of the derived column. Must be unique per dataset.
        :param pulumi.Input[str] dataset: The dataset this derived column is added to.
        :param pulumi.Input[str] description: A description that is shown in the UI.
        :param pulumi.Input[str] expression: The function of the derived column. See [Derived Column Syntax](https://docs.honeycomb.io/working-with-your-data/customizing-your-query/derived-columns/#derived-column-syntax).
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the derived column. Must be unique per dataset.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset this derived column is added to.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description that is shown in the UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        The function of the derived column. See [Derived Column Syntax](https://docs.honeycomb.io/working-with-your-data/customizing-your-query/derived-columns/#derived-column-syntax).
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)


class DerivedColumn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: DerivedColumn

        Creates a derived column. For more information about derived columns, check out [Calculate with derived columns](https://docs.honeycomb.io/working-with-your-data/customizing-your-query/derived-columns/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        duration_ms_log = honeycomb.DerivedColumn("durationMsLog",
            alias="duration_ms_log10",
            expression="LOG10($duration_ms)",
            description="LOG10 of duration_ms",
            dataset=dataset)
        ```

        ## Import

        Derived columns can be imported using a combination of the dataset name and their alias, e.g.

        ```sh
         $ pulumi import honeycomb:index/derivedColumn:DerivedColumn my_column my-dataset/duration_ms_log10
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: The name of the derived column. Must be unique per dataset.
        :param pulumi.Input[str] dataset: The dataset this derived column is added to.
        :param pulumi.Input[str] description: A description that is shown in the UI.
        :param pulumi.Input[str] expression: The function of the derived column. See [Derived Column Syntax](https://docs.honeycomb.io/working-with-your-data/customizing-your-query/derived-columns/#derived-column-syntax).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DerivedColumnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: DerivedColumn

        Creates a derived column. For more information about derived columns, check out [Calculate with derived columns](https://docs.honeycomb.io/working-with-your-data/customizing-your-query/derived-columns/).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        duration_ms_log = honeycomb.DerivedColumn("durationMsLog",
            alias="duration_ms_log10",
            expression="LOG10($duration_ms)",
            description="LOG10 of duration_ms",
            dataset=dataset)
        ```

        ## Import

        Derived columns can be imported using a combination of the dataset name and their alias, e.g.

        ```sh
         $ pulumi import honeycomb:index/derivedColumn:DerivedColumn my_column my-dataset/duration_ms_log10
        ```

        :param str resource_name: The name of the resource.
        :param DerivedColumnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DerivedColumnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DerivedColumnArgs.__new__(DerivedColumnArgs)

            if alias is None and not opts.urn:
                raise TypeError("Missing required property 'alias'")
            __props__.__dict__["alias"] = alias
            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            __props__.__dict__["description"] = description
            if expression is None and not opts.urn:
                raise TypeError("Missing required property 'expression'")
            __props__.__dict__["expression"] = expression
        super(DerivedColumn, __self__).__init__(
            'honeycomb:index/derivedColumn:DerivedColumn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias: Optional[pulumi.Input[str]] = None,
            dataset: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            expression: Optional[pulumi.Input[str]] = None) -> 'DerivedColumn':
        """
        Get an existing DerivedColumn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias: The name of the derived column. Must be unique per dataset.
        :param pulumi.Input[str] dataset: The dataset this derived column is added to.
        :param pulumi.Input[str] description: A description that is shown in the UI.
        :param pulumi.Input[str] expression: The function of the derived column. See [Derived Column Syntax](https://docs.honeycomb.io/working-with-your-data/customizing-your-query/derived-columns/#derived-column-syntax).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DerivedColumnState.__new__(_DerivedColumnState)

        __props__.__dict__["alias"] = alias
        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["description"] = description
        __props__.__dict__["expression"] = expression
        return DerivedColumn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[str]:
        """
        The name of the derived column. Must be unique per dataset.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[str]:
        """
        The dataset this derived column is added to.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description that is shown in the UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> pulumi.Output[str]:
        """
        The function of the derived column. See [Derived Column Syntax](https://docs.honeycomb.io/working-with-your-data/customizing-your-query/derived-columns/#derived-column-syntax).
        """
        return pulumi.get(self, "expression")

