# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BurnAlertArgs', 'BurnAlert']

@pulumi.input_type
class BurnAlertArgs:
    def __init__(__self__, *,
                 dataset: pulumi.Input[str],
                 exhaustion_minutes: pulumi.Input[int],
                 recipients: pulumi.Input[Sequence[pulumi.Input['BurnAlertRecipientArgs']]],
                 slo_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a BurnAlert resource.
        :param pulumi.Input[str] dataset: The dataset this burn alert is associated with.
        :param pulumi.Input[int] exhaustion_minutes: The amount of time, in minutes, remaining before the SLO's error budget will be exhausted and the alert will fire.
        :param pulumi.Input[Sequence[pulumi.Input['BurnAlertRecipientArgs']]] recipients: Zero or more configuration blocks (described below) with the recipients to notify when the alert fires.
        :param pulumi.Input[str] slo_id: ID of the SLO this burn alert is associated with.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "exhaustion_minutes", exhaustion_minutes)
        pulumi.set(__self__, "recipients", recipients)
        pulumi.set(__self__, "slo_id", slo_id)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Input[str]:
        """
        The dataset this burn alert is associated with.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="exhaustionMinutes")
    def exhaustion_minutes(self) -> pulumi.Input[int]:
        """
        The amount of time, in minutes, remaining before the SLO's error budget will be exhausted and the alert will fire.
        """
        return pulumi.get(self, "exhaustion_minutes")

    @exhaustion_minutes.setter
    def exhaustion_minutes(self, value: pulumi.Input[int]):
        pulumi.set(self, "exhaustion_minutes", value)

    @property
    @pulumi.getter
    def recipients(self) -> pulumi.Input[Sequence[pulumi.Input['BurnAlertRecipientArgs']]]:
        """
        Zero or more configuration blocks (described below) with the recipients to notify when the alert fires.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: pulumi.Input[Sequence[pulumi.Input['BurnAlertRecipientArgs']]]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> pulumi.Input[str]:
        """
        ID of the SLO this burn alert is associated with.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "slo_id", value)


@pulumi.input_type
class _BurnAlertState:
    def __init__(__self__, *,
                 dataset: Optional[pulumi.Input[str]] = None,
                 exhaustion_minutes: Optional[pulumi.Input[int]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input['BurnAlertRecipientArgs']]]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BurnAlert resources.
        :param pulumi.Input[str] dataset: The dataset this burn alert is associated with.
        :param pulumi.Input[int] exhaustion_minutes: The amount of time, in minutes, remaining before the SLO's error budget will be exhausted and the alert will fire.
        :param pulumi.Input[Sequence[pulumi.Input['BurnAlertRecipientArgs']]] recipients: Zero or more configuration blocks (described below) with the recipients to notify when the alert fires.
        :param pulumi.Input[str] slo_id: ID of the SLO this burn alert is associated with.
        """
        if dataset is not None:
            pulumi.set(__self__, "dataset", dataset)
        if exhaustion_minutes is not None:
            pulumi.set(__self__, "exhaustion_minutes", exhaustion_minutes)
        if recipients is not None:
            pulumi.set(__self__, "recipients", recipients)
        if slo_id is not None:
            pulumi.set(__self__, "slo_id", slo_id)

    @property
    @pulumi.getter
    def dataset(self) -> Optional[pulumi.Input[str]]:
        """
        The dataset this burn alert is associated with.
        """
        return pulumi.get(self, "dataset")

    @dataset.setter
    def dataset(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset", value)

    @property
    @pulumi.getter(name="exhaustionMinutes")
    def exhaustion_minutes(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of time, in minutes, remaining before the SLO's error budget will be exhausted and the alert will fire.
        """
        return pulumi.get(self, "exhaustion_minutes")

    @exhaustion_minutes.setter
    def exhaustion_minutes(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "exhaustion_minutes", value)

    @property
    @pulumi.getter
    def recipients(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BurnAlertRecipientArgs']]]]:
        """
        Zero or more configuration blocks (described below) with the recipients to notify when the alert fires.
        """
        return pulumi.get(self, "recipients")

    @recipients.setter
    def recipients(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BurnAlertRecipientArgs']]]]):
        pulumi.set(self, "recipients", value)

    @property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the SLO this burn alert is associated with.
        """
        return pulumi.get(self, "slo_id")

    @slo_id.setter
    def slo_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "slo_id", value)


class BurnAlert(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 exhaustion_minutes: Optional[pulumi.Input[int]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BurnAlertRecipientArgs']]]]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Resource: BurnAlert

        Creates a burn alert. For more information about burn alerts, check out [Define Burn Alerts](https://docs.honeycomb.io/working-with-your-data/slos/slo-process/#define-burn-alerts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        slo_id = config.require("sloId")
        example_alert = honeycomb.BurnAlert("exampleAlert",
            dataset=dataset,
            slo_id=slo_id,
            exhaustion_minutes=480,
            recipients=[
                honeycomb.BurnAlertRecipientArgs(
                    type="email",
                    target="hello@example.com",
                ),
                honeycomb.BurnAlertRecipientArgs(
                    type="slack",
                    target="#example-channel",
                ),
            ])
        ```

        ## Import

        Burn Alerts can be imported using a combination of the dataset name and their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/burnAlert:BurnAlert my_alert my-dataset/bj9BwOb1uKz
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this burn alert is associated with.
        :param pulumi.Input[int] exhaustion_minutes: The amount of time, in minutes, remaining before the SLO's error budget will be exhausted and the alert will fire.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BurnAlertRecipientArgs']]]] recipients: Zero or more configuration blocks (described below) with the recipients to notify when the alert fires.
        :param pulumi.Input[str] slo_id: ID of the SLO this burn alert is associated with.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BurnAlertArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Resource: BurnAlert

        Creates a burn alert. For more information about burn alerts, check out [Define Burn Alerts](https://docs.honeycomb.io/working-with-your-data/slos/slo-process/#define-burn-alerts).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_honeycomb as honeycomb

        config = pulumi.Config()
        dataset = config.require("dataset")
        slo_id = config.require("sloId")
        example_alert = honeycomb.BurnAlert("exampleAlert",
            dataset=dataset,
            slo_id=slo_id,
            exhaustion_minutes=480,
            recipients=[
                honeycomb.BurnAlertRecipientArgs(
                    type="email",
                    target="hello@example.com",
                ),
                honeycomb.BurnAlertRecipientArgs(
                    type="slack",
                    target="#example-channel",
                ),
            ])
        ```

        ## Import

        Burn Alerts can be imported using a combination of the dataset name and their ID, e.g.

        ```sh
         $ pulumi import honeycomb:index/burnAlert:BurnAlert my_alert my-dataset/bj9BwOb1uKz
        ```

        :param str resource_name: The name of the resource.
        :param BurnAlertArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BurnAlertArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dataset: Optional[pulumi.Input[str]] = None,
                 exhaustion_minutes: Optional[pulumi.Input[int]] = None,
                 recipients: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BurnAlertRecipientArgs']]]]] = None,
                 slo_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BurnAlertArgs.__new__(BurnAlertArgs)

            if dataset is None and not opts.urn:
                raise TypeError("Missing required property 'dataset'")
            __props__.__dict__["dataset"] = dataset
            if exhaustion_minutes is None and not opts.urn:
                raise TypeError("Missing required property 'exhaustion_minutes'")
            __props__.__dict__["exhaustion_minutes"] = exhaustion_minutes
            if recipients is None and not opts.urn:
                raise TypeError("Missing required property 'recipients'")
            __props__.__dict__["recipients"] = recipients
            if slo_id is None and not opts.urn:
                raise TypeError("Missing required property 'slo_id'")
            __props__.__dict__["slo_id"] = slo_id
        super(BurnAlert, __self__).__init__(
            'honeycomb:index/burnAlert:BurnAlert',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dataset: Optional[pulumi.Input[str]] = None,
            exhaustion_minutes: Optional[pulumi.Input[int]] = None,
            recipients: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BurnAlertRecipientArgs']]]]] = None,
            slo_id: Optional[pulumi.Input[str]] = None) -> 'BurnAlert':
        """
        Get an existing BurnAlert resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] dataset: The dataset this burn alert is associated with.
        :param pulumi.Input[int] exhaustion_minutes: The amount of time, in minutes, remaining before the SLO's error budget will be exhausted and the alert will fire.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BurnAlertRecipientArgs']]]] recipients: Zero or more configuration blocks (described below) with the recipients to notify when the alert fires.
        :param pulumi.Input[str] slo_id: ID of the SLO this burn alert is associated with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BurnAlertState.__new__(_BurnAlertState)

        __props__.__dict__["dataset"] = dataset
        __props__.__dict__["exhaustion_minutes"] = exhaustion_minutes
        __props__.__dict__["recipients"] = recipients
        __props__.__dict__["slo_id"] = slo_id
        return BurnAlert(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def dataset(self) -> pulumi.Output[str]:
        """
        The dataset this burn alert is associated with.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="exhaustionMinutes")
    def exhaustion_minutes(self) -> pulumi.Output[int]:
        """
        The amount of time, in minutes, remaining before the SLO's error budget will be exhausted and the alert will fire.
        """
        return pulumi.get(self, "exhaustion_minutes")

    @property
    @pulumi.getter
    def recipients(self) -> pulumi.Output[Sequence['outputs.BurnAlertRecipient']]:
        """
        Zero or more configuration blocks (described below) with the recipients to notify when the alert fires.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter(name="sloId")
    def slo_id(self) -> pulumi.Output[str]:
        """
        ID of the SLO this burn alert is associated with.
        """
        return pulumi.get(self, "slo_id")

