from collections.abc import Callable
from typing import Any

from django.http.request import HttpRequest
from django.http.response import HttpResponse, HttpResponseBase

class ContextMixin:
    extra_context: dict[str, Any] | None
    def get_context_data(self, **kwargs: Any) -> dict[str, Any]: ...

class View:
    http_method_names: list[str]
    request: HttpRequest
    args: Any
    kwargs: Any
    def __init__(self, **kwargs: Any) -> None: ...
    @classmethod
    def as_view(cls: Any, **initkwargs: Any) -> Callable[..., HttpResponseBase]: ...
    def setup(self, request: HttpRequest, *args: Any, **kwargs: Any) -> None: ...
    def dispatch(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def http_method_not_allowed(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponse: ...
    def options(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...

class TemplateResponseMixin:
    template_name: str
    template_engine: str | None
    response_class: type[HttpResponse]
    content_type: str | None
    request: HttpRequest
    def render_to_response(self, context: dict[str, Any], **response_kwargs: Any) -> HttpResponse: ...
    def get_template_names(self) -> list[str]: ...

class TemplateView(TemplateResponseMixin, ContextMixin, View):
    def get(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponse: ...

class RedirectView(View):
    permanent: bool
    url: str | None
    pattern_name: str | None
    query_string: bool
    def get_redirect_url(self, *args: Any, **kwargs: Any) -> str | None: ...
    def get(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def head(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def post(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def options(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def delete(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def put(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
    def patch(self, request: HttpRequest, *args: Any, **kwargs: Any) -> HttpResponseBase: ...
