from collections.abc import Callable
from typing import Any

class BaseSerializer:
    value: Any
    def __init__(self, value: Any) -> None: ...
    def serialize(self) -> tuple[str, set[str]]: ...

class BaseSequenceSerializer(BaseSerializer): ...
class BaseSimpleSerializer(BaseSerializer): ...
class DateTimeSerializer(BaseSerializer): ...
class DatetimeDatetimeSerializer(BaseSerializer): ...
class DecimalSerializer(BaseSerializer): ...

class DeconstructableSerializer(BaseSerializer):
    @staticmethod
    def serialize_deconstructed(
        path: str, args: list[Any], kwargs: dict[str, Callable | int | str]
    ) -> tuple[str, set[str]]: ...

class DictionarySerializer(BaseSerializer): ...
class EnumSerializer(BaseSerializer): ...
class FloatSerializer(BaseSimpleSerializer): ...
class FrozensetSerializer(BaseSequenceSerializer): ...
class FunctionTypeSerializer(BaseSerializer): ...
class FunctoolsPartialSerializer(BaseSerializer): ...
class IterableSerializer(BaseSerializer): ...
class ModelFieldSerializer(DeconstructableSerializer): ...
class ModelManagerSerializer(DeconstructableSerializer): ...
class OperationSerializer(BaseSerializer): ...
class PathLikeSerializer(BaseSerializer): ...
class PathSerializer(BaseSerializer): ...
class RegexSerializer(BaseSerializer): ...
class SequenceSerializer(BaseSequenceSerializer): ...
class SetSerializer(BaseSequenceSerializer): ...
class SettingsReferenceSerializer(BaseSerializer): ...
class TupleSerializer(BaseSequenceSerializer): ...
class TypeSerializer(BaseSerializer): ...
class UUIDSerializer(BaseSerializer): ...

def serializer_factory(value: Any) -> BaseSerializer: ...

class Serializer:
    @classmethod
    def register(cls, type_: type, serializer: type[BaseSerializer]) -> None: ...
    @classmethod
    def unregister(cls, type_: type) -> None: ...
