from enum import IntEnum
from typing import Any, AnyStr

from _typeshed import Self
from django.contrib.gis.gdal.base import GDALBase

class AxisOrder(IntEnum):
    TRADITIONAL: int
    AUTHORITY: int

class SpatialReference(GDALBase):
    destructor: Any
    axis_order: AxisOrder
    ptr: Any
    def __init__(self, srs_input: str | int = ..., srs_type: str = ..., axis_order: AxisOrder | None = ...) -> None: ...
    def __getitem__(self, target: str | tuple[str, int]) -> str: ...
    def attr_value(self, target: AnyStr, index: int = ...) -> str: ...
    def auth_name(self, target: AnyStr) -> str: ...
    def auth_code(self, target: AnyStr) -> str: ...
    def clone(self: Self) -> Self: ...
    def from_esri(self) -> None: ...
    def identify_epsg(self) -> None: ...
    def to_esri(self) -> None: ...
    def validate(self) -> None: ...
    @property
    def name(self) -> str | None: ...
    @property
    def srid(self) -> int | None: ...
    @property
    def linear_name(self) -> str: ...
    @property
    def linear_units(self) -> float: ...
    @property
    def angular_name(self) -> str: ...
    @property
    def angular_units(self) -> float: ...
    @property
    def units(self) -> tuple[float | None, str | None]: ...
    @property
    def ellipsoid(self) -> tuple[float, float, float]: ...
    @property
    def semi_major(self) -> float: ...
    @property
    def semi_minor(self) -> float: ...
    @property
    def inverse_flattening(self) -> float: ...
    @property
    def geographic(self) -> bool: ...
    @property
    def local(self) -> bool: ...
    @property
    def projected(self) -> bool: ...
    def import_epsg(self, epsg: int) -> None: ...
    def import_proj(self, proj: AnyStr) -> None: ...
    def import_user_input(self, user_input: AnyStr) -> None: ...
    def import_wkt(self, wkt: AnyStr) -> None: ...
    def import_xml(self, xml: AnyStr) -> None: ...
    @property
    def wkt(self) -> str: ...
    @property
    def proj(self) -> str: ...
    @property
    def proj4(self) -> str: ...

class CoordTransform(GDALBase):
    destructor: Any
    ptr: Any
    def __init__(self, source: SpatialReference, target: SpatialReference) -> None: ...
