from typing import Any, Optional

from botocore import utils as utils

BOTOCORE_DEFAUT_SESSION_VARIABLES: Any
DEFAULT_S3_CONFIG_VARS: Any
DEFAULT_PROXIES_CONFIG_VARS: Any

def create_botocore_default_config_mapping(session: Any) -> Any: ...

class ConfigChainFactory:
    def __init__(self, session: Any, environ: Optional[Any] = ...) -> None: ...
    def create_config_chain(
        self,
        instance_name: Optional[Any] = ...,
        env_var_names: Optional[Any] = ...,
        config_property_names: Optional[Any] = ...,
        default: Optional[Any] = ...,
        conversion_func: Optional[Any] = ...,
    ) -> Any: ...

class ConfigValueStore:
    def __init__(self, mapping: Optional[Any] = ...) -> None: ...
    def get_config_variable(self, logical_name: Any) -> Any: ...
    def set_config_variable(self, logical_name: Any, value: Any) -> None: ...
    def clear_config_variable(self, logical_name: Any) -> None: ...
    def set_config_provider(self, logical_name: Any, provider: Any) -> None: ...

class BaseProvider:
    def provide(self) -> None: ...

class ChainProvider(BaseProvider):
    def __init__(
        self, providers: Optional[Any] = ..., conversion_func: Optional[Any] = ...
    ) -> None: ...
    def provide(self) -> Any: ...

class InstanceVarProvider(BaseProvider):
    def __init__(self, instance_var: Any, session: Any) -> None: ...
    def provide(self) -> Any: ...

class ScopedConfigProvider(BaseProvider):
    def __init__(self, config_var_name: Any, session: Any) -> None: ...
    def provide(self) -> Any: ...

class EnvironmentProvider(BaseProvider):
    def __init__(self, name: Any, env: Any) -> None: ...
    def provide(self) -> Any: ...

class SectionConfigProvider(BaseProvider):
    def __init__(
        self, section_name: Any, session: Any, override_providers: Optional[Any] = ...
    ) -> None: ...
    def provide(self) -> Any: ...

class ConstantProvider(BaseProvider):
    def __init__(self, value: Any) -> None: ...
    def provide(self) -> Any: ...
