# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nonebot_plugin_remove_bg']

package_data = \
{'': ['*']}

install_requires = \
['aiohttp>=3.8.3,<4.0.0',
 'nonebot-adapter-onebot>=2.1.3,<3.0.0',
 'nonebot2>=2.0.0b5,<3.0.0']

setup_kwargs = {
    'name': 'nonebot-plugin-remove-bg',
    'version': '0.1.1',
    'description': '适用于nonebot2 v11的基于trace.moe的动画截图场景追溯插件',
    'long_description': '<div align="center">\n  <a href="https://v2.nonebot.dev/store"><img src="https://github.com/A-kirami/nonebot-plugin-template/blob/resources/nbp_logo.png" width="180" height="180" alt="NoneBotPluginLogo"></a>\n  <br>\n  <p><img src="https://github.com/A-kirami/nonebot-plugin-template/blob/resources/NoneBotPlugin.svg" width="240" alt="NoneBotPluginText"></p>\n</div>\n\n<div align="center">\n\n# nonebot_plugin_remove_bg\n  \n_✨ NoneBot 基于remove.bg的图片背景消除插件 ✨_\n  \n<a href="https://github.com/Ikaros-521/nonebot_plugin_remove_bg/stargazers">\n    <img alt="GitHub stars" src="https://img.shields.io/github/stars/Ikaros-521/nonebot_plugin_remove_bg?color=%09%2300BFFF&style=flat-square">\n</a>\n<a href="https://github.com/Ikaros-521/nonebot_plugin_remove_bg/issues">\n    <img alt="GitHub issues" src="https://img.shields.io/github/issues/Ikaros-521/nonebot_plugin_remove_bg?color=Emerald%20green&style=flat-square">\n</a>\n<a href="https://github.com/Ikaros-521/nonebot_plugin_remove_bg/network">\n    <img alt="GitHub forks" src="https://img.shields.io/github/forks/Ikaros-521/nonebot_plugin_remove_bg?color=%2300BFFF&style=flat-square">\n</a>\n<a href="./LICENSE">\n    <img src="https://img.shields.io/github/license/Ikaros-521/nonebot_plugin_remove_bg.svg" alt="license">\n</a>\n<a href="https://pypi.python.org/pypi/nonebot_plugin_remove_bg">\n    <img src="https://img.shields.io/pypi/v/nonebot_plugin_remove_bg.svg" alt="pypi">\n</a>\n<a href="https://www.python.org">\n    <img src="https://img.shields.io/badge/python-3.8+-blue.svg" alt="python">\n</a>\n\n</div>\n\n适用于nonebot2 v11的基于remove.bg的图片背景消除插件  \n调用的相关API源自:[https://www.remove.bg/api#api-reference](https://www.remove.bg/api#api-reference)   \n\n## 🔧 开发环境\nNonebot2：2.0.0b5  \npython：3.8.13  \n操作系统：Windows10（Linux兼容性问题不大）  \n编辑器：pycharm  \n\n## 💿 安装\n环境依赖`aiohttp`库   \n\n### 1. nb-cli安装（推荐）\n在你bot工程的文件夹下，运行cmd（运行路径要对啊），执行nb命令安装插件，插件配置会自动添加至配置文件  \n```\nnb plugin install nonebot_plugin_remove_bg\n```\n\n### 2. 本地安装\n先安装下 `aiohttp`  \n```\npip install aiohttp\n```\n将项目clone到你的机器人插件下的对应插件目录内（一般为机器人文件夹下的`src/plugins`），然后把`nonebot_plugin_remove_bg`文件夹里的内容拷贝至上一级目录即可。  \nclone命令参考（得先装`git`，懂的都懂）：\n```\ngit clone https://github.com/Ikaros-521/nonebot_plugin_remove_bg.git\n``` \n也可以直接下载压缩包到插件目录解压，然后同样提取`nonebot_plugin_remove_bg`至上一级目录。  \n目录结构： ```你的bot/src/plugins/nonebot_plugin_remove_bg/__init__.py```  \n\n\n### 3. pip安装\n```\npip install nonebot_plugin_remove_bg\n```  \n打开 nonebot2 项目的 ```bot.py``` 文件, 在其中写入  \n```nonebot.load_plugin(\'nonebot_plugin_remove_bg\')```  \n当然，如果是默认nb-cli创建的nonebot2的话，在bot路径```pyproject.toml```的```[tool.nonebot]```的```plugins```中添加```nonebot_plugin_remove_bg```即可  \npyproject.toml配置例如：  \n``` \n[tool.nonebot]\nplugin_dirs = ["src/plugins"]\nplugins = ["nonebot_plugin_remove_bg"]\n``` \n\n### 更新版本\n```\nnb plugin update nonebot_plugin_remove_bg\n```\n\n## 🔧 配置  \n\n### env配置\n```\n# nonebot_plugin_remove_bg 官方API KEY\nREMOVE_BG_API_KEY="XXXXXXXXXXXXXXXXXXXXXXXX"\n```\n|       配置项        | 必填 | 默认值  |                      说明                      |\n|:----------------:|:----:|:----:|:----------------------------:|\n| `REMOVE_BG_API_KEY` | 是 | `` | 注册官方账号申请API KEY（每月50次免费额度） |\n\n### API KEY获取方式\n访问[https://www.remove.bg/api#remove-background](https://www.remove.bg/api#remove-background)，注册账号，然后点击`Get API Key` -> ` New API Key` -> `Create API Key`。  \n\n## 🎉 功能\n基于remove.bg，上传图片调用API消除背景后返回处理后的图片  \n\n## 👉 命令\n\n### ①默认配置的背景消除\n\n#### 1、先发送命令，再发送图片（命令前缀请自行替换）\n先发送`/去背景`或`/rm_bg`，等bot返回`请发送需要去除背景的图片喵~`后，发送需要去除背景的图片即可。  \n\n#### 2、命令+图片\n编辑消息`/去背景[待去除背景的图片]`或`/rm_bg[待去除背景的图片]`发送即可。 \n\n#### 3、回复图片+命令\n回复需要处理的图片，然后追加命令`/去背景`或`/rm_bg`发送即可。\n\n### ②自定义配置的背景消除\n\n#### 1、命令+图片\n命令如下(命令前缀自行添加)：  \n```\n自定义去背景 -img <IMAGE> [-s --size -最大输出分辨率 <最大输出图像分辨率 \'preview/full/auto\'>] [-t --type -前景类型 <前景类型 \'auto/person/product/car\'>] [-tl --type_level -前景类型级别 <检测到的前景类型的分类级别 \'none/1/2/latest\'>]\\n [-r --roi -感兴趣区域 <感兴趣区域 x1 y1 x2 y2，如\'0% 0% 100% 100%\'>] [-c --crop -裁剪空白区 <是否裁剪掉所有空白区域 \'true/false\'>] [-p --position -定位主题 <在图像画布中定位主题 \'center/original/从“0%”到“100%”的一个值(水平和垂直)或两个值(水平、垂直)\'>]\\n [-sc --scale -缩放主体 <相对于图像总尺寸缩放主体 从“10%”到“100%”之间的任何值，也可以是“original”(默认)。缩放主体意味着“位置=中心”(除非另有说明)。>] [-ad --add_shadow -人工阴影 <是否向结果添加人工阴影 \'true/false\'>] [-se --semitransparency -半透明区域 <结果中是否包含半透明区域 \'true/false\'>]\n``` \n命令起始：`自定义去背景` 或 `remove_bg`  \n`-img` 必选参数，后面追加`<IMAGE>`图片（回复的话，图片就不用了）  \n`-s` 可选参数 `-s`可以改成 `--size` 或 `-最大输出分辨率`，含义是最大输出图像分辨率，传参内容是`\'preview/full/auto\'`（3选1）  \n其他的[]都是可选参数，含义和-s相同，不再赘述。  \n\n例如：  \n```\n/自定义去背景 -img <IMAGE> -s \'preview\'\n/remove_bg -img <IMAGE> -s \'full\' -r \'30% 30% 60% 60%\' -ad \'true\'\n```\n\n#### 2、回复图片+命令\n命令与上面相同，注意必选参数`-img`，不要忘记了。  \n\n#### 3、自定义去背景帮助\n获取命令的帮助说明命令为`自定义去背景帮助` 或 `自定义去背景help`   \n例如：  \n```\n/自定义去背景帮助\n/自定义去背景help\n```\n\n## ⚙ 拓展\n修改`__init__.py`中的`catch_str`等来自定义命令触发关键词。  \n代码实现缝合怪，感觉很kuso，待优化（大坑）    \n\n## 📝 更新日志\n\n<details>\n<summary>展开/收起</summary>\n\n### 0.0.1\n\n- 插件初次发布\n\n### 0.0.2\n\n- 向上兼容rc2  \n\n### 0.1.0\n\n- 修改原 remove_bg命令至 自定义去背景 功能（采用shell cmd的形式）。\n- 原 rm_bg 和 去背景 命令，增加可以直接回复图片进行处理。\n\n### 0.1.1\n\n- 修复 私聊bot无法正常运行的bug\n\n</details>\n\n## 致谢\n\n- [remove.bg](https://www.remove.bg) - API来源  \n\n## 项目打包上传至pypi\n\n官网：https://pypi.org，注册账号，在系统用户根目录下创建`.pypirc`，配置  \n``` \n[distutils] \nindex-servers=pypi \n \n[pypi] repository = https://upload.pypi.org/legacy/ \nusername = 用户名 \npassword = 密码\n```\n\n### poetry\n\n```\n# 参考 https://www.freesion.com/article/58051228882/\n# poetry config pypi-token.pypi\n\n# 1、安装poetry\npip install poetry\n\n# 2、初始化配置文件（根据提示填写）\npoetry init\n\n# 3、微调配置文件pyproject.toml\n\n# 4、运行 poetry install, 可生成 “poetry.lock” 文件（可跳过）\npoetry install\n\n# 5、编译，生成dist\npoetry build\n\n# 6、发布(poetry config pypi-token.pypi 配置token)\npoetry publish\n\n```\n\n### twine\n\n```\n# 参考 https://www.cnblogs.com/danhuai/p/14915042.html\n#创建setup.py文件 填写相关信息\n\n# 1、可以先升级打包工具\npip install --upgrade setuptools wheel twine\n\n# 2、打包\npython setup.py sdist bdist_wheel\n\n# 3、可以先检查一下包\ntwine check dist/*\n\n# 4、上传包到pypi（需输入用户名、密码）\ntwine upload dist/*\n```',
    'author': 'Ikaros',
    'author_email': '327209194@qq.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Ikaros-521/nonebot_plugin_remove_bg',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
