"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("@aws-cdk/core");
const _1 = require("./");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const envJP = {
            region: 'ap-northeast-1',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const envUS = {
            region: 'us-west-2',
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        // first stack in JP
        const stackJP = new cdk.Stack(app, 'demo-stack-jp', { env: envJP });
        new cdk.CfnOutput(stackJP, 'TopicName', { value: 'foo' });
        // second stack in US
        const stackUS = new cdk.Stack(app, 'demo-stack-us', { env: envUS });
        // ensure the dependency
        stackUS.addDependency(stackJP);
        // get the stackJP stack outputs from stackUS
        const outputs = new _1.StackOutputs(stackUS, 'Outputs', {
            stack: stackJP,
            alwaysUpdate: false,
        });
        const remoteOutputValue = outputs.getAttString('TopicName');
        // the value should be exactly the same with the output value of `TopicName`
        new cdk.CfnOutput(stackUS, 'RemoteTopicName', { value: remoteOutputValue });
        this.stack = [stackJP, stackUS];
    }
}
exports.IntegTesting = IntegTesting;
// run the integ testing
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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