#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['pyformatters_textranksummarizer']

package_data = \
{'': ['*']}

package_dir = \
{'': 'src'}

install_requires = \
['pymultirole-plugins>=0.5.174,<0.6.0',
 'spacy==3.4.0',
 'spacy[lookups]',
 'pytextrank',
 'collections_extended']

extras_require = \
{'dev': ['flit', 'pre-commit', 'bump2version'],
 'docs': ['sphinx',
          'sphinx-rtd-theme',
          'm2r2',
          'sphinxcontrib.apidoc',
          'jupyter_sphinx'],
 'test': ['pytest',
          'pytest-cov',
          'pytest-flake8',
          'pytest-black',
          'flake8==3.9.2',
          'tox',
          'pandas==1.2.3',
          'openpyxl==3.0.7']}

entry_points = \
{'pyformatters.plugins': ['textranksummarizer = '
                          'pyformatters_textranksummarizer.textranksummarizer:TextRankSummarizerFormatter'],
 'pyprocessors.plugins': ['textranksummarizer = '
                          'pyformatters_textranksummarizer.textranksummarizer:TextRankSummarizerFormatter']}

setup(name='pyformatters-textranksummarizer',
      version='0.5.103',
      description='Formatter/processor based on TextRank',
      author='Olivier Terrier',
      author_email='olivier.terrier@kairntech.com',
      url='https://github.com/oterrier/pyformatters_textranksummarizer/',
      packages=packages,
      package_data=package_data,
      package_dir=package_dir,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
      python_requires='>=3.8',
     )
